<?php $__env->startSection('title', __('purchase.add_purchase')); ?>

<?php $__env->startSection('content'); ?>

    <?php
        $custom_labels = json_decode(session('business.custom_labels'), true);
    ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> <?php echo app('translator')->getFromJson('sentence.kashf_hesab'); ?> <?php echo app('translator')->getFromJson('sentence.supplier'); ?>  <i class="fa fa-keyboard-o hover-q text-muted" aria-hidden="true" data-container="body" data-toggle="popover" data-placement="bottom" data-content="<?php echo $__env->make('purchase.partials.keyboard_shortcuts_details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>" data-html="true" data-trigger="hover" data-original-title="" title=""></i></h1>
    </section>
    <!-- Main content -->
    <section class="content">

        <!-- Page level currency setting -->
        <input type="hidden" id="p_code" value="<?php echo e($currency_details->code, false); ?>">
        <input type="hidden" id="p_symbol" value="<?php echo e($currency_details->symbol, false); ?>">
        <input type="hidden" id="p_thousand" value="<?php echo e($currency_details->thousand_separator, false); ?>">
        <input type="hidden" id="p_decimal" value="<?php echo e($currency_details->decimal_separator, false); ?>">

    <?php echo Form::open(['url' => action('PurchaseController@store'), 'method' => 'post', 'id' => 'add_purchase_form', 'files' => true ]); ?>

        <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
            <div class="row">
                <div class="<?php if(!empty($default_purchase_status)): ?> col-sm-4 <?php else: ?> col-sm-3 <?php endif; ?>">
                    <div class="form-group">
                        <?php echo Form::label('supplier_id', __('purchase.supplier') . ':*'); ?>

                        <div class="input-group">
						<span class="input-group-addon">
							<i class="fa fa-user"></i>
						</span>
                            <?php echo Form::select('contact_id', [], null, ['class' => 'form-control', 'placeholder' => __('messages.please_select'), 'required', 'id' => 'supplier_id']);; ?>

                            <span class="input-group-btn">
							<button type="button" class="btn btn-default bg-white btn-flat add_new_supplier" data-name=""><i class="fa fa-plus-circle text-primary fa-lg"></i></button>
						</span>
                        </div>
                    </div>
                    <strong>
                        <?php echo app('translator')->getFromJson('business.address'); ?>:
                    </strong>
                    <div id="supplier_address_div"></div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <?php echo Form::label('prescription_Date_id', __('messages.date') . ':*'); ?>

                        <div class="input-group">
							<span class="input-group-addon">
								<i class="fa fa-calendar"></i>
							</span>
                            <?php echo Form::text('prescription_Date', \Carbon::createFromTimestamp(strtotime('now'))->format(session('business.date_format')), ['class' => 'form-control', 'readonly', 'required', 'id' => 'Date_id']);; ?>

                        </div>
                    </div>
                </div>
                <div class="col-sm-3">
                    <label for="exampleInputEmail1">  <?php echo app('translator')->getFromJson('sentence.carPalet'); ?></label>

                    <select class="form-control m-bot15" id="carpalet" name="carpalet" value='' onchange="departmentChanged()" >
                        <?php $__currentLoopData = $cars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$cars): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($cars->id, false); ?>"><?php echo e($cars->car_palet, false); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-sm-3">
                    <label for="exampleInputEmail1">  <?php echo app('translator')->getFromJson('sentence.driver'); ?></label>

                    <?php echo Form::select('driver_name', $users, null, ['class' => 'form-control select2', 'style' => 'width:100%']);; ?>


                </div>
            </div>
        <?php echo $__env->renderComponent(); ?>
            <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
            <div class="row">
                <div class="col-sm-2">
                    <div class="form-group">
                        <?php echo Form::label('qty-weight', __('sentence.amountWeight') . ':'); ?>

                        <?php echo Form::text('qty_weight',0, ['class' => 'form-control', 'id' => 'qty-weight']);; ?>

                    </div>
                </div>

                <div class="col-sm-2">
                    <div class="form-group">
                        <?php echo Form::label('west-per', __('sentence.westper') . ':'); ?>

                        <?php echo Form::text('west_per',0, ['class' => 'form-control', 'id' => 'west-per']);; ?>

                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="form-group">
                        <?php echo Form::label('qty-weight', __('sentence.NetAmountWeight') . ':'); ?>

                        <?php echo Form::text('net_amount_weight',0, ['class' => 'form-control', 'id' => 'net-weight','disabled']);; ?>

                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="form-group">
                        <?php echo Form::label('kg_price', __('sentence.kgprice') . ':'); ?>

                        <?php echo Form::text('kg_price',0, ['class' => 'form-control', 'id' => 'kg-price']);; ?>

                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <?php echo Form::label('net_money', __('sentence.netAmountMoney') . ':'); ?>

                        <?php echo Form::text('net_money',0, ['class' => 'form-control', 'id' => 'net_money','disabled']);; ?>

                    </div>
                </div>

            </div>
        <?php echo $__env->renderComponent(); ?>
        <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
            <div class="row">
                <div class="col-sm-2">
                    <div class="form-group">
                        <?php echo Form::label('box_amount_total', __('sentence.boxRent') . ':'); ?>

                        <?php echo Form::text('box_amount_total',0, ['class' => 'form-control', 'id' => 'box-amount-total']);; ?>

                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="form-group">
                        <?php echo Form::label('box_amount_ton', __('sentence.boxRentTon') . ':'); ?>

                        <?php echo Form::text('box_amount_ton',0, ['class' => 'form-control', 'id' => 'box-amount-ton']);; ?>

                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="form-group">
                        <?php echo Form::label('box_count', __('sentence.boxCount') . ':'); ?>

                        <?php echo Form::text('box_count',0, ['class' => 'form-control', 'id' => 'box-count']);; ?>

                    </div>
                </div>
            </div>
        <?php echo $__env->renderComponent(); ?>
        <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
            <div class="row">
                <div class="col-sm-6">

                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <?php echo Form::label('final_amount_total', __('sentence.netAmountOverAll') . ':'); ?>

                        <?php echo Form::text('final_amount_total',0, ['class' => 'form-control', 'id' => 'final-amount-total','disabled']);; ?>

                    </div>
                </div>
            </div>
        <?php echo $__env->renderComponent(); ?>
        <?php echo Form::close(); ?>

    </section>
    <!-- quick product modal -->
    <div class="modal fade quick_add_product_modal" tabindex="-1" role="dialog" aria-labelledby="modalTitle"></div>
    <div class="modal fade contact_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
        <?php echo $__env->make('contact.create', ['quick_add' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <!-- /.content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
    <script src="<?php echo e(asset('js/purchase.js?v=' . $asset_v), false); ?>"></script>
    <script src="<?php echo e(asset('js/product.js?v=' . $asset_v), false); ?>"></script>
    <script type="text/javascript">
        $(document).ready( function(){
            __page_leave_confirmation('#add_purchase_form');
            $('.paid_on').datetimepicker({
                format: moment_date_format + ' ' + moment_time_format,
                ignoreReadonly: true,
            });
        });
        $(document).on('change', '.payment_types_dropdown, #location_id', function(e) {
            var default_accounts = $('select#location_id').length ?
                $('select#location_id')
                    .find(':selected')
                    .data('default_payment_accounts') : [];
            var payment_types_dropdown = $('.payment_types_dropdown');
            var payment_type = payment_types_dropdown.val();
            var payment_row = payment_types_dropdown.closest('.payment_row');
            var row_index = payment_row.find('.payment_row_index').val();

            var account_dropdown = payment_row.find('select#account_' + row_index);
            if (payment_type && payment_type != 'advance') {
                var default_account = default_accounts && default_accounts[payment_type]['account'] ?
                    default_accounts[payment_type]['account'] : '';
                if (account_dropdown.length && default_accounts) {
                    account_dropdown.val(default_account);
                    account_dropdown.change();
                }
            }

            if (payment_type == 'advance') {
                if (account_dropdown) {
                    account_dropdown.prop('disabled', true);
                    account_dropdown.closest('.form-group').addClass('hide');
                }
            } else {
                if (account_dropdown) {
                    account_dropdown.prop('disabled', false);
                    account_dropdown.closest('.form-group').removeClass('hide');
                }
            }
        });


        $('#qty-weight').on('input',function(e){
            var percentDescounted=$('#west-per').val();

            var netWeight=$('#qty-weight').val()-($('#qty-weight').val()*(percentDescounted/100));
           $('#net-weight').val(netWeight);
        });
        $('#west-per').on('input',function(e){
            var percentDescounted=$('#west-per').val();

            var netWeight=$('#qty-weight').val()-($('#qty-weight').val()*(percentDescounted/100));
            $('#net-weight').val(netWeight);
        });
        $('#kg-price').on('input',function(e){
            var mainNetweight= $('#net-weight').val();

            var netAmount=mainNetweight*$('#kg-price').val();
            $('#net_money').val(netAmount);
            netAmount=netAmount-$('#box-amount-total').val();
            $('#final-amount-total').val(netAmount);
        });
        $('#box-amount-total').on('input',function(e){
            var mainNetweight= $('#net-weight').val();
            var mainNetTons=mainNetweight/1000;

            var netAmount=$('#box-amount-total').val()/mainNetTons;
            $('#box-amount-ton').val(netAmount);
            netAmount=mainNetweight*$('#kg-price').val();
            netAmount=netAmount-$('#box-amount-total').val();
            $('#final-amount-total').val(netAmount);
        });
        $('#box-amount-ton').on('input',function(e){
            var mainNetweight= $('#net-weight').val();
            var mainNetTons=mainNetweight/1000;

            var netAmount=$('#box-amount-ton').val()*mainNetTons;
            $('#box-amount-total').val(netAmount);
            netAmount=mainNetweight*$('#kg-price').val();
            netAmount=netAmount-$('#box-amount-total').val();
            $('#final-amount-total').val(netAmount);
        });

    </script>
    <?php echo $__env->make('purchase.partials.keyboard_shortcuts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp\www\possys_enkelware\resources\views/zahraakashf/createSupplierStatement.blade.php ENDPATH**/ ?>