<!doctype html>
<html lang="<?php echo e(config('app.locale'), false); ?>" class="no-js">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token(), false); ?>">

    <title><?php echo $__env->yieldContent('title'); ?></title>

    <!-- Fonts -->
    <!-- <link href="https://fonts.googleapis.com/css?family=Raleway:100,300,600" rel="stylesheet" type="text/css"> -->


    <!-- GOOGLE FONTS -->
    <link href="https://fonts.googleapis.com/css2?family=Rubik:wght@300;400;500;700&display=swap" rel="stylesheet">

    <!-- Styles -->
    <!-- BOOTSTRAP CSS -->

    <link rel="stylesheet" href="<?php echo e(asset('homeassets/css/bootstrap.min.css'), false); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('homeassets/css/animate.min.css'), false); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('homeassets/css/magnific-popup.css'), false); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('homeassets/css/fontawesome-all.min.css'), false); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('homeassets/css/slick.css'), false); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('homeassets/css/aos.css'), false); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('homeassets/css/default.css'), false); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('homeassets/css/style.css'), false); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('homeassets/css/responsive.css'), false); ?>">


<body>
<!--Start Preloader -->
<div class="preloader"></div>
<!--End Preloader -->

<?php echo $__env->make('layouts.partials.home_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- main-area -->
<main>
    <!-- slider-area -->
    <section id="home" class="slider-area slider-six-area p-relative">
        <div class="slider-six-bg" data-background="<?php echo e(asset('homeassets/img/slider/slider_bg06.png'), false); ?>"></div>
        <div class="slider-overflow six-slider-overflow">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-7 col-lg-9">
                        <div class="slider-content slider-six-content text-center">
                            <h2 class="wow fadeInUp" data-wow-delay=".2s"><?php echo $__env->yieldContent('content'); ?></h2>
                            <a href="<?php echo e(route('login'), false); ?>" class="btn yellow-btn wow fadeInUp" data-wow-delay=".4s">Get
                                Started Now</a>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="slider-six-img text-center wow fadeInUp" data-wow-delay=".6s"
                             data-wow-duration="1.2s">
                            <img src="<?php echo e(asset('homeassets/img/slider/slider_img02.png'), false); ?>" alt="img">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="slider-six-shape slider-six-shape-one"><img
                    src="<?php echo e(asset('homeassets/img/shape/slider_six_shape01.png'), false); ?>" alt="shape" class="wow pulse"
                    data-wow-duration="1.8s" data-wow-iteration="infinite"></div>
        <div class="slider-six-shape slider-six-shape-two"><img
                    src="<?php echo e(asset('homeassets/img/shape/slider_six_shape02.png'), false); ?>" alt="shape"></div>
    </section>
    <!-- slider-area-end -->
    <!-- features-area -->
    <section id="features" class="features-area six-features-area pt-105">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-8 col-md-10">
                    <div class="section-title s-section-title mb-130 text-center">
                        <h2>Amazing Features</h2>
                        <p>Collaborate over projects with your team and clients optimised for mobile and tablet don't
                            let
                            slow</p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-4 col-md-6">
                    <div class="s-single-features text-center mb-80">
                        <div class="s-features-icon">
                            <img src="img/icon/six_features_icon01.png" alt="img">
                        </div>
                        <div class="s-features-content">
                            <h4>Easy Customize</h4>
                            <p>Customize Your Business Needs is very easy helps your business to grow </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="s-single-features text-center mb-80">
                        <div class="s-features-icon">
                            <img src="img/icon/six_features_icon02.png" alt="img">
                        </div>
                        <div class="s-features-content">
                            <h4>More Flexible</h4>
                            <p>Flexible Solution help business Owneres to make right Way business Grow</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="s-single-features text-center mb-80">
                        <div class="s-features-icon">
                            <img src="img/icon/six_features_icon03.png" alt="img">
                        </div>
                        <div class="s-features-content">
                            <h4>Clean Code</h4>
                            <p>Our App is open source technology so No hidden scripts or spams</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- features-area-end -->

</main>
<!-- main-area-end -->


<!-- Scripts -->

<?php echo $__env->yieldContent('javascript'); ?>




<!-- JS here -->
<script src="<?php echo e(asset('homeassets/js/vendor/jquery-1.12.4.min.js'), false); ?>"></script>
<script src="<?php echo e(asset('homeassets/js/popper.min.js'), false); ?>"></script>
<script src="<?php echo e(asset('homeassets/js/bootstrap.min.js'), false); ?>"></script>
<script src="<?php echo e(asset('homeassets/js/one-page-nav-min.js'), false); ?>"></script>
<script src="<?php echo e(asset('homeassets/js/slick.min.js'), false); ?>"></script>
<script src="<?php echo e(asset('homeassets/js/ajax-form.js'), false); ?>"></script>
<script src="<?php echo e(asset('homeassets/js/wow.min.js'), false); ?>"></script>
<script src="<?php echo e(asset('homeassets/js/aos.js'), false); ?>"></script>
<script src="<?php echo e(asset('homeassets/js/jquery.counterup.min.js'), false); ?>"></script>
<script src="<?php echo e(asset('homeassets/js/skrollr.min.js'), false); ?>"></script>
<script src="<?php echo e(asset('homeassets/js/element-in-view.js'), false); ?>"></script>
<script src="<?php echo e(asset('homeassets/js/parallax-scroll.js'), false); ?>"></script>
<script src="<?php echo e(asset('homeassets/js/paroller.js'), false); ?>"></script>
<script src="<?php echo e(asset('homeassets/js/jquery.waypoints.min.js'), false); ?>"></script>
<script src="<?php echo e(asset('homeassets/js/jquery.scrollUp.min.js'), false); ?>"></script>
<script src="<?php echo e(asset('homeassets/js/jquery.magnific-popup.min.js'), false); ?>"></script>
<script src="<?php echo e(asset('homeassets/js/plugins.js'), false); ?>"></script>
<script src="<?php echo e(asset('homeassets/js/main.js'), false); ?>"></script>
<script type="text/javascript">
    $(document).ready( function () {

        if ($('.preloader').length) {
            $('.preloader').delay(2000).fadeOut(500);
        }

    });

</script>
</body>
</html><?php /**PATH /home/newcairo/public_html/zahraa.rsegy.com/resources/views/layouts/home.blade.php ENDPATH**/ ?>