
<?php $__env->startSection('title', __('sentence.projects')); ?>


<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> <?php echo app('translator')->getFromJson('sentence.projects'); ?>
        </h1>
    </section>


    <!-- Main content -->
    <section class="content">
        <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => __( 'sentence.projects')]); ?>

            <?php $__env->slot('tool'); ?>
                <div class="box-tools" style="float: left">
                    <a class="btn btn-primary" data-toggle="modal"
                       href="#" id="btn_add_new_project">
                        <i class="fa fa-plus"></i> <?php echo app('translator')->getFromJson('messages.add'); ?> <?php echo app('translator')->getFromJson('sentence.project'); ?></a>
                </div>
            <?php $__env->endSlot(); ?>

            <div id="exTab2">
                <ul class="nav nav-tabs">
                    <li class="active">
                        <a href="#1" data-toggle="tab"><?php echo e(__('sentence.on_process_projects'), false); ?></a>
                    </li>
                    <li><a href="#2" data-toggle="tab"><?php echo e(__('sentence.finished_project'), false); ?></a>
                    </li>

                </ul>
                <div class="tab-content ">
                    <div class="tab-pane active" id="1">
                            <br />
                            <br />
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped" id="datatable-projects" style="width:100%;">
                                        <thead>
                                        <tr>

                                            <th><?php echo app('translator')->getFromJson('sentence.project'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('sentence.partner_name'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('sentence.partner_percent'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('sentence.project_expenses'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('lang_v1.added_by'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('lang_v1.added_on'); ?></th>
                                            <th  style="min-width: 65px;"><?php echo app('translator')->getFromJson('messages.action'); ?></th>

                                        </tr>
                                        </thead>


                                    </table>


                        </div>
                    </div>
                    <div class="tab-pane" id="2">
                            <br />
                            <br />

                                    <table class="table table-bordered table-striped" id="datatable-finished-projects">
                                        <thead>
                                        <tr>
                                            <th><?php echo app('translator')->getFromJson('sentence.project'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('sentence.partner_name'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('sentence.main_project_profit'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('sentence.project_expenses'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('sentence.boxRent'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('sentence.ShippingCost'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('sentence.partner_percent'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('sentence.netAmountOverAll'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('sentence.netAmountOverAllAfterExpense'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('sentence.netAmountOverAllAfterExpense'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('lang_v1.added_by'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('lang_v1.added_on'); ?></th>
                                        </tr>
                                        </thead>


                                    </table>


                    </div>

                </div>
            </div>






        <?php echo $__env->renderComponent(); ?>

        <div class="modal fade contact_modal" tabindex="-1" role="dialog"
             aria-labelledby="gridSystemModalLabel">
        </div>
        <div class="modal fade pay_contact_due_modal" tabindex="-1" role="dialog"
             aria-labelledby="gridSystemModalLabel">
        </div>



            <!-- Add Patient Modal-->
            <div class="modal fade" id="add_project_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none; ">
                <div class="modal-dialog" style="width: 800px!important;">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4 class="modal-title">  <?php echo e(__('sentence.add_project'), false); ?>  </h4>
                        </div>
                        <div class="modal-body">
                            <?php echo Form::open(['url' => action('CarController@store'), 'method' => 'post', 'id' => 'add_project_form','class'=>'clearfix', 'files' => true ]); ?>

                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <?php echo Form::label('car_type', __('sentence.project') . ':*'); ?>

                                        <?php echo Form::text('project_name',  null, ['class' => 'form-control',
                                        'placeholder' => __('sentence.first_name'),'required'=>'required']);; ?>

                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <?php echo Form::label('car_type', __('sentence.partner_name') . ':*'); ?>

                                        <?php echo Form::select('supplier_id', $contact, null, ['class' => 'form-control select2', 'style' => 'width:100%','id'=>'contact_id','required'=>'required']);; ?>


                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <?php echo Form::label('car_description', __('sentence.partner_percent') . ':*'); ?>

                                        <?php echo Form::text('percent',  '50', ['class' => 'form-control',
                                        'placeholder' => __('sentence.partner_percent'),'required'=>'required']);; ?>

                                    </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-12"><hr/></div>
                            <div class="form-group col-md-12">
                                <button type="submit" name="submit" class="btn btn-info pull-right" id="submit-project">  <?php echo app('translator')->getFromJson('messages.submit'); ?></button>
                            </div>
                            <?php echo Form::close(); ?>

                        </div>
                    </div><!-- /.modal-content -->
                </div><!-- /.modal-dialog -->
            </div>
            <!-- Add Schedule Modal-->
  <!-- Add Patient Modal-->
            <div class="modal fade" id="add_expenses_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none; ">
                <div class="modal-dialog" style="width: 800px!important;">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4 class="modal-title">  <?php echo e(__('sentence.project_expense'), false); ?>  </h4>
                        </div>
                        <div class="modal-body">
                            <?php echo Form::open(['url' => action('CarController@store'), 'method' => 'post', 'id' => 'add_expense_form','class'=>'clearfix', 'files' => true ]); ?>

                            <div class="row">
                              <input type="hidden" name="project_id" id="project_id_for_expenses" value=""/>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <?php echo Form::label('car_type', __('sentence.expense_cost') . ':*'); ?>

                                        <?php echo Form::text('expense_cost', null, ['class' => 'form-control', 'style' => 'width:100%','id'=>'contact_id','placeholder' => __('sentence.expense_cost'),'required'=>'required']);; ?>


                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <?php echo Form::label('car_description', __('sentence.expense_note') ); ?>

                                        <?php echo Form::textarea('additional_notes',  null, ['class' => 'form-control',
                                        'placeholder' => __('sentence.expense_note')]);; ?>

                                    </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-12"><hr/></div>
                            <div class="form-group col-md-12">
                                <button type="submit" name="submit" class="btn btn-info pull-right" id="submit-expenses">  <?php echo app('translator')->getFromJson('messages.submit'); ?></button>
                            </div>
                            <?php echo Form::close(); ?>

                        </div>
                    </div><!-- /.modal-content -->
                </div><!-- /.modal-dialog -->
            </div>
            <!-- Add Schedule Modal-->


    </section>
    <!-- /.content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>

    <script type="text/javascript">
        $("#btn_add_new_project").click(function() {
            //alert(this.id);
            $('#add_project_modal').modal('show');

        });


        $('#add_expenses_modal').on('shown.bs.modal', function (e) {
            let btn = $(e.relatedTarget); // e.related here is the element that opened the modal, specifically the row button
            console.log(btn.data('design'));

            var layer_id = btn.data('design').id;
            console.log(layer_id);
            $('#project_id_for_expenses').val(layer_id);


        });


        $("#submit-project").click(function () {
            $('#add_project_form').submit(function (e) {
                e.preventDefault();
                var formData = new FormData($('#add_project_form')[0]);
                var flag_material = false;
                console.log(formData);
                $.ajax({
                    url: '/storeProject',
                    type: 'POST',
                    data: formData,
                    success: function (response) {
                        console.log(response);
                        location.reload();

                    },
                    error: function (request, status, error) {
                        console.log(error);
                    },
                    contentType: false,
                    processData: false

                });
            });
        });
        $("#submit-expenses").click(function () {
            $('#add_expense_form').submit(function (e) {
                e.preventDefault();
                var formData = new FormData($('#add_expense_form')[0]);
                var flag_material = false;
                console.log(formData);
                $.ajax({
                    url: '/storeExpenses',
                    type: 'POST',
                    data: formData,
                    success: function (response) {
                        console.log(response);
                        location.reload();

                    },
                    error: function (request, status, error) {
                        console.log(error);
                    },
                    contentType: false,
                    processData: false

                });
            });
        });
        $(document).ready(function () {
           $('#datatable-projects').DataTable({processing: true,
                serverSide: true,
                aaSorting: [[1, 'DESC']],
                autoWidth:false,
                scrollY: "300px",
                scrollX: true,
                scrollCollapse: true,
                "ajax": {
                    "url": "/zahraaProjects",
                    "data": function (d) {

                        //d.group_name = "";
                        d.type = 'on_proccess';
                        d = __datatable_ajax_callback(d);
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(errorThrown);
                    }
                },
                columns: [

                    {data: 'project_name', name: 'project_name'},
                    {data: 'supplierName', name: 'supplierName'},
                    {data: 'supplier_percent', name: 'supplier_percent'},
                    {data: 'expenses', name: 'expenses'},
                    {data: 'created_by', name: 'created_by'},
                    {data: 'created_at', name: 'created_at'},
                    {data: 'action', name: 'action'},
                ],


            });
           $('#datatable-finished-projects').DataTable({processing: true,
                serverSide: true,
                aaSorting: [[1, 'DESC']],
                autoWidth:false,
                scrollX: true,
                scrollCollapse: true,
                "ajax": {
                    "url": "/zahraaProjects",
                    "data": function (d) {

                        //d.group_name = "";
                        d.type = 'finished_projects';
                        d = __datatable_ajax_callback(d);
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(errorThrown);
                    }
                },

                columns: [
                    {data: 'project_name', name: 'project_name'},
                    {data: 'supplier_name', name: 'supplier_name'},
                    {data: 'supplier_total', name: 'supplier_total'},
                    {data: 'expenses', name: 'expenses'},
                    {data: 'box_rent_cost', name: 'box_rent_cost'},
                    {data: 'driver_net_value', name: 'driver_net_value'},
                    {data: 'supplier_percent', name: 'supplier_percent'},
                    {data: 'supplier_net_value', name: 'supplier_net_value'},
                    {data: 'supplier_net_after_expenses', name: 'supplier_net_after_expenses'},
                    {data: 'net_supplier_after_percent', name: 'net_supplier_after_percent'},
                    {data: 'created_by', name: 'created_by'},
                    {data: 'created_at', name: 'created_at'},
                ],


            });

        });

        function LoadEdit(patientID) {

            $('#editCar-' + patientID).click(function (event) {
                event.preventDefault();
            });
            $('div.contact_modal').load($('#editCar-' + patientID).attr('data-goto'), function () {
                $(this).modal('show');

            });
        }
    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/newcairo/public_html/zahraa.rsegy.com/resources/views/zahraaprojects/index.blade.php ENDPATH**/ ?>