@extends('layouts.app')
@section('title', __('sentence.kashf_hesab'))


@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> @lang('sentence.kashf_hesab')
        </h1>
    </section>
    <style>
        .dataTables_wrapper {
            display: inline-table;

            /* below optional .*/
            --width: auto;
            --max-width: 45%;
        }


        th, td {
            white-space: nowrap;
        }

    </style>
    <link href="//datatables.net/download/build/nightly/jquery.dataTables.css" rel="stylesheet" type="text/css"/>

    <!-- Main content -->
    <section class="content">
        @component('components.widget', ['class' => 'box-primary', 'title' => __( 'sentence.kashf_hesab')])

            @slot('tool')
                <div class="box-tools" style="float: left">
                    <a class="btn btn-primary" data-toggle="modal"
                       href="{{ action('SupplierKashfController@create') }}">
                        <i class="fa fa-plus"></i> @lang('messages.add')</a>
                    <a class="btn btn-border-primary" data-toggle="modal"
                       href="{{ action('SupplierKashfController@createDirectBuy') }}">
                        <i class="fa fa-plus"></i> @lang('messages.add') كشف شراء مباشر </a>
                    <a class="btn btn-border-info" data-toggle="modal"
                       href="{{ action('SupplierKashfController@createWasal') }}">
                        <i class="fa fa-plus"></i> @lang('messages.add') كشف شراء وصال </a>
                    <button type="button" class="btn btn-success add_new_supplier"
                            data-name="" id="add_supplier_customer"><i
                                class="fa fa-plus-circle fa-lg"></i> @lang('sentence.add_contact')</button>
                    <button type="button" class="btn btn-border-success add_new_driver"
                            data-name="" id="add_driver"><i class="fa fa-plus fa-lg"></i> @lang('sentence.add_driver')
                    </button>
                </div>
            @endslot
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        {!! Form::label('expense_date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null, ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'date_range', 'readonly']); !!}
                    </div>
                </div>
            </div>

            <div id="exTab2">
                <ul class="nav nav-tabs">
                    <li class="active">
                        <a href="#1" data-toggle="tab">{{ __('sentence.supplier') }}</a>
                    </li>
                    <li><a href="#2" data-toggle="tab">{{ __('sentence.Customer') }}</a>
                    </li>
                    <li><a href="#3" data-toggle="tab">{{ __('sentence.driver') }}</a>
                    </li>

                </ul>
                <div class="tab-content ">
                    <div class="tab-pane active" id="1">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    {!! Form::label('car_type', __('sentence.supplier') . ':*') !!}
                                    {!! Form::select('supplier_id', $contact, null, ['class' => 'form-control select2', 'style' => 'width:100%','id'=>'supplier_id', 'placeholder' => __('lang_v1.all')]); !!}

                                </div>
                            </div>
                            <br/>
                            <br/>
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped" id="datatable-supplier"
                                           style="width:100%;">
                                        <thead>
                                        <tr>

                                            <th>@lang('sentence.supplier')</th>
                                            <th>@lang('sentence.kashfTYpe')</th>
                                            <th>@lang('sentence.project_status')</th>
                                            <th>@lang('sentence.onLandDate')</th>
                                            <th>@lang('sentence.factoryHoldDate')</th>
                                            <th>@lang('sentence.carPalet')</th>
                                            <th>@lang('sentence.driver')</th>
                                            <th>@lang('sentence.amountWeight')</th>
                                            <th>@lang('sentence.westper')</th>
                                            <th>@lang('sentence.NetAmountWeight')</th>
                                            <th>@lang('sentence.kgprice')</th>
                                            <th>@lang('sentence.boxRent')</th>
                                            <th>@lang('sentence.ShippingCost')</th>
                                            <th>@lang('sentence.daysDiff')</th>
                                            <th>@lang('sentence.dayCost')</th>
                                            <th>@lang('sentence.netAmountOverAll')</th>
                                            <th>@lang('lang_v1.added_on')</th>
                                            <th style="min-width: 65px;">@lang('messages.action')</th>

                                        </tr>
                                        </thead>


                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="2">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    {!! Form::label('car_type', __('sentence.Customer') . ':*') !!}
                                    {!! Form::select('customer_id', $contactCustomer, null, ['class' => 'form-control select2', 'style' => 'width:100%','id'=>'customer_id', 'placeholder' => __('lang_v1.all')]); !!}

                                </div>
                            </div>
                            <br/>
                            <br/>
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped" id="datatable-customer"
                                           style="width:100%;">
                                        <thead>
                                        <tr>
                                            <th style="min-width: 165px;">@lang('sentence.Customer')</th>
                                            <th>@lang('sentence.factory_name')</th>
                                            <th>@lang('sentence.factoryHoldDate')</th>
                                            <th>@lang('sentence.carPalet')</th>
                                            <th>@lang('sentence.driver')</th>
                                            <th>@lang('sentence.amountWeight')</th>
                                            <th>@lang('sentence.westper')</th>
                                            <th>@lang('sentence.NetAmountWeight')</th>
                                            <th>@lang('sentence.kgpriceClient')</th>
                                            <th>@lang('sentence.netAmountOverAllClient')</th>
                                            <th>@lang('lang_v1.added_on')</th>
                                            <th style="min-width: 65px;">@lang('messages.action')</th>
                                        </tr>
                                        </thead>


                                    </table>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="tab-pane" id="3">
                        <div class="col-md-4">
                            <div class="form-group">
                                {!! Form::label('car_type', __('sentence.driver') . ':*') !!}
                                {!! Form::select('driver_id', $users, null, ['class' => 'form-control select2', 'style' => 'width:100%','id'=>'driver_id', 'placeholder' => __('lang_v1.all')]); !!}

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped" id="datatable-driver"
                                           style="width:100%;">
                                        <thead>
                                        <tr>

                                            <th style="min-width: 165px;">@lang('sentence.driver')</th>
                                            <th>@lang('sentence.carPalet')</th>
                                            <th>@lang('sentence.onLandDate')</th>
                                            <th>@lang('sentence.outLandDate')</th>
                                            <th>@lang('sentence.factoryHoldDate')</th>
                                            <th>@lang('sentence.daysTotalNumber')</th>
                                            <th>@lang('sentence.daysTotalNumberDefualt')</th>
                                            <th>@lang('sentence.daysDiff')</th>
                                            <th>@lang('sentence.dayCost')</th>
                                            <th>@lang('sentence.ShippingCost')</th>
                                            <th>@lang('sentence.netAmountMoneyDriver')</th>
                                            <th>@lang('sentence.boxCount')</th>
                                            <th>@lang('lang_v1.added_on')</th>
                                            <th style="min-width: 65px;">@lang('messages.action')</th>

                                        </tr>
                                        </thead>


                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        @endcomponent

        <div class="modal fade contact_modal" tabindex="-1" role="dialog"
             aria-labelledby="gridSystemModalLabel">
        </div>
        <div class="modal fade pay_contact_due_modal" tabindex="-1" role="dialog"
             aria-labelledby="gridSystemModalLabel">
        </div>


        <!-- Add Patient Modal-->
        <div class="modal fade" id="add_supplier_customer_modal" tabindex="-1" role="dialog"
             aria-labelledby="myModalLabel" aria-hidden="true" style="display: none; ">
            <div class="modal-dialog" style="width: 800px!important;">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        <h4 class="modal-title">  {{ __('sentence.add_contact') }}  </h4>
                    </div>
                    <div class="modal-body">
                        {!! Form::open(['url' => action('CarController@store'), 'method' => 'post', 'id' => 'add_supplier_customer_form','class'=>'clearfix', 'files' => true ]) !!}
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    {!! Form::label('car_palet', __('sentence.contactType') . ':*') !!}
                                    <select name="contactType" class="form-control">
                                        <option value="1">عميل</option>
                                        <option value="2">مورد</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    {!! Form::label('car_type', __('sentence.first_name') . ':*') !!}
                                    {!! Form::text('first_name',  null, ['class' => 'form-control',
                                    'placeholder' => __('sentence.first_name'),'required'=>'required']); !!}
                                </div>
                            </div>
                            <input type="hidden" name="middle_name" value=" "/>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    {!! Form::label('car_type', __('sentence.last_name') . ':*') !!}
                                    {!! Form::text('last_name',  null, ['class' => 'form-control',
                                    'placeholder' => __('sentence.last_name'),'required'=>'required']); !!}
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="form-group">
                                    {!! Form::label('car_description', __('sentence.phone_number') . ':*') !!}
                                    {!! Form::text('mobile',  null, ['class' => 'form-control',
                                    'placeholder' => __('sentence.phone_number'),'required'=>'required']); !!}
                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <div class="col-md-12">
                            <hr/>
                        </div>
                        <div class="form-group col-md-12">
                            <button type="submit" name="submit" class="btn btn-info pull-right"
                                    id="submit-contact">  @lang('messages.submit')</button>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div>
        <!-- Add Schedule Modal-->

        <!-- Add Patient Modal-->
        <div class="modal fade" id="add_driver_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
             aria-hidden="true" style="display: none; ">
            <div class="modal-dialog" style="width: 800px!important;">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        <h4 class="modal-title">  {{ __('sentence.add_driver') }}  </h4>
                    </div>
                    <div class="modal-body">
                        {!! Form::open(['url' => action('CarController@store'), 'method' => 'post', 'id' => 'add_driver_form','class'=>'clearfix', 'files' => true ]) !!}
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    {!! Form::label('car_type', __('sentence.first_name') . ':*') !!}
                                    {!! Form::text('first_name',  null, ['class' => 'form-control',
                                    'placeholder' => __('sentence.first_name'),'required'=>'required']); !!}
                                </div>
                            </div>
                            <input type="hidden" name="middle_name" value=" "/>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    {!! Form::label('car_type', __('sentence.last_name') . ':*') !!}
                                    {!! Form::text('last_name',  null, ['class' => 'form-control',
                                    'placeholder' => __('sentence.last_name'),'required'=>'required']); !!}
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="form-group">
                                    {!! Form::label('car_description', __('sentence.phone_number') . ':*') !!}
                                    {!! Form::text('mobile',  null, ['class' => 'form-control',
                                    'placeholder' => __('sentence.phone_number'),'required'=>'required']); !!}
                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <div class="col-md-12">
                            <hr/>
                        </div>
                        <div class="form-group col-md-12">
                            <button type="submit" name="submit" class="btn btn-info pull-right"
                                    id="submit-driver">  @lang('messages.submit')</button>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div>
        <!-- Add Schedule Modal-->


    </section>
    <!-- /.content -->
@stop
@section('javascript')

    <script type="text/javascript">
        $("#add_supplier_customer").click(function () {
            //alert(this.id);
            $('#add_supplier_customer_modal').modal('show');

        });
        $("#add_driver").click(function () {
            //alert(this.id);
            $('#add_driver_modal').modal('show');

        });


        $("#submit-contact").click(function () {
            $('#add_supplier_customer_form').submit(function (e) {
                e.preventDefault();
                var formData = new FormData($('#add_supplier_customer_form')[0]);
                var flag_material = false;
                console.log(formData);
                $.ajax({
                    url: '/storeContactSmall',
                    type: 'POST',
                    data: formData,
                    success: function (response) {
                        console.log(response);
                        location.reload();

                    },
                    error: function (request, status, error) {
                        console.log(error);
                    },
                    contentType: false,
                    processData: false

                });
            });
        });
        $("#submit-driver").click(function () {
            $('#add_driver_form').submit(function (e) {
                e.preventDefault();
                var formData = new FormData($('#add_driver_form')[0]);
                var flag_material = false;
                console.log(formData);
                $.ajax({
                    url: '/storeDriverSmall',
                    type: 'POST',
                    data: formData,
                    success: function (response) {
                        console.log(response);
                        location.reload();

                    },
                    error: function (request, status, error) {
                        console.log(error);
                    },
                    contentType: false,
                    processData: false

                });
            });
        });
        if ($('#date_range').length == 1) {
            $('#date_range').daterangepicker(dateRangeSettings, function (start, end) {
                $('#date_range span').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );

                console.log($('input#date_range').val());
                supplier_table.ajax.reload();
                customer_table.ajax.reload();
                driver_table.ajax.reload();
                if ($('#date_range').length == 1) {
                    if ($('input#date_range').val()) {
                        start = $('input#date_range')
                            .data('daterangepicker')
                            .startDate.format('YYYY-MM-DD');
                        end = $('input#date_range')
                            .data('daterangepicker')
                            .endDate.format('YYYY-MM-DD');
                        console.log(start);
                        console.log(end);
                    }
                }
            });
            $('#date_range').on('cancel.daterangepicker', function (ev, picker) {
                $('#date_range').val('');
                supplier_table.ajax.reload();
                customer_table.ajax.reload();
                driver_table.ajax.reload();
                //  sell_payment_espitalia_report.ajax.reload();
            });
        }

        $(document).ready(function () {
            /*var start = '';
            var end = '';
            console.log($('input#date_range').val());
            if ($('#date_range').length == 1) {

                if ($('input#date_range').val()) {
                    start = $('input#date_range')
                        .data('daterangepicker')
                        .startDate.format('YYYY-MM-DD');
                    end = $('input#date_range')
                        .data('daterangepicker')
                        .endDate.format('YYYY-MM-DD');
                    console.log(start);
                    console.log(end);
                }
            }*/
            supplier_table = $('#datatable-supplier').DataTable({
                processing: true,
                serverSide: true,
                aaSorting: [[1, 'DESC']],
                autoWidth: false,
                scrollY: "300px",
                scrollX: true,
                scrollCollapse: true,
                "ajax": {
                    "url": "/supplierKashf",
                    "data": function (d) {
                        console.log($('input#date_range').val());
                        //d.group_name = "";
                        d.type = 'supplier';
                        d.supplier_id = $('#supplier_id').val();
                        var start = '';
                        var end = '';
                        if ($('input#date_range').val()) {
                            start = $('input#date_range')
                                .data('daterangepicker')
                                .startDate.format('YYYY-MM-DD');
                            end = $('input#date_range')
                                .data('daterangepicker')
                                .endDate.format('YYYY-MM-DD');
                            console.log(start);
                            console.log(end);
                        }

                        d.date_start = start;
                        d.date_end = end;
                        d = __datatable_ajax_callback(d);
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(errorThrown);
                    }
                },
                columnDefs: [{"className": "dt-center", "targets": "_all"},
                    {
                        targets: 1,
                        width: 1
                    }],
                columns: [

                    {data: 'supplierName', name: 'contacts.name'},
                    {data: 'kashfType', name: 'kashfType', searchable: false},
                    {data: 'project_status', name: 'project_status', searchable: false},
                    {data: 'on_land_date', name: 'on_land_date'},
                    {data: 'on_factory_date', name: 'on_factory_date'},
                    {data: 'car_palet', name: 'transport_cars.car_palet'},
                    {data: 'driver_name', name: 'driver_name'},
                    {data: 'main_weight', name: 'main_weight'},
                    {data: 'loses_percent', name: 'loses_percent'},
                    {data: 'net_weight', name: 'net_weight'},
                    {data: 'supplier_price', name: 'supplier_price'},
                    {data: 'box_rent_cost', name: 'box_rent_cost'},
                    {data: 'shipping_cost', name: 'shipping_cost'},
                    {data: 'stay_days_no', name: 'stay_days_no'},
                    {data: 'stay_day_cost', name: 'stay_day_cost'},

                    {data: 'supplier_net_value', name: 'supplier_net_value'},
                    {data: 'created_at', name: 'created_at'},
                    {data: 'action', name: 'action'},
                ],


            });
            customer_table = $('#datatable-customer').DataTable({
                processing: true,
                serverSide: true,
                aaSorting: [[1, 'DESC']],
                autoWidth: false,
                scrollY: "300px",
                scrollX: true,
                scrollCollapse: true,
                "ajax": {
                    "url": "/supplierKashf",
                    "data": function (d) {

                        //d.group_name = "";
                        d.type = 'customer';
                        d.customer_id = $('#customer_id').val();
                        var start = '';
                        var end = '';
                        if ($('input#date_range').val()) {
                            start = $('input#date_range')
                                .data('daterangepicker')
                                .startDate.format('YYYY-MM-DD');
                            end = $('input#date_range')
                                .data('daterangepicker')
                                .endDate.format('YYYY-MM-DD');
                            console.log(start);
                            console.log(end);
                        }

                        d.date_start = start;
                        d.date_end = end;
                        d = __datatable_ajax_callback(d);
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(errorThrown);
                    }
                },
                columns: [

                    {data: 'customerName', name: 'contacts.name'},
                    {data: 'factory_name', name: 'factory_name'},
                    {data: 'on_factory_date', name: 'on_factory_date'},
                    {data: 'car_palet', name: 'transport_cars.car_palet'},
                    {data: 'driver_name', name: 'driver_name'},
                    {data: 'main_weight', name: 'main_weight'},
                    {data: 'loses_percent', name: 'loses_percent'},
                    {data: 'net_weight', name: 'net_weight'},
                    {data: 'customer_price', name: 'customer_price'},
                    {data: 'customer_net_value', name: 'customer_net_value'},
                    {data: 'created_at', name: 'created_at'},
                    {data: 'action', name: 'action'},
                ],


            });
            driver_table = $('#datatable-driver').DataTable({
                processing: true,
                serverSide: true,
                aaSorting: [[1, 'DESC']],
                autoWidth: false,
                scrollY: "300px",
                scrollX: true,
                scrollCollapse: true,
                "ajax": {
                    "url": "/supplierKashf",
                    "data": function (d) {

                        //d.group_name = "";
                        d.type = 'driver';
                        d.driver_id = $('#driver_id').val();
                        var start = '';
                        var end = '';
                        if ($('input#date_range').val()) {
                            start = $('input#date_range')
                                .data('daterangepicker')
                                .startDate.format('YYYY-MM-DD');
                            end = $('input#date_range')
                                .data('daterangepicker')
                                .endDate.format('YYYY-MM-DD');
                            console.log(start);
                            console.log(end);
                        }

                        d.date_start = start;
                        d.date_end = end;
                        d = __datatable_ajax_callback(d);
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(errorThrown);
                    }
                },
                columnDefs: [
                    {"className": "dt-center", "targets": "_all"},
                    {
                        targets: 1,
                        width: 1
                    },
                ],

                columns: [

                    {data: 'driverName', name: 'driverName', searchable: false},
                    {data: 'car_palet', name: 'transport_cars.car_palet'},
                    {data: 'on_land_date', name: 'on_land_date'},
                    {data: 'out_land_date', name: 'out_land_date'},
                    {data: 'on_factory_date', name: 'on_factory_date'},
                    {data: 'total_days_no', name: 'total_days_no'},
                    {data: 'days_default', name: 'days_default'},
                    {data: 'stay_days_no', name: 'stay_days_no'},
                    {data: 'stay_day_cost', name: 'stay_day_cost'},
                    {data: 'shipping_cost', name: 'shipping_cost'},
                    {data: 'driver_net_value', name: 'driver_net_value'},
                    {data: 'box_count', name: 'box_count'},
                    {data: 'created_at', name: 'created_at'},
                    {data: 'action', name: 'action'},
                ],


            });


        });
        $(document).on('change', '#supplier_id, #customer_id, #driver_id', function () {
            supplier_table.ajax.reload();
            customer_table.ajax.reload();
            driver_table.ajax.reload();


        });

        function LoadEdit(patientID) {

            $('#editCar-' + patientID).click(function (event) {
                event.preventDefault();
            });
            $('div.contact_modal').load($('#editCar-' + patientID).attr('data-goto'), function () {
                $(this).modal('show');

            });
        }
    </script>

@endsection
