@extends('layouts.app')
@section('title', __('sentence.kashf_hesab'))


@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> كشف حساب السائق
        </h1>
        <h2>{{ $driver->driver_name }}</h2>
    </section>
    <style>
        .dataTables_wrapper {
            display: inline-table;

            /* below optional .*/
            --width: auto;
            --max-width: 45%;
        }


        th, td {
            white-space: nowrap;
        }

    </style>
    <link href="//datatables.net/download/build/nightly/jquery.dataTables.css" rel="stylesheet" type="text/css" />

    <!-- Main content -->
    <section class="content">
        @component('components.widget', ['class' => 'box-primary', 'title' => 'كشف الحساب '. $driver->driver_name ])
{{--
            {{ var_dump($driver_expenses) }}
--}}
            <table class="table table-condensed text-left align-left no-border @if(!empty($for_pdf)) table-pdf @endif">
                <tr>
                    <td>اجمالى مستحقات السائق</td>
                    {{--{{ var_dump($ledger_details) }}--}}
                    <td class="align-right">@format_currency($driver_needed_amount['net_total'])</td>
                </tr>
                <tr>
                    <td>اجمالى دفعات السائق</td>
                    {{--{{ var_dump($ledger_details) }}--}}
                    <td class="align-right">@format_currency($driver_payed_amount['payed_amount'])</td>
                </tr>
                <tr>
                    <td>صافى حساب السائق</td>
                    {{--{{ var_dump($ledger_details) }}--}}
                    <td class="align-right">@format_currency($driver_needed_amount['net_total']-$driver_payed_amount['payed_amount'])</td>
                </tr>
            </table>

            {{--
                        {{ var_dump($driver_payed) }}

            --}}
            <br />
         @php
         $total_amount=0
         @endphp
            <table class="table table-bordered table-striped" id="dataTableMis">
            <thead>
            <tr>

                <th>تاريخ الحركة</th>
                <th>المدين</th>
                <th>الدائن</th>
                <th>الرصيد</th>
                <th >رقم المرجع</th>

            </tr>
            </thead>

            <tbody>
            @foreach($driver_statment as $key=>$statement)
                <tr>
                <td>{{$statement['transaction_date']}}</td>
            @if($statement['needed']=='needed')
                <td>@format_currency($statement['final_total'])</td>
                <td></td>
                <td>@format_currency( $total_amount=$total_amount+$statement['final_total'] )</td>
                <td>{{$statement['ref_no']}}</td>
                @else
                    <td></td>
                    <td>@format_currency($statement['final_total'])</td>
                    <td>@format_currency( $total_amount=$total_amount-$statement['final_total'] )</td>
                    <td>{{$statement['ref_no']}}</td>
                @endif
                </tr>
            @endforeach
            </tbody>
            </table>


        @endcomponent

        <div class="modal fade contact_modal" tabindex="-1" role="dialog"
             aria-labelledby="gridSystemModalLabel">
        </div>
        <div class="modal fade pay_contact_due_modal" tabindex="-1" role="dialog"
             aria-labelledby="gridSystemModalLabel">
        </div>


    </section>
    <!-- /.content -->
@stop
@section('javascript')

    <script type="text/javascript">

        $(document).ready(function () {
            supplier_table=$('#datatable-supplier').DataTable();


        });
        $(document).on('change', '#supplier_id, #customer_id, #driver_id', function () {
            supplier_table.ajax.reload();



        });

    </script>


@endsection