@extends('layouts.guest')
@section('title', $title)
@section('content')
<style>
    @media print {
        .pagebreak { page-break-before: always; } /* page-break-after works, as well */
    }
</style>
<div class="container">
    <div class="spacer"></div>
    <div class="row">
        <div class="col-md-12 text-right" >
            <button type="button" class="btn btn-primary no-print" id="print_invoice" 
                 aria-label="Print"><i class="fas fa-print"></i> @lang( 'messages.print' )
            </button>
            @auth
                <a href="{{action('SellPosController@chasierscreen')}}" class="btn btn-success no-print" ><i class="fas fa-backward"></i>
                </a>
            @endauth
        </div>
    </div>
    <div class="row">

            <div class="spacer"></div>
            <div id="invoice_content">
                <img class="center-block" src="data:image/png;base64,{{DNS1D::getBarcodePNG($receipt, 'C128', 2,30,array(39, 48, 54), true)}}">
                <img class="center-block mt-5" src="data:image/png;base64,{{DNS2D::getBarcodePNG($receipt, 'QRCODE', 3, 3, [39, 48, 54])}}">

            </div>
            <div class="spacer"></div>

    </div>
    <div class="spacer"></div>
    <div class="pagebreak"> </div>
    <div class="row">

        <div class="spacer"></div>
        <div id="invoice_content">
            {!! $receipt2['html_content'] !!}
        </div>
        <div class="spacer"></div>

    </div>
    <div class="spacer"></div>
</div>
@stop
@section('javascript')
<script type="text/javascript">
    $(document).ready(function(){
        $(document).on('click', '#print_invoice', function(){
            $('#invoice_content').printThis();
        });
    });
    window.onafterprint = function(e){
        closePrintView();
    };

    function closePrintView() {
        document.location.href = "{{action('SellPosController@chasierscreen')}}";
    }

    @if(!empty(request()->input('print_on_load')))
        $(window).on('load', function(){
        window.print();
        setTimeout("closePrintView()", 3000);
    });
    @endif
</script>
@endsection