@extends('layouts.app')
@section('title', __('purchase.add_purchase'))

@section('content')

    @php
        $custom_labels = json_decode(session('business.custom_labels'), true);
    @endphp
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> @lang('sentence.kashf_hesab') @lang('sentence.supplier')  <i class="fa fa-keyboard-o hover-q text-muted" aria-hidden="true" data-container="body" data-toggle="popover" data-placement="bottom" data-content="@include('purchase.partials.keyboard_shortcuts_details')" data-html="true" data-trigger="hover" data-original-title="" title=""></i></h1>
    </section>
    <!-- Main content -->
    <section class="content">

        <!-- Page level currency setting -->
        <input type="hidden" id="p_code" value="{{$currency_details->code}}">
        <input type="hidden" id="p_symbol" value="{{$currency_details->symbol}}">
        <input type="hidden" id="p_thousand" value="{{$currency_details->thousand_separator}}">
        <input type="hidden" id="p_decimal" value="{{$currency_details->decimal_separator}}">

        {!! Form::open(['url' => action('PurchaseController@store'), 'method' => 'post', 'id' => 'add_purchase_form', 'files' => true ]) !!}
        @component('components.widget', ['class' => 'box-primary'])
            <div class="row">
                <div class="@if(!empty($default_purchase_status)) col-sm-4 @else col-sm-3 @endif">
                    <div class="form-group">
                        الخام
                        <div class="input-group">
						<span class="input-group-addon">
							<i class="fa fa-user"></i>
						</span>
                            {!! Form::select('contact_id', [], null, ['class' => 'form-control', 'placeholder' => __('messages.please_select'), 'required', 'id' => 'supplier_id']); !!}
                            <span class="input-group-btn">
							<button type="button" class="btn btn-default bg-white btn-flat add_new_supplier" data-name=""><i class="fa fa-plus-circle text-primary fa-lg"></i></button>
						</span>
                        </div>
                    </div>

                </div>
                <div class="@if(!empty($default_purchase_status)) col-sm-4 @else col-sm-3 @endif">
                    <div class="form-group">
                        تصنيف الخام
                        <div class="input-group">
						<span class="input-group-addon">
							<i class="fa fa-user"></i>
						</span>
                            {!! Form::select('contact_id', [], null, ['class' => 'form-control', 'placeholder' => __('messages.please_select'), 'required', 'id' => 'supplier_id']); !!}
                            <span class="input-group-btn">
							<button type="button" class="btn btn-default bg-white btn-flat add_new_supplier" data-name=""><i class="fa fa-plus-circle text-primary fa-lg"></i></button>
						</span>
                        </div>
                    </div>

                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        مجموعة الخام
                        {!! Form::text('west_per',null, ['class' => 'form-control', 'id' => 'west-per']); !!}
                    </div>
                </div>
                <div class="col-sm-3">
                    <button type="submit" class="btn btn-primary">@lang( 'messages.save' )</button>
                </div>


            </div>
        @endcomponent
        @component('components.widget', ['class' => 'box-primary'])
            <div class="table-responsive">
                <table class="table table-bordered table-striped" id="dataTableMis">
                    <thead>
                    <tr>

                        <th>الخام</th>
                        <th>تصنيف الخام</th>
                        <th>مجموعة الخام</th>
                        <th>اضيف بواسطة</th>
                        <th>تاريخ الاضافة</th>

                        <th style=" white-space: nowrap;">@lang('messages.action')</th>

                    </tr>
                    </thead>

                    <tbody>
                    {{--@foreach($cars as $key =>$car)
                        <tr>

                            <td>{{$car['car_palet']}}</td>
                            <td> {{$car['car_type']}}</td>
                            <td>{{$car['car_description']}}</td>
                            <td>

                                <a class="edit_patient_button" data-toggle="modal" href="#"
                                   data-goto="{{action('CarController@edit', [$car['id']])}}"
                                   id="editCar-{{ $car['id'] }}" data-id="{{ $car['id'] }}" onclick="LoadEdit('{{$car['id']}}')" >
                                    <i class="fa fa-edit"></i> @lang('messages.edit')</a>



                            </td>



                        </tr>
                    @endforeach--}}
                    </tbody>


                </table>
            </div>
        @endcomponent

        {!! Form::close() !!}
    </section>
    <!-- quick product modal -->
    <div class="modal fade quick_add_product_modal" tabindex="-1" role="dialog" aria-labelledby="modalTitle"></div>
    <div class="modal fade contact_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
        @include('contact.create', ['quick_add' => true])
    </div>
    <!-- /.content -->
@endsection
@section('javascript')
    <script src="{{ asset('js/purchase.js?v=' . $asset_v) }}"></script>
    <script src="{{ asset('js/product.js?v=' . $asset_v) }}"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#dataTableMis').DataTable({


            });
        });

    </script>
    @include('purchase.partials.keyboard_shortcuts')
@endsection
