<?php


namespace App\Http\Controllers;


use App\AlboTemplateMainTable;
use App\BusinessLocation;
use App\Contact;
use App\CustomerGroup;
use App\FinishedProjectsView;
use App\Product;
use App\PurchaseLine;
use App\Transaction;
use App\TransactionSellLine;
use App\TransportCar;
use App\User;
use App\Utils\BusinessUtil;
use App\Utils\ContactUtil;
use App\Utils\ModuleUtil;
use App\Utils\ProductUtil;
use App\Utils\TransactionUtil;
use App\Utils\Util;
use App\ZahraaKashfTotal;
use App\ZahraaProject;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Log;
use Yajra\DataTables\Facades\DataTables;

class ZahraaProjectsManage extends Controller
{

    protected $commonUtil;
    protected $contactUtil;
    protected $businessUtil;
    protected $productUtil;
    protected $transactionUtil;


    public function __construct(Util $commonUtil,
                                ContactUtil $contactUtil,
                                TransactionUtil $transactionUtil,
                                ModuleUtil $moduleUtil,
                                ProductUtil $productUtil,
                                BusinessUtil $businessUtil)
    {
        $this->commonUtil = $commonUtil;
        $this->contactUtil = $contactUtil;
        $this->businessUtil = $businessUtil;
        $this->transactionUtil = $transactionUtil;
        $this->productUtil = $productUtil;
        $this->moduleUtil = $moduleUtil;


    }


    /**
     * Display a listing of the resource.
     * @return Response
     */
    public function index()
    {
        $business_id = request()->session()->get('user.business_id');
        $query = Contact::where('contacts.business_id', $business_id)
            ->where('contacts.name', '<>', 'Walk-In Customer')
            ->where('contacts.name', '<>', '')
            ->where('contacts.type', '=', 'supplier');
        //$query->onlySuppliers();
        $query->select('contacts.id', DB::raw('CONCAT(contacts.name, " - ",
	contacts.mobile, " - ",
	CASE
	WHEN type="customer"
	THEN "عميل"
	ELSE
	"مورد"
	end ) as contactName'));
        $contact = $query->pluck('contactName', 'id');
        $query22 = ZahraaProject::join('contacts','zahraa_projects.supplier_id','=','contacts.id')
            ->join('users','zahraa_projects.created_by','=','users.id')
            ->leftJoin('transactions', function($join)
            {
                $join->on('transactions.project_id', '=', 'zahraa_projects.id')
                    ->where('transactions.type','=',DB::raw('"expense"'))
                    ->whereNotNull('transactions.contact_id');
            })
            ->join('zahraa_kashf_totals','zahraa_projects.id','=','zahraa_kashf_totals.project_id')
            ->where('zahraa_projects.project_status','=','1');
        $finalMaterials22 = $query22->select('zahraa_projects.id',
            'zahraa_projects.project_name',
            'zahraa_projects.supplier_percent',
            'contacts.name as supplierName',
            DB::raw('sum(zahraa_kashf_totals.box_rent_cost) as box_rent_cost'),
            DB::raw('sum(zahraa_kashf_totals.driver_net_value) as driver_net_value'),
            DB::raw('sum(zahraa_kashf_totals.supplier_net_value) as supplier_net_value'),
            DB::raw('concat(users.first_name," ",users.last_name) as created_by'),
            DB::raw('ifnull(sum(transactions.final_total),0) as expenses'),
            DB::raw('sum(zahraa_kashf_totals.supplier_total) as mainPrice'),
            'zahraa_projects.created_at'
        )
            ->groupBy('zahraa_projects.id')->toSql()
        ;
        if (request()->ajax()) {
            if (request()->get('type') == 'on_proccess') {
                $query = ZahraaProject::join('contacts','zahraa_projects.supplier_id','=','contacts.id')
                    ->join('users','zahraa_projects.created_by','=','users.id')
                    ->leftJoin('transactions', function($join)
                    {
                        $join->on('transactions.project_id', '=', 'zahraa_projects.id')
                        ->where('transactions.type','=',DB::raw('"expense"'))
                        ->whereNotNull('transactions.contact_id');
                    })
                ->where('zahraa_projects.project_status','=','0');
                $finalMaterials = $query->select('zahraa_projects.id',
                    'zahraa_projects.project_name',
                    'zahraa_projects.supplier_percent',
                    'contacts.name as supplierName',
                    DB::raw('concat(users.first_name," ",users.last_name) as created_by'),
                    DB::raw('ifnull(sum(transactions.final_total),0) as expenses'),
                    'zahraa_projects.created_at'
                )
                    ->groupBy('zahraa_projects.id')
                ;
                return Datatables::of($finalMaterials)
                    ->addColumn('action',
                        function ($row) {
                            $html = '<div class="btn-group btn-block">
                                    <button type="button" class="btn btn-info dropdown-toggle btn-xs" 
                                        data-toggle="dropdown" aria-expanded="false">' .
                                __('messages.actions') .
                                '<span class="caret"></span><span class="sr-only">Toggle Dropdown
                                        </span>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-left" role="menu">';

                            $html .= '<li><a target="_blank" href="#"><i class="fas fa-edit"></i> ' . __('messages.edit') . '</a></li>';

                            $html .= '<li><a href="#" onclick="return confirm(\'Are you sure you want to Delete this Operation?\');"><i class="fas fa-trash"></i> ' . __('messages.delete') . '</a></li>';
                            $html .= '</ul></div>';
                            $html .= '<a href="#add_expenses_modal" data-toggle="modal" data-design=\'{"id":"' . $row->id . '"}\' class="btn btn-warning  btn-block"><i class="fas fa-plus-square"></i> ' . __('sentence.project_expense') . '</a>';
                            $html .= '<a href="'.action('ZahraaProjectsManage@projectFinish',[$row->id]).'" class="btn btn-primary  btn-block"><i class="fas fa-plus"></i> ' . __('sentence.project_add_kashf') . '</a>';
                            $html .= '<a href="'.action('ZahraaProjectsManage@projectFinal',[$row->id]).'" class="btn btn-success  btn-block"><i class="fas fa-check"></i> ' . __('sentence.project_finish') . '</a>';
                            return $html;
                        })
                    ->editColumn('created_at', '{{@format_datetime($created_at)}}')
                    ->rawColumns(['action', 'id', 'project_name', 'expenses', 'supplierName', 'supplier_percent','created_by', 'created_at'])
                    ->make(true);
            }
            if (request()->get('type') == 'finished_projects') {
                $finalMaterials = FinishedProjectsView::select(
                    'finsihed_projects_view.project_name',
                    'finsihed_projects_view.supplier_name',
                    'finsihed_projects_view.supplier_total',
                    'finsihed_projects_view.expenses',
                    'finsihed_projects_view.box_rent_cost',
                    'finsihed_projects_view.driver_net_value',
                    'finsihed_projects_view.supplier_percent',
                    'finsihed_projects_view.supplier_net_value',
                    'finsihed_projects_view.supplier_net_after_expenses',
                    'finsihed_projects_view.created_by',
                    'finsihed_projects_view.created_at'
                )
                ;
                return Datatables::of($finalMaterials)
                    ->editColumn('created_at', '{{@format_datetime($created_at)}}')
                    ->editColumn(
                        'supplier_net_after_expenses',
                        function ($row) {
                            return '<span class="supplier_net_after_expenses" data-orig-value="'.$row->supplier_net_after_expenses.'">'.$this->transactionUtil->num_f($row->supplier_net_after_expenses,false).'</span>';
                        }
                    )
                    ->editColumn(
                        'supplier_total',
                        function ($row) {

                        return '<span class="supplier_total" data-orig-value="'.$row->supplier_total.'">'.$this->transactionUtil->num_f($row->supplier_total,false).'</span>';
                        }
                    )
                    ->editColumn(
                        'expenses',
                        function ($row) {

                            return '<span class="expenses" data-orig-value="'.$row->expenses.'">'.$this->transactionUtil->num_f($row->expenses,false).'</span>';
                        }
                    )
                    ->editColumn(
                        'box_rent_cost',
                        function ($row) {

                            return '<span class="box_rent_cost" data-orig-value="'.$row->box_rent_cost.'">'.$this->transactionUtil->num_f($row->box_rent_cost,false).'</span>';
                        }
                    )
                    ->editColumn(
                        'supplier_net_value',

                        function ($row) {

                            return '<span class="supplier_net_value" data-orig-value="'.$row->supplier_net_value.'">'.$this->transactionUtil->num_f($row->supplier_net_value,false).'</span>';
                        }
                    )
                    ->editColumn(
                        'driver_net_value',
                        function ($row) {

                            return '<span class="driver_net_value" data-orig-value="'.$row->driver_net_value.'">'.$this->transactionUtil->num_f($row->driver_net_value,false).'</span>';
                        }
                    )
                    ->addColumn(
                        'net_supplier_after_percent',
                        function ($row) {
                            $net_supplier_after_percent_var=$row->supplier_net_after_expenses*($row->supplier_percent/100);

                            return '<span class="net_supplier_after_percent" data-orig-value="'.$net_supplier_after_percent_var.'">'.$this->transactionUtil->num_f($net_supplier_after_percent_var,false).'</span>';
                        }
                    )
                    ->rawColumns([ 'project_name', 'supplier_name', 'supplier_total', 'expenses', 'box_rent_cost', 'driver_net_value', 'supplier_percent', 'supplier_net_value','supplier_net_after_expenses','created_by', 'created_at','net_supplier_after_percent'])
                    ->make(true);
            }
        }

        return view('zahraaprojects.index') ->with(compact('contact','finalMaterials22'));
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {

    }
    /**
     * Store a newly created resource in storage.
     *
     * @return \Illuminate\Http\Response
     */
    public function projectFinal($id)
    {

        $business_id = request()->session()->get('user.business_id');
        $user_id = request()->session()->get('user.id');
        $kashfhesabTotal=ZahraaKashfTotal::where('project_id','=',$id)
            ->get();

        $tax_id = null;
        $product_details = Product::join('variations', 'variations.product_id', '=', 'products.id')
            ->where('products.id', '=', '15080')
            ->select('products.id as id', 'variations.id as variations_id', 'variations.default_sell_price')
            ->first();

        $query = ZahraaProject::join('contacts','zahraa_projects.supplier_id','=','contacts.id')
            ->join('users','zahraa_projects.created_by','=','users.id')
            ->leftJoin('transactions', function($join)
            {
                $join->on('transactions.project_id', '=', 'zahraa_projects.id')
                    ->where('transactions.type','=',DB::raw('"expense"'))
                    ->whereNotNull('transactions.contact_id');
            })
            ->where('zahraa_projects.project_status','=','0');
        $finalMaterials = $query->select('zahraa_projects.id',
            'zahraa_projects.project_name',
            'zahraa_projects.supplier_percent',
            'contacts.name as supplierName',
            DB::raw('concat(users.first_name," ",users.last_name) as created_by'),
            DB::raw('ifnull(sum(transactions.final_total),0) as expenses'),
            'zahraa_projects.created_at'
        )
            ->where('zahraa_projects.id','=',$id)
            ->groupBy('zahraa_projects.id')->first();
        $finalExpenses=$finalMaterials->expenses;
        $countKashf=count($kashfhesabTotal);
        $finalExpenses=$finalExpenses/$countKashf;
        foreach ($kashfhesabTotal as $projectTotal)
        {

             $netTotal=$projectTotal->supplier_net_value-$projectTotal->driver_net_value-$projectTotal->box_rent_cost;
             $netTotal=$netTotal-$finalExpenses;
             $netTotal=$netTotal*($finalMaterials->supplier_percent/100);
             $products_array = array(
        'product_type' => 'single',
        'product_id' => $product_details->id,
        'variation_id' => $product_details->variations_id,
        'enable_stock' => '0',
        'quantity' => $netTotal,
        'product_unit_id' => '1',
        'sub_unit_id' => null,
        'base_unit_multiplier' => '1',
        'item_tax' => '0',
        'unit_price_inc_tax' => '1',

    );
             $ref_count = $this->productUtil->setAndGetReferenceCount('purchase');
             //Generate reference number
            if (empty($transaction_data['ref_no'])) {
                $invoice_no = $this->productUtil->generateReferenceNumber('purchase', $ref_count);
            }
            $transaction = Transaction::create([
        'business_id' => $business_id,
        'location_id' => '1',
        'type' => 'purchase',
        'discount_type' => 'percentage',
        'payment_status' => 'due',
        'status' => 'received',
        'contact_id' => $projectTotal->supplier_id,
        'ref_no' => $invoice_no,
        'total_before_tax' => $netTotal,
        'transaction_date' => $projectTotal->created_at,
        'final_total' => $netTotal,
        'created_by' => $user_id,
        'is_direct_sale' => 1,
        'exchange_rate' => 1,
        'is_suspend' => 0,
        'is_recurring' => 0,
        'recur_interval' => 1,
        'recur_interval_type' => null,
        'project_id'=>$id,
    ]);
            $line = array(
        'transaction_id' => $transaction->id,
        'product_id' => $products_array['product_id'],
        'variation_id' => $products_array['variation_id'],
        'quantity' => $products_array['quantity'],
        'pp_without_discount' => $products_array['unit_price_inc_tax'],
        'discount_percent' => '0',
        'purchase_price' => $products_array['unit_price_inc_tax'],
        'purchase_price_inc_tax' => $products_array['unit_price_inc_tax'],
        'item_tax' => '0'
    );
            PurchaseLine::create($line);
        }

        $projectMain=ZahraaProject::where('id','=',$id)->first();
        $projectMain->project_status=1;
        $projectMain->save();

        return redirect('zahraaProjects');

    }

    /**
     * Store a newly created resource in storage.
     *
     * @return \Illuminate\Http\Response
     */
    public function projectFinish($id)
    {
        $project=ZahraaProject::join('contacts','zahraa_projects.supplier_id','=','contacts.id')
            ->select('contacts.id as suppler_id', DB::raw('CONCAT(contacts.name, " - ",
	contacts.mobile, " - ",
	CASE
	WHEN type="customer"
	THEN "عميل"
	ELSE
	"مورد"
	end ) as contactName'),'project_name','zahraa_projects.id as project_id')
            ->where('zahraa_projects.id','=',$id)->first();
        $query = ZahraaProject::join('contacts','zahraa_projects.supplier_id','=','contacts.id')
            ->join('users','zahraa_projects.created_by','=','users.id')
            ->leftJoin('transactions', function($join)
            {
                $join->on('transactions.project_id', '=', 'zahraa_projects.id')
                    ->where('transactions.type','=',DB::raw('"expense"'))
                    ->whereNotNull('transactions.contact_id');
            })
            ->where('zahraa_projects.project_status','=','0');
        $finalMaterials = $query->select('zahraa_projects.id',
            'zahraa_projects.project_name',
            'zahraa_projects.supplier_percent',
            'contacts.name as supplierName',
            DB::raw('concat(users.first_name," ",users.last_name) as created_by'),
            DB::raw('ifnull(sum(transactions.final_total),0) as expenses'),
            'zahraa_projects.created_at'
        )
            ->groupBy('zahraa_projects.id')
            ->first();
        $business_id = request()->session()->get('user.business_id');
        $currency_details = $this->transactionUtil->purchaseCurrencyDetails($business_id);
        $business_locations = BusinessLocation::forDropdown($business_id, false, true);
        $bl_attributes = $business_locations['attributes'];
        $business_locations = $business_locations['locations'];
        $default_purchase_status = null;
        if (request()->session()->get('business.enable_purchase_status') != 1) {
            $default_purchase_status = 'received';
        }
        $types = [];
        if (auth()->user()->can('supplier.create')) {
            $types['supplier'] = __('report.supplier');
        }
        if (auth()->user()->can('customer.create')) {
            $types['customer'] = __('report.customer');
        }
        if (auth()->user()->can('supplier.create') && auth()->user()->can('customer.create')) {
            $types['both'] = __('lang_v1.both_supplier_customer');
        }
        $customer_groups = CustomerGroup::forDropdown($business_id);

        $business_details = $this->businessUtil->getDetails($business_id);
        $query = Contact::where('contacts.business_id', $business_id)
            ->where('contacts.name', '<>', 'Walk-In Customer')
            ->where('contacts.name', '<>', '')
            ->where('contacts.type', '=', 'supplier');
        //$query->onlySuppliers();
        $query->select('contacts.id', DB::raw('CONCAT(contacts.name, " - ",
	contacts.mobile, " - ",
	CASE
	WHEN type="customer"
	THEN "عميل"
	ELSE
	"مورد"
	end ) as contactName'));
        $query2 = Contact::where('contacts.business_id', $business_id)
            ->where('contacts.name', '<>', 'Walk-In Customer')
            ->where('contacts.name', '<>', '')
            ->where('contacts.type', '=', 'customer');
        //$query->onlySuppliers();
        $query2->select('contacts.id', DB::raw('CONCAT(contacts.name, " - ",
	contacts.mobile, " - ",
	CASE
	WHEN type="customer"
	THEN "عميل"
	ELSE
	"مورد"
	end ) as contactName'));

        $query3 = Contact::where('contacts.business_id', $business_id)
            ->where('contacts.name', '<>', 'Walk-In Customer')
            ->where('contacts.name', '<>', '')
            ->where('contacts.type', '=', 'driver');
        //$query->onlySuppliers();
        $query3->select('contacts.id', DB::raw('CONCAT(contacts.name, " - ",
	contacts.mobile, " - ",
	CASE
	WHEN type="customer"
	THEN "عميل"
	WHEN type="supplier"
	THEN "مورد"
	ELSE
	"سائق"
	end ) as contactName'));

        $contact = $query->pluck('contactName', 'id');
        $contactCustomer = $query2->pluck('contactName', 'id');
        $cars = TransportCar::where('business_id', '=', $business_id)
            ->get();
        $users = $query3->pluck('contactName', 'id');

        return view('zahraaprojects.createSupplierStatement')
            ->with(compact('business_id', 'contact', 'project', 'currency_details', 'default_purchase_status', 'customer_groups', 'types', 'cars', 'users', 'contactCustomer','finalMaterials'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $transaction_data = $request->only([ 'supplier_id', 'move_line', 'default_days', 'on_land_date', 'out_land_date', 'factory_date','days_total_number', 'days_diff','day_cost','shipping_cost','carpalet','driver_name','contact_customer_id','qty_weight','west_per','net_amount_weight','kg_price','kg_price_client','net_money','net_money_client','box_amount_total','box_count','final_amount_total_client','final_amount_total']);
        try {
            $business_id = $request->session()->get('user.business_id');
            $user_id = $request->session()->get('user.id');

            $transaction_data = $request->only([ 'supplier_id', 'move_line', 'default_days', 'on_land_date', 'out_land_date', 'factory_date','days_total_number', 'days_diff','day_cost','shipping_cost','carpalet','driver_name','contact_customer_id','qty_weight','west_per','net_amount_weight','kg_price','kg_price_client','net_money','net_money_client','box_amount_total','box_count','final_amount_total_client','final_amount_total']);

            $driverNetValue=$request->get('days_diff')*$request->get('day_cost');
            $driverNetValue+=$request->get('shipping_cost');

            $input=array(
                'supplier_id'=>$request->get('supplier_id'),
                'customer_id'=>$request->get('contact_customer_id'),
                'driver_id'=>$request->get('driver_name'),
                'move_line_id'=>$request->get('move_line'),
                'car_palate_id'=>$request->get('carpalet'),
                'days_default'=>$request->get('default_days'),
                'on_land_date'=>$request->get('on_land_date'),
                'out_land_date'=>$request->get('out_land_date'),
                'on_factory_date'=>$request->get('factory_date'),
                'total_days_no'=>$request->get('days_total_number'),
                'stay_days_no'=>$request->get('days_diff'),
                'stay_day_cost'=>$request->get('day_cost'),
                'shipping_cost'=>$request->get('shipping_cost'),
                'main_weight'=>$request->get('qty_weight'),
                'loses_percent'=>$request->get('west_per'),
                'net_weight'=>$request->get('net_amount_weight'),
                'supplier_price'=>$request->get('kg_price'),
                'customer_price'=>$request->get('kg_price_client'),
                'supplier_total'=>$request->get('net_money'),
                'customer_total'=>$request->get('net_money_client'),
                'box_rent_cost'=>$request->get('box_amount_total'),
                'box_count'=>$request->get('box_count'),
                'supplier_net_value'=>$request->get('final_amount_total'),
                'customer_net_value'=>$request->get('final_amount_total_client'),
                'project_id'=>$request->get('project_id'),
                'is_project'=>'1',
                'driver_net_value'=>$driverNetValue,
                'created_by'=>$user_id
            );

            $kashTransaction=ZahraaKashfTotal::create($input);
            $projectMain=ZahraaProject::where('id','=',$request->get('project_id'))->first();

            $user_id = $request->session()->get('user.id');

            $sale_type = 'sell';
            $invoice_scheme_id = '1';
            $invoice_no = $this->transactionUtil->getInvoiceNumber($business_id, 'final', '1', $invoice_scheme_id, $sale_type);
            $uf_data = true;
            $discount = ['discount_type' => 'percentage',
                'discount_amount' => '0'
            ];
            $tax_id = null;
            $product_details = Product::join('variations', 'variations.product_id', '=', 'products.id')
                ->where('products.id', '=', '15080')
                ->select('products.id as id', 'variations.id as variations_id', 'variations.default_sell_price')
                ->first();

            $products_array = array(
                'product_type' => 'single',
                'product_id' => $product_details->id,
                'variation_id' => $product_details->variations_id,
                'enable_stock' => '0',
                'quantity' => $request->get('final_amount_total_client'),
                'product_unit_id' => '1',
                'sub_unit_id' => null,
                'base_unit_multiplier' => '1',
                'item_tax' => '0',
                'unit_price_inc_tax' => '1',

            );
            $transaction = Transaction::create([
                'business_id' => $business_id,
                'location_id' => '1',
                'type' => 'sell',
                'discount_type' => 'percentage',
                'payment_status' => 'due',
                'status' => 'final',
                'contact_id' => $request->get('contact_customer_id'),
                'invoice_no' => $invoice_no,
                'total_before_tax' => $request->get('final_amount_total_client'),
                'transaction_date' => now(),
                'final_total' => $request->get('final_amount_total_client'),
                'created_by' => $user_id,
                'is_direct_sale' => 1,
                'exchange_rate' => 1,
                'is_suspend' => 0,
                'is_recurring' => 0,
                'recur_interval' => 1,
                'recur_interval_type' => null,
                'project_id'=>$request->get('project_id'),
            ]);


            $line = array(
                'transaction_id' => $transaction->id,
                'product_id' => $products_array['product_id'],
                'variation_id' => $products_array['variation_id'],
                'quantity' => $products_array['quantity'],
                'unit_price_before_discount' => $products_array['unit_price_inc_tax'],
                'unit_price' => '1',
                'line_discount_type' => null,
                'line_discount_amount' => 0,
                'item_tax' => 0,
                'tax_id' => null,
                'unit_price_inc_tax' => $products_array['unit_price_inc_tax'],
                'sell_line_note' => '',
                'sub_unit_id' => null,
                'discount_id' => null,
                'res_line_order_status' => 'received',
                'so_line_id' => null,
            );
            TransactionSellLine::create($line);

            $ref_count = $this->productUtil->setAndGetReferenceCount('expense');
            $invoice_no = $this->productUtil->generateReferenceNumber('expense', $ref_count);
            $transaction = Transaction::create([
                'business_id' => $business_id,
                'location_id' => '1',
                'type' => 'expense',
                'discount_type' => 'percentage',
                'payment_status' => 'due',
                'status' => 'final',
                'expense_for' => $request->get('driver_name'),
                'ref_no' => $invoice_no,
                'total_before_tax' => $driverNetValue,
                'transaction_date' => now(),
                'final_total' => $driverNetValue,
                'created_by' => $user_id,
                'is_direct_sale' => 1,
                'exchange_rate' => 1,
                'is_suspend' => 0,
                'is_recurring' => 0,
                'expense_category_id' => 13,
                'recur_interval' => 1,
                'recur_interval_type' => null,
                'project_id'=>$request->get('project_id'),

            ]);

            $output = ['success' => 1,
                'msg' => __('purchase.purchase_add_success')
            ];
        } catch (Exception $e) {
            DB::rollBack();
            Log::emergency("File:" . $e->getFile() . "Line:" . $e->getLine() . "Message:" . $e->getMessage().'\n'.print_r($transaction_data));

            $output = ['success' => 0,
                'msg' => __('messages.something_went_wrong')
            ];
        }

        return redirect('supplierKashf')->with('status', $output);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */

    public function storeProject(Request $request)
    {
        if (request()->ajax()) {

            try {
                $business_id = $request->session()->get('user.business_id');
                $user_id = $request->session()->get('user.id');
                $contact=Contact::where('id','=',$request->input('supplier_id'))->first();
                $input=array(
                    'project_name'=>$request->input('project_name')." - ".date("Y/m")."/".$request->input('percent')."%"." - ".$contact->name,
                    'supplier_id'=>$request->input('supplier_id'),
                    'project_status'=>'0',
                    'created_by'=>$user_id,
                    'supplier_percent'=>$request->input('percent')
                );
                $project=ZahraaProject::create(
                    $input
                );

                return $project;
            }
            catch (Exception $ee) {
                return $ee;
                \Log::emergency("File:" . $e->getFile() . "Line:" . $e->getLine() . "Message:" . $ee->getMessage());
            }
        }
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */

    public function storeExpenses(Request $request)
    {
        if (request()->ajax()) {

            try {
                $business_id = $request->session()->get('user.business_id');
                $user_id = $request->session()->get('user.id');
                $ref_count = $this->productUtil->setAndGetReferenceCount('expense');
                $invoice_no = $this->productUtil->generateReferenceNumber('expense', $ref_count);
                $projectInfo=ZahraaProject::where('id','=',$request->get('project_id'))->first();
                $transaction = Transaction::create([
                    'business_id' => $business_id,
                    'location_id' => '1',
                    'type' => 'expense',
                    'discount_type' => 'percentage',
                    'payment_status' => 'due',
                    'status' => 'final',
                    'contact_id' => $projectInfo->supplier_id,
                    'ref_no' => $invoice_no,
                    'total_before_tax' => $request->get('expense_cost'),
                    'transaction_date' => now(),
                    'final_total' => $request->get('expense_cost'),
                    'created_by' => $user_id,
                    'is_direct_sale' => 1,
                    'exchange_rate' => 1,
                    'is_suspend' => 0,
                    'is_recurring' => 0,
                    'expense_category_id' =>14,
                    'recur_interval' => 1,
                    'recur_interval_type' => null,
                    'project_id' => $request->get('project_id'),
                    'additional_notes' => $request->get('additional_notes'),
                ]);

                return $transaction;
            }
            catch (Exception $ee) {
                return $ee;
                \Log::emergency("File:" . $e->getFile() . "Line:" . $e->getLine() . "Message:" . $ee->getMessage());
            }
        }
    }

}