<?php


namespace App\Http\Controllers;


use App\AlboLayerPasteSubGroup;
use App\Contact;
use App\TransportCar;
use App\TransportLine;
use App\User;
use App\Utils\BusinessUtil;
use App\Utils\ContactUtil;
use App\Utils\ModuleUtil;
use App\Utils\ProductUtil;
use App\Utils\TransactionUtil;
use App\Utils\Util;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;

class TransportDaysHandlerController extends Controller
{
    protected $commonUtil;
    protected $contactUtil;
    protected $businessUtil;
    protected $productUtil;
    protected $transactionUtil;


    public function __construct(Util $commonUtil,
                                ContactUtil $contactUtil,
                                TransactionUtil $transactionUtil,
                                ModuleUtil $moduleUtil,
                                ProductUtil $productUtil,
                                BusinessUtil $businessUtil)
    {
        $this->commonUtil = $commonUtil;
        $this->contactUtil = $contactUtil;
        $this->businessUtil = $businessUtil;
        $this->transactionUtil = $transactionUtil;
        $this->productUtil = $productUtil;
        $this->moduleUtil = $moduleUtil;


    }

    /**
     * Display a listing of the resource.
     * @return Response
     */
    public function index()
    {
        $business_id = request()->session()->get('user.business_id');
        $query=Contact::where('contacts.business_id', $business_id)
        ->where('contacts.name','<>','Walk-In Customer')
        ->where('contacts.name','<>','');
        //$query->onlySuppliers();
        $query->select('contacts.id',DB::raw('CONCAT(contacts.name, " - ",
	contacts.mobile, " - ",
	CASE
	WHEN type="customer"
	THEN "عميل"
	ELSE
	"مورد"
	end ) as contactName'));

        $contact=TransportCar::where('business_id', '=', $business_id)
            ->select('car_type',DB::raw('car_type as car_palate_type'))
            ->distinct()
            ->pluck('car_palate_type','car_type');
        $transports=
            TransportLine::join('transport_cars','transport_lines.car_palete_id','=','transport_cars.id')
            ->select(DB::raw('concat(transport_cars.car_palet," (",transport_cars.car_type,")") as car_palate_type'),'transport_lines.move_from','transport_lines.move_to','transport_lines.days_count','transport_lines.shipping_cost','transport_lines.id','transport_cars.day_cost')
            ->get()->toArray();
        //$contact=Contact::where('contacts.business_id', $business_id);

        return view('zahraakashf.transportMove')
            ->with(compact('contact','transports'))
            ;
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */

    public function storeContactSmall(Request $request)
    {
        if (request()->ajax()) {

            try {
                $business_id = $request->session()->get('user.business_id');
                $emailAccount = $request->input('mobile') . '@rsegy.com';
                $input = array(
                    'type' => 'customer',
                    'business_id' => $business_id,
                    'created_by' => auth()->user()->id,
                    'first_name' => $request->input('first_name'),
                    'middle_name' => $request->input('middle_name'),
                    'last_name' => $request->input('last_name'),
                    'email' => $emailAccount,
                    'mobile' => $request->input('mobile')
                );
                if($request->input('contactType')==1)
                {
                    $input['type']='customer';
                }
                else
                {
                    $input['type']='supplier';
                }
                $name_array = [];
                if (!empty($input['first_name'])) {
                    $name_array[] = $input['first_name'];
                }
                if (!empty($input['middle_name'])) {
                    $name_array[] = $input['middle_name'];
                }
                if (!empty($input['last_name'])) {
                    $name_array[] = $input['last_name'];
                }
                $input['name'] = trim(implode(' ', $name_array));
                $ref_count = $this->contactUtil->setAndGetReferenceCount('contacts', $business_id);
                $contact_idref = $this->contactUtil->generateReferenceNumber('contacts', $ref_count, $business_id);
                $input['contact_id'] = $contact_idref;
                $contact = Contact::create($input);

                return $contact;
            }
            catch (Exception $ee) {
                return $ee;
                \Log::emergency("File:" . $e->getFile() . "Line:" . $e->getLine() . "Message:" . $ee->getMessage());
            }
        }
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */

    public function storeDriverSmall(Request $request)
    {
        if (request()->ajax()) {

            try {

                $business_id = $request->session()->get('user.business_id');
                $emailAccount = $request->input('mobile') . '@rsegy.com';
                $input = array(
                    'type' => 'customer',
                    'business_id' => $business_id,
                    'created_by' => auth()->user()->id,
                    'first_name' => $request->input('first_name'),
                    'middle_name' => '',
                    'last_name' => $request->input('last_name'),
                    'email' => $emailAccount,
                    'mobile' => $request->input('mobile')
                );

                    $input['type']='driver';

                $name_array = [];
                if (!empty($input['first_name'])) {
                    $name_array[] = $input['first_name'];
                }
                if (!empty($input['middle_name'])) {
                    $name_array[] = $input['middle_name'];
                }
                if (!empty($input['last_name'])) {
                    $name_array[] = $input['last_name'];
                }
                $input['name'] = trim(implode(' ', $name_array));
                $ref_count = $this->contactUtil->setAndGetReferenceCount('contacts', $business_id);
                $contact_idref = $this->contactUtil->generateReferenceNumber('contacts', $ref_count, $business_id);
                $input['contact_id'] = $contact_idref;
                $contact = Contact::create($input);

                return $contact;
            }
            catch (Exception $ee) {
                return $ee;
                \Log::emergency("File:" . $e->getFile() . "Line:" . $e->getLine() . "Message:" . $ee->getMessage());
            }
        }
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */

    public function storeTransportDestination(Request $request)
    {
        if (request()->ajax()) {

            try {
                $business_id = $request->session()->get('user.business_id');
                $carTypes=TransportCar::where('car_type','=',$request->input('car_palete_id'))
                    ->get();
                foreach ($carTypes as $car)
                {
                    TransportLine::where('car_palete_id','=',$car->id)
                        ->where('move_from','=',$request->input('transport_from'))
                        ->where('move_to','=',$request->input('transport_to'))
                        ->delete();

                }
                foreach ($carTypes as $car)
                {
                    $input=[
                        'business_id'=>   $business_id,
                        'created_by'=>auth()->user()->id,
                        'move_from'=>$request->input('transport_from'),
                        'move_to'=>$request->input('transport_to'),
                        'days_count'=>$request->input('days_count'),
                        'car_palete_id'=>$car->id,
                        'shipping_cost'=>$request->input('ShippingCost')
                    ];


                    $transport=TransportLine::create($input);
                }


                return $transport;
            }
            catch (Exception $ee) {
                return $ee;
                \Log::emergency("File:" . $e->getFile() . "Line:" . $e->getLine() . "Message:" . $ee->getMessage());
            }
        }
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */

    public function DriverMovesAccounts($id){

    }

}