<?php


namespace App\Http\Controllers;


use App\AlboTemplateMainTable;
use App\BusinessLocation;
use App\Contact;
use App\CustomerGroup;
use App\DrvierStatement;
use App\Product;
use App\PurchaseLine;
use App\Transaction;
use App\TransactionSellLine;
use App\TransportCar;
use App\TransportLine;
use App\User;
use App\Utils\BusinessUtil;
use App\Utils\ContactUtil;
use App\Utils\ModuleUtil;
use App\Utils\ProductUtil;
use App\Utils\TransactionUtil;
use App\Utils\Util;
use App\ZahraaKashfTotal;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Log;
use Yajra\DataTables\Facades\DataTables;

class SupplierKashfController extends Controller
{

    protected $commonUtil;
    protected $contactUtil;
    protected $businessUtil;
    protected $productUtil;
    protected $transactionUtil;


    public function __construct(Util $commonUtil,
                                ContactUtil $contactUtil,
                                TransactionUtil $transactionUtil,
                                ModuleUtil $moduleUtil,
                                ProductUtil $productUtil,
                                BusinessUtil $businessUtil)
    {
        $this->commonUtil = $commonUtil;
        $this->contactUtil = $contactUtil;
        $this->businessUtil = $businessUtil;
        $this->transactionUtil = $transactionUtil;
        $this->productUtil = $productUtil;
        $this->moduleUtil = $moduleUtil;


    }


    /**
     * Display a listing of the resource.
     * @return Response
     */
    public function index()
    {
        $business_id = request()->session()->get('user.business_id');

        if (request()->ajax()) {
            if (request()->get('type') == 'supplier') {

                $query = ZahraaKashfTotal::join('contacts','zahraa_kashf_totals.supplier_id','=','contacts.id')
                ->leftjoin('transport_cars','zahraa_kashf_totals.car_palate_id','=','transport_cars.id')
                ->leftjoin('contacts as cd','zahraa_kashf_totals.driver_id','=','cd.id')
                ->leftjoin('zahraa_projects','zahraa_kashf_totals.project_id','=','zahraa_projects.id');
                $materialuses = request()->get('supplier_id', null);

                if (!empty($materialuses)) {
                    $query->where('zahraa_kashf_totals.supplier_id', $materialuses);
                }
                $start = request()->get('date_start', null);
                $end = request()->get('date_end', null);
                if(!empty($start)){
                    $query->whereDate('zahraa_kashf_totals.created_at','>=', $start)
                    ->whereDate('zahraa_kashf_totals.created_at','<=', $end);
                }
                $finalMaterials = $query->select('zahraa_kashf_totals.id',
                    'contacts.name as supplierName',
                    'zahraa_kashf_totals.on_land_date',
                    'zahraa_kashf_totals.on_factory_date',
                    DB::raw('ifnull(transport_cars.car_palet,zahraa_kashf_totals.car_plate_name) as car_palet'),
                    DB::raw("CASE 
		WHEN zahraa_kashf_totals.is_wasal = 1
		then
		 zahraa_kashf_totals.driver_name
		 else
                    cd.name
                    end
                    as driver_name"),
                    'zahraa_kashf_totals.main_weight',
                    DB::raw('CASE 
		WHEN zahraa_kashf_totals.is_project=0 and zahraa_kashf_totals.is_direct_buy=1 THEN
zahraa_kashf_totals.loses_percent_supplier 
	ELSE
zahraa_kashf_totals.loses_percent 
END as loses_percent'),
                    DB::raw('CASE 
		WHEN zahraa_kashf_totals.is_project=0 and zahraa_kashf_totals.is_direct_buy=1 THEN
zahraa_kashf_totals.net_weight_supplier 
	ELSE
zahraa_kashf_totals.net_weight 
END as net_weight'),
                    'zahraa_kashf_totals.supplier_price',
                    'zahraa_kashf_totals.box_rent_cost',
                    'zahraa_kashf_totals.stay_days_no',
                    DB::raw('(zahraa_kashf_totals.stay_days_no*zahraa_kashf_totals.stay_day_cost) as stay_day_cost'),
                    'zahraa_kashf_totals.shipping_cost',
                    'zahraa_kashf_totals.supplier_net_value',
                    'zahraa_kashf_totals.created_at',
                    'zahraa_kashf_totals.supplier_id',
                    'zahraa_kashf_totals.customer_id',
                    DB::raw('
	CASE 
	when zahraa_projects.project_status=1
	then "مشروع منتهى"
		when zahraa_projects.project_status=0
		then
	"مشروع تحت التشغيل"
	ELSE
	""
	END as project_status'),
                    DB::raw('CASE 
	WHEN zahraa_kashf_totals.is_project=0 and zahraa_kashf_totals.is_direct_buy=0 and  zahraa_kashf_totals.is_wasal=0  THEN
		"عمولة"
	WHEN zahraa_kashf_totals.is_project=0 and zahraa_kashf_totals.is_direct_buy=0 and  zahraa_kashf_totals.is_wasal=1 THEN
		"عمولة (وصال)"
		WHEN zahraa_kashf_totals.is_project=0 and zahraa_kashf_totals.is_direct_buy=1 and  zahraa_kashf_totals.is_wasal=0  THEN
		"شراء مباشر"
		WHEN zahraa_kashf_totals.is_project=0 and zahraa_kashf_totals.is_direct_buy=1 and  zahraa_kashf_totals.is_wasal=1  THEN
		"شراء مباشر (وصال)"
	ELSE
		"مشاركة"
END as kashfType')
                );
                return Datatables::of($finalMaterials)
                    ->addColumn('action',
                        function ($row) {
                            $html = '<div class="btn-group">
                                    <button type="button" class="btn btn-info dropdown-toggle btn-xs" 
                                        data-toggle="dropdown" aria-expanded="false">' .
                                __('messages.actions') .
                                '<span class="caret"></span><span class="sr-only">Toggle Dropdown
                                        </span>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-left" role="menu">';
                            $html .= '<li><a target="_blank" href="'. action('ContactController@show', [$row->supplier_id]) . '"><i class="fas fa-eye"></i> ' . __('messages.view') . '</a></li>';
                            $html .= '<li><a target="_blank" href="#"><i class="fas fa-edit"></i> ' . __('messages.edit') . '</a></li>';


                            $html .= '<li><a href="' . action('SupplierKashfController@deleteKashf', [$row->id]) . '" onclick="return confirm(\'Are you sure you want to Delete this Operation?\');"><i class="fas fa-trash"></i> ' . __('messages.delete') . '</a></li>';
                            $html .= '</ul></div>';
                            return $html;
                        })
                    ->editColumn('supplierName', function ($row){
                        $html= $row->supplierName.'  <a target="_blank" class="btn btn-warning" href="'. action('ContactController@show', [$row->supplier_id]) . '"><i class="fas fa-eye"></i> '  . '</a> ';
                        return $html;
                    })
                    ->editColumn('created_at', '{{@format_datetime($created_at)}}')
                    ->rawColumns(['action', 'id', 'supplierName', 'on_land_date','on_factory_date','car_palet','main_weight','loses_percent','net_weight', 'supplier_price','box_rent_cost','stay_days_no','stay_day_cost', 'shipping_cost', 'supplier_net_value', 'created_at','project_status','kashfType','driver_name'])
                    ->make(true);
            }
            if (request()->get('type') == 'customer') {
                $query = ZahraaKashfTotal::join('contacts','zahraa_kashf_totals.customer_id','=','contacts.id')
                    ->leftjoin('transport_cars','zahraa_kashf_totals.car_palate_id','=','transport_cars.id')
                    ->leftjoin('contacts as cd','zahraa_kashf_totals.driver_id','=','cd.id');
                $materialuses = request()->get('customer_id', null);
                if (!empty($materialuses)) {
                    $query->where('zahraa_kashf_totals.customer_id', $materialuses);
                }
                $start = request()->get('date_start', null);
                $end = request()->get('date_end', null);
                if(!empty($start)){
                    $query->whereDate('zahraa_kashf_totals.created_at','>=', $start)
                        ->whereDate('zahraa_kashf_totals.created_at','<=', $end);
                }
                $finalMaterials = $query->select('zahraa_kashf_totals.id',
                    'contacts.name as customerName',
                    'zahraa_kashf_totals.on_land_date',
                    'zahraa_kashf_totals.on_factory_date',
                    DB::raw('ifnull(transport_cars.car_palet,zahraa_kashf_totals.car_plate_name) as car_palet'),
                    DB::raw("CASE 
		WHEN zahraa_kashf_totals.is_wasal = 1
		then
		 zahraa_kashf_totals.driver_name
		 else
                    cd.name
                    end
                    as driver_name"),
                    'zahraa_kashf_totals.factory_name',
                    'zahraa_kashf_totals.main_weight',
                    'zahraa_kashf_totals.loses_percent',
                    'zahraa_kashf_totals.net_weight',
                    'zahraa_kashf_totals.customer_price',
                    'zahraa_kashf_totals.box_rent_cost',
                    'zahraa_kashf_totals.stay_days_no',
                    'zahraa_kashf_totals.stay_day_cost',
                    'zahraa_kashf_totals.shipping_cost',
                    'zahraa_kashf_totals.customer_net_value',
                    'zahraa_kashf_totals.created_at',
                    'zahraa_kashf_totals.supplier_id',
                    'zahraa_kashf_totals.customer_id'
                );
                return Datatables::of($finalMaterials)
                    ->addColumn('action',
                        function ($row) {
                            $html = '<div class="btn-group">
                                    <button type="button" class="btn btn-info dropdown-toggle btn-xs" 
                                        data-toggle="dropdown" aria-expanded="false">' .
                                __('messages.actions') .
                                '<span class="caret"></span><span class="sr-only">Toggle Dropdown
                                        </span>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-left" role="menu">';
                            $html .= '<li><a target="_blank" href="'. action('ContactController@show', [$row->customer_id]) . '"><i class="fas fa-eye"></i> ' . __('messages.view') . '</a></li>';
                            $html .= '<li><a target="_blank" href="#"><i class="fas fa-edit"></i> ' . __('messages.edit') . '</a></li>';
                            $html .= '<li><a href="' . action('SupplierKashfController@deleteKashf', [$row->id]) . '" onclick="return confirm(\'Are you sure you want to Delete this Operation?\');"><i class="fas fa-trash"></i> ' . __('messages.delete') . '</a></li>';
                            $html .= '</ul></div>';
                            return $html;
                        })
                    ->editColumn('customerName', function ($row){
                        $html= $row->customerName.'  <a target="_blank" class="btn btn-warning" href="'. action('ContactController@show', [$row->customer_id]) . '"><i class="fas fa-eye"></i> '  . '</a> ';
                        return $html;
                    })
                    ->editColumn('created_at', '{{@format_datetime($created_at)}}')
                    ->rawColumns(['action', 'id', 'customerName', 'on_land_date','on_factory_date','car_palet','main_weight','loses_percent','net_weight', 'customer_price','box_rent_cost','stay_days_no','stay_day_cost', 'shipping_cost', 'customer_net_value', 'created_at','factory_name','driver_name'])
                    ->make(true);
            }
            if (request()->get('type') == 'driver') {
                $query = ZahraaKashfTotal:: join('contacts as cd','zahraa_kashf_totals.driver_id','=','cd.id')
                ->join('transport_cars','zahraa_kashf_totals.car_palate_id','=','transport_cars.id');
                $materialuses = request()->get('driver_id', null);
                if (!empty($materialuses)) {
                    $query->where('zahraa_kashf_totals.driver_id', $materialuses);
                }
                $start = request()->get('date_start', null);
                $end = request()->get('date_end', null);
                if(!empty($start)){
                    $query->whereDate('zahraa_kashf_totals.created_at','>=', $start)
                        ->whereDate('zahraa_kashf_totals.created_at','<=', $end);
                }
                $finalMaterials = $query->select('zahraa_kashf_totals.id',
                    'cd.name as driverName',
                    'zahraa_kashf_totals.on_land_date',
                    'zahraa_kashf_totals.out_land_date',
                    'zahraa_kashf_totals.on_factory_date',
                    'transport_cars.car_palet',
                    'zahraa_kashf_totals.total_days_no',
                    'zahraa_kashf_totals.days_default',
                    'zahraa_kashf_totals.box_count',
                    'zahraa_kashf_totals.customer_price',
                    'zahraa_kashf_totals.stay_days_no',
                    'zahraa_kashf_totals.stay_day_cost',
                    'zahraa_kashf_totals.shipping_cost',
                    'zahraa_kashf_totals.driver_net_value',
                    'zahraa_kashf_totals.created_at',
                    'zahraa_kashf_totals.driver_id'
                );
                return Datatables::of($finalMaterials)
                    ->addColumn('action',
                        function ($row) {
                            $html = '<div class="btn-group">
                                    <button type="button" class="btn btn-info dropdown-toggle btn-xs" 
                                        data-toggle="dropdown" aria-expanded="false">' .
                                __('messages.actions') .
                                '<span class="caret"></span><span class="sr-only">Toggle Dropdown
                                        </span>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-left" role="menu">';

                            $html .= '<li><a target="_blank" href="#"><i class="fas fa-edit"></i> ' . __('messages.edit') . '</a></li>';
                            $html .= '<li><a href="' . action('SupplierKashfController@deleteKashf', [$row->id]) . '" onclick="return confirm(\'Are you sure you want to Delete this Operation?\');"><i class="fas fa-trash"></i> ' . __('messages.delete') . '</a></li>';
                            $html .= '</ul></div>';
                            return $html;
                        })
                    ->editColumn('created_at', '{{@format_datetime($created_at)}}')
                    ->editColumn('driverName', function ($row){
                        $html= $row->driverName.'  <a target="_blank" class="btn btn-warning" href="'. action('ContactController@show', [$row->driver_id])   . '"><i class="fas fa-eye"></i> '  . '</a> ';
                        return $html;
                    })
                    ->rawColumns(['action', 'id', 'driverName', 'on_land_date','out_land_date','on_factory_date','car_palet','total_days_no','days_default','box_count', 'customer_price','stay_days_no','stay_day_cost', 'shipping_cost', 'customer_net_value', 'created_at'])
                    ->make(true);
            }
        }
        $query = Contact::where('contacts.business_id', $business_id)
            ->where('contacts.name', '<>', 'Walk-In Customer')
            ->where('contacts.name', '<>', '')
            ->where('contacts.type', '=', 'supplier');
        //$query->onlySuppliers();
        $query->select('contacts.id', DB::raw('CONCAT(contacts.name, " - ",
	contacts.mobile, " - ",
	CASE
	WHEN type="customer"
	THEN "عميل"
	ELSE
	"مورد"
	end ) as contactName'));
        $query2 = Contact::where('contacts.business_id', $business_id)
            ->where('contacts.name', '<>', 'Walk-In Customer')
            ->where('contacts.name', '<>', '')
            ->where('contacts.type', '=', 'customer');
        //$query->onlySuppliers();
        $query2->select('contacts.id', DB::raw('CONCAT(contacts.name, " - ",
	contacts.mobile, " - ",
	CASE
	WHEN type="customer"
	THEN "عميل"
	ELSE
	"مورد"
	end ) as contactName'));
        $query3 = Contact::where('contacts.business_id', $business_id)
            ->where('contacts.name', '<>', 'Walk-In Customer')
            ->where('contacts.name', '<>', '')
            ->where('contacts.type', '=', 'driver');
        //$query->onlySuppliers();
        $query3->select('contacts.id', DB::raw('CONCAT(contacts.name, " - ",
	contacts.mobile, " - ",
	CASE
	WHEN type="customer"
	THEN "عميل"
	WHEN type="supplier"
	THEN "مورد"
	ELSE
	"سائق"
	end ) as contactName'));
        $contact = $query->pluck('contactName', 'id');
        $contactCustomer = $query2->pluck('contactName', 'id');
        $users = $query3->pluck('contactName', 'id');
        return view('zahraakashf.index')->with(compact('business_id', 'contact', 'users', 'contactCustomer'));;
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        $business_id = request()->session()->get('user.business_id');
        $currency_details = $this->transactionUtil->purchaseCurrencyDetails($business_id);
        $business_locations = BusinessLocation::forDropdown($business_id, false, true);
        $bl_attributes = $business_locations['attributes'];
        $business_locations = $business_locations['locations'];
        $default_purchase_status = null;
        if (request()->session()->get('business.enable_purchase_status') != 1) {
            $default_purchase_status = 'received';
        }
        $types = [];
        if (auth()->user()->can('supplier.create')) {
            $types['supplier'] = __('report.supplier');
        }
        if (auth()->user()->can('customer.create')) {
            $types['customer'] = __('report.customer');
        }
        if (auth()->user()->can('supplier.create') && auth()->user()->can('customer.create')) {
            $types['both'] = __('lang_v1.both_supplier_customer');
        }
        $customer_groups = CustomerGroup::forDropdown($business_id);

        $business_details = $this->businessUtil->getDetails($business_id);
        $query = Contact::where('contacts.business_id', $business_id)
            ->where('contacts.name', '<>', 'Walk-In Customer')
            ->where('contacts.name', '<>', '')
            ->where('contacts.type', '=', 'supplier');
        //$query->onlySuppliers();
        $query->select('contacts.id', DB::raw('CONCAT(contacts.name, " - ",
	contacts.mobile, " - ",
	CASE
	WHEN type="customer"
	THEN "عميل"
	ELSE
	"مورد"
	end ) as contactName'));
        $query2 = Contact::where('contacts.business_id', $business_id)
            ->where('contacts.name', '<>', 'Walk-In Customer')
            ->where('contacts.name', '<>', '')
            ->where('contacts.type', '=', 'customer');
        //$query->onlySuppliers();
        $query2->select('contacts.id', DB::raw('CONCAT(contacts.name, " - ",
	contacts.mobile, " - ",
	CASE
	WHEN type="customer"
	THEN "عميل"
	ELSE
	"مورد"
	end ) as contactName'));


        $query3 = Contact::where('contacts.business_id', $business_id)
            ->where('contacts.name', '<>', 'Walk-In Customer')
            ->where('contacts.name', '<>', '')
            ->where('contacts.type', '=', 'driver');
        //$query->onlySuppliers();
        $query3->select('contacts.id', DB::raw('CONCAT(contacts.name, " - ",
	contacts.mobile, " - ",
	CASE
	WHEN type="customer"
	THEN "عميل"
	WHEN type="supplier"
	THEN "مورد"
	ELSE
	"سائق"
	end ) as contactName'));

        $contact = $query->pluck('contactName', 'id');
        $contactCustomer = $query2->pluck('contactName', 'id');
        $cars = TransportCar::where('business_id', '=', $business_id)
            ->get();
        $users = $query3->pluck('contactName', 'id');

        return view('zahraakashf.createSupplierStatement')
            ->with(compact('business_id', 'contact', 'currency_details', 'default_purchase_status', 'customer_groups', 'types', 'cars', 'users', 'contactCustomer'));
    }




    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function createDirectBuy()
    {
        $business_id = request()->session()->get('user.business_id');
        $currency_details = $this->transactionUtil->purchaseCurrencyDetails($business_id);
        $business_locations = BusinessLocation::forDropdown($business_id, false, true);
        $bl_attributes = $business_locations['attributes'];
        $business_locations = $business_locations['locations'];
        $default_purchase_status = null;
        if (request()->session()->get('business.enable_purchase_status') != 1) {
            $default_purchase_status = 'received';
        }
        $types = [];
        if (auth()->user()->can('supplier.create')) {
            $types['supplier'] = __('report.supplier');
        }
        if (auth()->user()->can('customer.create')) {
            $types['customer'] = __('report.customer');
        }
        if (auth()->user()->can('supplier.create') && auth()->user()->can('customer.create')) {
            $types['both'] = __('lang_v1.both_supplier_customer');
        }
        $customer_groups = CustomerGroup::forDropdown($business_id);

        $business_details = $this->businessUtil->getDetails($business_id);
        $query = Contact::where('contacts.business_id', $business_id)
            ->where('contacts.name', '<>', 'Walk-In Customer')
            ->where('contacts.name', '<>', '')
            ->where('contacts.type', '=', 'supplier');
        //$query->onlySuppliers();
        $query->select('contacts.id', DB::raw('CONCAT(contacts.name, " - ",
	contacts.mobile, " - ",
	CASE
	WHEN type="customer"
	THEN "عميل"
	ELSE
	"مورد"
	end ) as contactName'));
        $query2 = Contact::where('contacts.business_id', $business_id)
            ->where('contacts.name', '<>', 'Walk-In Customer')
            ->where('contacts.name', '<>', '')
            ->where('contacts.type', '=', 'customer');
        //$query->onlySuppliers();
        $query2->select('contacts.id', DB::raw('CONCAT(contacts.name, " - ",
	contacts.mobile, " - ",
	CASE
	WHEN type="customer"
	THEN "عميل"
	ELSE
	"مورد"
	end ) as contactName'));

        $query3 = Contact::where('contacts.business_id', $business_id)
            ->where('contacts.name', '<>', 'Walk-In Customer')
            ->where('contacts.name', '<>', '')
            ->where('contacts.type', '=', 'driver');
        //$query->onlySuppliers();
        $query3->select('contacts.id', DB::raw('CONCAT(contacts.name, " - ",
	contacts.mobile, " - ",
	CASE
	WHEN type="customer"
	THEN "عميل"
	WHEN type="supplier"
	THEN "مورد"
	ELSE
	"سائق"
	end ) as contactName'));

        $contact = $query->pluck('contactName', 'id');
        $contactCustomer = $query2->pluck('contactName', 'id');
        $cars = TransportCar::where('business_id', '=', $business_id)
            ->get();
        $users = $query3->pluck('contactName', 'id');

        return view('zahraakashf.createSupplierDirectBuyStatement')
            ->with(compact('business_id', 'contact', 'currency_details', 'default_purchase_status', 'customer_groups', 'types', 'cars', 'users', 'contactCustomer'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function createWasal()
    {
        $business_id = request()->session()->get('user.business_id');
        $currency_details = $this->transactionUtil->purchaseCurrencyDetails($business_id);
        $business_locations = BusinessLocation::forDropdown($business_id, false, true);
        $bl_attributes = $business_locations['attributes'];
        $business_locations = $business_locations['locations'];
        $default_purchase_status = null;
        if (request()->session()->get('business.enable_purchase_status') != 1) {
            $default_purchase_status = 'received';
        }
        $types = [];
        if (auth()->user()->can('supplier.create')) {
            $types['supplier'] = __('report.supplier');
        }
        if (auth()->user()->can('customer.create')) {
            $types['customer'] = __('report.customer');
        }
        if (auth()->user()->can('supplier.create') && auth()->user()->can('customer.create')) {
            $types['both'] = __('lang_v1.both_supplier_customer');
        }
        $customer_groups = CustomerGroup::forDropdown($business_id);

        $business_details = $this->businessUtil->getDetails($business_id);
        $query = Contact::where('contacts.business_id', $business_id)
            ->where('contacts.name', '<>', 'Walk-In Customer')
            ->where('contacts.name', '<>', '')
            ->where('contacts.type', '=', 'supplier');
        //$query->onlySuppliers();
        $query->select('contacts.id', DB::raw('CONCAT(contacts.name, " - ",
	contacts.mobile, " - ",
	CASE
	WHEN type="customer"
	THEN "عميل"
	ELSE
	"مورد"
	end ) as contactName'));
        $query2 = Contact::where('contacts.business_id', $business_id)
            ->where('contacts.name', '<>', 'Walk-In Customer')
            ->where('contacts.name', '<>', '')
            ->where('contacts.type', '=', 'customer');
        //$query->onlySuppliers();
        $query2->select('contacts.id', DB::raw('CONCAT(contacts.name, " - ",
	contacts.mobile, " - ",
	CASE
	WHEN type="customer"
	THEN "عميل"
	ELSE
	"مورد"
	end ) as contactName'));

        $query3 = Contact::where('contacts.business_id', $business_id)
            ->where('contacts.name', '<>', 'Walk-In Customer')
            ->where('contacts.name', '<>', '')
            ->where('contacts.type', '=', 'driver');
        //$query->onlySuppliers();
        $query3->select('contacts.id', DB::raw('CONCAT(contacts.name, " - ",
	contacts.mobile, " - ",
	CASE
	WHEN type="customer"
	THEN "عميل"
	WHEN type="supplier"
	THEN "مورد"
	ELSE
	"سائق"
	end ) as contactName'));
        $contact = $query->pluck('contactName', 'id');
        $contactCustomer = $query2->pluck('contactName', 'id');
        $cars = TransportCar::where('business_id', '=', $business_id)
            ->get();
        $users = $query3->pluck('contactName', 'id');

        return view('zahraakashf.createSupplierWasalStatement')
            ->with(compact('business_id', 'contact', 'currency_details', 'default_purchase_status', 'customer_groups', 'types', 'cars', 'users', 'contactCustomer'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $transaction_data = $request->only([ 'supplier_id', 'move_line', 'default_days', 'on_land_date', 'out_land_date', 'factory_date','days_total_number', 'days_diff','day_cost','shipping_cost','carpalet','driver_name','contact_customer_id','qty_weight','west_per','net_amount_weight','kg_price','kg_price_client','net_money','net_money_client','box_amount_total','box_count','final_amount_total_client','final_amount_total','factory_name']);
        try {
            $business_id = $request->session()->get('user.business_id');
            $user_id = $request->session()->get('user.id');

            $transaction_data = $request->only([ 'supplier_id', 'move_line', 'default_days', 'on_land_date', 'out_land_date', 'factory_date','days_total_number', 'days_diff','day_cost','shipping_cost','carpalet','driver_name','contact_customer_id','qty_weight','west_per','net_amount_weight','kg_price','kg_price_client','net_money','net_money_client','box_amount_total','box_count','final_amount_total_client','final_amount_total','factory_name']);

            $driverNetValue=$request->get('days_diff')*$request->get('day_cost');
            $driverNetValue+=$request->get('shipping_cost');

            $input=array(
                'supplier_id'=>$request->get('supplier_id'),
                'customer_id'=>$request->get('contact_customer_id'),
                'driver_id'=>$request->get('driver_name'),
                'move_line_id'=>$request->get('move_line'),
                'car_palate_id'=>$request->get('carpalet'),
                'days_default'=>$request->get('default_days'),
                'on_land_date'=>$request->get('on_land_date'),
                'out_land_date'=>$request->get('out_land_date'),
                'on_factory_date'=>$request->get('factory_date'),
                'total_days_no'=>$request->get('days_total_number'),
                'stay_days_no'=>$request->get('days_diff'),
                'stay_day_cost'=>$request->get('day_cost'),
                'shipping_cost'=>$request->get('shipping_cost'),
                'main_weight'=>$request->get('qty_weight'),
                'loses_percent'=>$request->get('west_per'),
                'net_weight'=>$request->get('net_amount_weight'),
                'supplier_price'=>$request->get('kg_price'),
                'customer_price'=>$request->get('kg_price_client'),
                'supplier_total'=>$request->get('net_money'),
                'customer_total'=>$request->get('net_money_client'),
                'box_rent_cost'=>$request->get('box_amount_total'),
                'box_count'=>$request->get('box_count'),
                'supplier_net_value'=>$request->get('final_amount_total'),
                'factory_name'=>$request->get('factory_name'),
                'customer_net_value'=>$request->get('final_amount_total_client'),
                'driver_net_value'=>$driverNetValue,
                'created_by'=>$user_id
            );

            $kashTransaction=ZahraaKashfTotal::create($input);
            $user_id = $request->session()->get('user.id');

            $sale_type = 'sell';
            $invoice_scheme_id = '1';
            $invoice_no = $this->transactionUtil->getInvoiceNumber($business_id, 'final', '1', $invoice_scheme_id, $sale_type);
            $uf_data = true;
            $discount = ['discount_type' => 'percentage',
                'discount_amount' => '0'
            ];
            $tax_id = null;
            $product_details = Product::join('variations', 'variations.product_id', '=', 'products.id')
                ->where('products.id', '=', '15080')
                ->select('products.id as id', 'variations.id as variations_id', 'variations.default_sell_price')
                ->first();



            $products_array = array(
                'product_type' => 'single',
                'product_id' => $product_details->id,
                'variation_id' => $product_details->variations_id,
                'enable_stock' => '0',
                'quantity' => $request->get('net_amount_weight'),
                'product_unit_id' => '1',
                'sub_unit_id' => null,
                'base_unit_multiplier' => '1',
                'item_tax' => '0',
                'unit_price_inc_tax' => $request->get('kg_price_client')

            );
            $transaction = Transaction::create([
                'business_id' => $business_id,
                'location_id' => '1',
                'type' => 'sell',
                'discount_type' => 'percentage',
                'payment_status' => 'due',
                'status' => 'final',
                'contact_id' => $request->get('contact_customer_id'),
                'invoice_no' => $invoice_no,
                'total_before_tax' => $request->get('final_amount_total_client'),
                'transaction_date' => now(),
                'final_total' => $request->get('final_amount_total_client'),
                'created_by' => $user_id,
                'is_direct_sale' => 1,
                'exchange_rate' => 1,
                'is_suspend' => 0,
                'is_recurring' => 0,
                'recur_interval' => 1,
                'recur_interval_type' => null,
                'kashf_id' => $kashTransaction->id,
            ]);


            $line = array(
                'transaction_id' => $transaction->id,
                'product_id' => $products_array['product_id'],
                'variation_id' => $products_array['variation_id'],
                'quantity' => $products_array['quantity'],
                'unit_price_before_discount' => $products_array['unit_price_inc_tax'],
                'unit_price' => '1',
                'line_discount_type' => null,
                'line_discount_amount' => 0,
                'item_tax' => 0,
                'tax_id' => null,
                'unit_price_inc_tax' => $products_array['unit_price_inc_tax'],
                'sell_line_note' => '',
                'sub_unit_id' => null,
                'discount_id' => null,
                'res_line_order_status' => 'received',
                'so_line_id' => null
            );
            TransactionSellLine::create($line);
//Update reference count
            $ref_count = $this->productUtil->setAndGetReferenceCount('purchase');
            //Generate reference number
            if (empty($transaction_data['ref_no'])) {
                $invoice_no = $this->productUtil->generateReferenceNumber('purchase', $ref_count);
            }
            $products_array = array(
                'product_type' => 'single',
                'product_id' => $product_details->id,
                'variation_id' => $product_details->variations_id,
                'enable_stock' => '0',
                'quantity' => $request->get('net_amount_weight'),
                'product_unit_id' => '1',
                'sub_unit_id' => null,
                'base_unit_multiplier' => '1',
                'item_tax' => '0',
                'unit_price_inc_tax' => $request->get('kg_price'),

            );
            $transaction = Transaction::create([
                'business_id' => $business_id,
                'location_id' => '1',
                'type' => 'purchase',
                'discount_type' => 'percentage',
                'payment_status' => 'due',
                'status' => 'received',
                'contact_id' => $request->get('supplier_id'),
                'ref_no' => $invoice_no,
                'total_before_tax' => $request->get('final_amount_total'),
                'transaction_date' => now(),
                'final_total' => $request->get('final_amount_total'),
                'created_by' => $user_id,
                'is_direct_sale' => 1,
                'exchange_rate' => 1,
                'is_suspend' => 0,
                'is_recurring' => 0,
                'recur_interval' => 1,
                'recur_interval_type' => null,
                'kashf_id' => $kashTransaction->id,
            ]);
            $line = array(
                'transaction_id' => $transaction->id,
                'product_id' => $products_array['product_id'],
                'variation_id' => $products_array['variation_id'],
                'quantity' => $products_array['quantity'],
                'pp_without_discount' => $products_array['unit_price_inc_tax'],
                'discount_percent' => '0',
                'purchase_price' => $products_array['unit_price_inc_tax'],
                'purchase_price_inc_tax' => $products_array['unit_price_inc_tax'],
                'item_tax' => '0'
            );
            PurchaseLine::create($line);
            $ref_count = $this->productUtil->setAndGetReferenceCount('purchase');
            $invoice_no = $this->productUtil->generateReferenceNumber('purchase', $ref_count);
            $product_details2 = Product::join('variations', 'variations.product_id', '=', 'products.id')
                ->where('products.id', '=', '15081')
                ->select('products.id as id', 'variations.id as variations_id', 'variations.default_sell_price')
                ->first();

            $products_array = array(
                'product_type' => 'single',
                'product_id' => $product_details2->id,
                'variation_id' => $product_details2->variations_id,
                'enable_stock' => '0',
                'quantity' => '1',
                'product_unit_id' => '1',
                'sub_unit_id' => null,
                'base_unit_multiplier' => '1',
                'item_tax' => '0',
                'unit_price_inc_tax' => $driverNetValue,

            );
            $transaction = Transaction::create([
                'business_id' => $business_id,
                'location_id' => '1',
                'type' => 'purchase',
                'discount_type' => 'percentage',
                'payment_status' => 'due',
                'status' => 'received',
                'contact_id' => $request->get('driver_name'),
                'ref_no' => $invoice_no,
                'total_before_tax' => $driverNetValue,
                'transaction_date' => now(),
                'final_total' => $driverNetValue,
                'created_by' => $user_id,
                'is_direct_sale' => 1,
                'exchange_rate' => 1,
                'is_suspend' => 0,
                'is_recurring' => 0,
                'recur_interval' => 1,
                'recur_interval_type' => null,
                'kashf_id' => $kashTransaction->id,
            ]);
            $line = array(
                'transaction_id' => $transaction->id,
                'product_id' => $products_array['product_id'],
                'variation_id' => $products_array['variation_id'],
                'quantity' => '1',
                'pp_without_discount' => $driverNetValue,
                'discount_percent' => '0',
                'purchase_price' => $driverNetValue,
                'purchase_price_inc_tax' => $driverNetValue,
                'item_tax' => '0'
            );
            PurchaseLine::create($line);

            $output = ['success' => 1,
                'msg' => __('purchase.purchase_add_success')
            ];
        } catch (Exception $e) {
            DB::rollBack();
            Log::emergency("File:" . $e->getFile() . "Line:" . $e->getLine() . "Message:" . $e->getMessage().'\n'.print_r($transaction_data));

            $output = ['success' => 0,
                'msg' => __('messages.something_went_wrong')
            ];
        }

        return redirect('supplierKashf')->with('status', $output);
    }
/**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return Response
     */
    public function storeDirectBuy(Request $request)
    {
        $transaction_data = $request->only([ 'supplier_id', 'move_line', 'default_days', 'on_land_date', 'out_land_date', 'factory_date','days_total_number', 'days_diff','day_cost','shipping_cost','carpalet','driver_name','contact_customer_id','qty_weight','west_per','net_amount_weight','kg_price','kg_price_client','net_money','net_money_client','box_amount_total','box_count','final_amount_total_client','final_amount_total','factory_name']);
        try {
            $business_id = $request->session()->get('user.business_id');
            $user_id = $request->session()->get('user.id');

            $transaction_data = $request->only([ 'supplier_id', 'move_line', 'default_days', 'on_land_date', 'out_land_date', 'factory_date','days_total_number', 'days_diff','day_cost','shipping_cost','carpalet','driver_name','contact_customer_id','qty_weight','west_per','net_amount_weight','kg_price','kg_price_client','net_money','net_money_client','box_amount_total','box_count','final_amount_total_client','final_amount_total','factory_name']);

            $driverNetValue=$request->get('days_diff')*$request->get('day_cost');
            $driverNetValue+=$request->get('shipping_cost');

            $input=array(
                'supplier_id'=>$request->get('supplier_id'),
                'customer_id'=>$request->get('contact_customer_id'),
                'driver_id'=>$request->get('driver_name'),
                'move_line_id'=>$request->get('move_line'),
                'car_palate_id'=>$request->get('carpalet'),
                'days_default'=>$request->get('default_days'),
                'on_land_date'=>$request->get('on_land_date'),
                'out_land_date'=>$request->get('out_land_date'),
                'on_factory_date'=>$request->get('factory_date'),
                'total_days_no'=>$request->get('days_total_number'),
                'stay_days_no'=>$request->get('days_diff'),
                'stay_day_cost'=>$request->get('day_cost'),
                'shipping_cost'=>$request->get('shipping_cost'),
                'main_weight'=>$request->get('qty_weight'),
                'loses_percent'=>$request->get('west_per'),
                'net_weight'=>$request->get('net_amount_weight'),
                'loses_percent_supplier'=>$request->get('west_per_supplier'),
                'net_weight_supplier'=>$request->get('net_amount_weight_supplier'),
                'supplier_price'=>$request->get('kg_price'),
                'customer_price'=>$request->get('kg_price_client'),
                'supplier_total'=>$request->get('net_money'),
                'customer_total'=>$request->get('net_money_client'),
                'box_rent_cost'=>$request->get('box_amount_total'),
                'box_count'=>$request->get('box_count'),
                'supplier_net_value'=>$request->get('final_amount_total'),
                'customer_net_value'=>$request->get('final_amount_total_client'),
                'factory_name'=>$request->get('factory_name'),
                'driver_net_value'=>$driverNetValue,
                'created_by'=>$user_id,
                'is_direct_buy'=>'1'
            );

            $kashTransaction=ZahraaKashfTotal::create($input);
            $user_id = $request->session()->get('user.id');

            $sale_type = 'sell';
            $invoice_scheme_id = '1';
            $invoice_no = $this->transactionUtil->getInvoiceNumber($business_id, 'final', '1', $invoice_scheme_id, $sale_type);
            $uf_data = true;
            $discount = ['discount_type' => 'percentage',
                'discount_amount' => '0'
            ];
            $tax_id = null;
            $product_details = Product::join('variations', 'variations.product_id', '=', 'products.id')
                ->where('products.id', '=', '15080')
                ->select('products.id as id', 'variations.id as variations_id', 'variations.default_sell_price')
                ->first();

            $products_array = array(
                'product_type' => 'single',
                'product_id' => $product_details->id,
                'variation_id' => $product_details->variations_id,
                'enable_stock' => '0',
                'quantity' => $request->get('net_amount_weight'),
                'product_unit_id' => '1',
                'sub_unit_id' => null,
                'base_unit_multiplier' => '1',
                'item_tax' => '0',
                'unit_price_inc_tax' => $request->get('kg_price_client')

            );
            $transaction = Transaction::create([
                'business_id' => $business_id,
                'location_id' => '1',
                'type' => 'sell',
                'discount_type' => 'percentage',
                'payment_status' => 'due',
                'status' => 'final',
                'contact_id' => $request->get('contact_customer_id'),
                'invoice_no' => $invoice_no,
                'total_before_tax' => $request->get('final_amount_total_client'),
                'transaction_date' => now(),
                'final_total' => $request->get('final_amount_total_client'),
                'created_by' => $user_id,
                'is_direct_sale' => 1,
                'exchange_rate' => 1,
                'is_suspend' => 0,
                'is_recurring' => 0,
                'recur_interval' => 1,
                'recur_interval_type' => null,
                'kashf_id' => $kashTransaction->id,
            ]);


            $line = array(
                'transaction_id' => $transaction->id,
                'product_id' => $products_array['product_id'],
                'variation_id' => $products_array['variation_id'],
                'quantity' => $products_array['quantity'],
                'unit_price_before_discount' => $products_array['unit_price_inc_tax'],
                'unit_price' => '1',
                'line_discount_type' => null,
                'line_discount_amount' => 0,
                'item_tax' => 0,
                'tax_id' => null,
                'unit_price_inc_tax' => $products_array['unit_price_inc_tax'],
                'sell_line_note' => '',
                'sub_unit_id' => null,
                'discount_id' => null,
                'res_line_order_status' => 'received',
                'so_line_id' => null
            );
            TransactionSellLine::create($line);
//Update reference count
            $ref_count = $this->productUtil->setAndGetReferenceCount('purchase');
            //Generate reference number
            if (empty($transaction_data['ref_no'])) {
                $invoice_no = $this->productUtil->generateReferenceNumber('purchase', $ref_count);
            }
            $products_array = array(
                'product_type' => 'single',
                'product_id' => $product_details->id,
                'variation_id' => $product_details->variations_id,
                'enable_stock' => '0',
                'quantity' => $request->get('net_amount_weight_supplier'),
                'product_unit_id' => '1',
                'sub_unit_id' => null,
                'base_unit_multiplier' => '1',
                'item_tax' => '0',
                'unit_price_inc_tax' => $request->get('kg_price')

            );
            $transaction = Transaction::create([
                'business_id' => $business_id,
                'location_id' => '1',
                'type' => 'purchase',
                'discount_type' => 'percentage',
                'payment_status' => 'due',
                'status' => 'received',
                'contact_id' => $request->get('supplier_id'),
                'ref_no' => $invoice_no,
                'total_before_tax' => $request->get('final_amount_total'),
                'transaction_date' => now(),
                'final_total' => $request->get('final_amount_total'),
                'created_by' => $user_id,
                'is_direct_sale' => 1,
                'exchange_rate' => 1,
                'is_suspend' => 0,
                'is_recurring' => 0,
                'recur_interval' => 1,
                'recur_interval_type' => null,
                'kashf_id' => $kashTransaction->id,
            ]);
            $line = array(
                'transaction_id' => $transaction->id,
                'product_id' => $products_array['product_id'],
                'variation_id' => $products_array['variation_id'],
                'quantity' => $products_array['quantity'],
                'pp_without_discount' => $products_array['unit_price_inc_tax'],
                'discount_percent' => '0',
                'purchase_price' => $products_array['unit_price_inc_tax'],
                'purchase_price_inc_tax' => $products_array['unit_price_inc_tax'],
                'item_tax' => '0'
            );
            PurchaseLine::create($line);
            $ref_count = $this->productUtil->setAndGetReferenceCount('purchase');
            $invoice_no = $this->productUtil->generateReferenceNumber('purchase', $ref_count);
            $product_details2 = Product::join('variations', 'variations.product_id', '=', 'products.id')
                ->where('products.id', '=', '15081')
                ->select('products.id as id', 'variations.id as variations_id', 'variations.default_sell_price')
                ->first();

            $products_array = array(
                'product_type' => 'single',
                'product_id' => $product_details2->id,
                'variation_id' => $product_details2->variations_id,
                'enable_stock' => '0',
                'quantity' => '1',
                'product_unit_id' => '1',
                'sub_unit_id' => null,
                'base_unit_multiplier' => '1',
                'item_tax' => '0',
                'unit_price_inc_tax' => $driverNetValue,

            );
            $transaction = Transaction::create([
                'business_id' => $business_id,
                'location_id' => '1',
                'type' => 'purchase',
                'discount_type' => 'percentage',
                'payment_status' => 'due',
                'status' => 'received',
                'contact_id' => $request->get('driver_name'),
                'ref_no' => $invoice_no,
                'total_before_tax' => $driverNetValue,
                'transaction_date' => now(),
                'final_total' => $driverNetValue,
                'created_by' => $user_id,
                'is_direct_sale' => 1,
                'exchange_rate' => 1,
                'is_suspend' => 0,
                'is_recurring' => 0,
                'recur_interval' => 1,
                'recur_interval_type' => null,
                'kashf_id' => $kashTransaction->id,
            ]);
            $line = array(
                'transaction_id' => $transaction->id,
                'product_id' => $products_array['product_id'],
                'variation_id' => $products_array['variation_id'],
                'quantity' => '1',
                'pp_without_discount' => $driverNetValue,
                'discount_percent' => '0',
                'purchase_price' => $driverNetValue,
                'purchase_price_inc_tax' => $driverNetValue,
                'item_tax' => '0'
            );
            PurchaseLine::create($line);

            $output = ['success' => 1,
                'msg' => __('purchase.purchase_add_success')
            ];
        } catch (Exception $e) {
            DB::rollBack();
            Log::emergency("File:" . $e->getFile() . "Line:" . $e->getLine() . "Message:" . $e->getMessage().'\n'.print_r($transaction_data));

            $output = ['success' => 0,
                'msg' => __('messages.something_went_wrong')
            ];
        }

        return redirect('supplierKashf')->with('status', $output);
    }

/**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return Response
     */
    public function storeWasal(Request $request)
    {
        $transaction_data = $request->only([ 'supplier_id', 'move_line', 'default_days', 'on_land_date', 'out_land_date', 'factory_date','days_total_number', 'days_diff','day_cost','shipping_cost','carpalet','driver_name','contact_customer_id','qty_weight','west_per','net_amount_weight','kg_price','kg_price_client','net_money','net_money_client','box_amount_total','box_count','final_amount_total_client','final_amount_total','factory_name']);
        try {
            $business_id = $request->session()->get('user.business_id');
            $user_id = $request->session()->get('user.id');

            $transaction_data = $request->only([ 'supplier_id', 'move_line', 'default_days', 'on_land_date', 'out_land_date', 'factory_date','days_total_number', 'days_diff','day_cost','shipping_cost','carpalet','driver_name','contact_customer_id','qty_weight','west_per','net_amount_weight','kg_price','kg_price_client','net_money','net_money_client','box_amount_total','box_count','final_amount_total_client','final_amount_total','factory_name','statement_type']);

            $driverNetValue=$request->get('days_diff')*$request->get('day_cost');
            $driverNetValue+=$request->get('shipping_cost');
$statementType=$request->get('statement_type');
            $input=array(
                'supplier_id'=>$request->get('supplier_id'),
                'customer_id'=>$request->get('contact_customer_id'),
                'move_line_id'=>$request->get('move_line'),
                'days_default'=>$request->get('default_days'),
                'on_land_date'=>$request->get('on_land_date'),
                'out_land_date'=>$request->get('out_land_date'),
                'on_factory_date'=>$request->get('factory_date'),
                'total_days_no'=>$request->get('days_total_number'),
                'stay_days_no'=>$request->get('days_diff'),
                'stay_day_cost'=>$request->get('day_cost'),
                'shipping_cost'=>$request->get('shipping_cost'),
                'main_weight'=>$request->get('qty_weight'),
                'loses_percent'=>$request->get('west_per'),
                'net_weight'=>$request->get('net_amount_weight'),
                'loses_percent_supplier'=>$request->get('west_per_supplier'),
                'net_weight_supplier'=>$request->get('net_amount_weight_supplier'),
                'supplier_price'=>$request->get('kg_price'),
                'customer_price'=>$request->get('kg_price_client'),
                'supplier_total'=>$request->get('net_money'),
                'customer_total'=>$request->get('net_money_client'),
                'box_rent_cost'=>$request->get('box_amount_total'),
                'box_count'=>$request->get('box_count'),
                'supplier_net_value'=>$request->get('final_amount_total'),
                'customer_net_value'=>$request->get('final_amount_total_client'),
                'driver_net_value'=>$driverNetValue,
                'created_by'=>$user_id,
                'is_wasal'=>'1',
                'driver_name'=>$request->get('driver_name'),
                'car_plate_name'=>$request->get('carpalet'),
                'factory_name'=>$request->get('factory_name'),
            );
            if($statementType==1)
                $input['is_direct_buy']='1';

            $kashTransaction=ZahraaKashfTotal::create($input);
            $user_id = $request->session()->get('user.id');

            $sale_type = 'sell';
            $invoice_scheme_id = '1';
            $invoice_no = $this->transactionUtil->getInvoiceNumber($business_id, 'final', '1', $invoice_scheme_id, $sale_type);
            $uf_data = true;
            $discount = ['discount_type' => 'percentage',
                'discount_amount' => '0'
            ];
            $tax_id = null;
            $product_details = Product::join('variations', 'variations.product_id', '=', 'products.id')
                ->where('products.id', '=', '15080')
                ->select('products.id as id', 'variations.id as variations_id', 'variations.default_sell_price')
                ->first();

            $products_array = array(
                'product_type' => 'single',
                'product_id' => $product_details->id,
                'variation_id' => $product_details->variations_id,
                'enable_stock' => '0',
                'quantity' => $request->get('net_amount_weight'),
                'product_unit_id' => '1',
                'sub_unit_id' => null,
                'base_unit_multiplier' => '1',
                'item_tax' => '0',
                'unit_price_inc_tax' => $request->get('kg_price_client'),

            );
            $transaction = Transaction::create([
                'business_id' => $business_id,
                'location_id' => '1',
                'type' => 'sell',
                'discount_type' => 'percentage',
                'payment_status' => 'due',
                'status' => 'final',
                'contact_id' => $request->get('contact_customer_id'),
                'invoice_no' => $invoice_no,
                'total_before_tax' => $request->get('final_amount_total_client'),
                'transaction_date' => now(),
                'final_total' => $request->get('final_amount_total_client'),
                'created_by' => $user_id,
                'is_direct_sale' => 1,
                'exchange_rate' => 1,
                'is_suspend' => 0,
                'is_recurring' => 0,
                'recur_interval' => 1,
                'recur_interval_type' => null,
                'kashf_id' => $kashTransaction->id,
            ]);


            $line = array(
                'transaction_id' => $transaction->id,
                'product_id' => $products_array['product_id'],
                'variation_id' => $products_array['variation_id'],
                'quantity' => $products_array['quantity'],
                'unit_price_before_discount' => $products_array['unit_price_inc_tax'],
                'unit_price' => '1',
                'line_discount_type' => null,
                'line_discount_amount' => 0,
                'item_tax' => 0,
                'tax_id' => null,
                'unit_price_inc_tax' => $products_array['unit_price_inc_tax'],
                'sell_line_note' => '',
                'sub_unit_id' => null,
                'discount_id' => null,
                'res_line_order_status' => 'received',
                'so_line_id' => null
            );
            TransactionSellLine::create($line);
//Update reference count
            $ref_count = $this->productUtil->setAndGetReferenceCount('purchase');
            //Generate reference number
            if (empty($transaction_data['ref_no'])) {
                $invoice_no = $this->productUtil->generateReferenceNumber('purchase', $ref_count);
            }

            $products_array = array(
                'product_type' => 'single',
                'product_id' => $product_details->id,
                'variation_id' => $product_details->variations_id,
                'enable_stock' => '0',
                'quantity' => $request->get('net_amount_weight_supplier'),
                'product_unit_id' => '1',
                'sub_unit_id' => null,
                'base_unit_multiplier' => '1',
                'item_tax' => '0',
                'unit_price_inc_tax' => $request->get('kg_price'),

            );
            $transaction = Transaction::create([
                'business_id' => $business_id,
                'location_id' => '1',
                'type' => 'purchase',
                'discount_type' => 'percentage',
                'payment_status' => 'due',
                'status' => 'received',
                'contact_id' => $request->get('supplier_id'),
                'ref_no' => $invoice_no,
                'total_before_tax' => $request->get('final_amount_total'),
                'transaction_date' => now(),
                'final_total' => $request->get('final_amount_total'),
                'created_by' => $user_id,
                'is_direct_sale' => 1,
                'exchange_rate' => 1,
                'is_suspend' => 0,
                'is_recurring' => 0,
                'recur_interval' => 1,
                'recur_interval_type' => null,
                'kashf_id' => $kashTransaction->id,
            ]);
            $line = array(
                'transaction_id' => $transaction->id,
                'product_id' => $products_array['product_id'],
                'variation_id' => $products_array['variation_id'],
                'quantity' => $products_array['quantity'],
                'pp_without_discount' => $products_array['unit_price_inc_tax'],
                'discount_percent' => '0',
                'purchase_price' => $products_array['unit_price_inc_tax'],
                'purchase_price_inc_tax' => $products_array['unit_price_inc_tax'],
                'item_tax' => '0'
            );
            PurchaseLine::create($line);

            $output = ['success' => 1,
                'msg' => __('purchase.purchase_add_success')
            ];
        } catch (Exception $e) {
            DB::rollBack();
            Log::emergency("File:" . $e->getFile() . "Line:" . $e->getLine() . "Message:" . $e->getMessage().'\n'.print_r($transaction_data));

            $output = ['success' => 0,
                'msg' => __('messages.something_went_wrong')
            ];
        }

        return redirect('supplierKashf')->with('status', $output);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return Response
     */
    public function deleteKashf($id){
        $zahraaKashf=ZahraaKashfTotal::where('id','=',$id)->delete();
        $transaction=Transaction::where('kashf_id','=',$id)->delete();
        return redirect('supplierKashf');

    }


    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return Response
     */
    public function getBoxCountCar($id)
    {
        if (request()->ajax()) {
            try {

                $material = TransportCar::where('id', '=', $id)
                    ->first();

                return response()->json(["materials" => $material]);

            } catch (Exception $ee) {
                return $ee;
                Log::emergency("File:" . $e->getFile() . "Line:" . $e->getLine() . "Message:" . $ee->getMessage());
            }
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return Response
     */
    public function getTransportByContact($id)
    {
        if (request()->ajax()) {
            try {

                $material = TransportLine::where('car_palete_id', '=', $id)
                    ->get();
                if($id=='-1')
                    $material = TransportLine::select(
                        'transport_lines.id',
                        'transport_lines.move_from',
                        'transport_lines.move_to',
                        'transport_lines.days_count'
                    )->distinct()->groupBy('transport_lines.move_from',
                        'transport_lines.move_to')->get();
                return response()->json(["transports" => $material]);

            } catch (Exception $ee) {
                return $ee;
                Log::emergency("File:" . $e->getFile() . "Line:" . $e->getLine() . "Message:" . $ee->getMessage());
            }
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return Response
     */
    public function getTransportDaysById($id)
    {
        if (request()->ajax()) {
            try {

                $material = TransportLine::where('id', '=', $id)
                    ->select('transport_lines.days_count',DB::raw('ifnull(transport_lines.shipping_cost,"0") as shipping_cost'))
                    ->first();

                return $material;

            } catch (Exception $ee) {
                return $ee;
                Log::emergency("File:" . $e->getFile() . "Line:" . $e->getLine() . "Message:" . $ee->getMessage());
            }
        }
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return Response
     */
    public function showDriverStatment($id)
    {

        $driver=User::where('id','=',$id)
            ->select(DB::raw("CONCAT(users.surname,' ', 
	users.first_name,' ', 
	users.last_name ) as driver_name"))
            ->first();
        $driver_expenses=Transaction::join('users','transactions.expense_for','=','users.id')
            ->join('expense_categories','transactions.expense_category_id','=','expense_categories.id')
            ->where('transactions.expense_for','=',$id)
            ->select('transactions.transaction_date',
                'transactions.final_total',
                'expense_categories.name AS expense_name',
            'transactions.ref_no')
            ->get();
        $driver_needed_amount=Transaction::join('users','transactions.expense_for','=','users.id')
            ->join('expense_categories','transactions.expense_category_id','=','expense_categories.id')
            ->where('transactions.expense_for','=',$id)
            ->select(DB::raw('SUM(transactions.final_total) as net_total'))
            ->first();
        $driver_payed=Transaction::join('users','transactions.expense_for','=','users.id')
            ->join('transaction_payments','transactions.id','=','transaction_payments.transaction_id')
            ->join('expense_categories','transactions.expense_category_id','=','expense_categories.id')
            ->where('transactions.expense_for','=',$id)
            ->select(
	'transaction_payments.paid_on as transaction_date',
                'transaction_payments.amount as final_total',
                'expense_categories.name AS expense_name',
            'transaction_payments.payment_ref_no as ref_no')
            ->get();

        $driver_statment=DrvierStatement::where('driver_id','=',$id)->orderBy('transaction_date','asc')->get();
        $driver_payed_amount=Transaction::join('users','transactions.expense_for','=','users.id')
            ->join('transaction_payments','transactions.id','=','transaction_payments.transaction_id')
            ->where('transactions.expense_for','=',$id)
            ->select(DB::raw('	sum(transaction_payments.amount) as payed_amount'))
            ->first();


//        $driver_statment = array_values(array_sort($driver_statment, function ($value) {
//            return $value['transaction_date'];
//        }));

        if (request()->ajax()) {
            try {

                $material = TransportLine::where('id', '=', $id)
                    ->select('transport_lines.days_count',DB::raw('ifnull(transport_lines.shipping_cost,"0") as shipping_cost'))
                    ->first();

                return $material;

            } catch (Exception $ee) {
                return $ee;
                Log::emergency("File:" . $e->getFile() . "Line:" . $e->getLine() . "Message:" . $ee->getMessage());
            }
        }


        return view('zahraakashf.driverStatment')->with(compact('driver', 'driver_expenses', 'driver_needed_amount', 'driver_payed', 'driver_payed_amount','driver_statment'));;

    }



}