<?php


namespace App\Http\Controllers;


use App\TransportCar;
use App\TransportLine;
use App\Utils\BusinessUtil;
use App\Utils\ContactUtil;
use App\Utils\ModuleUtil;
use App\Utils\ProductUtil;
use App\Utils\TransactionUtil;
use App\Utils\Util;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;

class CarController  extends Controller
{
    protected $commonUtil;
    protected $contactUtil;
    protected $businessUtil;
    protected $productUtil;
    protected $transactionUtil;


    public function __construct(Util $commonUtil,
                                ContactUtil $contactUtil,
                                TransactionUtil $transactionUtil,
                                ModuleUtil $moduleUtil,
                                ProductUtil $productUtil,
                                BusinessUtil $businessUtil)
    {
        $this->commonUtil = $commonUtil;
        $this->contactUtil = $contactUtil;
        $this->businessUtil = $businessUtil;
        $this->transactionUtil = $transactionUtil;
        $this->productUtil = $productUtil;
        $this->moduleUtil = $moduleUtil;


    }

    /**
     * Display a listing of the resource.
     * @return Response
     */
    public function index()
    {
        $business_id = request()->session()->get('user.business_id');
        $cars=TransportCar::where('business_id','=',$business_id)
            ->orderBy('id', 'DESC')->paginate(10000);;

        return view('cars.index')
            ->with(compact('cars'));
    }
    /**
     * Show the restaurant module related details in pos screen.
     *
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
        $business_id = request()->session()->get('user.business_id');
        $carInsert=array(
            'business_id'=>$business_id,
            'car_palet'=>$request->car_palet,
            'car_type'=>$request->car_type,
            'box_count'=>$request->box_count,
            'day_cost'=>$request->day_cost,
            'box_cost'=>$request->box_cost,
            'car_description'=>$request->car_description,
            'created_by' => auth()->user()->id,

        );
        $Maincar=TransportCar::create($carInsert);
        $carTypeMain=TransportCar::where('car_type','=',$request->car_type)->first();
        $carTransports=TransportLine::where('car_palete_id','=',$carTypeMain->id)
            ->get();

        foreach ($carTransports as $car)
        {
            $input=[
                'business_id'=>   $business_id,
                'created_by'=>auth()->user()->id,
                'move_from'=>$car->move_from,
                'move_to'=>$car->move_to,
                'days_count'=>$car->days_count,
                'car_palete_id'=>$Maincar->id,
                'shipping_cost'=>$car->shipping_cost
            ];


            $transport=TransportLine::create($input);
        }

        return redirect()->route('cars.index');

    }



    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        if (request()->ajax()) {
            $business_id = request()->session()->get('user.business_id');
            $car = TransportCar::
                where('id', '=', $id)
                ->get()->toArray();

            return view('cars.edit')
                ->with(compact('car'));
        }
    }


    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $business_id = request()->session()->get('user.business_id');

        $Maincar=TransportCar::where('id','=',$id)->first();
        $Maincar->car_palet=$request->car_palet;
        $Maincar->car_type=$request->car_type;
        $Maincar->box_count=$request->box_count;
        $Maincar->day_cost=$request->day_cost;
        $Maincar->box_cost=$request->box_cost;
        $Maincar->car_description=$request->car_description;
        $Maincar->save();
        $carTypeMain=TransportCar::where('car_type','=',$request->car_type)->first();
        $carTransports=TransportLine::where('car_palete_id','=',$carTypeMain->id)
            ->get();

            TransportLine::where('car_palete_id','=',$Maincar->id)
                ->delete();


        foreach ($carTransports as $car)
        {
            $input=[
                'business_id'=>   $business_id,
                'created_by'=>auth()->user()->id,
                'move_from'=>$car->move_from,
                'move_to'=>$car->move_to,
                'days_count'=>$car->days_count,
                'car_palete_id'=>$Maincar->id,
                'shipping_cost'=>$car->shipping_cost
            ];


            $transport=TransportLine::create($input);
        }

        return redirect()->route('cars.index');
    }



}