
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `account_transactions_account_id_index` (`account_id`) USING BTREE,
  KEY `account_transactions_transaction_id_index` (`transaction_id`) USING BTREE,
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`) USING BTREE,
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`) USING BTREE,
  KEY `account_transactions_created_by_index` (`created_by`) USING BTREE,
  KEY `account_transactions_type_index` (`type`) USING BTREE,
  KEY `account_transactions_sub_type_index` (`sub_type`) USING BTREE,
  KEY `account_transactions_operation_date_index` (`operation_date`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
INSERT INTO `account_transactions` VALUES (1,23,'credit',NULL,11875.0000,NULL,'2021-09-20 22:37:00',1,569,417,NULL,NULL,NULL,'2021-09-20 22:41:00','2021-09-20 22:41:00'),(2,23,'credit',NULL,11250.0000,NULL,'2021-09-20 22:39:00',1,570,418,NULL,NULL,NULL,'2021-09-20 22:41:11','2021-09-20 22:41:11');
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_account_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`) USING BTREE,
  KEY `account_types_business_id_index` (`business_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
INSERT INTO `account_types` VALUES (1,'الأصول',NULL,1,'2021-09-20 21:58:04','2021-09-20 21:59:15'),(2,'الخصوم',NULL,1,'2021-09-20 21:59:29','2021-09-20 21:59:29'),(3,'حقوق الملكية',NULL,1,'2021-09-20 21:59:42','2021-09-20 21:59:42'),(4,'الإيرادات',NULL,1,'2021-09-20 21:59:59','2021-09-20 21:59:59'),(5,'المصروفات',NULL,1,'2021-09-20 22:00:13','2021-09-20 22:00:13'),(6,'الأصول الثابتة',1,1,'2021-09-20 22:02:07','2021-09-20 22:02:07'),(7,'الأصول المتداولة',1,1,'2021-09-20 22:02:29','2021-09-20 22:02:29'),(8,'الخصوم المتداولة',2,1,'2021-09-20 22:10:44','2021-09-20 22:10:44'),(9,'الخصوم طويلة الأجل',2,1,'2021-09-20 22:11:01','2021-09-20 22:11:01'),(10,'إيرادات النشاط الرئيسي',4,1,'2021-09-20 22:17:18','2021-09-20 22:17:18'),(11,'إيرادات أخرى',4,1,'2021-09-20 22:17:29','2021-09-20 22:17:29'),(12,'تكلفة المبيعات',5,1,'2021-09-20 22:17:43','2021-09-20 22:17:43'),(13,'مصاريف البيع والتسويق',5,1,'2021-09-20 22:17:57','2021-09-20 22:17:57'),(14,'مصاريف إدارية وعمومية',5,1,'2021-09-20 22:18:16','2021-09-20 22:18:16');
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_details` text COLLATE utf8mb4_unicode_ci,
  `account_type_id` int(11) DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `accounts_business_id_index` (`business_id`) USING BTREE,
  KEY `accounts_account_type_id_index` (`account_type_id`) USING BTREE,
  KEY `accounts_created_by_index` (`created_by`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,1,'الاراضى','11001','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',6,NULL,1,0,NULL,'2021-09-20 21:39:56','2021-09-20 22:03:18'),(2,1,'المبانى','11002','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',6,NULL,1,0,NULL,'2021-09-20 22:04:14','2021-09-20 22:04:14'),(3,1,'السيارات','11003','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',6,NULL,1,0,NULL,'2021-09-20 22:04:29','2021-09-20 22:04:29'),(4,1,'الاثاث','11004','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',6,NULL,1,0,NULL,'2021-09-20 22:04:50','2021-09-20 22:04:50'),(5,1,'الخزينة','12001','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',7,NULL,1,0,NULL,'2021-09-20 22:05:51','2021-09-20 22:05:51'),(6,1,'البنوك','12002','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',7,NULL,1,0,NULL,'2021-09-20 22:06:07','2021-09-20 22:06:07'),(7,1,'اوراق القبض','12003','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',7,NULL,1,0,NULL,'2021-09-20 22:06:47','2021-09-20 22:06:47'),(8,1,'المخزون','12004','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',7,NULL,1,0,NULL,'2021-09-20 22:08:05','2021-09-20 22:08:05'),(9,1,'المدينون','12005','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',7,NULL,1,0,NULL,'2021-09-20 22:08:27','2021-09-20 22:08:27'),(10,1,'ايرادات مستحقة','12006','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',7,NULL,1,0,NULL,'2021-09-20 22:08:46','2021-09-20 22:08:46'),(11,1,'مصروفات مدفوعة مقدماً','12007','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',7,NULL,1,0,NULL,'2021-09-20 22:09:20','2021-09-20 22:09:20'),(12,1,'الدئنون','21001','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',8,NULL,1,0,NULL,'2021-09-20 22:12:14','2021-09-20 22:12:14'),(13,1,'قروض قصيرة الاجل','21002','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',8,NULL,1,0,NULL,'2021-09-20 22:13:07','2021-09-20 22:13:07'),(14,1,'اوراق الدفع','21003','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',8,NULL,1,0,NULL,'2021-09-20 22:13:30','2021-09-20 22:13:30'),(15,1,'ايرادات مقبوضة مقدماً','21004','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',8,NULL,1,0,NULL,'2021-09-20 22:14:02','2021-09-20 22:14:02'),(16,1,'مصروفات مستحقة','21005','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',8,NULL,1,0,NULL,'2021-09-20 22:14:25','2021-09-20 22:14:25'),(17,1,'قروض طويلة الاجل','22001','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',9,NULL,1,0,NULL,'2021-09-20 22:14:50','2021-09-20 22:14:50'),(18,1,'رأس المال','31000','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',3,NULL,1,0,NULL,'2021-09-20 22:15:27','2021-09-20 22:15:27'),(19,1,'المسحوبات الشخصية','32000','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',3,NULL,1,0,NULL,'2021-09-20 22:15:58','2021-09-20 22:15:58'),(20,1,'جاري صاحب الشركة','33000','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',3,NULL,1,0,NULL,'2021-09-20 22:16:20','2021-09-20 22:16:20'),(21,1,'الاحتياطات','34000','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',3,NULL,1,0,NULL,'2021-09-20 22:16:48','2021-09-20 22:16:48'),(22,1,'الأرباح المحتجزة','35000','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',3,NULL,1,0,NULL,'2021-09-20 22:17:05','2021-09-20 22:17:05'),(23,1,'المبيعات','41001','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',10,NULL,1,0,NULL,'2021-09-20 22:20:16','2021-09-20 22:20:16'),(24,1,'مردودات المبيعات','41002','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',10,NULL,1,0,NULL,'2021-09-20 22:20:54','2021-09-20 22:20:54'),(25,1,'الخصم على المبيعات','41003','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',10,NULL,1,0,NULL,'2021-09-20 22:21:27','2021-09-20 22:21:27'),(26,1,'ايرادات استثمار','42001','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',11,NULL,1,0,NULL,'2021-09-20 22:21:53','2021-09-20 22:21:53'),(27,1,'ايرادات ايجارات','42002','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',11,NULL,1,0,NULL,'2021-09-20 22:22:12','2021-09-20 22:22:12'),(28,1,'المشتريات','51001','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',12,NULL,1,0,NULL,'2021-09-20 22:22:58','2021-09-20 22:22:58'),(29,1,'مصاريف المشتريات','51002','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',12,NULL,1,0,NULL,'2021-09-20 22:23:32','2021-09-20 22:23:32'),(30,1,'مردودات المشتريات','51003','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',12,NULL,1,0,NULL,'2021-09-20 22:24:06','2021-09-20 22:24:06'),(31,1,'الخصم على المشتريات','51004','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',12,NULL,1,0,NULL,'2021-09-20 22:24:35','2021-09-20 22:24:35'),(32,1,'مصروفات المبيعات','52001','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',13,NULL,1,0,NULL,'2021-09-20 22:25:11','2021-09-20 22:25:11'),(33,1,'عمولات المبيعات','52002','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',13,NULL,1,0,NULL,'2021-09-20 22:25:39','2021-09-20 22:25:39'),(34,1,'دعاية و اعلان','52003','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',13,NULL,1,0,NULL,'2021-09-20 22:25:57','2021-09-20 22:25:57'),(35,1,'رواتب','53001','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',14,NULL,1,0,NULL,'2021-09-20 22:26:19','2021-09-20 22:26:19'),(36,1,'ايجار','53002','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',14,NULL,1,0,NULL,'2021-09-20 22:26:34','2021-09-20 22:26:34'),(37,1,'صيانة','53003','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',14,NULL,1,0,NULL,'2021-09-20 22:26:48','2021-09-20 22:26:48'),(38,1,'هاتف و انترنت','53004','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',14,NULL,1,0,NULL,'2021-09-20 22:27:06','2021-09-20 22:27:06'),(39,1,'كهرباء','53005','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',14,NULL,1,0,NULL,'2021-09-20 22:27:25','2021-09-20 22:27:25');
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `properties` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `activity_log_log_name_index` (`log_name`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=611 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES (1,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-31 02:14:35','2021-08-31 02:14:35'),(2,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-01 02:40:57','2021-09-01 02:40:57'),(3,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-01 02:40:57','2021-09-01 02:40:57'),(4,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-01 02:41:05','2021-09-01 02:41:05'),(5,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-01 12:20:22','2021-09-01 12:20:22'),(6,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-01 12:46:58','2021-09-01 12:46:58'),(7,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-01 12:47:12','2021-09-01 12:47:12'),(8,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-01 16:35:19','2021-09-01 16:35:19'),(9,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-01 19:37:59','2021-09-01 19:37:59'),(10,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-01 19:57:38','2021-09-01 19:57:38'),(11,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-01 20:53:55','2021-09-01 20:53:55'),(12,'default','logout',2,'App\\User',2,2,'App\\User','[]','2021-09-01 21:21:41','2021-09-01 21:21:42'),(13,'default','added',3,'App\\User',2,2,'App\\User','{\"name\":\"\\u0627\\u0633\\u062a\\u0627\\u0630 Cargo Mansoura \"}','2021-09-01 21:23:37','2021-09-01 21:23:37'),(14,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-01 21:23:52','2021-09-01 21:23:52'),(15,'default','added',34,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-01 21:28:23','2021-09-01 21:28:23'),(16,'default','added',39,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":150}}','2021-09-01 21:32:46','2021-09-01 21:32:46'),(17,'default','edited',39,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":150},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"150.0000\"}}','2021-09-01 21:32:52','2021-09-01 21:32:52'),(18,'default','payment_edited',39,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"150.0000\"}}','2021-09-01 21:33:42','2021-09-01 21:33:42'),(19,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-01 21:56:27','2021-09-01 21:56:27'),(20,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-01 22:03:33','2021-09-01 22:03:33'),(21,'default','logout',3,'App\\User',2,3,'App\\User','[]','2021-09-01 22:28:01','2021-09-01 22:28:01'),(22,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-01 22:28:15','2021-09-01 22:28:15'),(23,'default','added',75,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-01 22:39:51','2021-09-01 22:39:51'),(24,'default','added',76,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":150}}','2021-09-01 22:41:31','2021-09-01 22:41:31'),(25,'default','logout',2,'App\\User',2,2,'App\\User','[]','2021-09-01 22:43:56','2021-09-01 22:43:56'),(26,'default','logout',3,'App\\User',2,3,'App\\User','[]','2021-09-01 22:51:24','2021-09-01 22:51:24'),(27,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-01 22:51:53','2021-09-01 22:51:53'),(28,'default','logout',3,'App\\User',2,3,'App\\User','[]','2021-09-01 22:58:29','2021-09-01 22:58:29'),(29,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-01 23:00:25','2021-09-01 23:00:25'),(30,'default','logout',3,'App\\User',2,3,'App\\User','[]','2021-09-01 23:07:03','2021-09-01 23:07:03'),(31,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-02 02:47:14','2021-09-02 02:47:14'),(32,'default','logout',3,'App\\User',2,3,'App\\User','[]','2021-09-02 02:47:27','2021-09-02 02:47:27'),(33,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-02 02:48:04','2021-09-02 02:48:04'),(34,'default','added',9,'App\\User',2,2,'App\\User','{\"name\":\" Domuiat Branch \"}','2021-09-02 02:54:25','2021-09-02 02:54:25'),(35,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-02 10:51:35','2021-09-02 10:51:35'),(36,'default','added',154,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 10:52:41','2021-09-02 10:52:41'),(37,'default','added',155,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-02 12:00:13','2021-09-02 12:00:13'),(38,'default','added',156,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-02 12:01:36','2021-09-02 12:01:36'),(39,'default','added',157,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-02 12:03:32','2021-09-02 12:03:32'),(40,'default','added',158,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 12:12:24','2021-09-02 12:12:24'),(41,'default','added',159,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-02 12:14:02','2021-09-02 12:14:02'),(42,'default','added',160,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":275}}','2021-09-02 12:36:31','2021-09-02 12:36:31'),(43,'default','added',161,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-02 12:55:55','2021-09-02 12:55:55'),(44,'default','added',162,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":100}}','2021-09-02 13:15:57','2021-09-02 13:15:57'),(45,'default','added',163,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 13:16:58','2021-09-02 13:16:58'),(46,'default','added',164,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-02 13:35:20','2021-09-02 13:35:20'),(47,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-02 13:40:03','2021-09-02 13:40:03'),(48,'default','added',165,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-02 13:50:58','2021-09-02 13:50:58'),(49,'default','added',166,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-02 14:13:54','2021-09-02 14:13:54'),(50,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-02 14:16:16','2021-09-02 14:16:16'),(51,'default','added',167,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 14:28:43','2021-09-02 14:28:43'),(52,'default','added',168,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-02 14:36:23','2021-09-02 14:36:23'),(53,'default','added',169,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-02 14:51:25','2021-09-02 14:51:25'),(54,'default','added',170,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 14:53:16','2021-09-02 14:53:16'),(55,'default','added',171,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-02 15:02:22','2021-09-02 15:02:22'),(56,'default','added',172,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-02 15:03:39','2021-09-02 15:03:39'),(57,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-02 15:09:06','2021-09-02 15:09:06'),(58,'default','added',173,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-02 15:18:26','2021-09-02 15:18:26'),(59,'default','logout',2,'App\\User',2,2,'App\\User','[]','2021-09-02 15:18:33','2021-09-02 15:18:33'),(60,'default','added',174,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 15:19:53','2021-09-02 15:19:53'),(61,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-02 15:20:02','2021-09-02 15:20:02'),(62,'default','added',176,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 15:22:43','2021-09-02 15:22:43'),(63,'default','added',177,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":425}}','2021-09-02 15:37:05','2021-09-02 15:37:05'),(64,'default','added',178,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-02 15:38:35','2021-09-02 15:38:35'),(65,'default','added',179,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-02 16:08:05','2021-09-02 16:08:05'),(66,'default','added',180,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 16:14:38','2021-09-02 16:14:38'),(67,'default','added',181,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-02 16:15:51','2021-09-02 16:15:51'),(68,'default','added',182,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-02 16:28:07','2021-09-02 16:28:07'),(69,'default','added',183,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-02 16:35:41','2021-09-02 16:35:41'),(70,'default','added',184,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-02 16:38:49','2021-09-02 16:38:49'),(71,'default','added',185,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":425}}','2021-09-02 16:44:50','2021-09-02 16:44:50'),(72,'default','added',186,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-02 16:45:39','2021-09-02 16:45:39'),(73,'default','added',187,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-02 16:46:22','2021-09-02 16:46:22'),(74,'default','added',188,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-02 16:51:52','2021-09-02 16:51:52'),(75,'default','added',190,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-02 17:12:54','2021-09-02 17:12:54'),(76,'default','added',191,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-02 17:15:12','2021-09-02 17:15:12'),(77,'default','added',192,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 17:16:19','2021-09-02 17:16:19'),(78,'default','added',193,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-02 17:19:58','2021-09-02 17:19:58'),(79,'default','added',194,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-02 17:27:23','2021-09-02 17:27:23'),(80,'default','added',195,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 17:37:56','2021-09-02 17:37:56'),(81,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-02 17:58:16','2021-09-02 17:58:16'),(82,'default','added',197,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 18:08:48','2021-09-02 18:08:48'),(83,'default','added',198,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-02 18:09:37','2021-09-02 18:09:37'),(84,'default','added',199,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-02 18:15:43','2021-09-02 18:15:43'),(85,'default','logout',2,'App\\User',2,2,'App\\User','[]','2021-09-02 18:15:51','2021-09-02 18:15:51'),(86,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-02 18:16:11','2021-09-02 18:16:11'),(87,'default','added',200,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-02 18:18:14','2021-09-02 18:18:14'),(88,'default','logout',3,'App\\User',2,3,'App\\User','[]','2021-09-02 18:18:15','2021-09-02 18:18:15'),(89,'default','added',201,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-02 18:20:15','2021-09-02 18:20:15'),(90,'default','added',202,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-02 18:22:15','2021-09-02 18:22:15'),(91,'default','added',203,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-02 18:26:11','2021-09-02 18:26:11'),(92,'default','added',204,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":195}}','2021-09-02 18:34:26','2021-09-02 18:34:26'),(93,'default','added',205,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-02 18:36:25','2021-09-02 18:36:25'),(94,'default','added',206,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":375}}','2021-09-02 18:38:17','2021-09-02 18:38:17'),(95,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-02 18:42:59','2021-09-02 18:42:59'),(96,'default','added',207,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-02 18:43:58','2021-09-02 18:43:58'),(97,'default','logout',3,'App\\User',2,3,'App\\User','[]','2021-09-02 18:44:06','2021-09-02 18:44:06'),(98,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-02 18:44:52','2021-09-02 18:44:52'),(99,'default','added',208,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":375}}','2021-09-02 18:45:18','2021-09-02 18:45:18'),(100,'default','added',209,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 18:47:17','2021-09-02 18:47:17'),(101,'default','added',210,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-02 18:49:46','2021-09-02 18:49:46'),(102,'default','logout',2,'App\\User',2,2,'App\\User','[]','2021-09-02 18:50:15','2021-09-02 18:50:15'),(103,'default','added',211,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-02 18:51:48','2021-09-02 18:51:48'),(104,'default','added',212,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-02 18:53:30','2021-09-02 18:53:30'),(105,'default','added',213,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":345}}','2021-09-02 18:54:49','2021-09-02 18:54:49'),(106,'default','added',214,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 18:55:24','2021-09-02 18:55:24'),(107,'default','added',215,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-02 18:55:49','2021-09-02 18:55:49'),(108,'default','added',216,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-02 18:58:52','2021-09-02 18:58:52'),(109,'default','added',217,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 19:13:58','2021-09-02 19:13:58'),(110,'default','added',218,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-02 19:15:20','2021-09-02 19:15:20'),(111,'default','added',219,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-02 19:16:30','2021-09-02 19:16:30'),(112,'default','added',220,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-02 19:24:44','2021-09-02 19:24:44'),(113,'default','added',221,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":575}}','2021-09-02 19:25:50','2021-09-02 19:25:50'),(114,'default','added',222,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 19:26:25','2021-09-02 19:26:25'),(115,'default','added',223,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-02 19:29:41','2021-09-02 19:29:41'),(116,'default','added',224,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":225}}','2021-09-02 19:34:46','2021-09-02 19:34:46'),(117,'default','added',225,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":270}}','2021-09-02 19:35:25','2021-09-02 19:35:25'),(118,'default','added',226,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-02 19:36:44','2021-09-02 19:36:44'),(119,'default','added',227,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 19:43:08','2021-09-02 19:43:08'),(120,'default','added',228,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 19:51:23','2021-09-02 19:51:23'),(121,'default','added',229,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 19:55:11','2021-09-02 19:55:11'),(122,'default','added',230,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-02 19:55:49','2021-09-02 19:55:49'),(123,'default','added',231,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 20:01:55','2021-09-02 20:01:55'),(124,'default','added',232,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 20:04:06','2021-09-02 20:04:06'),(125,'default','added',233,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 20:09:32','2021-09-02 20:09:32'),(126,'default','added',234,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 20:10:49','2021-09-02 20:10:49'),(127,'default','added',235,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-02 20:12:40','2021-09-02 20:12:40'),(128,'default','added',236,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":345}}','2021-09-02 20:20:03','2021-09-02 20:20:03'),(129,'default','added',237,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 20:24:26','2021-09-02 20:24:26'),(130,'default','added',238,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-02 20:31:12','2021-09-02 20:31:12'),(131,'default','added',239,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-02 20:48:57','2021-09-02 20:48:57'),(132,'default','added',240,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-02 20:58:22','2021-09-02 20:58:22'),(133,'default','added',241,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-02 21:01:59','2021-09-02 21:01:59'),(134,'default','added',242,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 21:05:34','2021-09-02 21:05:34'),(135,'default','added',243,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-02 21:07:56','2021-09-02 21:07:56'),(136,'default','added',244,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 21:10:54','2021-09-02 21:10:54'),(137,'default','added',245,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-02 21:26:09','2021-09-02 21:26:09'),(138,'default','added',246,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-02 21:34:31','2021-09-02 21:34:31'),(139,'default','added',247,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":825}}','2021-09-02 21:39:06','2021-09-02 21:39:06'),(140,'default','added',248,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-02 21:40:37','2021-09-02 21:40:37'),(141,'default','added',249,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 21:46:42','2021-09-02 21:46:42'),(142,'default','added',250,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 21:48:55','2021-09-02 21:48:55'),(143,'default','added',251,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-02 21:51:03','2021-09-02 21:51:03'),(144,'default','added',252,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-02 22:00:23','2021-09-02 22:00:23'),(145,'default','added',253,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-02 22:12:31','2021-09-02 22:12:31'),(146,'default','added',254,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-02 22:19:22','2021-09-02 22:19:22'),(147,'default','added',255,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-02 22:29:42','2021-09-02 22:29:42'),(148,'default','added',256,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-02 22:31:18','2021-09-02 22:31:18'),(149,'default','added',257,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-02 22:38:12','2021-09-02 22:38:12'),(150,'default','added',258,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-02 22:40:38','2021-09-02 22:40:38'),(151,'default','added',259,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 22:43:11','2021-09-02 22:43:11'),(152,'default','added',260,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-02 22:54:37','2021-09-02 22:54:37'),(153,'default','added',261,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 22:55:56','2021-09-02 22:55:56'),(154,'default','added',262,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 22:56:41','2021-09-02 22:56:41'),(155,'default','added',263,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-02 22:58:58','2021-09-02 22:58:58'),(156,'default','added',264,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-02 23:02:03','2021-09-02 23:02:03'),(157,'default','added',265,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-02 23:05:40','2021-09-02 23:05:40'),(158,'default','added',266,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-02 23:07:52','2021-09-02 23:07:52'),(159,'default','added',267,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":325}}','2021-09-02 23:08:24','2021-09-02 23:08:24'),(160,'default','added',268,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 23:08:53','2021-09-02 23:08:53'),(161,'default','added',269,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 23:15:47','2021-09-02 23:15:47'),(162,'default','added',270,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":100}}','2021-09-02 23:17:39','2021-09-02 23:17:39'),(163,'default','added',271,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 23:18:34','2021-09-02 23:18:34'),(164,'default','added',272,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 23:20:16','2021-09-02 23:20:16'),(165,'default','added',273,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-02 23:25:53','2021-09-02 23:25:53'),(166,'default','added',274,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":100}}','2021-09-02 23:30:43','2021-09-02 23:30:43'),(167,'default','added',275,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-02 23:36:46','2021-09-02 23:36:46'),(168,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-03 10:50:35','2021-09-03 10:50:35'),(169,'default','added',276,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":50}}','2021-09-03 13:12:55','2021-09-03 13:12:55'),(170,'default','added',277,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-03 13:14:10','2021-09-03 13:14:10'),(171,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-03 14:00:52','2021-09-03 14:00:52'),(172,'default','added',278,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-03 14:53:27','2021-09-03 14:53:27'),(173,'default','added',279,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-03 15:00:48','2021-09-03 15:00:48'),(174,'default','added',280,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-03 15:09:02','2021-09-03 15:09:02'),(175,'default','added',281,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-03 15:16:35','2021-09-03 15:16:35'),(176,'default','added',282,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1150}}','2021-09-03 16:00:14','2021-09-03 16:00:14'),(177,'default','added',283,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":870}}','2021-09-03 16:03:34','2021-09-03 16:03:34'),(178,'default','added',284,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-03 16:19:33','2021-09-03 16:19:33'),(179,'default','added',285,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":225}}','2021-09-03 16:21:48','2021-09-03 16:21:48'),(180,'default','added',286,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":-100}}','2021-09-03 16:56:37','2021-09-03 16:56:37'),(181,'default','added',287,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-03 17:17:39','2021-09-03 17:17:39'),(182,'default','added',288,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-03 17:30:31','2021-09-03 17:30:31'),(183,'default','added',289,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-03 17:40:37','2021-09-03 17:40:37'),(184,'default','added',290,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-03 17:42:31','2021-09-03 17:42:31'),(185,'default','added',291,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-03 17:45:46','2021-09-03 17:45:46'),(186,'default','added',292,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-03 17:48:03','2021-09-03 17:48:03'),(187,'default','added',293,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":100}}','2021-09-03 18:35:04','2021-09-03 18:35:04'),(188,'default','added',294,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-03 18:39:20','2021-09-03 18:39:21'),(189,'default','added',295,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-03 18:39:33','2021-09-03 18:39:33'),(190,'default','added',296,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-03 18:58:05','2021-09-03 18:58:05'),(191,'default','added',297,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-03 19:01:30','2021-09-03 19:01:30'),(192,'default','added',298,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-03 19:04:07','2021-09-03 19:04:07'),(193,'default','added',299,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":525}}','2021-09-03 19:27:30','2021-09-03 19:27:30'),(194,'default','added',300,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-03 19:43:03','2021-09-03 19:43:03'),(195,'default','added',301,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":195}}','2021-09-03 19:45:10','2021-09-03 19:45:10'),(196,'default','added',302,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":-150}}','2021-09-03 19:50:44','2021-09-03 19:50:44'),(197,'default','added',303,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-03 20:04:39','2021-09-03 20:04:39'),(198,'default','added',304,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-03 20:06:55','2021-09-03 20:06:55'),(199,'default','added',305,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-03 20:10:57','2021-09-03 20:10:57'),(200,'default','added',306,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-03 20:12:06','2021-09-03 20:12:06'),(201,'default','added',307,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-03 20:20:44','2021-09-03 20:20:44'),(202,'default','added',308,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-03 20:23:18','2021-09-03 20:23:18'),(203,'default','added',309,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-03 20:24:03','2021-09-03 20:24:03'),(204,'default','added',310,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-03 20:32:21','2021-09-03 20:32:21'),(205,'default','added',311,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-03 20:36:21','2021-09-03 20:36:21'),(206,'default','added',312,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":225}}','2021-09-03 20:37:02','2021-09-03 20:37:02'),(207,'default','added',313,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-03 20:37:47','2021-09-03 20:37:47'),(208,'default','added',314,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-03 20:41:28','2021-09-03 20:41:28'),(209,'default','added',315,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-03 20:52:48','2021-09-03 20:52:48'),(210,'default','added',316,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-03 21:07:12','2021-09-03 21:07:12'),(211,'default','added',317,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-03 21:14:18','2021-09-03 21:14:18'),(212,'default','added',318,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-03 21:20:18','2021-09-03 21:20:18'),(213,'default','added',319,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-03 21:28:18','2021-09-03 21:28:18'),(214,'default','added',320,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-03 21:45:39','2021-09-03 21:45:39'),(215,'default','added',321,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-03 21:50:29','2021-09-03 21:50:29'),(216,'default','added',322,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":225}}','2021-09-03 21:50:36','2021-09-03 21:50:36'),(217,'default','added',323,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-03 21:54:58','2021-09-03 21:54:58'),(218,'default','added',324,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":195}}','2021-09-03 22:07:44','2021-09-03 22:07:44'),(219,'default','added',325,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":0}}','2021-09-03 22:24:29','2021-09-03 22:24:29'),(220,'default','added',326,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-03 22:25:05','2021-09-03 22:25:05'),(221,'default','added',327,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-03 22:52:39','2021-09-03 22:52:39'),(222,'default','added',328,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-03 22:53:01','2021-09-03 22:53:01'),(223,'default','added',329,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-03 22:54:02','2021-09-03 22:54:02'),(224,'default','added',330,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-03 23:21:16','2021-09-03 23:21:16'),(225,'default','added',331,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-03 23:25:16','2021-09-03 23:25:16'),(226,'default','added',332,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":425}}','2021-09-03 23:26:49','2021-09-03 23:26:49'),(227,'default','added',333,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":425}}','2021-09-03 23:55:09','2021-09-03 23:55:09'),(228,'default','added',334,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":75}}','2021-09-03 23:56:58','2021-09-03 23:56:58'),(229,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-04 00:18:30','2021-09-04 00:18:30'),(230,'default','edited',302,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":150},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"-150.0000\"}}','2021-09-04 00:51:27','2021-09-04 00:51:27'),(231,'default','edited',286,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":100},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"-100.0000\"}}','2021-09-04 00:51:59','2021-09-04 00:51:59'),(232,'default','edited',302,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":150},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"150.0000\"}}','2021-09-04 01:20:21','2021-09-04 01:20:21'),(233,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-04 08:32:28','2021-09-04 08:32:28'),(234,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-04 09:46:41','2021-09-04 09:46:41'),(235,'default','logout',2,'App\\User',2,2,'App\\User','[]','2021-09-04 09:53:30','2021-09-04 09:53:30'),(236,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-04 09:53:45','2021-09-04 09:53:45'),(237,'default','edited',334,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":75},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"75.0000\"}}','2021-09-04 09:55:31','2021-09-04 09:55:31'),(238,'default','edited',334,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":75},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"75.0000\"}}','2021-09-04 09:55:53','2021-09-04 09:55:53'),(239,'default','logout',9,'App\\User',2,9,'App\\User','[]','2021-09-04 10:01:59','2021-09-04 10:01:59'),(240,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-04 10:02:23','2021-09-04 10:02:23'),(241,'default','payment_edited',334,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"75.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"75.0000\"}}','2021-09-04 10:03:48','2021-09-04 10:03:48'),(242,'default','payment_edited',302,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"150.0000\"}}','2021-09-04 10:04:01','2021-09-04 10:04:01'),(243,'default','payment_edited',293,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"100.0000\"}}','2021-09-04 10:04:18','2021-09-04 10:04:18'),(244,'default','payment_edited',286,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"100.0000\"}}','2021-09-04 10:04:43','2021-09-04 10:04:43'),(245,'default','payment_edited',276,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"50.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"50.0000\"}}','2021-09-04 10:04:59','2021-09-04 10:04:59'),(246,'default','payment_edited',274,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"100.0000\"}}','2021-09-04 10:05:13','2021-09-04 10:05:13'),(247,'default','payment_edited',270,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"100.0000\"}}','2021-09-04 10:05:30','2021-09-04 10:05:30'),(248,'default','payment_edited',162,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"100.0000\"}}','2021-09-04 10:05:41','2021-09-04 10:05:42'),(249,'default','payment_edited',76,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"150.0000\"}}','2021-09-04 10:05:54','2021-09-04 10:05:54'),(250,'default','logout',2,'App\\User',2,2,'App\\User','[]','2021-09-04 10:07:41','2021-09-04 10:07:41'),(251,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-04 11:22:23','2021-09-04 11:22:23'),(252,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-04 11:47:10','2021-09-04 11:47:10'),(253,'default','added',335,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 12:19:48','2021-09-04 12:19:48'),(254,'default','added',336,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-04 12:29:30','2021-09-04 12:29:30'),(255,'default','added',337,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":475}}','2021-09-04 12:42:22','2021-09-04 12:42:22'),(256,'default','added',338,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":100}}','2021-09-04 12:48:50','2021-09-04 12:48:50'),(257,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-04 13:09:15','2021-09-04 13:09:15'),(258,'default','payment_edited',338,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"100.0000\"}}','2021-09-04 13:20:28','2021-09-04 13:20:28'),(259,'default','added',339,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":475}}','2021-09-04 14:08:14','2021-09-04 14:08:14'),(260,'default','added',340,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 15:33:30','2021-09-04 15:33:30'),(261,'default','added',341,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 16:09:23','2021-09-04 16:09:23'),(262,'default','added',342,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-04 16:10:59','2021-09-04 16:10:59'),(263,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-04 16:56:24','2021-09-04 16:56:24'),(264,'default','added',343,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 17:16:52','2021-09-04 17:16:52'),(265,'default','added',344,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-04 17:24:21','2021-09-04 17:24:21'),(266,'default','added',345,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":75}}','2021-09-04 17:25:04','2021-09-04 17:25:04'),(267,'default','payment_edited',345,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"75.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"75.0000\"}}','2021-09-04 17:29:50','2021-09-04 17:29:50'),(268,'default','added',346,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-04 17:36:15','2021-09-04 17:36:15'),(269,'default','added',347,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-04 17:56:23','2021-09-04 17:56:23'),(270,'default','added',348,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":375}}','2021-09-04 17:58:41','2021-09-04 17:58:41'),(271,'default','added',349,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 18:46:28','2021-09-04 18:46:28'),(272,'default','added',350,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-09-04 18:48:18','2021-09-04 18:48:18'),(273,'default','added',351,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 18:51:55','2021-09-04 18:51:55'),(274,'default','added',352,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 18:55:10','2021-09-04 18:55:10'),(275,'default','added',353,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-04 19:01:19','2021-09-04 19:01:19'),(276,'default','added',354,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-04 19:06:02','2021-09-04 19:06:02'),(277,'default','added',355,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":75}}','2021-09-04 19:06:55','2021-09-04 19:06:55'),(278,'default','payment_edited',355,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"75.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"75.0000\"}}','2021-09-04 19:09:21','2021-09-04 19:09:21'),(279,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-04 19:28:18','2021-09-04 19:28:18'),(280,'default','logout',2,'App\\User',2,2,'App\\User','[]','2021-09-04 19:30:00','2021-09-04 19:30:00'),(281,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-04 19:30:26','2021-09-04 19:30:26'),(282,'default','added',356,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":395}}','2021-09-04 19:40:58','2021-09-04 19:40:58'),(283,'default','added',357,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-04 20:11:10','2021-09-04 20:11:10'),(284,'default','added',358,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-04 20:27:28','2021-09-04 20:27:28'),(285,'default','added',359,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 20:33:39','2021-09-04 20:33:39'),(286,'default','added',360,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-04 20:35:12','2021-09-04 20:35:12'),(287,'default','added',361,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-04 20:35:55','2021-09-04 20:35:55'),(288,'default','added',362,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-04 20:40:00','2021-09-04 20:40:00'),(289,'default','added',363,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-04 20:53:38','2021-09-04 20:53:38'),(290,'default','added',364,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-04 20:57:00','2021-09-04 20:57:00'),(291,'default','added',365,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-09-04 20:57:58','2021-09-04 20:57:58'),(292,'default','added',366,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":200}}','2021-09-04 21:05:56','2021-09-04 21:05:56'),(293,'default','added',367,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-04 21:08:20','2021-09-04 21:08:20'),(294,'default','payment_edited',366,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"200.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"200.0000\"}}','2021-09-04 21:13:31','2021-09-04 21:13:31'),(295,'default','added',368,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 21:28:12','2021-09-04 21:28:12'),(296,'default','added',369,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 21:29:05','2021-09-04 21:29:05'),(297,'default','added',370,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-04 21:40:44','2021-09-04 21:40:44'),(298,'default','added',371,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-04 21:47:44','2021-09-04 21:47:44'),(299,'default','added',372,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-04 22:02:41','2021-09-04 22:02:41'),(300,'default','added',373,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 22:02:59','2021-09-04 22:02:59'),(301,'default','added',374,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 22:03:24','2021-09-04 22:03:24'),(302,'default','added',375,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-04 22:07:54','2021-09-04 22:07:54'),(303,'default','added',376,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 22:17:30','2021-09-04 22:17:30'),(304,'default','added',377,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 22:22:55','2021-09-04 22:22:55'),(305,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-04 22:26:45','2021-09-04 22:26:45'),(306,'default','added',378,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-04 22:37:39','2021-09-04 22:37:39'),(307,'default','added',379,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-04 22:45:00','2021-09-04 22:45:00'),(308,'default','added',380,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":275}}','2021-09-04 22:47:25','2021-09-04 22:47:25'),(309,'default','added',381,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-04 22:48:28','2021-09-04 22:48:28'),(310,'default','added',382,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 22:49:36','2021-09-04 22:49:36'),(311,'default','added',383,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-04 22:51:31','2021-09-04 22:51:31'),(312,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-04 23:54:52','2021-09-04 23:54:52'),(313,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-04 23:57:20','2021-09-04 23:57:20'),(314,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-05 00:35:09','2021-09-05 00:35:09'),(315,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-05 01:33:12','2021-09-05 01:33:12'),(316,'default','logout',2,'App\\User',2,2,'App\\User','[]','2021-09-05 01:35:01','2021-09-05 01:35:01'),(317,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-05 11:19:38','2021-09-05 11:19:38'),(318,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-05 11:26:05','2021-09-05 11:26:05'),(319,'default','added',384,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-05 11:41:53','2021-09-05 11:41:53'),(320,'default','added',385,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-05 11:59:40','2021-09-05 11:59:40'),(321,'default','added',386,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-05 12:09:07','2021-09-05 12:09:07'),(322,'default','added',387,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-05 12:09:45','2021-09-05 12:09:45'),(323,'default','added',388,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-05 12:26:06','2021-09-05 12:26:06'),(324,'default','added',389,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-05 13:29:07','2021-09-05 13:29:07'),(325,'default','added',390,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":300}}','2021-09-05 15:22:48','2021-09-05 15:22:48'),(326,'default','payment_edited',390,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"300.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"300.0000\"}}','2021-09-05 15:23:18','2021-09-05 15:23:18'),(327,'default','added',391,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-05 15:24:23','2021-09-05 15:24:23'),(328,'default','added',392,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-05 15:32:10','2021-09-05 15:32:10'),(329,'default','added',393,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-05 16:07:36','2021-09-05 16:07:36'),(330,'default','added',394,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-05 17:52:43','2021-09-05 17:52:43'),(331,'default','added',395,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-05 18:04:14','2021-09-05 18:04:14'),(332,'default','added',396,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-05 18:06:48','2021-09-05 18:06:48'),(333,'default','added',397,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-05 18:32:58','2021-09-05 18:32:58'),(334,'default','added',398,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-05 18:42:04','2021-09-05 18:42:04'),(335,'default','added',399,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-05 18:48:36','2021-09-05 18:48:36'),(336,'default','added',400,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-05 18:53:15','2021-09-05 18:53:15'),(337,'default','added',401,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-05 19:36:46','2021-09-05 19:36:46'),(338,'default','added',402,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-05 19:45:10','2021-09-05 19:45:10'),(339,'default','added',403,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-05 19:47:35','2021-09-05 19:47:35'),(340,'default','added',404,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-05 20:25:23','2021-09-05 20:25:23'),(341,'default','added',405,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-05 20:41:22','2021-09-05 20:41:22'),(342,'default','added',406,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-05 20:42:46','2021-09-05 20:42:46'),(343,'default','added',407,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-05 21:18:29','2021-09-05 21:18:29'),(344,'default','added',408,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-05 21:20:21','2021-09-05 21:20:21'),(345,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-05 21:20:29','2021-09-05 21:20:29'),(346,'default','added',409,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-05 21:30:02','2021-09-05 21:30:02'),(347,'default','added',410,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-05 21:47:25','2021-09-05 21:47:25'),(348,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-05 22:10:10','2021-09-05 22:10:10'),(349,'default','added',411,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":225}}','2021-09-05 22:40:19','2021-09-05 22:40:19'),(350,'default','added',412,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-05 22:53:10','2021-09-05 22:53:10'),(351,'default','added',413,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-05 23:02:18','2021-09-05 23:02:18'),(352,'default','added',414,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":225}}','2021-09-05 23:04:46','2021-09-05 23:04:46'),(353,'default','logout',2,'App\\User',2,2,'App\\User','[]','2021-09-05 23:33:38','2021-09-05 23:33:38'),(354,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-06 10:21:41','2021-09-06 10:21:41'),(355,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-06 11:21:03','2021-09-06 11:21:03'),(356,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-06 11:47:28','2021-09-06 11:47:28'),(357,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-06 12:34:05','2021-09-06 12:34:05'),(358,'default','added',415,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-06 13:17:55','2021-09-06 13:17:55'),(359,'default','added',416,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-06 14:06:12','2021-09-06 14:06:12'),(360,'default','added',417,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-06 14:16:40','2021-09-06 14:16:40'),(361,'default','added',418,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-06 16:10:43','2021-09-06 16:10:43'),(362,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-06 17:51:12','2021-09-06 17:51:12'),(363,'default','added',419,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":50}}','2021-09-06 17:52:16','2021-09-06 17:52:16'),(364,'default','added',420,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-06 17:52:49','2021-09-06 17:52:49'),(365,'default','payment_edited',419,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"50.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"50.0000\"}}','2021-09-06 17:54:33','2021-09-06 17:54:33'),(366,'default','added',421,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-06 18:38:05','2021-09-06 18:38:05'),(367,'default','added',422,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-06 18:56:11','2021-09-06 18:56:11'),(368,'default','added',423,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-06 19:12:58','2021-09-06 19:12:58'),(369,'default','added',424,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-06 19:16:30','2021-09-06 19:16:30'),(370,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-06 19:26:51','2021-09-06 19:26:51'),(371,'default','added',425,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-06 19:35:03','2021-09-06 19:35:03'),(372,'default','added',426,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":0}}','2021-09-06 19:57:09','2021-09-06 19:57:09'),(373,'default','edited',426,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":150},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}','2021-09-06 19:59:45','2021-09-06 19:59:45'),(374,'default','payment_edited',426,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"150.0000\"}}','2021-09-06 20:00:28','2021-09-06 20:00:28'),(375,'default','added',427,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-06 20:08:02','2021-09-06 20:08:02'),(376,'default','added',428,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-06 20:09:40','2021-09-06 20:09:40'),(377,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-06 20:35:47','2021-09-06 20:35:47'),(378,'default','added',429,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-06 20:38:46','2021-09-06 20:38:46'),(379,'default','added',430,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-06 20:51:19','2021-09-06 20:51:19'),(380,'default','logout',2,'App\\User',2,2,'App\\User','[]','2021-09-06 21:06:30','2021-09-06 21:06:30'),(381,'default','added',431,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-06 21:22:21','2021-09-06 21:22:21'),(382,'default','added',432,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-06 21:22:37','2021-09-06 21:22:37'),(383,'default','added',433,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-06 21:23:21','2021-09-06 21:23:21'),(384,'default','added',434,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":575}}','2021-09-06 21:26:07','2021-09-06 21:26:07'),(385,'default','added',435,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-06 21:41:10','2021-09-06 21:41:10'),(386,'default','added',436,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-06 21:55:08','2021-09-06 21:55:08'),(387,'default','added',437,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":275}}','2021-09-06 22:11:02','2021-09-06 22:11:02'),(388,'default','added',438,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-06 22:36:37','2021-09-06 22:36:37'),(389,'default','added',439,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-06 22:57:31','2021-09-06 22:57:31'),(390,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-06 23:17:59','2021-09-06 23:17:59'),(391,'default','logout',2,'App\\User',2,2,'App\\User','[]','2021-09-07 00:04:00','2021-09-07 00:04:00'),(392,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-07 09:56:54','2021-09-07 09:56:54'),(393,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-07 10:15:41','2021-09-07 10:15:41'),(394,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-07 11:04:22','2021-09-07 11:04:22'),(395,'default','added',440,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-07 11:19:36','2021-09-07 11:19:36'),(396,'default','added',441,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":50}}','2021-09-07 11:48:36','2021-09-07 11:48:36'),(397,'default','added',442,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-07 11:49:53','2021-09-07 11:49:53'),(398,'default','payment_edited',441,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"50.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"50.0000\"}}','2021-09-07 11:51:19','2021-09-07 11:51:19'),(399,'default','added',443,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-07 12:19:56','2021-09-07 12:19:56'),(400,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-07 12:52:40','2021-09-07 12:52:40'),(401,'default','added',444,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}','2021-09-07 13:23:35','2021-09-07 13:23:35'),(402,'default','added',445,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-07 13:47:49','2021-09-07 13:47:49'),(403,'default','added',446,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-07 15:07:51','2021-09-07 15:07:51'),(404,'default','added',447,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-07 15:10:13','2021-09-07 15:10:13'),(405,'default','added',448,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":200}}','2021-09-07 15:12:11','2021-09-07 15:12:11'),(406,'default','payment_edited',448,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"200.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"200.0000\"}}','2021-09-07 15:13:12','2021-09-07 15:13:12'),(407,'default','added',449,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-07 16:32:09','2021-09-07 16:32:09'),(408,'default','added',450,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-07 16:34:23','2021-09-07 16:34:23'),(409,'default','added',451,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":225}}','2021-09-07 17:17:35','2021-09-07 17:17:35'),(410,'default','added',452,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-07 17:53:50','2021-09-07 17:53:50'),(411,'default','added',453,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":225}}','2021-09-07 18:15:30','2021-09-07 18:15:30'),(412,'default','added',454,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-07 18:54:24','2021-09-07 18:54:24'),(413,'default','added',455,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-07 18:56:23','2021-09-07 18:56:23'),(414,'default','added',456,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-07 19:00:27','2021-09-07 19:00:27'),(415,'default','added',457,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-07 19:19:08','2021-09-07 19:19:08'),(416,'default','added',458,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}','2021-09-07 19:31:15','2021-09-07 19:31:15'),(417,'default','added',459,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-07 20:04:54','2021-09-07 20:04:54'),(418,'default','added',460,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-07 20:41:39','2021-09-07 20:41:39'),(419,'default','added',461,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-07 20:59:08','2021-09-07 20:59:08'),(420,'default','added',462,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-09-07 21:42:36','2021-09-07 21:42:36'),(421,'default','added',463,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-07 22:29:14','2021-09-07 22:29:14'),(422,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-07 23:23:02','2021-09-07 23:23:02'),(423,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-08 09:51:48','2021-09-08 09:51:48'),(424,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-08 10:53:10','2021-09-08 10:53:10'),(425,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-08 12:49:27','2021-09-08 12:49:27'),(426,'default','added',464,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-08 13:18:05','2021-09-08 13:18:05'),(427,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-08 13:44:56','2021-09-08 13:44:56'),(428,'default','added',465,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":50}}','2021-09-08 13:47:35','2021-09-08 13:47:35'),(429,'default','added',466,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-08 13:51:16','2021-09-08 13:51:16'),(430,'default','added',467,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-08 13:55:00','2021-09-08 13:55:00'),(431,'default','added',468,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-08 13:56:08','2021-09-08 13:56:08'),(432,'default','added',469,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":225}}','2021-09-08 13:56:11','2021-09-08 13:56:11'),(433,'default','edited',465,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":50},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"50.0000\"}}','2021-09-08 13:58:19','2021-09-08 13:58:19'),(434,'default','added',470,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-08 15:53:46','2021-09-08 15:53:46'),(435,'default','added',471,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":50}}','2021-09-08 15:56:50','2021-09-08 15:56:50'),(436,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-08 16:07:11','2021-09-08 16:07:11'),(437,'default','added',472,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-08 16:07:53','2021-09-08 16:07:53'),(438,'default','added',473,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-08 16:55:51','2021-09-08 16:55:51'),(439,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-08 17:11:39','2021-09-08 17:11:39'),(440,'default','added',474,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":75}}','2021-09-08 17:21:05','2021-09-08 17:21:05'),(441,'default','edited',474,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":75},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"75.0000\"}}','2021-09-08 17:21:33','2021-09-08 17:21:33'),(442,'default','added',475,'App\\Transaction',2,2,'App\\User','[]','2021-09-08 17:29:07','2021-09-08 17:29:07'),(443,'default','added',476,'App\\Transaction',2,2,'App\\User','[]','2021-09-08 17:38:03','2021-09-08 17:38:03'),(444,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-08 18:19:13','2021-09-08 18:19:13'),(445,'default','payment_edited',474,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"75.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"75.0000\"}}','2021-09-08 18:24:29','2021-09-08 18:24:29'),(446,'default','payment_edited',471,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"50.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"50.0000\"}}','2021-09-08 18:24:44','2021-09-08 18:24:44'),(447,'default','added',478,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-08 19:25:32','2021-09-08 19:25:32'),(448,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-08 19:30:43','2021-09-08 19:30:43'),(449,'default','added',479,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-08 19:34:20','2021-09-08 19:34:20'),(450,'default','payment_edited',465,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"50.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"50.0000\"}}','2021-09-08 19:40:55','2021-09-08 19:40:55'),(451,'default','added',480,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-08 19:41:58','2021-09-08 19:41:58'),(452,'default','added',481,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-08 19:43:14','2021-09-08 19:43:14'),(453,'default','added',482,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-08 20:09:16','2021-09-08 20:09:16'),(454,'default','added',483,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-08 20:18:09','2021-09-08 20:18:09'),(455,'default','added',484,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-08 20:45:08','2021-09-08 20:45:08'),(456,'default','added',485,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-08 20:48:15','2021-09-08 20:48:15'),(457,'default','added',486,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-08 20:49:08','2021-09-08 20:49:08'),(458,'default','added',487,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-08 21:15:16','2021-09-08 21:15:16'),(459,'default','added',488,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-08 22:11:49','2021-09-08 22:11:49'),(460,'default','added',489,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-08 22:24:10','2021-09-08 22:24:10'),(461,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-08 23:33:44','2021-09-08 23:33:44'),(462,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-09 11:18:09','2021-09-09 11:18:09'),(463,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-09 11:52:46','2021-09-09 11:52:46'),(464,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-09 12:33:08','2021-09-09 12:33:08'),(465,'default','added',490,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-09 13:46:48','2021-09-09 13:46:48'),(466,'default','added',491,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-09 14:20:25','2021-09-09 14:20:25'),(467,'default','added',492,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-09 14:37:28','2021-09-09 14:37:28'),(468,'default','added',493,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-09 14:52:11','2021-09-09 14:52:11'),(469,'default','added',494,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":350}}','2021-09-09 15:03:07','2021-09-09 15:03:07'),(470,'default','payment_edited',494,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"350.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"350.0000\"}}','2021-09-09 15:05:50','2021-09-09 15:05:50'),(471,'default','added',495,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":75}}','2021-09-09 15:34:05','2021-09-09 15:34:05'),(472,'default','added',496,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-09 15:36:15','2021-09-09 15:36:15'),(473,'default','added',497,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-09 16:22:56','2021-09-09 16:22:56'),(474,'default','added',498,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":150}}','2021-09-09 16:35:04','2021-09-09 16:35:04'),(475,'default','payment_edited',498,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"150.0000\"}}','2021-09-09 16:35:35','2021-09-09 16:35:35'),(476,'default','added',499,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":75}}','2021-09-09 16:37:17','2021-09-09 16:37:17'),(477,'default','payment_edited',499,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"75.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"75.0000\"}}','2021-09-09 16:37:42','2021-09-09 16:37:42'),(478,'default','payment_edited',495,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"75.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"75.0000\"}}','2021-09-09 16:42:43','2021-09-09 16:42:43'),(479,'default','added',500,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-09 16:44:58','2021-09-09 16:44:58'),(480,'default','added',501,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-09 16:45:18','2021-09-09 16:45:18'),(481,'default','added',3,'App\\Contact',2,2,'App\\User','[]','2021-09-09 17:39:40','2021-09-09 17:39:40'),(482,'default','edited',3,'App\\Contact',2,2,'App\\User','[]','2021-09-09 17:40:35','2021-09-09 17:40:35'),(483,'default','edited',3,'App\\Contact',2,2,'App\\User','[]','2021-09-09 17:41:24','2021-09-09 17:41:24'),(484,'default','contact_deleted',3,'App\\Contact',2,2,'App\\User','[]','2021-09-09 17:41:44','2021-09-09 17:41:44'),(485,'default','added',4,'App\\Contact',2,2,'App\\User','[]','2021-09-09 17:41:58','2021-09-09 17:41:58'),(486,'default','added',502,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-09 17:44:14','2021-09-09 17:44:14'),(487,'default','added',503,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":8390}}','2021-09-09 17:51:57','2021-09-09 17:51:57'),(488,'default','added',504,'App\\Transaction',2,2,'App\\User','[]','2021-09-09 17:54:32','2021-09-09 17:54:32'),(489,'default','added',505,'App\\Transaction',2,2,'App\\User','[]','2021-09-09 17:56:40','2021-09-09 17:56:40'),(490,'default','added',506,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1615}}','2021-09-09 17:58:50','2021-09-09 17:58:50'),(491,'default','added',507,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-09 19:43:45','2021-09-09 19:43:45'),(492,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-09 20:57:24','2021-09-09 20:57:24'),(493,'default','added',508,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-09 21:33:29','2021-09-09 21:33:29'),(494,'default','added',509,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-09 21:59:51','2021-09-09 21:59:51'),(495,'default','added',510,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":275}}','2021-09-09 23:15:06','2021-09-09 23:15:06'),(496,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-09 23:16:01','2021-09-09 23:16:01'),(497,'default','added',511,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"pending\",\"payment_status\":\"due\",\"final_total\":36625}}','2021-09-09 23:23:34','2021-09-09 23:23:34'),(498,'default','added',512,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"pending\",\"payment_status\":\"due\",\"final_total\":38650}}','2021-09-09 23:33:30','2021-09-09 23:33:30'),(499,'default','added',513,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"pending\",\"payment_status\":\"due\",\"final_total\":23975}}','2021-09-09 23:38:43','2021-09-09 23:38:43'),(500,'default','added',514,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"pending\",\"payment_status\":\"due\",\"final_total\":38650}}','2021-09-09 23:49:28','2021-09-09 23:49:28'),(501,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-10 12:12:31','2021-09-10 12:12:31'),(502,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-10 13:14:13','2021-09-10 13:14:13'),(503,'default','added',515,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":675}}','2021-09-10 14:19:36','2021-09-10 14:19:36'),(504,'default','added',516,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-10 14:26:24','2021-09-10 14:26:24'),(505,'default','added',517,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-10 15:16:00','2021-09-10 15:16:00'),(506,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-10 16:15:55','2021-09-10 16:15:55'),(507,'default','edited',514,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"pending\",\"payment_status\":\"due\",\"final_total\":38650},\"old\":{\"type\":\"purchase\",\"status\":\"pending\",\"payment_status\":\"due\",\"final_total\":\"38650.0000\"}}','2021-09-10 16:16:50','2021-09-10 16:16:50'),(508,'default','edited',513,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"pending\",\"payment_status\":\"due\",\"final_total\":23975},\"old\":{\"type\":\"purchase\",\"status\":\"pending\",\"payment_status\":\"due\",\"final_total\":\"23975.0000\"}}','2021-09-10 16:17:18','2021-09-10 16:17:18'),(509,'default','edited',512,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"pending\",\"payment_status\":\"due\",\"final_total\":38650},\"old\":{\"type\":\"purchase\",\"status\":\"pending\",\"payment_status\":\"due\",\"final_total\":\"38650.0000\"}}','2021-09-10 16:17:38','2021-09-10 16:17:38'),(510,'default','edited',511,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"pending\",\"payment_status\":\"due\",\"final_total\":36625},\"old\":{\"type\":\"purchase\",\"status\":\"pending\",\"payment_status\":\"due\",\"final_total\":\"36625.0000\"}}','2021-09-10 16:18:14','2021-09-10 16:18:14'),(511,'default','added',518,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":36625}}','2021-09-10 16:27:37','2021-09-10 16:27:37'),(512,'default','added',519,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":23975}}','2021-09-10 16:37:33','2021-09-10 16:37:33'),(513,'default','added',520,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-10 17:06:27','2021-09-10 17:06:27'),(514,'default','added',521,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":1490}}','2021-09-10 17:30:22','2021-09-10 17:30:22'),(515,'default','added',522,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1490}}','2021-09-10 17:32:40','2021-09-10 17:32:40'),(516,'default','added',523,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-10 17:48:00','2021-09-10 17:48:00'),(517,'default','added',524,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-10 17:49:24','2021-09-10 17:49:24'),(518,'default','added',525,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-10 17:53:46','2021-09-10 17:53:46'),(519,'default','added',526,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-10 18:52:44','2021-09-10 18:52:44'),(520,'default','added',527,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-10 19:09:22','2021-09-10 19:09:22'),(521,'default','added',528,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-10 19:26:21','2021-09-10 19:26:21'),(522,'default','added',531,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-10 19:38:04','2021-09-10 19:38:04'),(523,'default','added',532,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-10 19:42:34','2021-09-10 19:42:34'),(524,'default','added',533,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":500}}','2021-09-10 20:04:16','2021-09-10 20:04:16'),(525,'default','payment_edited',533,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}','2021-09-10 20:04:48','2021-09-10 20:04:48'),(526,'default','added',534,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":950}}','2021-09-10 20:16:34','2021-09-10 20:16:34'),(527,'default','added',535,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-10 21:13:24','2021-09-10 21:13:24'),(528,'default','added',536,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-10 21:16:33','2021-09-10 21:16:33'),(529,'default','added',537,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-10 21:22:41','2021-09-10 21:22:41'),(530,'default','added',538,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-10 22:14:17','2021-09-10 22:14:17'),(531,'default','added',539,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-10 22:15:08','2021-09-10 22:15:08'),(532,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-11 00:31:11','2021-09-11 00:31:11'),(533,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-11 10:51:50','2021-09-11 10:51:50'),(534,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-11 13:45:05','2021-09-11 13:45:05'),(535,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-11 14:26:22','2021-09-11 14:26:22'),(536,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-11 14:44:58','2021-09-11 14:44:58'),(537,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-11 16:49:14','2021-09-11 16:49:14'),(538,'default','added',540,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-11 17:13:57','2021-09-11 17:13:57'),(539,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-11 17:57:17','2021-09-11 17:57:17'),(540,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-11 19:21:10','2021-09-11 19:21:10'),(541,'default','added',541,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-11 20:27:49','2021-09-11 20:27:49'),(542,'default','added',542,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":50}}','2021-09-11 20:31:12','2021-09-11 20:31:12'),(543,'default','payment_edited',542,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"50.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"50.0000\"}}','2021-09-11 20:31:48','2021-09-11 20:31:48'),(544,'default','added',543,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-09-11 20:45:46','2021-09-11 20:45:46'),(545,'default','added',544,'App\\Transaction',2,2,'App\\User','[]','2021-09-11 20:50:03','2021-09-11 20:50:03'),(546,'default','added',545,'App\\Transaction',2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":8500}}','2021-09-11 20:51:49','2021-09-11 20:51:49'),(547,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-11 21:57:06','2021-09-11 21:57:06'),(548,'default','added',546,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":250}}','2021-09-11 21:58:40','2021-09-11 21:58:40'),(549,'default','payment_edited',546,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"250.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"250.0000\"}}','2021-09-11 21:59:48','2021-09-11 21:59:48'),(550,'default','added',547,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-11 22:19:48','2021-09-11 22:19:48'),(551,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-11 23:18:42','2021-09-11 23:18:42'),(552,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-11 23:55:11','2021-09-11 23:55:11'),(553,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-12 10:45:47','2021-09-12 10:45:47'),(554,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-12 10:59:49','2021-09-12 10:59:49'),(555,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-12 16:20:21','2021-09-12 16:20:21'),(556,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-12 19:17:14','2021-09-12 19:17:14'),(557,'default','added',548,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":200}}','2021-09-12 19:45:22','2021-09-12 19:45:22'),(558,'default','payment_edited',548,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"200.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"200.0000\"}}','2021-09-12 19:51:41','2021-09-12 19:51:41'),(559,'default','added',549,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-12 20:06:40','2021-09-12 20:06:40'),(560,'default','added',550,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":195}}','2021-09-12 22:02:25','2021-09-12 22:02:25'),(561,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-12 22:39:34','2021-09-12 22:39:34'),(562,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-12 23:20:12','2021-09-12 23:20:12'),(563,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-13 10:44:50','2021-09-13 10:44:50'),(564,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-13 10:46:24','2021-09-13 10:46:24'),(565,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-13 11:05:29','2021-09-13 11:05:29'),(566,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-13 13:22:25','2021-09-13 13:22:25'),(567,'default','added',551,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-13 13:23:47','2021-09-13 13:23:47'),(568,'default','added',552,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-13 16:34:15','2021-09-13 16:34:15'),(569,'default','added',553,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-13 18:21:41','2021-09-13 18:21:41'),(570,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-13 18:43:10','2021-09-13 18:43:10'),(571,'default','added',554,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-13 18:43:31','2021-09-13 18:43:31'),(572,'default','added',555,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-13 19:25:31','2021-09-13 19:25:31'),(573,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-13 21:07:33','2021-09-13 21:07:33'),(574,'default','added',556,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":100}}','2021-09-13 21:08:29','2021-09-13 21:08:29'),(575,'default','added',557,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-13 21:09:58','2021-09-13 21:09:58'),(576,'default','added',558,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-13 22:27:31','2021-09-13 22:27:31'),(577,'default','payment_edited',556,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"100.0000\"}}','2021-09-13 22:42:16','2021-09-13 22:42:16'),(578,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-13 23:58:29','2021-09-13 23:58:29'),(579,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-14 10:59:52','2021-09-14 10:59:52'),(580,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-14 11:08:16','2021-09-14 11:08:16'),(581,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-14 15:14:47','2021-09-14 15:14:47'),(582,'default','added',559,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-14 15:15:10','2021-09-14 15:15:10'),(583,'default','added',560,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-14 15:27:41','2021-09-14 15:27:41'),(584,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-14 17:01:09','2021-09-14 17:01:09'),(585,'default','added',561,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-14 17:01:34','2021-09-14 17:01:34'),(586,'default','added',562,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-14 17:21:26','2021-09-14 17:21:26'),(587,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-14 18:35:29','2021-09-14 18:35:29'),(588,'default','added',563,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-14 20:13:11','2021-09-14 20:13:11'),(589,'default','added',564,'App\\Transaction',2,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":390}}','2021-09-14 20:47:47','2021-09-14 20:47:47'),(590,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-14 21:28:33','2021-09-14 21:28:33'),(591,'default','added',565,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":225}}','2021-09-14 21:29:08','2021-09-14 21:29:08'),(592,'default','added',566,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-14 21:55:29','2021-09-14 21:55:29'),(593,'default','added',567,'App\\Transaction',2,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-14 22:01:51','2021-09-14 22:01:51'),(594,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-15 11:11:12','2021-09-15 11:11:12'),(595,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-15 13:05:13','2021-09-15 13:05:13'),(596,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-16 00:03:19','2021-09-16 00:03:19'),(597,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-16 14:26:11','2021-09-16 14:26:11'),(598,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-16 15:12:12','2021-09-16 15:12:12'),(599,'default','logout',2,'App\\User',2,2,'App\\User','[]','2021-09-16 15:12:38','2021-09-16 15:12:38'),(600,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-16 16:47:30','2021-09-16 16:47:30'),(601,'default','login',3,'App\\User',2,3,'App\\User','[]','2021-09-17 17:45:37','2021-09-17 17:45:37'),(602,'default','login',2,'App\\User',2,2,'App\\User','[]','2021-09-17 23:37:30','2021-09-17 23:37:30'),(603,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-20 21:27:12','2021-09-20 21:27:12'),(604,'default','added',5,'App\\Contact',1,1,'App\\User','[]','2021-09-20 22:38:24','2021-09-20 22:38:24'),(605,'default','added',569,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11875}}','2021-09-20 22:39:03','2021-09-20 22:39:03'),(606,'default','added',570,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11250}}','2021-09-20 22:39:54','2021-09-20 22:39:54'),(607,'default','payment_edited',569,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"11875.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"11875.0000\"}}','2021-09-20 22:40:20','2021-09-20 22:40:20'),(608,'default','login',9,'App\\User',2,9,'App\\User','[]','2021-09-21 00:28:57','2021-09-21 00:28:57'),(609,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-21 13:42:32','2021-09-21 13:42:32'),(610,'default','added',571,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":250}}','2021-09-21 13:50:23','2021-09-21 13:50:23');
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `width` double(22,4) DEFAULT NULL,
  `height` double(22,4) DEFAULT NULL,
  `paper_width` double(22,4) DEFAULT NULL,
  `paper_height` double(22,4) DEFAULT NULL,
  `top_margin` double(22,4) DEFAULT NULL,
  `left_margin` double(22,4) DEFAULT NULL,
  `row_distance` double(22,4) DEFAULT NULL,
  `col_distance` double(22,4) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_continuous` tinyint(1) NOT NULL DEFAULT '0',
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `barcodes_business_id_foreign` (`business_id`) USING BTREE,
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'20 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 4\" x 1\", Labels per sheet: 20',4.0000,1.0000,8.5000,11.0000,0.5000,0.1250,0.0000,0.1875,2,0,0,20,NULL,'2017-12-18 06:13:44','2017-12-18 06:13:44'),(2,'30 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2.625\" x 1\", Labels per sheet: 30',2.6250,1.0000,8.5000,11.0000,0.5000,0.1880,0.0000,0.1250,3,0,0,30,NULL,'2017-12-18 06:04:39','2017-12-18 06:10:40'),(3,'32 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1.25\", Labels per sheet: 32',2.0000,1.2500,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,32,NULL,'2017-12-18 05:55:40','2017-12-18 05:55:40'),(4,'40 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1\", Labels per sheet: 40',2.0000,1.0000,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,40,NULL,'2017-12-18 05:58:40','2017-12-18 05:58:40'),(5,'50 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 1.5\" x 1\", Labels per sheet: 50',1.5000,1.0000,8.5000,11.0000,0.5000,0.5000,0.0000,0.0000,5,0,0,50,NULL,'2017-12-18 05:51:10','2017-12-18 05:51:10'),(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm, Gap: 3.18mm',1.2500,1.0000,1.2500,0.0000,0.1250,0.0000,0.1250,0.0000,1,0,1,NULL,NULL,'2017-12-18 05:51:10','2017-12-18 05:51:10'),(7,'مقاس فايير وود',NULL,2.0000,1.0000,2.1000,NULL,0.0000,0.0000,0.3000,0.0000,1,0,1,28,2,'2021-09-04 13:29:54','2021-09-04 13:29:54');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `booking_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `bookings_contact_id_foreign` (`contact_id`) USING BTREE,
  KEY `bookings_business_id_foreign` (`business_id`) USING BTREE,
  KEY `bookings_created_by_foreign` (`created_by`) USING BTREE,
  KEY `bookings_table_id_index` (`table_id`) USING BTREE,
  KEY `bookings_waiter_id_index` (`waiter_id`) USING BTREE,
  KEY `bookings_location_id_index` (`location_id`) USING BTREE,
  KEY `bookings_booking_status_index` (`booking_status`) USING BTREE,
  KEY `bookings_correspondent_id_index` (`correspondent_id`) USING BTREE,
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `brands_business_id_foreign` (`business_id`) USING BTREE,
  KEY `brands_created_by_foreign` (`created_by`) USING BTREE,
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_1` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number_2` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_2` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_label_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_label_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT '0.00',
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT '1',
  `accounting_method` enum('fifo','lifo','avco') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(5,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'includes',
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sku_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `expiry_type` enum('add_expiry','add_manufacturing') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT '1',
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT '1.000',
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT '30',
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT '30',
  `keyboard_shortcuts` text COLLATE utf8mb4_unicode_ci,
  `pos_settings` text COLLATE utf8mb4_unicode_ci,
  `weighing_scale_setting` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'used to store the configuration of weighing scale',
  `enable_brand` tinyint(1) NOT NULL DEFAULT '1',
  `enable_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT '1',
  `enable_purchase_status` tinyint(1) DEFAULT '1',
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT '0',
  `default_unit` int(11) DEFAULT NULL,
  `enable_sub_units` tinyint(1) NOT NULL DEFAULT '0',
  `enable_racks` tinyint(1) NOT NULL DEFAULT '0',
  `enable_row` tinyint(1) NOT NULL DEFAULT '0',
  `enable_position` tinyint(1) NOT NULL DEFAULT '0',
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT '1',
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT '1',
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT '1',
  `currency_symbol_placement` enum('before','after') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'before',
  `enabled_modules` text COLLATE utf8mb4_unicode_ci,
  `date_format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '24',
  `ref_no_prefixes` text COLLATE utf8mb4_unicode_ci,
  `theme_color` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `enable_rp` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `rp_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `amount_for_unit_rp` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `min_order_total_for_rp` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `max_rp_per_order` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `redeem_amount_per_unit_rp` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `min_order_total_for_redeem` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `min_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `max_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_period` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_type` enum('month','year') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'year' COMMENT 'rp is the short form of reward points',
  `email_settings` text COLLATE utf8mb4_unicode_ci,
  `sms_settings` text COLLATE utf8mb4_unicode_ci,
  `custom_labels` text COLLATE utf8mb4_unicode_ci,
  `common_settings` text COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `business_owner_id_foreign` (`owner_id`) USING BTREE,
  KEY `business_currency_id_foreign` (`currency_id`) USING BTREE,
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`) USING BTREE,
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'e Solutions Main',35,'2021-08-01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,1,'Africa/Cairo',1,'fifo',0.00,'includes',NULL,NULL,1,'add_manufacturing','stop_selling',90,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"cmmsn_calculation_type\":\"invoice_value\",\"amount_rounding_method\":null,\"enable_msp\":\"1\",\"cash_denominations\":null,\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}','{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,1,1,1,0,NULL,0,0,0,0,0,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\",\"account\",\"tables\",\"kitchen\"]','m/d/Y','24','{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}','black',NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":\"Test\",\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"default_credit_limit\":null,\"default_datatable_page_entries\":\"25\"}',1,'2021-08-31 05:43:53','2021-09-21 13:43:28'),(2,'Cargo',35,'2021-09-01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,2,'Africa/Cairo',1,'fifo',0.00,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"cmmsn_calculation_type\":\"invoice_value\",\"amount_rounding_method\":null,\"disable_pay_checkout\":\"1\",\"disable_draft\":\"1\",\"disable_discount\":\"1\",\"disable_suspend\":\"1\",\"cash_denominations\":\"10,20,50,100,200\",\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}','{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,0,1,1,0,2,0,0,0,0,1,'cmsn_agnt',1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\",\"account\"]','m/d/Y','24','{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}','black',1,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"default_credit_limit\":null,\"default_datatable_page_entries\":\"25\"}',1,'2021-09-01 12:23:39','2021-09-11 20:51:49');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landmark` text COLLATE utf8mb4_unicode_ci,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zip_code` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `sale_invoice_layout_id` int(11) DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT '1',
  `receipt_printer_type` enum('browser','printer') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `featured_products` text COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `default_payment_accounts` text COLLATE utf8mb4_unicode_ci,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `business_locations_business_id_index` (`business_id`) USING BTREE,
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`) USING BTREE,
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`) USING BTREE,
  KEY `business_locations_sale_invoice_layout_id_index` (`sale_invoice_layout_id`) USING BTREE,
  KEY `business_locations_selling_price_group_id_index` (`selling_price_group_id`) USING BTREE,
  KEY `business_locations_receipt_printer_type_index` (`receipt_printer_type`) USING BTREE,
  KEY `business_locations_printer_id_index` (`printer_id`) USING BTREE,
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,'BL0001','e Solutions Main','Maadi','Egypt','Cairo','Cairo','11331',1,1,1,NULL,1,'browser',NULL,'','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,'2021-08-31 05:43:53','2021-08-31 05:43:53'),(2,2,'BL0001','Mansoura Branch','Mansoura Branch','Egypt','Cairo','Cairo','11331',2,2,2,NULL,1,'browser',NULL,NULL,NULL,NULL,NULL,NULL,1,'{\"cash\":{\"is_enabled\":\"1\",\"account\":null},\"card\":{\"is_enabled\":\"1\",\"account\":null},\"cheque\":{\"is_enabled\":\"1\",\"account\":null},\"bank_transfer\":{\"is_enabled\":\"1\",\"account\":null},\"other\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_1\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_2\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_3\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_4\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_5\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_6\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_7\":{\"is_enabled\":\"1\",\"account\":null}}',NULL,NULL,NULL,NULL,NULL,'2021-09-01 12:23:39','2021-09-01 18:56:46'),(3,2,'BL0002','Domuiat Branch',NULL,'Egypt','Al Qahirah','Cairo','11331',2,2,2,1,1,'browser',NULL,NULL,NULL,NULL,NULL,NULL,1,'{\"cash\":{\"is_enabled\":\"1\",\"account\":null},\"card\":{\"is_enabled\":\"1\",\"account\":null},\"cheque\":{\"is_enabled\":\"1\",\"account\":null},\"bank_transfer\":{\"is_enabled\":\"1\",\"account\":null},\"other\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_1\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_2\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_3\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_4\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_5\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_6\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_7\":{\"is_enabled\":\"1\",\"account\":null}}',NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:18:22','2021-09-01 22:18:22');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `pay_method` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_type` enum('initial','sell','transfer','refund') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`) USING BTREE,
  KEY `cash_register_transactions_transaction_id_index` (`transaction_id`) USING BTREE,
  KEY `cash_register_transactions_type_index` (`type`) USING BTREE,
  KEY `cash_register_transactions_transaction_type_index` (`transaction_type`) USING BTREE,
  CONSTRAINT `cash_register_transactions_cash_register_id_foreign` FOREIGN KEY (`cash_register_id`) REFERENCES `cash_registers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=761 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
INSERT INTO `cash_register_transactions` VALUES (1,1,1.0000,'cash','credit','initial',NULL,'2021-09-01 18:57:22','2021-09-01 18:57:22'),(2,2,1.0000,'cash','credit','initial',NULL,'2021-09-01 21:25:19','2021-09-01 21:25:19'),(3,2,150.0000,'cash','credit','sell',34,'2021-09-01 21:28:23','2021-09-01 21:28:23'),(4,2,0.0000,'cash','credit','sell',34,'2021-09-01 21:28:23','2021-09-01 21:28:23'),(5,3,150.0000,'cash','credit','sell',75,'2021-09-01 22:39:51','2021-09-01 22:39:51'),(6,3,0.0000,'cash','credit','sell',75,'2021-09-01 22:39:51','2021-09-01 22:39:51'),(7,3,100.0000,'cash','credit','sell',154,'2021-09-02 10:52:41','2021-09-02 10:52:41'),(8,3,0.0000,'cash','credit','sell',154,'2021-09-02 10:52:41','2021-09-02 10:52:41'),(9,3,300.0000,'cash','credit','sell',155,'2021-09-02 12:00:13','2021-09-02 12:00:13'),(10,3,0.0000,'cash','credit','sell',155,'2021-09-02 12:00:13','2021-09-02 12:00:13'),(11,3,50.0000,'cash','credit','sell',156,'2021-09-02 12:01:36','2021-09-02 12:01:36'),(12,3,0.0000,'cash','credit','sell',156,'2021-09-02 12:01:36','2021-09-02 12:01:36'),(13,3,50.0000,'cash','credit','sell',157,'2021-09-02 12:03:32','2021-09-02 12:03:32'),(14,3,0.0000,'cash','credit','sell',157,'2021-09-02 12:03:32','2021-09-02 12:03:32'),(15,3,100.0000,'cash','credit','sell',158,'2021-09-02 12:12:24','2021-09-02 12:12:24'),(16,3,0.0000,'cash','credit','sell',158,'2021-09-02 12:12:24','2021-09-02 12:12:24'),(17,3,200.0000,'cash','credit','sell',159,'2021-09-02 12:14:02','2021-09-02 12:14:02'),(18,3,0.0000,'cash','credit','sell',159,'2021-09-02 12:14:02','2021-09-02 12:14:02'),(19,3,275.0000,'cash','credit','sell',160,'2021-09-02 12:36:31','2021-09-02 12:36:31'),(20,3,0.0000,'cash','credit','sell',160,'2021-09-02 12:36:31','2021-09-02 12:36:31'),(21,3,200.0000,'cash','credit','sell',161,'2021-09-02 12:55:55','2021-09-02 12:55:55'),(22,3,0.0000,'cash','credit','sell',161,'2021-09-02 12:55:55','2021-09-02 12:55:55'),(23,3,100.0000,'cash','credit','sell',163,'2021-09-02 13:16:58','2021-09-02 13:16:58'),(24,3,0.0000,'cash','credit','sell',163,'2021-09-02 13:16:58','2021-09-02 13:16:58'),(25,3,250.0000,'cash','credit','sell',164,'2021-09-02 13:35:19','2021-09-02 13:35:19'),(26,3,0.0000,'cash','credit','sell',164,'2021-09-02 13:35:19','2021-09-02 13:35:19'),(27,3,200.0000,'cash','credit','sell',165,'2021-09-02 13:50:58','2021-09-02 13:50:58'),(28,3,0.0000,'cash','credit','sell',165,'2021-09-02 13:50:58','2021-09-02 13:50:58'),(29,3,450.0000,'cash','credit','sell',166,'2021-09-02 14:13:54','2021-09-02 14:13:54'),(30,3,0.0000,'cash','credit','sell',166,'2021-09-02 14:13:54','2021-09-02 14:13:54'),(31,3,100.0000,'cash','credit','sell',167,'2021-09-02 14:28:43','2021-09-02 14:28:43'),(32,3,0.0000,'cash','credit','sell',167,'2021-09-02 14:28:43','2021-09-02 14:28:43'),(33,3,150.0000,'cash','credit','sell',168,'2021-09-02 14:36:23','2021-09-02 14:36:23'),(34,3,0.0000,'cash','credit','sell',168,'2021-09-02 14:36:23','2021-09-02 14:36:23'),(35,3,200.0000,'cash','credit','sell',169,'2021-09-02 14:51:25','2021-09-02 14:51:25'),(36,3,0.0000,'cash','credit','sell',169,'2021-09-02 14:51:25','2021-09-02 14:51:25'),(37,3,100.0000,'cash','credit','sell',170,'2021-09-02 14:53:16','2021-09-02 14:53:16'),(38,3,0.0000,'cash','credit','sell',170,'2021-09-02 14:53:16','2021-09-02 14:53:16'),(39,3,150.0000,'cash','credit','sell',171,'2021-09-02 15:02:22','2021-09-02 15:02:22'),(40,3,0.0000,'cash','credit','sell',171,'2021-09-02 15:02:22','2021-09-02 15:02:22'),(41,3,150.0000,'cash','credit','sell',172,'2021-09-02 15:03:39','2021-09-02 15:03:39'),(42,3,0.0000,'cash','credit','sell',172,'2021-09-02 15:03:39','2021-09-02 15:03:39'),(43,4,50.0000,'cash','credit','sell',173,'2021-09-02 15:18:26','2021-09-02 15:18:26'),(44,4,0.0000,'cash','credit','sell',173,'2021-09-02 15:18:26','2021-09-02 15:18:26'),(45,3,100.0000,'cash','credit','sell',174,'2021-09-02 15:19:53','2021-09-02 15:19:53'),(46,3,0.0000,'cash','credit','sell',174,'2021-09-02 15:19:53','2021-09-02 15:19:53'),(47,4,100.0000,'cash','credit','sell',176,'2021-09-02 15:22:43','2021-09-02 15:22:43'),(48,4,0.0000,'cash','credit','sell',176,'2021-09-02 15:22:43','2021-09-02 15:22:43'),(49,4,425.0000,'cash','credit','sell',177,'2021-09-02 15:37:04','2021-09-02 15:37:04'),(50,4,0.0000,'cash','credit','sell',177,'2021-09-02 15:37:04','2021-09-02 15:37:04'),(51,4,75.0000,'cash','credit','sell',178,'2021-09-02 15:38:35','2021-09-02 15:38:35'),(52,4,0.0000,'cash','credit','sell',178,'2021-09-02 15:38:35','2021-09-02 15:38:35'),(53,4,200.0000,'cash','credit','sell',179,'2021-09-02 16:08:05','2021-09-02 16:08:05'),(54,4,0.0000,'cash','credit','sell',179,'2021-09-02 16:08:05','2021-09-02 16:08:05'),(55,3,100.0000,'cash','credit','sell',180,'2021-09-02 16:14:38','2021-09-02 16:14:38'),(56,3,0.0000,'cash','credit','sell',180,'2021-09-02 16:14:38','2021-09-02 16:14:38'),(57,3,50.0000,'cash','credit','sell',181,'2021-09-02 16:15:51','2021-09-02 16:15:51'),(58,3,0.0000,'cash','credit','sell',181,'2021-09-02 16:15:51','2021-09-02 16:15:51'),(59,3,700.0000,'cash','credit','sell',182,'2021-09-02 16:28:07','2021-09-02 16:28:07'),(60,3,0.0000,'cash','credit','sell',182,'2021-09-02 16:28:07','2021-09-02 16:28:07'),(61,3,75.0000,'cash','credit','sell',183,'2021-09-02 16:35:41','2021-09-02 16:35:41'),(62,3,0.0000,'cash','credit','sell',183,'2021-09-02 16:35:41','2021-09-02 16:35:41'),(63,3,500.0000,'cash','credit','sell',184,'2021-09-02 16:38:49','2021-09-02 16:38:49'),(64,3,0.0000,'cash','credit','sell',184,'2021-09-02 16:38:49','2021-09-02 16:38:49'),(65,4,425.0000,'cash','credit','sell',185,'2021-09-02 16:44:50','2021-09-02 16:44:50'),(66,4,0.0000,'cash','credit','sell',185,'2021-09-02 16:44:50','2021-09-02 16:44:50'),(67,4,150.0000,'cash','credit','sell',186,'2021-09-02 16:45:39','2021-09-02 16:45:39'),(68,4,0.0000,'cash','credit','sell',186,'2021-09-02 16:45:39','2021-09-02 16:45:39'),(69,3,550.0000,'cash','credit','sell',187,'2021-09-02 16:46:22','2021-09-02 16:46:22'),(70,3,0.0000,'cash','credit','sell',187,'2021-09-02 16:46:22','2021-09-02 16:46:22'),(71,4,550.0000,'cash','credit','sell',188,'2021-09-02 16:51:52','2021-09-02 16:51:52'),(72,4,0.0000,'cash','credit','sell',188,'2021-09-02 16:51:52','2021-09-02 16:51:52'),(73,3,150.0000,'cash','credit','sell',190,'2021-09-02 17:12:54','2021-09-02 17:12:54'),(74,3,0.0000,'cash','credit','sell',190,'2021-09-02 17:12:54','2021-09-02 17:12:54'),(75,4,200.0000,'cash','credit','sell',191,'2021-09-02 17:15:12','2021-09-02 17:15:12'),(76,4,0.0000,'cash','credit','sell',191,'2021-09-02 17:15:12','2021-09-02 17:15:12'),(77,3,100.0000,'cash','credit','sell',192,'2021-09-02 17:16:19','2021-09-02 17:16:19'),(78,3,0.0000,'cash','credit','sell',192,'2021-09-02 17:16:19','2021-09-02 17:16:19'),(79,3,50.0000,'cash','credit','sell',193,'2021-09-02 17:19:58','2021-09-02 17:19:58'),(80,3,0.0000,'cash','credit','sell',193,'2021-09-02 17:19:58','2021-09-02 17:19:58'),(81,3,450.0000,'cash','credit','sell',194,'2021-09-02 17:27:23','2021-09-02 17:27:23'),(82,3,0.0000,'cash','credit','sell',194,'2021-09-02 17:27:23','2021-09-02 17:27:23'),(83,3,100.0000,'cash','credit','sell',195,'2021-09-02 17:37:56','2021-09-02 17:37:56'),(84,3,0.0000,'cash','credit','sell',195,'2021-09-02 17:37:56','2021-09-02 17:37:56'),(85,4,100.0000,'cash','credit','sell',197,'2021-09-02 18:08:47','2021-09-02 18:08:47'),(86,4,0.0000,'cash','credit','sell',197,'2021-09-02 18:08:47','2021-09-02 18:08:47'),(87,3,200.0000,'cash','credit','sell',198,'2021-09-02 18:09:37','2021-09-02 18:09:37'),(88,3,0.0000,'cash','credit','sell',198,'2021-09-02 18:09:37','2021-09-02 18:09:37'),(89,3,250.0000,'cash','credit','sell',199,'2021-09-02 18:15:43','2021-09-02 18:15:43'),(90,3,0.0000,'cash','credit','sell',199,'2021-09-02 18:15:43','2021-09-02 18:15:43'),(91,4,150.0000,'cash','credit','sell',200,'2021-09-02 18:18:14','2021-09-02 18:18:14'),(92,4,0.0000,'cash','credit','sell',200,'2021-09-02 18:18:14','2021-09-02 18:18:14'),(93,3,200.0000,'cash','credit','sell',201,'2021-09-02 18:20:15','2021-09-02 18:20:15'),(94,3,0.0000,'cash','credit','sell',201,'2021-09-02 18:20:15','2021-09-02 18:20:15'),(95,4,150.0000,'cash','credit','sell',202,'2021-09-02 18:22:15','2021-09-02 18:22:15'),(96,4,0.0000,'cash','credit','sell',202,'2021-09-02 18:22:15','2021-09-02 18:22:15'),(97,4,150.0000,'cash','credit','sell',203,'2021-09-02 18:26:11','2021-09-02 18:26:11'),(98,4,0.0000,'cash','credit','sell',203,'2021-09-02 18:26:11','2021-09-02 18:26:11'),(99,3,195.0000,'cash','credit','sell',204,'2021-09-02 18:34:25','2021-09-02 18:34:25'),(100,3,0.0000,'cash','credit','sell',204,'2021-09-02 18:34:25','2021-09-02 18:34:25'),(101,4,250.0000,'cash','credit','sell',205,'2021-09-02 18:36:25','2021-09-02 18:36:25'),(102,4,0.0000,'cash','credit','sell',205,'2021-09-02 18:36:25','2021-09-02 18:36:25'),(103,3,375.0000,'cash','credit','sell',206,'2021-09-02 18:38:17','2021-09-02 18:38:17'),(104,3,0.0000,'cash','credit','sell',206,'2021-09-02 18:38:17','2021-09-02 18:38:17'),(105,4,150.0000,'cash','credit','sell',207,'2021-09-02 18:43:58','2021-09-02 18:43:58'),(106,4,0.0000,'cash','credit','sell',207,'2021-09-02 18:43:58','2021-09-02 18:43:58'),(107,3,375.0000,'cash','credit','sell',208,'2021-09-02 18:45:18','2021-09-02 18:45:18'),(108,3,0.0000,'cash','credit','sell',208,'2021-09-02 18:45:18','2021-09-02 18:45:18'),(109,3,100.0000,'cash','credit','sell',209,'2021-09-02 18:47:17','2021-09-02 18:47:17'),(110,3,0.0000,'cash','credit','sell',209,'2021-09-02 18:47:17','2021-09-02 18:47:17'),(111,3,250.0000,'cash','credit','sell',210,'2021-09-02 18:49:46','2021-09-02 18:49:46'),(112,3,0.0000,'cash','credit','sell',210,'2021-09-02 18:49:46','2021-09-02 18:49:46'),(113,4,100.0000,'cash','credit','sell',211,'2021-09-02 18:51:48','2021-09-02 18:51:48'),(114,4,0.0000,'cash','credit','sell',211,'2021-09-02 18:51:48','2021-09-02 18:51:48'),(115,3,75.0000,'cash','credit','sell',212,'2021-09-02 18:53:30','2021-09-02 18:53:30'),(116,3,0.0000,'cash','credit','sell',212,'2021-09-02 18:53:30','2021-09-02 18:53:30'),(117,3,345.0000,'cash','credit','sell',213,'2021-09-02 18:54:49','2021-09-02 18:54:49'),(118,3,0.0000,'cash','credit','sell',213,'2021-09-02 18:54:49','2021-09-02 18:54:49'),(119,4,100.0000,'cash','credit','sell',214,'2021-09-02 18:55:24','2021-09-02 18:55:24'),(120,4,0.0000,'cash','credit','sell',214,'2021-09-02 18:55:24','2021-09-02 18:55:24'),(121,3,150.0000,'cash','credit','sell',215,'2021-09-02 18:55:49','2021-09-02 18:55:49'),(122,3,0.0000,'cash','credit','sell',215,'2021-09-02 18:55:49','2021-09-02 18:55:49'),(123,4,50.0000,'cash','credit','sell',216,'2021-09-02 18:58:52','2021-09-02 18:58:52'),(124,4,0.0000,'cash','credit','sell',216,'2021-09-02 18:58:52','2021-09-02 18:58:52'),(125,3,100.0000,'cash','credit','sell',217,'2021-09-02 19:13:58','2021-09-02 19:13:58'),(126,3,0.0000,'cash','credit','sell',217,'2021-09-02 19:13:58','2021-09-02 19:13:58'),(127,3,150.0000,'cash','credit','sell',218,'2021-09-02 19:15:20','2021-09-02 19:15:20'),(128,3,0.0000,'cash','credit','sell',218,'2021-09-02 19:15:20','2021-09-02 19:15:20'),(129,3,150.0000,'cash','credit','sell',219,'2021-09-02 19:16:30','2021-09-02 19:16:30'),(130,3,0.0000,'cash','credit','sell',219,'2021-09-02 19:16:30','2021-09-02 19:16:30'),(131,3,500.0000,'cash','credit','sell',220,'2021-09-02 19:24:44','2021-09-02 19:24:44'),(132,3,0.0000,'cash','credit','sell',220,'2021-09-02 19:24:44','2021-09-02 19:24:44'),(133,4,575.0000,'cash','credit','sell',221,'2021-09-02 19:25:49','2021-09-02 19:25:49'),(134,4,0.0000,'cash','credit','sell',221,'2021-09-02 19:25:49','2021-09-02 19:25:49'),(135,4,100.0000,'cash','credit','sell',222,'2021-09-02 19:26:25','2021-09-02 19:26:25'),(136,4,0.0000,'cash','credit','sell',222,'2021-09-02 19:26:25','2021-09-02 19:26:25'),(137,3,200.0000,'cash','credit','sell',223,'2021-09-02 19:29:41','2021-09-02 19:29:41'),(138,3,0.0000,'cash','credit','sell',223,'2021-09-02 19:29:41','2021-09-02 19:29:41'),(139,4,225.0000,'cash','credit','sell',224,'2021-09-02 19:34:46','2021-09-02 19:34:46'),(140,4,0.0000,'cash','credit','sell',224,'2021-09-02 19:34:46','2021-09-02 19:34:46'),(141,4,270.0000,'cash','credit','sell',225,'2021-09-02 19:35:25','2021-09-02 19:35:25'),(142,4,0.0000,'cash','credit','sell',225,'2021-09-02 19:35:25','2021-09-02 19:35:25'),(143,4,150.0000,'cash','credit','sell',226,'2021-09-02 19:36:44','2021-09-02 19:36:44'),(144,4,0.0000,'cash','credit','sell',226,'2021-09-02 19:36:44','2021-09-02 19:36:44'),(145,4,100.0000,'cash','credit','sell',227,'2021-09-02 19:43:08','2021-09-02 19:43:08'),(146,4,0.0000,'cash','credit','sell',227,'2021-09-02 19:43:08','2021-09-02 19:43:08'),(147,4,100.0000,'cash','credit','sell',228,'2021-09-02 19:51:22','2021-09-02 19:51:22'),(148,4,0.0000,'cash','credit','sell',228,'2021-09-02 19:51:22','2021-09-02 19:51:22'),(149,4,100.0000,'cash','credit','sell',229,'2021-09-02 19:55:11','2021-09-02 19:55:11'),(150,4,0.0000,'cash','credit','sell',229,'2021-09-02 19:55:11','2021-09-02 19:55:11'),(151,4,300.0000,'cash','credit','sell',230,'2021-09-02 19:55:49','2021-09-02 19:55:49'),(152,4,0.0000,'cash','credit','sell',230,'2021-09-02 19:55:49','2021-09-02 19:55:49'),(153,3,100.0000,'cash','credit','sell',231,'2021-09-02 20:01:55','2021-09-02 20:01:55'),(154,3,0.0000,'cash','credit','sell',231,'2021-09-02 20:01:55','2021-09-02 20:01:55'),(155,3,100.0000,'cash','credit','sell',232,'2021-09-02 20:04:06','2021-09-02 20:04:06'),(156,3,0.0000,'cash','credit','sell',232,'2021-09-02 20:04:06','2021-09-02 20:04:06'),(157,4,100.0000,'cash','credit','sell',233,'2021-09-02 20:09:32','2021-09-02 20:09:32'),(158,4,0.0000,'cash','credit','sell',233,'2021-09-02 20:09:32','2021-09-02 20:09:32'),(159,4,100.0000,'cash','credit','sell',234,'2021-09-02 20:10:49','2021-09-02 20:10:49'),(160,4,0.0000,'cash','credit','sell',234,'2021-09-02 20:10:49','2021-09-02 20:10:49'),(161,3,150.0000,'cash','credit','sell',235,'2021-09-02 20:12:40','2021-09-02 20:12:40'),(162,3,0.0000,'cash','credit','sell',235,'2021-09-02 20:12:40','2021-09-02 20:12:40'),(163,4,345.0000,'cash','credit','sell',236,'2021-09-02 20:20:03','2021-09-02 20:20:03'),(164,4,0.0000,'cash','credit','sell',236,'2021-09-02 20:20:03','2021-09-02 20:20:03'),(165,3,100.0000,'cash','credit','sell',237,'2021-09-02 20:24:26','2021-09-02 20:24:26'),(166,3,0.0000,'cash','credit','sell',237,'2021-09-02 20:24:26','2021-09-02 20:24:26'),(167,3,175.0000,'cash','credit','sell',238,'2021-09-02 20:31:12','2021-09-02 20:31:12'),(168,3,0.0000,'cash','credit','sell',238,'2021-09-02 20:31:12','2021-09-02 20:31:12'),(169,3,50.0000,'cash','credit','sell',239,'2021-09-02 20:48:57','2021-09-02 20:48:57'),(170,3,0.0000,'cash','credit','sell',239,'2021-09-02 20:48:57','2021-09-02 20:48:57'),(171,3,900.0000,'cash','credit','sell',240,'2021-09-02 20:58:21','2021-09-02 20:58:21'),(172,3,0.0000,'cash','credit','sell',240,'2021-09-02 20:58:21','2021-09-02 20:58:21'),(173,3,75.0000,'cash','credit','sell',241,'2021-09-02 21:01:59','2021-09-02 21:01:59'),(174,3,0.0000,'cash','credit','sell',241,'2021-09-02 21:01:59','2021-09-02 21:01:59'),(175,3,100.0000,'cash','credit','sell',242,'2021-09-02 21:05:34','2021-09-02 21:05:34'),(176,3,0.0000,'cash','credit','sell',242,'2021-09-02 21:05:34','2021-09-02 21:05:34'),(177,4,200.0000,'cash','credit','sell',243,'2021-09-02 21:07:56','2021-09-02 21:07:56'),(178,4,0.0000,'cash','credit','sell',243,'2021-09-02 21:07:56','2021-09-02 21:07:56'),(179,3,100.0000,'cash','credit','sell',244,'2021-09-02 21:10:54','2021-09-02 21:10:54'),(180,3,0.0000,'cash','credit','sell',244,'2021-09-02 21:10:54','2021-09-02 21:10:54'),(181,3,300.0000,'cash','credit','sell',245,'2021-09-02 21:26:09','2021-09-02 21:26:09'),(182,3,0.0000,'cash','credit','sell',245,'2021-09-02 21:26:09','2021-09-02 21:26:09'),(183,3,75.0000,'cash','credit','sell',246,'2021-09-02 21:34:31','2021-09-02 21:34:31'),(184,3,0.0000,'cash','credit','sell',246,'2021-09-02 21:34:31','2021-09-02 21:34:31'),(185,4,825.0000,'cash','credit','sell',247,'2021-09-02 21:39:06','2021-09-02 21:39:06'),(186,4,0.0000,'cash','credit','sell',247,'2021-09-02 21:39:06','2021-09-02 21:39:06'),(187,3,200.0000,'cash','credit','sell',248,'2021-09-02 21:40:37','2021-09-02 21:40:37'),(188,3,0.0000,'cash','credit','sell',248,'2021-09-02 21:40:37','2021-09-02 21:40:37'),(189,3,100.0000,'cash','credit','sell',249,'2021-09-02 21:46:42','2021-09-02 21:46:42'),(190,3,0.0000,'cash','credit','sell',249,'2021-09-02 21:46:42','2021-09-02 21:46:42'),(191,3,100.0000,'cash','credit','sell',250,'2021-09-02 21:48:55','2021-09-02 21:48:55'),(192,3,0.0000,'cash','credit','sell',250,'2021-09-02 21:48:55','2021-09-02 21:48:55'),(193,3,300.0000,'cash','credit','sell',251,'2021-09-02 21:51:03','2021-09-02 21:51:03'),(194,3,0.0000,'cash','credit','sell',251,'2021-09-02 21:51:03','2021-09-02 21:51:03'),(195,3,250.0000,'cash','credit','sell',252,'2021-09-02 22:00:23','2021-09-02 22:00:23'),(196,3,0.0000,'cash','credit','sell',252,'2021-09-02 22:00:23','2021-09-02 22:00:23'),(197,4,300.0000,'cash','credit','sell',253,'2021-09-02 22:12:31','2021-09-02 22:12:31'),(198,4,0.0000,'cash','credit','sell',253,'2021-09-02 22:12:31','2021-09-02 22:12:31'),(199,3,500.0000,'cash','credit','sell',254,'2021-09-02 22:19:22','2021-09-02 22:19:22'),(200,3,0.0000,'cash','credit','sell',254,'2021-09-02 22:19:22','2021-09-02 22:19:22'),(201,4,50.0000,'cash','credit','sell',255,'2021-09-02 22:29:42','2021-09-02 22:29:42'),(202,4,0.0000,'cash','credit','sell',255,'2021-09-02 22:29:42','2021-09-02 22:29:42'),(203,3,175.0000,'cash','credit','sell',256,'2021-09-02 22:31:18','2021-09-02 22:31:18'),(204,3,0.0000,'cash','credit','sell',256,'2021-09-02 22:31:18','2021-09-02 22:31:18'),(205,4,75.0000,'cash','credit','sell',257,'2021-09-02 22:38:12','2021-09-02 22:38:12'),(206,4,0.0000,'cash','credit','sell',257,'2021-09-02 22:38:12','2021-09-02 22:38:12'),(207,3,75.0000,'cash','credit','sell',258,'2021-09-02 22:40:38','2021-09-02 22:40:38'),(208,3,0.0000,'cash','credit','sell',258,'2021-09-02 22:40:38','2021-09-02 22:40:38'),(209,4,100.0000,'cash','credit','sell',259,'2021-09-02 22:43:11','2021-09-02 22:43:11'),(210,4,0.0000,'cash','credit','sell',259,'2021-09-02 22:43:11','2021-09-02 22:43:11'),(211,3,150.0000,'cash','credit','sell',260,'2021-09-02 22:54:37','2021-09-02 22:54:37'),(212,3,0.0000,'cash','credit','sell',260,'2021-09-02 22:54:37','2021-09-02 22:54:37'),(213,3,100.0000,'cash','credit','sell',261,'2021-09-02 22:55:56','2021-09-02 22:55:56'),(214,3,0.0000,'cash','credit','sell',261,'2021-09-02 22:55:56','2021-09-02 22:55:56'),(215,3,100.0000,'cash','credit','sell',262,'2021-09-02 22:56:41','2021-09-02 22:56:41'),(216,3,0.0000,'cash','credit','sell',262,'2021-09-02 22:56:41','2021-09-02 22:56:41'),(217,3,175.0000,'cash','credit','sell',263,'2021-09-02 22:58:58','2021-09-02 22:58:58'),(218,3,0.0000,'cash','credit','sell',263,'2021-09-02 22:58:58','2021-09-02 22:58:58'),(219,3,150.0000,'cash','credit','sell',264,'2021-09-02 23:02:02','2021-09-02 23:02:02'),(220,3,0.0000,'cash','credit','sell',264,'2021-09-02 23:02:02','2021-09-02 23:02:02'),(221,3,50.0000,'cash','credit','sell',265,'2021-09-02 23:05:40','2021-09-02 23:05:40'),(222,3,0.0000,'cash','credit','sell',265,'2021-09-02 23:05:40','2021-09-02 23:05:40'),(223,3,200.0000,'cash','credit','sell',266,'2021-09-02 23:07:52','2021-09-02 23:07:52'),(224,3,0.0000,'cash','credit','sell',266,'2021-09-02 23:07:52','2021-09-02 23:07:52'),(225,4,325.0000,'cash','credit','sell',267,'2021-09-02 23:08:24','2021-09-02 23:08:24'),(226,4,0.0000,'cash','credit','sell',267,'2021-09-02 23:08:24','2021-09-02 23:08:24'),(227,4,100.0000,'cash','credit','sell',268,'2021-09-02 23:08:53','2021-09-02 23:08:53'),(228,4,0.0000,'cash','credit','sell',268,'2021-09-02 23:08:53','2021-09-02 23:08:53'),(229,3,100.0000,'cash','credit','sell',269,'2021-09-02 23:15:47','2021-09-02 23:15:47'),(230,3,0.0000,'cash','credit','sell',269,'2021-09-02 23:15:47','2021-09-02 23:15:47'),(231,4,100.0000,'cash','credit','sell',271,'2021-09-02 23:18:34','2021-09-02 23:18:34'),(232,4,0.0000,'cash','credit','sell',271,'2021-09-02 23:18:34','2021-09-02 23:18:34'),(233,3,100.0000,'cash','credit','sell',272,'2021-09-02 23:20:16','2021-09-02 23:20:16'),(234,3,0.0000,'cash','credit','sell',272,'2021-09-02 23:20:16','2021-09-02 23:20:16'),(235,3,150.0000,'cash','credit','sell',273,'2021-09-02 23:25:53','2021-09-02 23:25:53'),(236,3,0.0000,'cash','credit','sell',273,'2021-09-02 23:25:53','2021-09-02 23:25:53'),(237,4,200.0000,'cash','credit','sell',275,'2021-09-02 23:36:46','2021-09-02 23:36:46'),(238,4,0.0000,'cash','credit','sell',275,'2021-09-02 23:36:46','2021-09-02 23:36:46'),(239,3,50.0000,'cash','credit','sell',277,'2021-09-03 13:14:10','2021-09-03 13:14:10'),(240,3,0.0000,'cash','credit','sell',277,'2021-09-03 13:14:10','2021-09-03 13:14:10'),(241,3,700.0000,'cash','credit','sell',278,'2021-09-03 14:53:27','2021-09-03 14:53:27'),(242,3,0.0000,'cash','credit','sell',278,'2021-09-03 14:53:27','2021-09-03 14:53:27'),(243,3,50.0000,'cash','credit','sell',279,'2021-09-03 15:00:48','2021-09-03 15:00:48'),(244,3,0.0000,'cash','credit','sell',279,'2021-09-03 15:00:48','2021-09-03 15:00:48'),(245,3,75.0000,'cash','credit','sell',280,'2021-09-03 15:09:02','2021-09-03 15:09:02'),(246,3,0.0000,'cash','credit','sell',280,'2021-09-03 15:09:02','2021-09-03 15:09:02'),(247,3,175.0000,'cash','credit','sell',281,'2021-09-03 15:16:35','2021-09-03 15:16:35'),(248,3,0.0000,'cash','credit','sell',281,'2021-09-03 15:16:35','2021-09-03 15:16:35'),(249,5,8015.0000,'cash','credit','initial',NULL,'2021-09-03 15:44:17','2021-09-03 15:44:17'),(250,5,1150.0000,'cash','credit','sell',282,'2021-09-03 16:00:14','2021-09-03 16:00:14'),(251,5,0.0000,'cash','credit','sell',282,'2021-09-03 16:00:14','2021-09-03 16:00:14'),(252,5,870.0000,'cash','credit','sell',283,'2021-09-03 16:03:34','2021-09-03 16:03:34'),(253,5,0.0000,'cash','credit','sell',283,'2021-09-03 16:03:34','2021-09-03 16:03:34'),(254,3,50.0000,'cash','credit','sell',284,'2021-09-03 16:19:33','2021-09-03 16:19:33'),(255,3,0.0000,'cash','credit','sell',284,'2021-09-03 16:19:33','2021-09-03 16:19:33'),(256,5,225.0000,'cash','credit','sell',285,'2021-09-03 16:21:48','2021-09-03 16:21:48'),(257,5,0.0000,'cash','credit','sell',285,'2021-09-03 16:21:48','2021-09-03 16:21:48'),(258,5,100.0000,'cash','credit','sell',287,'2021-09-03 17:17:39','2021-09-03 17:17:39'),(259,5,0.0000,'cash','credit','sell',287,'2021-09-03 17:17:39','2021-09-03 17:17:39'),(260,3,100.0000,'cash','credit','sell',288,'2021-09-03 17:30:31','2021-09-03 17:30:31'),(261,3,0.0000,'cash','credit','sell',288,'2021-09-03 17:30:31','2021-09-03 17:30:31'),(262,3,250.0000,'cash','credit','sell',289,'2021-09-03 17:40:37','2021-09-03 17:40:37'),(263,3,0.0000,'cash','credit','sell',289,'2021-09-03 17:40:37','2021-09-03 17:40:37'),(264,5,200.0000,'cash','credit','sell',290,'2021-09-03 17:42:31','2021-09-03 17:42:31'),(265,5,0.0000,'cash','credit','sell',290,'2021-09-03 17:42:31','2021-09-03 17:42:31'),(266,5,100.0000,'cash','credit','sell',291,'2021-09-03 17:45:46','2021-09-03 17:45:46'),(267,5,0.0000,'cash','credit','sell',291,'2021-09-03 17:45:46','2021-09-03 17:45:46'),(268,3,200.0000,'cash','credit','sell',292,'2021-09-03 17:48:03','2021-09-03 17:48:03'),(269,3,0.0000,'cash','credit','sell',292,'2021-09-03 17:48:03','2021-09-03 17:48:03'),(270,5,75.0000,'cash','credit','sell',294,'2021-09-03 18:39:20','2021-09-03 18:39:20'),(271,5,0.0000,'cash','credit','sell',294,'2021-09-03 18:39:20','2021-09-03 18:39:20'),(272,3,250.0000,'cash','credit','sell',295,'2021-09-03 18:39:33','2021-09-03 18:39:33'),(273,3,0.0000,'cash','credit','sell',295,'2021-09-03 18:39:33','2021-09-03 18:39:33'),(274,3,100.0000,'cash','credit','sell',296,'2021-09-03 18:58:05','2021-09-03 18:58:05'),(275,3,0.0000,'cash','credit','sell',296,'2021-09-03 18:58:05','2021-09-03 18:58:05'),(276,3,100.0000,'cash','credit','sell',297,'2021-09-03 19:01:30','2021-09-03 19:01:30'),(277,3,0.0000,'cash','credit','sell',297,'2021-09-03 19:01:30','2021-09-03 19:01:30'),(278,5,100.0000,'cash','credit','sell',298,'2021-09-03 19:04:07','2021-09-03 19:04:07'),(279,5,0.0000,'cash','credit','sell',298,'2021-09-03 19:04:07','2021-09-03 19:04:07'),(280,3,525.0000,'cash','credit','sell',299,'2021-09-03 19:27:30','2021-09-03 19:27:30'),(281,3,0.0000,'cash','credit','sell',299,'2021-09-03 19:27:30','2021-09-03 19:27:30'),(282,5,100.0000,'cash','credit','sell',300,'2021-09-03 19:43:03','2021-09-03 19:43:03'),(283,5,0.0000,'cash','credit','sell',300,'2021-09-03 19:43:03','2021-09-03 19:43:03'),(284,5,195.0000,'cash','credit','sell',301,'2021-09-03 19:45:10','2021-09-03 19:45:10'),(285,5,0.0000,'cash','credit','sell',301,'2021-09-03 19:45:10','2021-09-03 19:45:10'),(286,5,150.0000,'cash','credit','sell',303,'2021-09-03 20:04:39','2021-09-03 20:04:39'),(287,5,0.0000,'cash','credit','sell',303,'2021-09-03 20:04:39','2021-09-03 20:04:39'),(288,3,150.0000,'cash','credit','sell',304,'2021-09-03 20:06:55','2021-09-03 20:06:55'),(289,3,0.0000,'cash','credit','sell',304,'2021-09-03 20:06:55','2021-09-03 20:06:55'),(290,5,0.0000,'cash','credit','sell',305,'2021-09-03 20:10:57','2021-09-03 20:10:57'),(291,5,0.0000,'cash','credit','sell',305,'2021-09-03 20:10:57','2021-09-03 20:10:57'),(292,5,50.0000,'cash','credit','sell',306,'2021-09-03 20:12:06','2021-09-03 20:12:06'),(293,5,0.0000,'cash','credit','sell',306,'2021-09-03 20:12:06','2021-09-03 20:12:06'),(294,5,100.0000,'cash','credit','sell',307,'2021-09-03 20:20:44','2021-09-03 20:20:44'),(295,5,0.0000,'cash','credit','sell',307,'2021-09-03 20:20:44','2021-09-03 20:20:44'),(296,5,200.0000,'cash','credit','sell',308,'2021-09-03 20:23:18','2021-09-03 20:23:18'),(297,5,0.0000,'cash','credit','sell',308,'2021-09-03 20:23:18','2021-09-03 20:23:18'),(298,3,150.0000,'cash','credit','sell',309,'2021-09-03 20:24:03','2021-09-03 20:24:03'),(299,3,0.0000,'cash','credit','sell',309,'2021-09-03 20:24:03','2021-09-03 20:24:03'),(300,3,300.0000,'cash','credit','sell',310,'2021-09-03 20:32:21','2021-09-03 20:32:21'),(301,3,0.0000,'cash','credit','sell',310,'2021-09-03 20:32:21','2021-09-03 20:32:21'),(302,5,150.0000,'cash','credit','sell',311,'2021-09-03 20:36:21','2021-09-03 20:36:21'),(303,5,0.0000,'cash','credit','sell',311,'2021-09-03 20:36:21','2021-09-03 20:36:21'),(304,3,225.0000,'cash','credit','sell',312,'2021-09-03 20:37:02','2021-09-03 20:37:02'),(305,3,0.0000,'cash','credit','sell',312,'2021-09-03 20:37:02','2021-09-03 20:37:02'),(306,5,100.0000,'cash','credit','sell',313,'2021-09-03 20:37:47','2021-09-03 20:37:47'),(307,5,0.0000,'cash','credit','sell',313,'2021-09-03 20:37:47','2021-09-03 20:37:47'),(308,5,100.0000,'cash','credit','sell',314,'2021-09-03 20:41:28','2021-09-03 20:41:28'),(309,5,0.0000,'cash','credit','sell',314,'2021-09-03 20:41:28','2021-09-03 20:41:28'),(310,3,150.0000,'cash','credit','sell',315,'2021-09-03 20:52:48','2021-09-03 20:52:48'),(311,3,0.0000,'cash','credit','sell',315,'2021-09-03 20:52:48','2021-09-03 20:52:48'),(312,5,100.0000,'cash','credit','sell',316,'2021-09-03 21:07:12','2021-09-03 21:07:12'),(313,5,0.0000,'cash','credit','sell',316,'2021-09-03 21:07:12','2021-09-03 21:07:12'),(314,3,100.0000,'cash','credit','sell',317,'2021-09-03 21:14:18','2021-09-03 21:14:18'),(315,3,0.0000,'cash','credit','sell',317,'2021-09-03 21:14:18','2021-09-03 21:14:18'),(316,5,100.0000,'cash','credit','sell',318,'2021-09-03 21:20:18','2021-09-03 21:20:18'),(317,5,0.0000,'cash','credit','sell',318,'2021-09-03 21:20:18','2021-09-03 21:20:18'),(318,5,175.0000,'cash','credit','sell',319,'2021-09-03 21:28:18','2021-09-03 21:28:18'),(319,5,0.0000,'cash','credit','sell',319,'2021-09-03 21:28:18','2021-09-03 21:28:18'),(320,3,150.0000,'cash','credit','sell',320,'2021-09-03 21:45:39','2021-09-03 21:45:39'),(321,3,0.0000,'cash','credit','sell',320,'2021-09-03 21:45:39','2021-09-03 21:45:39'),(322,5,150.0000,'cash','credit','sell',321,'2021-09-03 21:50:29','2021-09-03 21:50:29'),(323,5,0.0000,'cash','credit','sell',321,'2021-09-03 21:50:29','2021-09-03 21:50:29'),(324,3,225.0000,'cash','credit','sell',322,'2021-09-03 21:50:36','2021-09-03 21:50:36'),(325,3,0.0000,'cash','credit','sell',322,'2021-09-03 21:50:36','2021-09-03 21:50:36'),(326,5,350.0000,'cash','credit','sell',323,'2021-09-03 21:54:58','2021-09-03 21:54:58'),(327,5,0.0000,'cash','credit','sell',323,'2021-09-03 21:54:58','2021-09-03 21:54:58'),(328,3,195.0000,'cash','credit','sell',324,'2021-09-03 22:07:44','2021-09-03 22:07:44'),(329,3,0.0000,'cash','credit','sell',324,'2021-09-03 22:07:44','2021-09-03 22:07:44'),(330,5,100.0000,'cash','credit','sell',326,'2021-09-03 22:25:05','2021-09-03 22:25:05'),(331,5,0.0000,'cash','credit','sell',326,'2021-09-03 22:25:05','2021-09-03 22:25:05'),(332,5,200.0000,'cash','credit','sell',327,'2021-09-03 22:52:39','2021-09-03 22:52:39'),(333,5,0.0000,'cash','credit','sell',327,'2021-09-03 22:52:39','2021-09-03 22:52:39'),(334,3,500.0000,'cash','credit','sell',328,'2021-09-03 22:53:01','2021-09-03 22:53:01'),(335,3,0.0000,'cash','credit','sell',328,'2021-09-03 22:53:01','2021-09-03 22:53:01'),(336,3,100.0000,'cash','credit','sell',329,'2021-09-03 22:54:02','2021-09-03 22:54:02'),(337,3,0.0000,'cash','credit','sell',329,'2021-09-03 22:54:02','2021-09-03 22:54:02'),(338,3,100.0000,'cash','credit','sell',330,'2021-09-03 23:21:16','2021-09-03 23:21:16'),(339,3,0.0000,'cash','credit','sell',330,'2021-09-03 23:21:16','2021-09-03 23:21:16'),(340,5,100.0000,'cash','credit','sell',331,'2021-09-03 23:25:16','2021-09-03 23:25:16'),(341,5,0.0000,'cash','credit','sell',331,'2021-09-03 23:25:16','2021-09-03 23:25:16'),(342,3,425.0000,'cash','credit','sell',332,'2021-09-03 23:26:49','2021-09-03 23:26:49'),(343,3,0.0000,'cash','credit','sell',332,'2021-09-03 23:26:49','2021-09-03 23:26:49'),(344,5,425.0000,'cash','credit','sell',333,'2021-09-03 23:55:09','2021-09-03 23:55:09'),(345,5,0.0000,'cash','credit','sell',333,'2021-09-03 23:55:09','2021-09-03 23:55:09'),(346,7,100.0000,'cash','credit','sell',335,'2021-09-04 12:19:48','2021-09-04 12:19:48'),(347,7,0.0000,'cash','credit','sell',335,'2021-09-04 12:19:48','2021-09-04 12:19:48'),(348,6,250.0000,'cash','credit','sell',336,'2021-09-04 12:29:30','2021-09-04 12:29:30'),(349,6,0.0000,'cash','credit','sell',336,'2021-09-04 12:29:30','2021-09-04 12:29:30'),(350,6,475.0000,'cash','credit','sell',337,'2021-09-04 12:42:21','2021-09-04 12:42:21'),(351,6,0.0000,'cash','credit','sell',337,'2021-09-04 12:42:21','2021-09-04 12:42:21'),(352,7,475.0000,'cash','credit','sell',339,'2021-09-04 14:08:14','2021-09-04 14:08:14'),(353,7,0.0000,'cash','credit','sell',339,'2021-09-04 14:08:14','2021-09-04 14:08:14'),(354,7,100.0000,'cash','credit','sell',340,'2021-09-04 15:33:30','2021-09-04 15:33:30'),(355,7,0.0000,'cash','credit','sell',340,'2021-09-04 15:33:30','2021-09-04 15:33:30'),(356,7,100.0000,'cash','credit','sell',341,'2021-09-04 16:09:23','2021-09-04 16:09:23'),(357,7,0.0000,'cash','credit','sell',341,'2021-09-04 16:09:23','2021-09-04 16:09:23'),(358,7,250.0000,'cash','credit','sell',342,'2021-09-04 16:10:59','2021-09-04 16:10:59'),(359,7,0.0000,'cash','credit','sell',342,'2021-09-04 16:10:59','2021-09-04 16:10:59'),(360,6,100.0000,'cash','credit','refund',NULL,'2021-09-04 12:47:00','2021-09-04 12:47:00'),(361,7,100.0000,'cash','credit','sell',343,'2021-09-04 17:16:52','2021-09-04 17:16:52'),(362,7,0.0000,'cash','credit','sell',343,'2021-09-04 17:16:52','2021-09-04 17:16:52'),(363,6,75.0000,'cash','credit','sell',344,'2021-09-04 17:24:21','2021-09-04 17:24:21'),(364,6,0.0000,'cash','credit','sell',344,'2021-09-04 17:24:21','2021-09-04 17:24:21'),(365,6,75.0000,'cash','credit','refund',NULL,'2021-09-04 17:29:50','2021-09-04 17:29:50'),(366,7,50.0000,'cash','credit','sell',346,'2021-09-04 17:36:15','2021-09-04 17:36:15'),(367,7,0.0000,'cash','credit','sell',346,'2021-09-04 17:36:15','2021-09-04 17:36:15'),(368,7,150.0000,'cash','credit','sell',347,'2021-09-04 17:56:23','2021-09-04 17:56:23'),(369,7,0.0000,'cash','credit','sell',347,'2021-09-04 17:56:23','2021-09-04 17:56:23'),(370,7,375.0000,'cash','credit','sell',348,'2021-09-04 17:58:41','2021-09-04 17:58:41'),(371,7,0.0000,'cash','credit','sell',348,'2021-09-04 17:58:41','2021-09-04 17:58:41'),(372,7,100.0000,'cash','credit','sell',349,'2021-09-04 18:46:28','2021-09-04 18:46:28'),(373,7,0.0000,'cash','credit','sell',349,'2021-09-04 18:46:28','2021-09-04 18:46:28'),(374,7,600.0000,'cash','credit','sell',350,'2021-09-04 18:48:17','2021-09-04 18:48:17'),(375,7,0.0000,'cash','credit','sell',350,'2021-09-04 18:48:17','2021-09-04 18:48:17'),(376,6,100.0000,'cash','credit','sell',351,'2021-09-04 18:51:55','2021-09-04 18:51:55'),(377,6,0.0000,'cash','credit','sell',351,'2021-09-04 18:51:55','2021-09-04 18:51:55'),(378,7,100.0000,'cash','credit','sell',352,'2021-09-04 18:55:10','2021-09-04 18:55:10'),(379,7,0.0000,'cash','credit','sell',352,'2021-09-04 18:55:10','2021-09-04 18:55:10'),(380,7,200.0000,'cash','credit','sell',353,'2021-09-04 19:01:19','2021-09-04 19:01:19'),(381,7,0.0000,'cash','credit','sell',353,'2021-09-04 19:01:19','2021-09-04 19:01:19'),(382,6,75.0000,'cash','credit','sell',354,'2021-09-04 19:06:02','2021-09-04 19:06:02'),(383,6,0.0000,'cash','credit','sell',354,'2021-09-04 19:06:02','2021-09-04 19:06:02'),(384,6,75.0000,'cash','credit','refund',NULL,'2021-09-04 19:09:21','2021-09-04 19:09:21'),(385,6,395.0000,'cash','credit','sell',356,'2021-09-04 19:40:58','2021-09-04 19:40:58'),(386,6,0.0000,'cash','credit','sell',356,'2021-09-04 19:40:58','2021-09-04 19:40:58'),(387,6,75.0000,'cash','credit','sell',357,'2021-09-04 20:11:10','2021-09-04 20:11:10'),(388,6,0.0000,'cash','credit','sell',357,'2021-09-04 20:11:10','2021-09-04 20:11:10'),(389,7,50.0000,'cash','credit','sell',358,'2021-09-04 20:27:28','2021-09-04 20:27:28'),(390,7,0.0000,'cash','credit','sell',358,'2021-09-04 20:27:28','2021-09-04 20:27:28'),(391,7,100.0000,'cash','credit','sell',359,'2021-09-04 20:33:39','2021-09-04 20:33:39'),(392,7,0.0000,'cash','credit','sell',359,'2021-09-04 20:33:39','2021-09-04 20:33:39'),(393,7,150.0000,'cash','credit','sell',360,'2021-09-04 20:35:12','2021-09-04 20:35:12'),(394,7,0.0000,'cash','credit','sell',360,'2021-09-04 20:35:12','2021-09-04 20:35:12'),(395,7,250.0000,'cash','credit','sell',361,'2021-09-04 20:35:55','2021-09-04 20:35:55'),(396,7,0.0000,'cash','credit','sell',361,'2021-09-04 20:35:55','2021-09-04 20:35:55'),(397,7,75.0000,'cash','credit','sell',362,'2021-09-04 20:40:00','2021-09-04 20:40:00'),(398,7,0.0000,'cash','credit','sell',362,'2021-09-04 20:40:00','2021-09-04 20:40:00'),(399,7,200.0000,'cash','credit','sell',363,'2021-09-04 20:53:38','2021-09-04 20:53:38'),(400,7,0.0000,'cash','credit','sell',363,'2021-09-04 20:53:38','2021-09-04 20:53:38'),(401,6,150.0000,'cash','credit','sell',364,'2021-09-04 20:57:00','2021-09-04 20:57:00'),(402,6,0.0000,'cash','credit','sell',364,'2021-09-04 20:57:00','2021-09-04 20:57:00'),(403,6,25.0000,'cash','credit','sell',365,'2021-09-04 20:57:58','2021-09-04 20:57:58'),(404,6,0.0000,'cash','credit','sell',365,'2021-09-04 20:57:58','2021-09-04 20:57:58'),(405,7,150.0000,'cash','credit','sell',367,'2021-09-04 21:08:20','2021-09-04 21:08:20'),(406,7,0.0000,'cash','credit','sell',367,'2021-09-04 21:08:20','2021-09-04 21:08:20'),(407,7,200.0000,'cash','credit','refund',NULL,'2021-09-04 21:13:31','2021-09-04 21:13:31'),(408,7,100.0000,'cash','credit','sell',368,'2021-09-04 21:28:12','2021-09-04 21:28:12'),(409,7,0.0000,'cash','credit','sell',368,'2021-09-04 21:28:12','2021-09-04 21:28:12'),(410,6,100.0000,'cash','credit','sell',369,'2021-09-04 21:29:05','2021-09-04 21:29:05'),(411,6,0.0000,'cash','credit','sell',369,'2021-09-04 21:29:05','2021-09-04 21:29:05'),(412,6,300.0000,'cash','credit','sell',370,'2021-09-04 21:40:44','2021-09-04 21:40:44'),(413,6,0.0000,'cash','credit','sell',370,'2021-09-04 21:40:44','2021-09-04 21:40:44'),(414,7,250.0000,'cash','credit','sell',371,'2021-09-04 21:47:44','2021-09-04 21:47:44'),(415,7,0.0000,'cash','credit','sell',371,'2021-09-04 21:47:44','2021-09-04 21:47:44'),(416,6,200.0000,'cash','credit','sell',372,'2021-09-04 22:02:41','2021-09-04 22:02:41'),(417,6,0.0000,'cash','credit','sell',372,'2021-09-04 22:02:41','2021-09-04 22:02:41'),(418,7,100.0000,'cash','credit','sell',373,'2021-09-04 22:02:59','2021-09-04 22:02:59'),(419,7,0.0000,'cash','credit','sell',373,'2021-09-04 22:02:59','2021-09-04 22:02:59'),(420,6,100.0000,'cash','credit','sell',374,'2021-09-04 22:03:24','2021-09-04 22:03:24'),(421,6,0.0000,'cash','credit','sell',374,'2021-09-04 22:03:24','2021-09-04 22:03:24'),(422,7,75.0000,'cash','credit','sell',375,'2021-09-04 22:07:54','2021-09-04 22:07:54'),(423,7,0.0000,'cash','credit','sell',375,'2021-09-04 22:07:54','2021-09-04 22:07:54'),(424,7,100.0000,'cash','credit','sell',376,'2021-09-04 22:17:30','2021-09-04 22:17:30'),(425,7,0.0000,'cash','credit','sell',376,'2021-09-04 22:17:30','2021-09-04 22:17:30'),(426,7,100.0000,'cash','credit','sell',377,'2021-09-04 22:22:55','2021-09-04 22:22:55'),(427,7,0.0000,'cash','credit','sell',377,'2021-09-04 22:22:55','2021-09-04 22:22:55'),(428,6,250.0000,'cash','credit','sell',378,'2021-09-04 22:37:39','2021-09-04 22:37:39'),(429,6,0.0000,'cash','credit','sell',378,'2021-09-04 22:37:39','2021-09-04 22:37:39'),(430,7,125.0000,'cash','credit','sell',379,'2021-09-04 22:45:00','2021-09-04 22:45:00'),(431,7,0.0000,'cash','credit','sell',379,'2021-09-04 22:45:00','2021-09-04 22:45:00'),(432,7,275.0000,'cash','credit','sell',380,'2021-09-04 22:47:25','2021-09-04 22:47:25'),(433,7,0.0000,'cash','credit','sell',380,'2021-09-04 22:47:25','2021-09-04 22:47:25'),(434,7,175.0000,'cash','credit','sell',381,'2021-09-04 22:48:28','2021-09-04 22:48:28'),(435,7,0.0000,'cash','credit','sell',381,'2021-09-04 22:48:28','2021-09-04 22:48:28'),(436,6,100.0000,'cash','credit','sell',382,'2021-09-04 22:49:36','2021-09-04 22:49:36'),(437,6,0.0000,'cash','credit','sell',382,'2021-09-04 22:49:36','2021-09-04 22:49:36'),(438,7,50.0000,'cash','credit','sell',383,'2021-09-04 22:51:31','2021-09-04 22:51:31'),(439,7,0.0000,'cash','credit','sell',383,'2021-09-04 22:51:31','2021-09-04 22:51:31'),(440,11,100.0000,'cash','credit','sell',384,'2021-09-05 11:41:52','2021-09-05 11:41:52'),(441,11,0.0000,'cash','credit','sell',384,'2021-09-05 11:41:53','2021-09-05 11:41:53'),(442,11,100.0000,'cash','credit','sell',385,'2021-09-05 11:59:40','2021-09-05 11:59:40'),(443,11,0.0000,'cash','credit','sell',385,'2021-09-05 11:59:40','2021-09-05 11:59:40'),(444,11,75.0000,'cash','credit','sell',386,'2021-09-05 12:09:07','2021-09-05 12:09:07'),(445,11,0.0000,'cash','credit','sell',386,'2021-09-05 12:09:07','2021-09-05 12:09:07'),(446,11,75.0000,'cash','credit','sell',387,'2021-09-05 12:09:45','2021-09-05 12:09:45'),(447,11,0.0000,'cash','credit','sell',387,'2021-09-05 12:09:45','2021-09-05 12:09:45'),(448,11,150.0000,'cash','credit','sell',388,'2021-09-05 12:26:06','2021-09-05 12:26:06'),(449,11,0.0000,'cash','credit','sell',388,'2021-09-05 12:26:06','2021-09-05 12:26:06'),(450,11,75.0000,'cash','credit','sell',389,'2021-09-05 13:29:07','2021-09-05 13:29:07'),(451,11,0.0000,'cash','credit','sell',389,'2021-09-05 13:29:07','2021-09-05 13:29:07'),(453,11,300.0000,'cash','credit','sell',391,'2021-09-05 15:24:23','2021-09-05 15:24:23'),(454,11,0.0000,'cash','credit','sell',391,'2021-09-05 15:24:23','2021-09-05 15:24:23'),(455,11,250.0000,'cash','credit','sell',392,'2021-09-05 15:32:10','2021-09-05 15:32:10'),(456,11,0.0000,'cash','credit','sell',392,'2021-09-05 15:32:10','2021-09-05 15:32:10'),(457,11,150.0000,'cash','credit','sell',393,'2021-09-05 16:07:36','2021-09-05 16:07:36'),(458,11,0.0000,'cash','credit','sell',393,'2021-09-05 16:07:36','2021-09-05 16:07:36'),(459,11,100.0000,'cash','credit','sell',394,'2021-09-05 17:52:43','2021-09-05 17:52:43'),(460,11,0.0000,'cash','credit','sell',394,'2021-09-05 17:52:43','2021-09-05 17:52:43'),(461,13,250.0000,'cash','credit','sell',395,'2021-09-05 18:04:14','2021-09-05 18:04:14'),(462,13,0.0000,'cash','credit','sell',395,'2021-09-05 18:04:14','2021-09-05 18:04:14'),(463,13,100.0000,'cash','credit','sell',396,'2021-09-05 18:06:48','2021-09-05 18:06:48'),(464,13,0.0000,'cash','credit','sell',396,'2021-09-05 18:06:48','2021-09-05 18:06:48'),(465,13,100.0000,'cash','credit','sell',397,'2021-09-05 18:32:58','2021-09-05 18:32:58'),(466,13,0.0000,'cash','credit','sell',397,'2021-09-05 18:32:58','2021-09-05 18:32:58'),(467,11,100.0000,'cash','credit','sell',398,'2021-09-05 18:42:04','2021-09-05 18:42:04'),(468,11,0.0000,'cash','credit','sell',398,'2021-09-05 18:42:04','2021-09-05 18:42:04'),(469,11,200.0000,'cash','credit','sell',399,'2021-09-05 18:48:36','2021-09-05 18:48:36'),(470,11,0.0000,'cash','credit','sell',399,'2021-09-05 18:48:36','2021-09-05 18:48:36'),(471,11,200.0000,'cash','credit','sell',400,'2021-09-05 18:53:15','2021-09-05 18:53:15'),(472,11,0.0000,'cash','credit','sell',400,'2021-09-05 18:53:15','2021-09-05 18:53:15'),(473,13,100.0000,'cash','credit','sell',401,'2021-09-05 19:36:46','2021-09-05 19:36:46'),(474,13,0.0000,'cash','credit','sell',401,'2021-09-05 19:36:46','2021-09-05 19:36:46'),(475,11,100.0000,'cash','credit','sell',402,'2021-09-05 19:45:10','2021-09-05 19:45:10'),(476,11,0.0000,'cash','credit','sell',402,'2021-09-05 19:45:10','2021-09-05 19:45:10'),(477,11,50.0000,'cash','credit','sell',403,'2021-09-05 19:47:35','2021-09-05 19:47:35'),(478,11,0.0000,'cash','credit','sell',403,'2021-09-05 19:47:35','2021-09-05 19:47:35'),(479,13,100.0000,'cash','credit','sell',404,'2021-09-05 20:25:23','2021-09-05 20:25:23'),(480,13,0.0000,'cash','credit','sell',404,'2021-09-05 20:25:23','2021-09-05 20:25:23'),(481,13,200.0000,'cash','credit','sell',405,'2021-09-05 20:41:22','2021-09-05 20:41:22'),(482,13,0.0000,'cash','credit','sell',405,'2021-09-05 20:41:22','2021-09-05 20:41:22'),(483,13,50.0000,'cash','credit','sell',406,'2021-09-05 20:42:46','2021-09-05 20:42:46'),(484,13,0.0000,'cash','credit','sell',406,'2021-09-05 20:42:46','2021-09-05 20:42:46'),(485,11,150.0000,'cash','credit','sell',407,'2021-09-05 21:18:29','2021-09-05 21:18:29'),(486,11,0.0000,'cash','credit','sell',407,'2021-09-05 21:18:29','2021-09-05 21:18:29'),(487,11,100.0000,'cash','credit','sell',408,'2021-09-05 21:20:21','2021-09-05 21:20:21'),(488,11,0.0000,'cash','credit','sell',408,'2021-09-05 21:20:21','2021-09-05 21:20:21'),(489,11,100.0000,'cash','credit','sell',409,'2021-09-05 21:30:02','2021-09-05 21:30:02'),(490,11,0.0000,'cash','credit','sell',409,'2021-09-05 21:30:02','2021-09-05 21:30:02'),(491,11,50.0000,'cash','credit','sell',410,'2021-09-05 21:47:25','2021-09-05 21:47:25'),(492,11,0.0000,'cash','credit','sell',410,'2021-09-05 21:47:25','2021-09-05 21:47:25'),(493,13,225.0000,'cash','credit','sell',411,'2021-09-05 22:40:19','2021-09-05 22:40:19'),(494,13,0.0000,'cash','credit','sell',411,'2021-09-05 22:40:19','2021-09-05 22:40:19'),(495,11,50.0000,'cash','credit','sell',412,'2021-09-05 22:53:10','2021-09-05 22:53:10'),(496,11,0.0000,'cash','credit','sell',412,'2021-09-05 22:53:10','2021-09-05 22:53:10'),(497,11,250.0000,'cash','credit','sell',413,'2021-09-05 23:02:18','2021-09-05 23:02:18'),(498,11,0.0000,'cash','credit','sell',413,'2021-09-05 23:02:18','2021-09-05 23:02:18'),(499,13,225.0000,'cash','credit','sell',414,'2021-09-05 23:04:46','2021-09-05 23:04:46'),(500,13,0.0000,'cash','credit','sell',414,'2021-09-05 23:04:46','2021-09-05 23:04:46'),(501,14,2425.0000,'cash','credit','initial',NULL,'2021-09-05 23:07:53','2021-09-05 23:07:53'),(502,14,50.0000,'cash','credit','sell',415,'2021-09-06 13:17:55','2021-09-06 13:17:55'),(503,14,0.0000,'cash','credit','sell',415,'2021-09-06 13:17:55','2021-09-06 13:17:55'),(504,14,200.0000,'cash','credit','sell',416,'2021-09-06 14:06:12','2021-09-06 14:06:12'),(505,14,0.0000,'cash','credit','sell',416,'2021-09-06 14:06:12','2021-09-06 14:06:12'),(506,15,150.0000,'cash','credit','sell',417,'2021-09-06 14:16:40','2021-09-06 14:16:40'),(507,15,0.0000,'cash','credit','sell',417,'2021-09-06 14:16:40','2021-09-06 14:16:40'),(508,15,200.0000,'cash','credit','sell',418,'2021-09-06 16:10:43','2021-09-06 16:10:43'),(509,15,0.0000,'cash','credit','sell',418,'2021-09-06 16:10:43','2021-09-06 16:10:43'),(510,14,75.0000,'cash','credit','sell',420,'2021-09-06 17:52:49','2021-09-06 17:52:49'),(511,14,0.0000,'cash','credit','sell',420,'2021-09-06 17:52:49','2021-09-06 17:52:49'),(512,14,50.0000,'cash','credit','refund',NULL,'2021-09-06 17:54:33','2021-09-06 17:54:33'),(513,14,150.0000,'cash','credit','sell',421,'2021-09-06 18:38:05','2021-09-06 18:38:05'),(514,14,0.0000,'cash','credit','sell',421,'2021-09-06 18:38:05','2021-09-06 18:38:05'),(515,14,100.0000,'cash','credit','sell',422,'2021-09-06 18:56:11','2021-09-06 18:56:11'),(516,14,0.0000,'cash','credit','sell',422,'2021-09-06 18:56:11','2021-09-06 18:56:11'),(517,14,200.0000,'cash','credit','sell',423,'2021-09-06 19:12:58','2021-09-06 19:12:58'),(518,14,0.0000,'cash','credit','sell',423,'2021-09-06 19:12:58','2021-09-06 19:12:58'),(519,14,150.0000,'cash','credit','sell',424,'2021-09-06 19:16:30','2021-09-06 19:16:30'),(520,14,0.0000,'cash','credit','sell',424,'2021-09-06 19:16:30','2021-09-06 19:16:30'),(521,14,150.0000,'cash','credit','sell',425,'2021-09-06 19:35:03','2021-09-06 19:35:03'),(522,14,0.0000,'cash','credit','sell',425,'2021-09-06 19:35:03','2021-09-06 19:35:03'),(523,14,150.0000,'cash','credit','refund',NULL,'2021-09-06 20:00:28','2021-09-06 20:00:28'),(524,14,75.0000,'cash','credit','sell',427,'2021-09-06 20:08:02','2021-09-06 20:08:02'),(525,14,0.0000,'cash','credit','sell',427,'2021-09-06 20:08:02','2021-09-06 20:08:02'),(526,14,75.0000,'cash','credit','sell',428,'2021-09-06 20:09:40','2021-09-06 20:09:40'),(527,14,0.0000,'cash','credit','sell',428,'2021-09-06 20:09:40','2021-09-06 20:09:40'),(528,15,250.0000,'cash','credit','sell',429,'2021-09-06 20:38:46','2021-09-06 20:38:46'),(529,15,0.0000,'cash','credit','sell',429,'2021-09-06 20:38:46','2021-09-06 20:38:46'),(530,15,50.0000,'cash','credit','sell',430,'2021-09-06 20:51:19','2021-09-06 20:51:19'),(531,15,0.0000,'cash','credit','sell',430,'2021-09-06 20:51:19','2021-09-06 20:51:19'),(532,14,250.0000,'cash','credit','sell',431,'2021-09-06 21:22:21','2021-09-06 21:22:21'),(533,14,0.0000,'cash','credit','sell',431,'2021-09-06 21:22:21','2021-09-06 21:22:21'),(534,15,100.0000,'cash','credit','sell',432,'2021-09-06 21:22:37','2021-09-06 21:22:37'),(535,15,0.0000,'cash','credit','sell',432,'2021-09-06 21:22:37','2021-09-06 21:22:37'),(536,15,100.0000,'cash','credit','sell',433,'2021-09-06 21:23:21','2021-09-06 21:23:21'),(537,15,0.0000,'cash','credit','sell',433,'2021-09-06 21:23:21','2021-09-06 21:23:21'),(538,14,575.0000,'cash','credit','sell',434,'2021-09-06 21:26:07','2021-09-06 21:26:07'),(539,14,0.0000,'cash','credit','sell',434,'2021-09-06 21:26:07','2021-09-06 21:26:07'),(540,14,200.0000,'cash','credit','sell',435,'2021-09-06 21:41:10','2021-09-06 21:41:10'),(541,14,0.0000,'cash','credit','sell',435,'2021-09-06 21:41:10','2021-09-06 21:41:10'),(542,14,250.0000,'cash','credit','sell',436,'2021-09-06 21:55:08','2021-09-06 21:55:08'),(543,14,0.0000,'cash','credit','sell',436,'2021-09-06 21:55:08','2021-09-06 21:55:08'),(544,14,275.0000,'cash','credit','sell',437,'2021-09-06 22:11:02','2021-09-06 22:11:02'),(545,14,0.0000,'cash','credit','sell',437,'2021-09-06 22:11:02','2021-09-06 22:11:02'),(546,14,250.0000,'cash','credit','sell',438,'2021-09-06 22:36:37','2021-09-06 22:36:37'),(547,14,0.0000,'cash','credit','sell',438,'2021-09-06 22:36:37','2021-09-06 22:36:37'),(548,14,350.0000,'cash','credit','sell',439,'2021-09-06 22:57:31','2021-09-06 22:57:31'),(549,14,0.0000,'cash','credit','sell',439,'2021-09-06 22:57:31','2021-09-06 22:57:31'),(550,18,250.0000,'cash','credit','sell',440,'2021-09-07 11:19:35','2021-09-07 11:19:35'),(551,18,0.0000,'cash','credit','sell',440,'2021-09-07 11:19:35','2021-09-07 11:19:35'),(552,18,50.0000,'cash','credit','sell',442,'2021-09-07 11:49:53','2021-09-07 11:49:53'),(553,18,0.0000,'cash','credit','sell',442,'2021-09-07 11:49:53','2021-09-07 11:49:53'),(554,18,50.0000,'cash','credit','refund',NULL,'2021-09-07 11:51:19','2021-09-07 11:51:19'),(555,18,200.0000,'cash','credit','sell',443,'2021-09-07 12:19:56','2021-09-07 12:19:56'),(556,18,0.0000,'cash','credit','sell',443,'2021-09-07 12:19:56','2021-09-07 12:19:56'),(557,18,650.0000,'cash','credit','sell',444,'2021-09-07 13:23:35','2021-09-07 13:23:35'),(558,18,0.0000,'cash','credit','sell',444,'2021-09-07 13:23:35','2021-09-07 13:23:35'),(559,20,150.0000,'cash','credit','sell',445,'2021-09-07 13:47:49','2021-09-07 13:47:49'),(560,20,0.0000,'cash','credit','sell',445,'2021-09-07 13:47:49','2021-09-07 13:47:49'),(561,20,200.0000,'cash','credit','sell',446,'2021-09-07 15:07:51','2021-09-07 15:07:51'),(562,20,0.0000,'cash','credit','sell',446,'2021-09-07 15:07:51','2021-09-07 15:07:51'),(563,20,200.0000,'cash','credit','sell',447,'2021-09-07 15:10:13','2021-09-07 15:10:13'),(564,20,0.0000,'cash','credit','sell',447,'2021-09-07 15:10:13','2021-09-07 15:10:13'),(565,20,200.0000,'cash','credit','refund',NULL,'2021-09-07 15:13:12','2021-09-07 15:13:12'),(566,20,150.0000,'cash','credit','sell',449,'2021-09-07 16:32:09','2021-09-07 16:32:09'),(567,20,0.0000,'cash','credit','sell',449,'2021-09-07 16:32:09','2021-09-07 16:32:09'),(568,18,100.0000,'cash','credit','sell',450,'2021-09-07 16:34:23','2021-09-07 16:34:23'),(569,18,0.0000,'cash','credit','sell',450,'2021-09-07 16:34:23','2021-09-07 16:34:23'),(570,18,225.0000,'cash','credit','sell',451,'2021-09-07 17:17:35','2021-09-07 17:17:35'),(571,18,0.0000,'cash','credit','sell',451,'2021-09-07 17:17:35','2021-09-07 17:17:35'),(572,18,50.0000,'cash','credit','sell',452,'2021-09-07 17:53:50','2021-09-07 17:53:50'),(573,18,0.0000,'cash','credit','sell',452,'2021-09-07 17:53:50','2021-09-07 17:53:50'),(574,18,225.0000,'cash','credit','sell',453,'2021-09-07 18:15:30','2021-09-07 18:15:30'),(575,18,0.0000,'cash','credit','sell',453,'2021-09-07 18:15:30','2021-09-07 18:15:30'),(576,18,350.0000,'cash','credit','sell',454,'2021-09-07 18:54:24','2021-09-07 18:54:24'),(577,18,0.0000,'cash','credit','sell',454,'2021-09-07 18:54:24','2021-09-07 18:54:24'),(578,20,150.0000,'cash','credit','sell',455,'2021-09-07 18:56:23','2021-09-07 18:56:23'),(579,20,0.0000,'cash','credit','sell',455,'2021-09-07 18:56:23','2021-09-07 18:56:23'),(580,20,50.0000,'cash','credit','sell',456,'2021-09-07 19:00:27','2021-09-07 19:00:27'),(581,20,0.0000,'cash','credit','sell',456,'2021-09-07 19:00:27','2021-09-07 19:00:27'),(582,20,200.0000,'cash','credit','sell',457,'2021-09-07 19:19:08','2021-09-07 19:19:08'),(583,20,0.0000,'cash','credit','sell',457,'2021-09-07 19:19:08','2021-09-07 19:19:08'),(584,20,650.0000,'cash','credit','sell',458,'2021-09-07 19:31:15','2021-09-07 19:31:15'),(585,20,0.0000,'cash','credit','sell',458,'2021-09-07 19:31:15','2021-09-07 19:31:15'),(586,20,200.0000,'cash','credit','sell',459,'2021-09-07 20:04:54','2021-09-07 20:04:54'),(587,20,0.0000,'cash','credit','sell',459,'2021-09-07 20:04:54','2021-09-07 20:04:54'),(588,20,100.0000,'cash','credit','sell',460,'2021-09-07 20:41:39','2021-09-07 20:41:39'),(589,20,0.0000,'cash','credit','sell',460,'2021-09-07 20:41:39','2021-09-07 20:41:39'),(590,18,100.0000,'cash','credit','sell',461,'2021-09-07 20:59:08','2021-09-07 20:59:08'),(591,18,0.0000,'cash','credit','sell',461,'2021-09-07 20:59:08','2021-09-07 20:59:08'),(592,18,25.0000,'cash','credit','sell',462,'2021-09-07 21:42:36','2021-09-07 21:42:36'),(593,18,0.0000,'cash','credit','sell',462,'2021-09-07 21:42:36','2021-09-07 21:42:36'),(594,18,50.0000,'cash','credit','sell',463,'2021-09-07 22:29:14','2021-09-07 22:29:14'),(595,18,0.0000,'cash','credit','sell',463,'2021-09-07 22:29:14','2021-09-07 22:29:14'),(596,23,100.0000,'cash','credit','sell',464,'2021-09-08 13:18:05','2021-09-08 13:18:05'),(597,23,0.0000,'cash','credit','sell',464,'2021-09-08 13:18:05','2021-09-08 13:18:05'),(598,22,50.0000,'cash','credit','sell',466,'2021-09-08 13:51:16','2021-09-08 13:51:16'),(599,22,0.0000,'cash','credit','sell',466,'2021-09-08 13:51:16','2021-09-08 13:51:16'),(600,23,100.0000,'cash','credit','sell',467,'2021-09-08 13:55:00','2021-09-08 13:55:00'),(601,23,0.0000,'cash','credit','sell',467,'2021-09-08 13:55:00','2021-09-08 13:55:00'),(602,23,50.0000,'cash','credit','sell',468,'2021-09-08 13:56:08','2021-09-08 13:56:08'),(603,23,0.0000,'cash','credit','sell',468,'2021-09-08 13:56:08','2021-09-08 13:56:08'),(604,22,225.0000,'cash','credit','sell',469,'2021-09-08 13:56:11','2021-09-08 13:56:11'),(605,22,0.0000,'cash','credit','sell',469,'2021-09-08 13:56:11','2021-09-08 13:56:11'),(606,23,50.0000,'cash','credit','sell',470,'2021-09-08 15:53:46','2021-09-08 15:53:46'),(607,23,0.0000,'cash','credit','sell',470,'2021-09-08 15:53:46','2021-09-08 15:53:46'),(608,22,100.0000,'cash','credit','sell',472,'2021-09-08 16:07:53','2021-09-08 16:07:53'),(609,22,0.0000,'cash','credit','sell',472,'2021-09-08 16:07:53','2021-09-08 16:07:53'),(610,23,75.0000,'cash','credit','sell',473,'2021-09-08 16:55:51','2021-09-08 16:55:51'),(611,23,0.0000,'cash','credit','sell',473,'2021-09-08 16:55:51','2021-09-08 16:55:51'),(612,23,75.0000,'cash','credit','refund',474,'2021-09-08 18:24:29','2021-09-08 18:24:29'),(613,23,50.0000,'cash','credit','refund',471,'2021-09-08 18:24:44','2021-09-08 18:24:44'),(614,23,350.0000,'cash','credit','sell',478,'2021-09-08 19:25:32','2021-09-08 19:25:32'),(615,23,0.0000,'cash','credit','sell',478,'2021-09-08 19:25:32','2021-09-08 19:25:32'),(616,22,125.0000,'cash','credit','sell',479,'2021-09-08 19:34:20','2021-09-08 19:34:20'),(617,22,0.0000,'cash','credit','sell',479,'2021-09-08 19:34:20','2021-09-08 19:34:20'),(618,22,50.0000,'cash','credit','refund',465,'2021-09-08 19:40:55','2021-09-08 19:40:55'),(619,23,300.0000,'cash','credit','sell',480,'2021-09-08 19:41:57','2021-09-08 19:41:57'),(620,23,0.0000,'cash','credit','sell',480,'2021-09-08 19:41:57','2021-09-08 19:41:57'),(621,23,50.0000,'cash','credit','sell',481,'2021-09-08 19:43:14','2021-09-08 19:43:14'),(622,23,0.0000,'cash','credit','sell',481,'2021-09-08 19:43:14','2021-09-08 19:43:14'),(623,22,100.0000,'cash','credit','sell',482,'2021-09-08 20:09:16','2021-09-08 20:09:16'),(624,22,0.0000,'cash','credit','sell',482,'2021-09-08 20:09:16','2021-09-08 20:09:16'),(625,22,200.0000,'cash','credit','sell',483,'2021-09-08 20:18:09','2021-09-08 20:18:09'),(626,22,0.0000,'cash','credit','sell',483,'2021-09-08 20:18:09','2021-09-08 20:18:09'),(627,23,350.0000,'cash','credit','sell',484,'2021-09-08 20:45:08','2021-09-08 20:45:08'),(628,23,0.0000,'cash','credit','sell',484,'2021-09-08 20:45:08','2021-09-08 20:45:08'),(629,22,100.0000,'cash','credit','sell',485,'2021-09-08 20:48:15','2021-09-08 20:48:15'),(630,22,0.0000,'cash','credit','sell',485,'2021-09-08 20:48:15','2021-09-08 20:48:15'),(631,23,150.0000,'cash','credit','sell',486,'2021-09-08 20:49:08','2021-09-08 20:49:08'),(632,23,0.0000,'cash','credit','sell',486,'2021-09-08 20:49:08','2021-09-08 20:49:08'),(633,22,50.0000,'cash','credit','sell',487,'2021-09-08 21:15:16','2021-09-08 21:15:16'),(634,22,0.0000,'cash','credit','sell',487,'2021-09-08 21:15:16','2021-09-08 21:15:16'),(635,23,50.0000,'cash','credit','sell',488,'2021-09-08 22:11:49','2021-09-08 22:11:49'),(636,23,0.0000,'cash','credit','sell',488,'2021-09-08 22:11:49','2021-09-08 22:11:49'),(637,23,50.0000,'cash','credit','sell',489,'2021-09-08 22:24:10','2021-09-08 22:24:10'),(638,23,0.0000,'cash','credit','sell',489,'2021-09-08 22:24:10','2021-09-08 22:24:10'),(639,24,150.0000,'cash','credit','sell',490,'2021-09-09 13:46:48','2021-09-09 13:46:48'),(640,24,0.0000,'cash','credit','sell',490,'2021-09-09 13:46:48','2021-09-09 13:46:48'),(641,24,75.0000,'cash','credit','sell',491,'2021-09-09 14:20:25','2021-09-09 14:20:25'),(642,24,0.0000,'cash','credit','sell',491,'2021-09-09 14:20:25','2021-09-09 14:20:25'),(643,24,75.0000,'cash','credit','sell',492,'2021-09-09 14:37:28','2021-09-09 14:37:28'),(644,24,0.0000,'cash','credit','sell',492,'2021-09-09 14:37:28','2021-09-09 14:37:28'),(645,24,100.0000,'cash','credit','sell',493,'2021-09-09 14:52:11','2021-09-09 14:52:11'),(646,24,0.0000,'cash','credit','sell',493,'2021-09-09 14:52:11','2021-09-09 14:52:11'),(647,25,350.0000,'cash','credit','refund',494,'2021-09-09 15:05:50','2021-09-09 15:05:50'),(648,25,75.0000,'cash','credit','sell',496,'2021-09-09 15:36:15','2021-09-09 15:36:15'),(649,25,0.0000,'cash','credit','sell',496,'2021-09-09 15:36:15','2021-09-09 15:36:15'),(650,24,75.0000,'cash','credit','sell',497,'2021-09-09 16:22:56','2021-09-09 16:22:56'),(651,24,0.0000,'cash','credit','sell',497,'2021-09-09 16:22:56','2021-09-09 16:22:56'),(652,24,150.0000,'cash','credit','refund',498,'2021-09-09 16:35:35','2021-09-09 16:35:35'),(653,24,75.0000,'cash','credit','refund',499,'2021-09-09 16:37:42','2021-09-09 16:37:42'),(654,25,75.0000,'cash','credit','refund',495,'2021-09-09 16:42:43','2021-09-09 16:42:43'),(655,25,100.0000,'cash','credit','sell',500,'2021-09-09 16:44:58','2021-09-09 16:44:58'),(656,25,0.0000,'cash','credit','sell',500,'2021-09-09 16:44:58','2021-09-09 16:44:58'),(657,25,100.0000,'cash','credit','sell',501,'2021-09-09 16:45:18','2021-09-09 16:45:18'),(658,25,0.0000,'cash','credit','sell',501,'2021-09-09 16:45:18','2021-09-09 16:45:18'),(659,24,75.0000,'cash','credit','sell',502,'2021-09-09 17:44:14','2021-09-09 17:44:14'),(660,24,0.0000,'cash','credit','sell',502,'2021-09-09 17:44:14','2021-09-09 17:44:14'),(661,25,50.0000,'cash','credit','sell',507,'2021-09-09 19:43:45','2021-09-09 19:43:45'),(662,25,0.0000,'cash','credit','sell',507,'2021-09-09 19:43:45','2021-09-09 19:43:45'),(663,24,450.0000,'cash','credit','sell',508,'2021-09-09 21:33:29','2021-09-09 21:33:29'),(664,24,0.0000,'cash','credit','sell',508,'2021-09-09 21:33:29','2021-09-09 21:33:29'),(665,25,100.0000,'cash','credit','sell',509,'2021-09-09 21:59:51','2021-09-09 21:59:51'),(666,25,0.0000,'cash','credit','sell',509,'2021-09-09 21:59:51','2021-09-09 21:59:51'),(667,25,275.0000,'cash','credit','sell',510,'2021-09-09 23:15:06','2021-09-09 23:15:06'),(668,25,0.0000,'cash','credit','sell',510,'2021-09-09 23:15:06','2021-09-09 23:15:06'),(669,27,675.0000,'cash','credit','sell',515,'2021-09-10 14:19:36','2021-09-10 14:19:36'),(670,27,0.0000,'cash','credit','sell',515,'2021-09-10 14:19:36','2021-09-10 14:19:36'),(671,26,200.0000,'cash','credit','sell',516,'2021-09-10 14:26:24','2021-09-10 14:26:24'),(672,26,0.0000,'cash','credit','sell',516,'2021-09-10 14:26:24','2021-09-10 14:26:24'),(673,26,250.0000,'cash','credit','sell',517,'2021-09-10 15:16:00','2021-09-10 15:16:00'),(674,26,0.0000,'cash','credit','sell',517,'2021-09-10 15:16:00','2021-09-10 15:16:00'),(675,26,75.0000,'cash','credit','sell',520,'2021-09-10 17:06:27','2021-09-10 17:06:27'),(676,26,0.0000,'cash','credit','sell',520,'2021-09-10 17:06:27','2021-09-10 17:06:27'),(677,26,1490.0000,'cash','credit','sell',522,'2021-09-10 17:32:40','2021-09-10 17:32:40'),(678,26,0.0000,'cash','credit','sell',522,'2021-09-10 17:32:40','2021-09-10 17:32:40'),(679,27,500.0000,'cash','credit','sell',523,'2021-09-10 17:48:00','2021-09-10 17:48:00'),(680,27,0.0000,'cash','credit','sell',523,'2021-09-10 17:48:00','2021-09-10 17:48:00'),(681,27,500.0000,'cash','credit','sell',524,'2021-09-10 17:49:24','2021-09-10 17:49:24'),(682,27,0.0000,'cash','credit','sell',524,'2021-09-10 17:49:24','2021-09-10 17:49:24'),(683,27,300.0000,'cash','credit','sell',525,'2021-09-10 17:53:46','2021-09-10 17:53:46'),(684,27,0.0000,'cash','credit','sell',525,'2021-09-10 17:53:46','2021-09-10 17:53:46'),(685,26,450.0000,'cash','credit','sell',526,'2021-09-10 18:52:44','2021-09-10 18:52:44'),(686,26,0.0000,'cash','credit','sell',526,'2021-09-10 18:52:44','2021-09-10 18:52:44'),(687,26,75.0000,'cash','credit','sell',527,'2021-09-10 19:09:22','2021-09-10 19:09:22'),(688,26,0.0000,'cash','credit','sell',527,'2021-09-10 19:09:22','2021-09-10 19:09:22'),(689,27,75.0000,'cash','credit','sell',528,'2021-09-10 19:26:20','2021-09-10 19:26:20'),(690,27,0.0000,'cash','credit','sell',528,'2021-09-10 19:26:20','2021-09-10 19:26:20'),(695,27,175.0000,'cash','credit','sell',531,'2021-09-10 19:38:04','2021-09-10 19:38:04'),(696,27,0.0000,'cash','credit','sell',531,'2021-09-10 19:38:04','2021-09-10 19:38:04'),(697,26,50.0000,'cash','credit','sell',532,'2021-09-10 19:42:34','2021-09-10 19:42:34'),(698,26,0.0000,'cash','credit','sell',532,'2021-09-10 19:42:34','2021-09-10 19:42:34'),(699,27,500.0000,'cash','credit','refund',533,'2021-09-10 20:04:48','2021-09-10 20:04:48'),(700,27,950.0000,'cash','credit','sell',534,'2021-09-10 20:16:34','2021-09-10 20:16:34'),(701,27,0.0000,'cash','credit','sell',534,'2021-09-10 20:16:34','2021-09-10 20:16:34'),(702,27,50.0000,'cash','credit','sell',535,'2021-09-10 21:13:24','2021-09-10 21:13:24'),(703,27,0.0000,'cash','credit','sell',535,'2021-09-10 21:13:24','2021-09-10 21:13:24'),(704,27,150.0000,'cash','credit','sell',536,'2021-09-10 21:16:33','2021-09-10 21:16:33'),(705,27,0.0000,'cash','credit','sell',536,'2021-09-10 21:16:33','2021-09-10 21:16:33'),(706,27,75.0000,'cash','credit','sell',537,'2021-09-10 21:22:41','2021-09-10 21:22:41'),(707,27,0.0000,'cash','credit','sell',537,'2021-09-10 21:22:41','2021-09-10 21:22:41'),(708,26,75.0000,'cash','credit','sell',538,'2021-09-10 22:14:17','2021-09-10 22:14:17'),(709,26,0.0000,'cash','credit','sell',538,'2021-09-10 22:14:17','2021-09-10 22:14:17'),(710,27,250.0000,'cash','credit','sell',539,'2021-09-10 22:15:08','2021-09-10 22:15:08'),(711,27,0.0000,'cash','credit','sell',539,'2021-09-10 22:15:08','2021-09-10 22:15:08'),(712,28,75.0000,'cash','credit','sell',540,'2021-09-11 17:13:56','2021-09-11 17:13:56'),(713,28,0.0000,'cash','credit','sell',540,'2021-09-11 17:13:56','2021-09-11 17:13:56'),(714,28,50.0000,'cash','credit','sell',541,'2021-09-11 20:27:48','2021-09-11 20:27:48'),(715,28,0.0000,'cash','credit','sell',541,'2021-09-11 20:27:48','2021-09-11 20:27:48'),(716,28,50.0000,'cash','credit','refund',542,'2021-09-11 20:31:48','2021-09-11 20:31:48'),(717,28,600.0000,'cash','credit','sell',543,'2021-09-11 20:45:46','2021-09-11 20:45:46'),(718,28,0.0000,'cash','credit','sell',543,'2021-09-11 20:45:46','2021-09-11 20:45:46'),(719,29,250.0000,'cash','credit','refund',546,'2021-09-11 21:59:48','2021-09-11 21:59:48'),(720,28,75.0000,'cash','credit','sell',547,'2021-09-11 22:19:48','2021-09-11 22:19:48'),(721,28,0.0000,'cash','credit','sell',547,'2021-09-11 22:19:48','2021-09-11 22:19:48'),(722,30,200.0000,'cash','credit','refund',548,'2021-09-12 19:51:41','2021-09-12 19:51:41'),(723,30,500.0000,'cash','credit','sell',549,'2021-09-12 20:06:40','2021-09-12 20:06:40'),(724,30,0.0000,'cash','credit','sell',549,'2021-09-12 20:06:40','2021-09-12 20:06:40'),(725,30,195.0000,'cash','credit','sell',550,'2021-09-12 22:02:25','2021-09-12 22:02:25'),(726,30,0.0000,'cash','credit','sell',550,'2021-09-12 22:02:25','2021-09-12 22:02:25'),(727,32,175.0000,'cash','credit','sell',551,'2021-09-13 13:23:47','2021-09-13 13:23:47'),(728,32,0.0000,'cash','credit','sell',551,'2021-09-13 13:23:47','2021-09-13 13:23:47'),(729,32,50.0000,'cash','credit','sell',552,'2021-09-13 16:34:15','2021-09-13 16:34:15'),(730,32,0.0000,'cash','credit','sell',552,'2021-09-13 16:34:15','2021-09-13 16:34:15'),(731,32,150.0000,'cash','credit','sell',553,'2021-09-13 18:21:41','2021-09-13 18:21:41'),(732,32,0.0000,'cash','credit','sell',553,'2021-09-13 18:21:41','2021-09-13 18:21:41'),(733,33,75.0000,'cash','credit','sell',554,'2021-09-13 18:43:31','2021-09-13 18:43:31'),(734,33,0.0000,'cash','credit','sell',554,'2021-09-13 18:43:31','2021-09-13 18:43:31'),(735,32,150.0000,'cash','credit','sell',555,'2021-09-13 19:25:31','2021-09-13 19:25:31'),(736,32,0.0000,'cash','credit','sell',555,'2021-09-13 19:25:31','2021-09-13 19:25:31'),(737,33,100.0000,'cash','credit','sell',557,'2021-09-13 21:09:57','2021-09-13 21:09:57'),(738,33,0.0000,'cash','credit','sell',557,'2021-09-13 21:09:57','2021-09-13 21:09:57'),(739,32,100.0000,'cash','credit','sell',558,'2021-09-13 22:27:31','2021-09-13 22:27:31'),(740,32,0.0000,'cash','credit','sell',558,'2021-09-13 22:27:31','2021-09-13 22:27:31'),(741,33,100.0000,'cash','credit','refund',556,'2021-09-13 22:42:16','2021-09-13 22:42:16'),(742,34,100.0000,'cash','credit','sell',559,'2021-09-14 15:15:10','2021-09-14 15:15:10'),(743,34,0.0000,'cash','credit','sell',559,'2021-09-14 15:15:10','2021-09-14 15:15:10'),(744,34,150.0000,'cash','credit','sell',560,'2021-09-14 15:27:41','2021-09-14 15:27:41'),(745,34,0.0000,'cash','credit','sell',560,'2021-09-14 15:27:41','2021-09-14 15:27:41'),(746,35,100.0000,'cash','credit','sell',561,'2021-09-14 17:01:34','2021-09-14 17:01:34'),(747,35,0.0000,'cash','credit','sell',561,'2021-09-14 17:01:34','2021-09-14 17:01:34'),(748,35,150.0000,'cash','credit','sell',562,'2021-09-14 17:21:26','2021-09-14 17:21:26'),(749,35,0.0000,'cash','credit','sell',562,'2021-09-14 17:21:26','2021-09-14 17:21:26'),(750,34,250.0000,'cash','credit','sell',563,'2021-09-14 20:13:11','2021-09-14 20:13:11'),(751,34,0.0000,'cash','credit','sell',563,'2021-09-14 20:13:11','2021-09-14 20:13:11'),(752,34,390.0000,'cash','credit','sell',564,'2021-09-14 20:47:47','2021-09-14 20:47:47'),(753,34,0.0000,'cash','credit','sell',564,'2021-09-14 20:47:47','2021-09-14 20:47:47'),(754,35,225.0000,'cash','credit','sell',565,'2021-09-14 21:29:08','2021-09-14 21:29:08'),(755,35,0.0000,'cash','credit','sell',565,'2021-09-14 21:29:08','2021-09-14 21:29:08'),(756,35,200.0000,'cash','credit','sell',566,'2021-09-14 21:55:29','2021-09-14 21:55:29'),(757,35,0.0000,'cash','credit','sell',566,'2021-09-14 21:55:29','2021-09-14 21:55:29'),(758,35,75.0000,'cash','credit','sell',567,'2021-09-14 22:01:51','2021-09-14 22:01:51'),(759,35,0.0000,'cash','credit','sell',567,'2021-09-14 22:01:51','2021-09-14 22:01:51'),(760,37,100.0000,'cash','credit','initial',NULL,'2021-09-21 13:43:49','2021-09-21 13:43:49');
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `total_card_slips` int(11) NOT NULL DEFAULT '0',
  `total_cheques` int(11) NOT NULL DEFAULT '0',
  `denominations` text COLLATE utf8mb4_unicode_ci,
  `closing_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `cash_registers_business_id_foreign` (`business_id`) USING BTREE,
  KEY `cash_registers_user_id_foreign` (`user_id`) USING BTREE,
  KEY `cash_registers_location_id_index` (`location_id`) USING BTREE,
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES (1,2,2,2,'close','2021-09-01 21:20:27',1.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}','Demo1','2021-09-01 18:57:00','2021-09-01 21:20:27'),(2,2,2,3,'close','2021-09-01 22:01:50',151.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-01 21:25:00','2021-09-01 22:01:50'),(3,2,2,3,'close','2021-09-04 00:20:55',20410.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-01 22:28:00','2021-09-04 00:20:55'),(4,2,3,9,'close','2021-09-03 15:43:55',8015.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-02 15:13:00','2021-09-03 15:43:55'),(5,2,3,9,'close','2021-09-03 23:59:08',13680.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-03 15:44:00','2021-09-03 23:59:08'),(6,2,3,9,'close','2021-09-04 22:54:55',2420.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-04 00:02:00','2021-09-04 22:54:55'),(7,2,2,3,'close','2021-09-04 22:57:54',4825.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-04 12:12:00','2021-09-04 22:57:54'),(11,2,2,3,'close','2021-09-05 23:06:31',2425.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-05 11:20:00','2021-09-05 23:06:31'),(13,2,3,9,'close','2021-09-05 23:21:09',1350.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-05 15:38:00','2021-09-05 23:21:09'),(14,2,2,3,'close','2021-09-06 23:03:01',5600.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-05 23:07:00','2021-09-06 23:03:01'),(15,2,3,9,'close','2021-09-06 22:48:50',850.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-06 11:59:00','2021-09-06 22:48:50'),(18,2,2,3,'close','2021-09-07 22:44:27',2225.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-07 11:17:00','2021-09-07 22:44:27'),(20,2,3,9,'close','2021-09-07 22:43:57',1850.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-07 12:52:00','2021-09-07 22:43:57'),(22,2,2,3,'close','2021-09-08 22:42:45',900.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-08 10:53:00','2021-09-08 22:42:45'),(23,2,3,9,'close','2021-09-08 22:35:14',1550.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-08 13:17:00','2021-09-08 22:35:14'),(24,2,2,3,'close','2021-09-09 23:20:15',775.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-09 11:18:00','2021-09-09 23:20:15'),(25,2,3,9,'close','2021-09-09 23:37:11',275.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-09 11:53:00','2021-09-09 23:37:11'),(26,2,3,9,'close','2021-09-10 23:38:09',2665.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-10 13:14:00','2021-09-10 23:38:09'),(27,2,2,3,'close','2021-09-10 23:25:50',3200.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-10 13:57:00','2021-09-10 23:25:50'),(28,2,3,9,'close','2021-09-11 22:43:30',750.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-11 10:52:00','2021-09-11 22:43:30'),(29,2,2,3,'close','2021-09-11 22:58:59',-250.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-11 14:26:00','2021-09-11 22:58:59'),(30,2,3,9,'close','2021-09-12 22:38:02',495.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-12 10:46:00','2021-09-12 22:38:02'),(31,2,2,3,'close','2021-09-12 22:49:14',0.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-12 11:00:00','2021-09-12 22:49:14'),(32,2,3,9,'close','2021-09-13 22:41:11',625.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-13 10:45:00','2021-09-13 22:41:11'),(33,2,2,3,'close','2021-09-13 22:43:32',75.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-13 11:05:00','2021-09-13 22:43:32'),(34,2,3,9,'close','2021-09-14 22:45:42',890.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-14 11:00:00','2021-09-14 22:45:42'),(35,2,2,3,'close','2021-09-14 22:30:49',750.0000,0,0,'{\"10\":null,\"20\":null,\"50\":null,\"100\":null,\"200\":null}',NULL,'2021-09-14 11:08:00','2021-09-14 22:30:49'),(36,2,2,3,'open',NULL,0.0000,0,0,NULL,NULL,'2021-09-15 11:11:00','2021-09-15 11:11:59'),(37,1,1,1,'open',NULL,0.0000,0,0,NULL,NULL,'2021-09-21 13:43:00','2021-09-21 13:43:49');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `category_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `categories_business_id_foreign` (`business_id`) USING BTREE,
  KEY `categories_created_by_foreign` (`created_by`) USING BTREE,
  KEY `categories_parent_id_index` (`parent_id`) USING BTREE,
  CONSTRAINT `categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Chino',2,'CH1',0,2,'product','Chino',NULL,NULL,'2021-09-01 17:00:19','2021-09-01 17:37:26'),(2,'Tracksuit',2,'TR1',0,2,'product',NULL,NULL,NULL,'2021-09-01 17:07:03','2021-09-01 17:07:03'),(3,'Jeans',2,NULL,0,2,'product',NULL,NULL,NULL,'2021-09-01 17:07:20','2021-09-01 17:37:50'),(4,'Sweatpant',2,'Sweatpant',0,2,'product',NULL,NULL,NULL,'2021-09-01 17:07:30','2021-09-01 17:07:30'),(5,'Short',2,NULL,0,2,'product',NULL,NULL,NULL,'2021-09-01 17:07:39','2021-09-01 17:38:22'),(6,'Swimshort',2,NULL,0,2,'product',NULL,NULL,NULL,'2021-09-01 17:07:48','2021-09-01 17:07:48'),(7,'Shirt',2,NULL,0,2,'product',NULL,NULL,NULL,'2021-09-01 17:07:59','2021-09-01 17:38:14'),(8,'T-shirt',2,'T-shirt',0,2,'product',NULL,NULL,NULL,'2021-09-01 17:08:08','2021-09-01 17:08:08'),(9,'Polo',2,NULL,0,2,'product',NULL,NULL,NULL,'2021-09-01 17:08:26','2021-09-01 17:38:00');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorizables` (
  `category_id` int(11) NOT NULL,
  `categorizable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categorizable_id` bigint(20) unsigned NOT NULL,
  KEY `categorizables_categorizable_type_categorizable_id_index` (`categorizable_type`,`categorizable_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categorizables` WRITE;
/*!40000 ALTER TABLE `categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `categorizables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `supplier_business_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `middle_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `tax_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_line_1` text COLLATE utf8mb4_unicode_ci,
  `address_line_2` text COLLATE utf8mb4_unicode_ci,
  `zip_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landline` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit_limit` decimal(22,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `balance` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `total_rp` int(11) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `total_rp_used` int(11) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `total_rp_expired` int(11) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `shipping_address` text COLLATE utf8mb4_unicode_ci,
  `shipping_custom_field_details` longtext COLLATE utf8mb4_unicode_ci,
  `is_export` tinyint(1) NOT NULL DEFAULT '0',
  `export_custom_field_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_6` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field6` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field7` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field8` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field9` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field10` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `contacts_business_id_foreign` (`business_id`) USING BTREE,
  KEY `contacts_created_by_foreign` (`created_by`) USING BTREE,
  KEY `contacts_type_index` (`type`) USING BTREE,
  KEY `contacts_contact_status_index` (`contact_status`) USING BTREE,
  CONSTRAINT `contacts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,1,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,1,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-31 05:43:53','2021-08-31 05:43:53'),(2,2,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,2,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 12:23:39','2021-09-01 12:23:39'),(3,2,'supplier','Firewood','',NULL,NULL,NULL,NULL,NULL,'Firewoo-1','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01200080553',NULL,'01200080553',NULL,NULL,NULL,2,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 17:41:44','2021-09-09 17:39:40','2021-09-09 17:41:44'),(4,2,'supplier','Firewood','',NULL,NULL,NULL,NULL,NULL,'CO0003','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01200080553',NULL,NULL,NULL,NULL,NULL,2,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 17:41:58','2021-09-09 17:41:58'),(5,1,'customer',NULL,'Dahshsan',NULL,'Dahshsan',NULL,NULL,NULL,'CO0002','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01000000000',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 22:38:24','2021-09-20 22:38:24');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `thousand_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `decimal_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'Albania','Leke','ALL','Lek',',','.',NULL,NULL),(2,'America','Dollars','USD','$',',','.',NULL,NULL),(3,'Afghanistan','Afghanis','AF','؋',',','.',NULL,NULL),(4,'Argentina','Pesos','ARS','$',',','.',NULL,NULL),(5,'Aruba','Guilders','AWG','ƒ',',','.',NULL,NULL),(6,'Australia','Dollars','AUD','$',',','.',NULL,NULL),(7,'Azerbaijan','New Manats','AZ','ман',',','.',NULL,NULL),(8,'Bahamas','Dollars','BSD','$',',','.',NULL,NULL),(9,'Barbados','Dollars','BBD','$',',','.',NULL,NULL),(10,'Belarus','Rubles','BYR','p.',',','.',NULL,NULL),(11,'Belgium','Euro','EUR','€',',','.',NULL,NULL),(12,'Beliz','Dollars','BZD','BZ$',',','.',NULL,NULL),(13,'Bermuda','Dollars','BMD','$',',','.',NULL,NULL),(14,'Bolivia','Bolivianos','BOB','$b',',','.',NULL,NULL),(15,'Bosnia and Herzegovina','Convertible Marka','BAM','KM',',','.',NULL,NULL),(16,'Botswana','Pula\'s','BWP','P',',','.',NULL,NULL),(17,'Bulgaria','Leva','BG','лв',',','.',NULL,NULL),(18,'Brazil','Reais','BRL','R$',',','.',NULL,NULL),(19,'Britain [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(20,'Brunei Darussalam','Dollars','BND','$',',','.',NULL,NULL),(21,'Cambodia','Riels','KHR','៛',',','.',NULL,NULL),(22,'Canada','Dollars','CAD','$',',','.',NULL,NULL),(23,'Cayman Islands','Dollars','KYD','$',',','.',NULL,NULL),(24,'Chile','Pesos','CLP','$',',','.',NULL,NULL),(25,'China','Yuan Renminbi','CNY','¥',',','.',NULL,NULL),(26,'Colombia','Pesos','COP','$',',','.',NULL,NULL),(27,'Costa Rica','Colón','CRC','₡',',','.',NULL,NULL),(28,'Croatia','Kuna','HRK','kn',',','.',NULL,NULL),(29,'Cuba','Pesos','CUP','₱',',','.',NULL,NULL),(30,'Cyprus','Euro','EUR','€','.',',',NULL,NULL),(31,'Czech Republic','Koruny','CZK','Kč',',','.',NULL,NULL),(32,'Denmark','Kroner','DKK','kr',',','.',NULL,NULL),(33,'Dominican Republic','Pesos','DOP ','RD$',',','.',NULL,NULL),(34,'East Caribbean','Dollars','XCD','$',',','.',NULL,NULL),(35,'Egypt','Pounds','EGP','£',',','.',NULL,NULL),(36,'El Salvador','Colones','SVC','$',',','.',NULL,NULL),(37,'England [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(38,'Euro','Euro','EUR','€','.',',',NULL,NULL),(39,'Falkland Islands','Pounds','FKP','£',',','.',NULL,NULL),(40,'Fiji','Dollars','FJD','$',',','.',NULL,NULL),(41,'France','Euro','EUR','€','.',',',NULL,NULL),(42,'Ghana','Cedis','GHS','¢',',','.',NULL,NULL),(43,'Gibraltar','Pounds','GIP','£',',','.',NULL,NULL),(44,'Greece','Euro','EUR','€','.',',',NULL,NULL),(45,'Guatemala','Quetzales','GTQ','Q',',','.',NULL,NULL),(46,'Guernsey','Pounds','GGP','£',',','.',NULL,NULL),(47,'Guyana','Dollars','GYD','$',',','.',NULL,NULL),(48,'Holland [Netherlands]','Euro','EUR','€','.',',',NULL,NULL),(49,'Honduras','Lempiras','HNL','L',',','.',NULL,NULL),(50,'Hong Kong','Dollars','HKD','$',',','.',NULL,NULL),(51,'Hungary','Forint','HUF','Ft',',','.',NULL,NULL),(52,'Iceland','Kronur','ISK','kr',',','.',NULL,NULL),(53,'India','Rupees','INR','₹',',','.',NULL,NULL),(54,'Indonesia','Rupiahs','IDR','Rp',',','.',NULL,NULL),(55,'Iran','Rials','IRR','﷼',',','.',NULL,NULL),(56,'Ireland','Euro','EUR','€','.',',',NULL,NULL),(57,'Isle of Man','Pounds','IMP','£',',','.',NULL,NULL),(58,'Israel','New Shekels','ILS','₪',',','.',NULL,NULL),(59,'Italy','Euro','EUR','€','.',',',NULL,NULL),(60,'Jamaica','Dollars','JMD','J$',',','.',NULL,NULL),(61,'Japan','Yen','JPY','¥',',','.',NULL,NULL),(62,'Jersey','Pounds','JEP','£',',','.',NULL,NULL),(63,'Kazakhstan','Tenge','KZT','лв',',','.',NULL,NULL),(64,'Korea [North]','Won','KPW','₩',',','.',NULL,NULL),(65,'Korea [South]','Won','KRW','₩',',','.',NULL,NULL),(66,'Kyrgyzstan','Soms','KGS','лв',',','.',NULL,NULL),(67,'Laos','Kips','LAK','₭',',','.',NULL,NULL),(68,'Latvia','Lati','LVL','Ls',',','.',NULL,NULL),(69,'Lebanon','Pounds','LBP','£',',','.',NULL,NULL),(70,'Liberia','Dollars','LRD','$',',','.',NULL,NULL),(71,'Liechtenstein','Switzerland Francs','CHF','CHF',',','.',NULL,NULL),(72,'Lithuania','Litai','LTL','Lt',',','.',NULL,NULL),(73,'Luxembourg','Euro','EUR','€','.',',',NULL,NULL),(74,'Macedonia','Denars','MKD','ден',',','.',NULL,NULL),(75,'Malaysia','Ringgits','MYR','RM',',','.',NULL,NULL),(76,'Malta','Euro','EUR','€','.',',',NULL,NULL),(77,'Mauritius','Rupees','MUR','₨',',','.',NULL,NULL),(78,'Mexico','Pesos','MXN','$',',','.',NULL,NULL),(79,'Mongolia','Tugriks','MNT','₮',',','.',NULL,NULL),(80,'Mozambique','Meticais','MZ','MT',',','.',NULL,NULL),(81,'Namibia','Dollars','NAD','$',',','.',NULL,NULL),(82,'Nepal','Rupees','NPR','₨',',','.',NULL,NULL),(83,'Netherlands Antilles','Guilders','ANG','ƒ',',','.',NULL,NULL),(84,'Netherlands','Euro','EUR','€','.',',',NULL,NULL),(85,'New Zealand','Dollars','NZD','$',',','.',NULL,NULL),(86,'Nicaragua','Cordobas','NIO','C$',',','.',NULL,NULL),(87,'Nigeria','Nairas','NGN','₦',',','.',NULL,NULL),(88,'North Korea','Won','KPW','₩',',','.',NULL,NULL),(89,'Norway','Krone','NOK','kr',',','.',NULL,NULL),(90,'Oman','Rials','OMR','﷼',',','.',NULL,NULL),(91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL),(92,'Panama','Balboa','PAB','B/.',',','.',NULL,NULL),(93,'Paraguay','Guarani','PYG','Gs',',','.',NULL,NULL),(94,'Peru','Nuevos Soles','PE','S/.',',','.',NULL,NULL),(95,'Philippines','Pesos','PHP','Php',',','.',NULL,NULL),(96,'Poland','Zlotych','PL','zł',',','.',NULL,NULL),(97,'Qatar','Rials','QAR','﷼',',','.',NULL,NULL),(98,'Romania','New Lei','RO','lei',',','.',NULL,NULL),(99,'Russia','Rubles','RUB','руб',',','.',NULL,NULL),(100,'Saint Helena','Pounds','SHP','£',',','.',NULL,NULL),(101,'Saudi Arabia','Riyals','SAR','﷼',',','.',NULL,NULL),(102,'Serbia','Dinars','RSD','Дин.',',','.',NULL,NULL),(103,'Seychelles','Rupees','SCR','₨',',','.',NULL,NULL),(104,'Singapore','Dollars','SGD','$',',','.',NULL,NULL),(105,'Slovenia','Euro','EUR','€','.',',',NULL,NULL),(106,'Solomon Islands','Dollars','SBD','$',',','.',NULL,NULL),(107,'Somalia','Shillings','SOS','S',',','.',NULL,NULL),(108,'South Africa','Rand','ZAR','R',',','.',NULL,NULL),(109,'South Korea','Won','KRW','₩',',','.',NULL,NULL),(110,'Spain','Euro','EUR','€','.',',',NULL,NULL),(111,'Sri Lanka','Rupees','LKR','₨',',','.',NULL,NULL),(112,'Sweden','Kronor','SEK','kr',',','.',NULL,NULL),(113,'Switzerland','Francs','CHF','CHF',',','.',NULL,NULL),(114,'Suriname','Dollars','SRD','$',',','.',NULL,NULL),(115,'Syria','Pounds','SYP','£',',','.',NULL,NULL),(116,'Taiwan','New Dollars','TWD','NT$',',','.',NULL,NULL),(117,'Thailand','Baht','THB','฿',',','.',NULL,NULL),(118,'Trinidad and Tobago','Dollars','TTD','TT$',',','.',NULL,NULL),(119,'Turkey','Lira','TRY','TL',',','.',NULL,NULL),(120,'Turkey','Liras','TRL','£',',','.',NULL,NULL),(121,'Tuvalu','Dollars','TVD','$',',','.',NULL,NULL),(122,'Ukraine','Hryvnia','UAH','₴',',','.',NULL,NULL),(123,'United Kingdom','Pounds','GBP','£',',','.',NULL,NULL),(124,'United States of America','Dollars','USD','$',',','.',NULL,NULL),(125,'Uruguay','Pesos','UYU','$U',',','.',NULL,NULL),(126,'Uzbekistan','Sums','UZS','лв',',','.',NULL,NULL),(127,'Vatican City','Euro','EUR','€','.',',',NULL,NULL),(128,'Venezuela','Bolivares Fuertes','VEF','Bs',',','.',NULL,NULL),(129,'Vietnam','Dong','VND','₫',',','.',NULL,NULL),(130,'Yemen','Rials','YER','﷼',',','.',NULL,NULL),(131,'Zimbabwe','Zimbabwe Dollars','ZWD','Z$',',','.',NULL,NULL),(132,'Iraq','Iraqi dinar','IQD','د.ع',',','.',NULL,NULL),(133,'Kenya','Kenyan shilling','KES','KSh',',','.',NULL,NULL),(134,'Bangladesh','Taka','BDT','৳',',','.',NULL,NULL),(135,'Algerie','Algerian dinar','DZD','د.ج',' ','.',NULL,NULL),(136,'United Arab Emirates','United Arab Emirates dirham','AED','د.إ',',','.',NULL,NULL),(137,'Uganda','Uganda shillings','UGX','USh',',','.',NULL,NULL),(138,'Tanzania','Tanzanian shilling','TZS','TSh',',','.',NULL,NULL),(139,'Angola','Kwanza','AOA','Kz',',','.',NULL,NULL),(140,'Kuwait','Kuwaiti dinar','KWD','KD',',','.',NULL,NULL),(141,'Bahrain','Bahraini dinar','BHD','BD',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(5,2) NOT NULL,
  `price_calculation_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'percentage',
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `customer_groups_business_id_foreign` (`business_id`) USING BTREE,
  KEY `customer_groups_created_by_index` (`created_by`) USING BTREE,
  KEY `customer_groups_price_calculation_type_index` (`price_calculation_type`) USING BTREE,
  KEY `customer_groups_selling_price_group_id_index` (`selling_price_group_id`) USING BTREE,
  CONSTRAINT `customer_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dashboard_configurations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dashboard_configurations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `created_by` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `configuration` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `dashboard_configurations_business_id_foreign` (`business_id`) USING BTREE,
  CONSTRAINT `dashboard_configurations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dashboard_configurations` WRITE;
/*!40000 ALTER TABLE `dashboard_configurations` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_configurations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discount_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discount_variations` (
  `discount_id` int(11) NOT NULL,
  `variation_id` int(11) NOT NULL,
  KEY `discount_variations_discount_id_index` (`discount_id`) USING BTREE,
  KEY `discount_variations_variation_id_index` (`variation_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discount_variations` WRITE;
/*!40000 ALTER TABLE `discount_variations` DISABLE KEYS */;
/*!40000 ALTER TABLE `discount_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(11) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `discount_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `starts_at` datetime DEFAULT NULL,
  `ends_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `applicable_in_spg` tinyint(1) DEFAULT '0',
  `applicable_in_cg` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `discounts_business_id_index` (`business_id`) USING BTREE,
  KEY `discounts_brand_id_index` (`brand_id`) USING BTREE,
  KEY `discounts_category_id_index` (`category_id`) USING BTREE,
  KEY `discounts_location_id_index` (`location_id`) USING BTREE,
  KEY `discounts_priority_index` (`priority`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `document_and_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `document_and_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `notable_id` int(11) NOT NULL,
  `notable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `heading` text COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci,
  `is_private` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `document_and_notes_business_id_index` (`business_id`) USING BTREE,
  KEY `document_and_notes_notable_id_index` (`notable_id`) USING BTREE,
  KEY `document_and_notes_created_by_index` (`created_by`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `document_and_notes` WRITE;
/*!40000 ALTER TABLE `document_and_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `document_and_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `expense_categories_business_id_foreign` (`business_id`) USING BTREE,
  CONSTRAINT `expense_categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`) USING BTREE,
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`) USING BTREE,
  CONSTRAINT `group_sub_taxes_group_tax_id_foreign` FOREIGN KEY (`group_tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `group_sub_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `header_text` text COLLATE utf8mb4_unicode_ci,
  `invoice_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `round_off_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_due_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT '0',
  `client_id_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_time_format` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT '1',
  `show_brand` tinyint(1) NOT NULL DEFAULT '0',
  `show_sku` tinyint(1) NOT NULL DEFAULT '1',
  `show_cat_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `show_lot` tinyint(1) NOT NULL DEFAULT '0',
  `show_image` tinyint(1) NOT NULL DEFAULT '0',
  `show_sale_description` tinyint(1) NOT NULL DEFAULT '0',
  `sales_person_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT '0',
  `table_product_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_qty_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_unit_price_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_subtotal_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_code_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT '0',
  `show_business_name` tinyint(1) NOT NULL DEFAULT '0',
  `show_location_name` tinyint(1) NOT NULL DEFAULT '1',
  `show_landmark` tinyint(1) NOT NULL DEFAULT '1',
  `show_city` tinyint(1) NOT NULL DEFAULT '1',
  `show_state` tinyint(1) NOT NULL DEFAULT '1',
  `show_zip_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_country` tinyint(1) NOT NULL DEFAULT '1',
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT '1',
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT '0',
  `show_email` tinyint(1) NOT NULL DEFAULT '0',
  `show_tax_1` tinyint(1) NOT NULL DEFAULT '1',
  `show_tax_2` tinyint(1) NOT NULL DEFAULT '0',
  `show_barcode` tinyint(1) NOT NULL DEFAULT '0',
  `show_payments` tinyint(1) NOT NULL DEFAULT '0',
  `show_customer` tinyint(1) NOT NULL DEFAULT '0',
  `customer_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `commission_agent_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_commission_agent` tinyint(1) NOT NULL DEFAULT '0',
  `show_reward_point` tinyint(1) NOT NULL DEFAULT '0',
  `highlight_color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `footer_text` text COLLATE utf8mb4_unicode_ci,
  `module_info` text COLLATE utf8mb4_unicode_ci,
  `common_settings` text COLLATE utf8mb4_unicode_ci,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `business_id` int(10) unsigned NOT NULL,
  `show_qr_code` tinyint(1) NOT NULL DEFAULT '0',
  `qr_code_fields` text COLLATE utf8mb4_unicode_ci,
  `design` varchar(190) COLLATE utf8mb4_unicode_ci DEFAULT 'classic',
  `cn_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cn_amount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_tax_headings` text COLLATE utf8mb4_unicode_ci,
  `show_previous_bal` tinyint(1) NOT NULL DEFAULT '0',
  `prev_bal_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `change_return_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_fields` text COLLATE utf8mb4_unicode_ci,
  `contact_custom_fields` text COLLATE utf8mb4_unicode_ci,
  `location_custom_fields` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `invoice_layouts_business_id_foreign` (`business_id`) USING BTREE,
  CONSTRAINT `invoice_layouts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES (1,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,1,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2021-08-31 05:43:53','2021-08-31 05:43:53'),(2,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,0,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,1,1,0,0,0,0,0,1,0,0,0,0,1,0,0,'Customer','Sales Man',1,0,'#000000',NULL,NULL,'{\"proforma_heading\":null,\"due_date_label\":null,\"total_quantity_label\":null,\"item_discount_label\":null,\"num_to_word_format\":\"international\"}',1,2,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2021-09-01 12:23:39','2021-09-01 21:44:51');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheme_type` enum('blank','year') COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT '0',
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `invoice_schemes_business_id_foreign` (`business_id`) USING BTREE,
  KEY `invoice_schemes_scheme_type_index` (`scheme_type`) USING BTREE,
  CONSTRAINT `invoice_schemes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES (1,1,'Default','blank','',1,3,4,1,'2021-08-31 05:43:53','2021-09-21 13:50:23'),(2,2,'Default','blank','',1,365,4,1,'2021-09-01 12:23:39','2021-09-14 22:01:51');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `media`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `file_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `uploaded_by` int(11) DEFAULT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_media_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `media_model_type_model_id_index` (`model_type`,`model_id`) USING BTREE,
  KEY `media_business_id_index` (`business_id`) USING BTREE,
  KEY `media_uploaded_by_index` (`uploaded_by`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `media` WRITE;
/*!40000 ALTER TABLE `media` DISABLE KEYS */;
/*!40000 ALTER TABLE `media` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=285 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2016_06_01_000001_create_oauth_auth_codes_table',1),(4,'2016_06_01_000002_create_oauth_access_tokens_table',1),(5,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(6,'2016_06_01_000004_create_oauth_clients_table',1),(7,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(8,'2017_07_05_071953_create_currencies_table',1),(9,'2017_07_05_073658_create_business_table',1),(10,'2017_07_22_075923_add_business_id_users_table',1),(11,'2017_07_23_113209_create_brands_table',1),(12,'2017_07_26_083429_create_permission_tables',1),(13,'2017_07_26_110000_create_tax_rates_table',1),(14,'2017_07_26_122313_create_units_table',1),(15,'2017_07_27_075706_create_contacts_table',1),(16,'2017_08_04_071038_create_categories_table',1),(17,'2017_08_08_115903_create_products_table',1),(18,'2017_08_09_061616_create_variation_templates_table',1),(19,'2017_08_09_061638_create_variation_value_templates_table',1),(20,'2017_08_10_061146_create_product_variations_table',1),(21,'2017_08_10_061216_create_variations_table',1),(22,'2017_08_19_054827_create_transactions_table',1),(23,'2017_08_31_073533_create_purchase_lines_table',1),(24,'2017_10_15_064638_create_transaction_payments_table',1),(25,'2017_10_31_065621_add_default_sales_tax_to_business_table',1),(26,'2017_11_20_051930_create_table_group_sub_taxes',1),(27,'2017_11_20_063603_create_transaction_sell_lines',1),(28,'2017_11_21_064540_create_barcodes_table',1),(29,'2017_11_23_181237_create_invoice_schemes_table',1),(30,'2017_12_25_122822_create_business_locations_table',1),(31,'2017_12_25_160253_add_location_id_to_transactions_table',1),(32,'2017_12_25_163227_create_variation_location_details_table',1),(33,'2018_01_04_115627_create_sessions_table',1),(34,'2018_01_05_112817_create_invoice_layouts_table',1),(35,'2018_01_06_112303_add_invoice_scheme_id_and_invoice_layout_id_to_business_locations',1),(36,'2018_01_08_104124_create_expense_categories_table',1),(37,'2018_01_08_123327_modify_transactions_table_for_expenses',1),(38,'2018_01_09_111005_modify_payment_status_in_transactions_table',1),(39,'2018_01_09_111109_add_paid_on_column_to_transaction_payments_table',1),(40,'2018_01_25_172439_add_printer_related_fields_to_business_locations_table',1),(41,'2018_01_27_184322_create_printers_table',1),(42,'2018_01_30_181442_create_cash_registers_table',1),(43,'2018_01_31_125836_create_cash_register_transactions_table',1),(44,'2018_02_07_173326_modify_business_table',1),(45,'2018_02_08_105425_add_enable_product_expiry_column_to_business_table',1),(46,'2018_02_08_111027_add_expiry_period_and_expiry_period_type_columns_to_products_table',1),(47,'2018_02_08_131118_add_mfg_date_and_exp_date_purchase_lines_table',1),(48,'2018_02_08_155348_add_exchange_rate_to_transactions_table',1),(49,'2018_02_09_124945_modify_transaction_payments_table_for_contact_payments',1),(50,'2018_02_12_113640_create_transaction_sell_lines_purchase_lines_table',1),(51,'2018_02_12_114605_add_quantity_sold_in_purchase_lines_table',1),(52,'2018_02_13_183323_alter_decimal_fields_size',1),(53,'2018_02_14_161928_add_transaction_edit_days_to_business_table',1),(54,'2018_02_15_161032_add_document_column_to_transactions_table',1),(55,'2018_02_17_124709_add_more_options_to_invoice_layouts',1),(56,'2018_02_19_111517_add_keyboard_shortcut_column_to_business_table',1),(57,'2018_02_19_121537_stock_adjustment_move_to_transaction_table',1),(58,'2018_02_20_165505_add_is_direct_sale_column_to_transactions_table',1),(59,'2018_02_21_105329_create_system_table',1),(60,'2018_02_23_100549_version_1_2',1),(61,'2018_02_23_125648_add_enable_editing_sp_from_purchase_column_to_business_table',1),(62,'2018_02_26_103612_add_sales_commission_agent_column_to_business_table',1),(63,'2018_02_26_130519_modify_users_table_for_sales_cmmsn_agnt',1),(64,'2018_02_26_134500_add_commission_agent_to_transactions_table',1),(65,'2018_02_27_121422_add_item_addition_method_to_business_table',1),(66,'2018_02_27_170232_modify_transactions_table_for_stock_transfer',1),(67,'2018_03_05_153510_add_enable_inline_tax_column_to_business_table',1),(68,'2018_03_06_210206_modify_product_barcode_types',1),(69,'2018_03_13_181541_add_expiry_type_to_business_table',1),(70,'2018_03_16_113446_product_expiry_setting_for_business',1),(71,'2018_03_19_113601_add_business_settings_options',1),(72,'2018_03_26_125334_add_pos_settings_to_business_table',1),(73,'2018_03_26_165350_create_customer_groups_table',1),(74,'2018_03_27_122720_customer_group_related_changes_in_tables',1),(75,'2018_03_29_110138_change_tax_field_to_nullable_in_business_table',1),(76,'2018_03_29_115502_add_changes_for_sr_number_in_products_and_sale_lines_table',1),(77,'2018_03_29_134340_add_inline_discount_fields_in_purchase_lines',1),(78,'2018_03_31_140921_update_transactions_table_exchange_rate',1),(79,'2018_04_03_103037_add_contact_id_to_contacts_table',1),(80,'2018_04_03_122709_add_changes_to_invoice_layouts_table',1),(81,'2018_04_09_135320_change_exchage_rate_size_in_business_table',1),(82,'2018_04_17_123122_add_lot_number_to_business',1),(83,'2018_04_17_160845_add_product_racks_table',1),(84,'2018_04_20_182015_create_res_tables_table',1),(85,'2018_04_24_105246_restaurant_fields_in_transaction_table',1),(86,'2018_04_24_114149_add_enabled_modules_business_table',1),(87,'2018_04_24_133704_add_modules_fields_in_invoice_layout_table',1),(88,'2018_04_27_132653_quotation_related_change',1),(89,'2018_05_02_104439_add_date_format_and_time_format_to_business',1),(90,'2018_05_02_111939_add_sell_return_to_transaction_payments',1),(91,'2018_05_14_114027_add_rows_positions_for_products',1),(92,'2018_05_14_125223_add_weight_to_products_table',1),(93,'2018_05_14_164754_add_opening_stock_permission',1),(94,'2018_05_15_134729_add_design_to_invoice_layouts',1),(95,'2018_05_16_183307_add_tax_fields_invoice_layout',1),(96,'2018_05_18_191956_add_sell_return_to_transaction_table',1),(97,'2018_05_21_131349_add_custom_fileds_to_contacts_table',1),(98,'2018_05_21_131607_invoice_layout_fields_for_sell_return',1),(99,'2018_05_21_131949_add_custom_fileds_and_website_to_business_locations_table',1),(100,'2018_05_22_123527_create_reference_counts_table',1),(101,'2018_05_22_154540_add_ref_no_prefixes_column_to_business_table',1),(102,'2018_05_24_132620_add_ref_no_column_to_transaction_payments_table',1),(103,'2018_05_24_161026_add_location_id_column_to_business_location_table',1),(104,'2018_05_25_180603_create_modifiers_related_table',1),(105,'2018_05_29_121714_add_purchase_line_id_to_stock_adjustment_line_table',1),(106,'2018_05_31_114645_add_res_order_status_column_to_transactions_table',1),(107,'2018_06_05_103530_rename_purchase_line_id_in_stock_adjustment_lines_table',1),(108,'2018_06_05_111905_modify_products_table_for_modifiers',1),(109,'2018_06_06_110524_add_parent_sell_line_id_column_to_transaction_sell_lines_table',1),(110,'2018_06_07_152443_add_is_service_staff_to_roles_table',1),(111,'2018_06_07_182258_add_image_field_to_products_table',1),(112,'2018_06_13_133705_create_bookings_table',1),(113,'2018_06_15_173636_add_email_column_to_contacts_table',1),(114,'2018_06_27_182835_add_superadmin_related_fields_business',1),(115,'2018_07_10_101913_add_custom_fields_to_products_table',1),(116,'2018_07_17_103434_add_sales_person_name_label_to_invoice_layouts_table',1),(117,'2018_07_17_163920_add_theme_skin_color_column_to_business_table',1),(118,'2018_07_24_160319_add_lot_no_line_id_to_transaction_sell_lines_table',1),(119,'2018_07_25_110004_add_show_expiry_and_show_lot_colums_to_invoice_layouts_table',1),(120,'2018_07_25_172004_add_discount_columns_to_transaction_sell_lines_table',1),(121,'2018_07_26_124720_change_design_column_type_in_invoice_layouts_table',1),(122,'2018_07_26_170424_add_unit_price_before_discount_column_to_transaction_sell_line_table',1),(123,'2018_07_28_103614_add_credit_limit_column_to_contacts_table',1),(124,'2018_08_08_110755_add_new_payment_methods_to_transaction_payments_table',1),(125,'2018_08_08_122225_modify_cash_register_transactions_table_for_new_payment_methods',1),(126,'2018_08_14_104036_add_opening_balance_type_to_transactions_table',1),(127,'2018_09_04_155900_create_accounts_table',1),(128,'2018_09_06_114438_create_selling_price_groups_table',1),(129,'2018_09_06_154057_create_variation_group_prices_table',1),(130,'2018_09_07_102413_add_permission_to_access_default_selling_price',1),(131,'2018_09_07_134858_add_selling_price_group_id_to_transactions_table',1),(132,'2018_09_10_112448_update_product_type_to_single_if_null_in_products_table',1),(133,'2018_09_10_152703_create_account_transactions_table',1),(134,'2018_09_10_173656_add_account_id_column_to_transaction_payments_table',1),(135,'2018_09_19_123914_create_notification_templates_table',1),(136,'2018_09_22_110504_add_sms_and_email_settings_columns_to_business_table',1),(137,'2018_09_24_134942_add_lot_no_line_id_to_stock_adjustment_lines_table',1),(138,'2018_09_26_105557_add_transaction_payments_for_existing_expenses',1),(139,'2018_09_27_111609_modify_transactions_table_for_purchase_return',1),(140,'2018_09_27_131154_add_quantity_returned_column_to_purchase_lines_table',1),(141,'2018_10_02_131401_add_return_quantity_column_to_transaction_sell_lines_table',1),(142,'2018_10_03_104918_add_qty_returned_column_to_transaction_sell_lines_purchase_lines_table',1),(143,'2018_10_03_185947_add_default_notification_templates_to_database',1),(144,'2018_10_09_153105_add_business_id_to_transaction_payments_table',1),(145,'2018_10_16_135229_create_permission_for_sells_and_purchase',1),(146,'2018_10_22_114441_add_columns_for_variable_product_modifications',1),(147,'2018_10_22_134428_modify_variable_product_data',1),(148,'2018_10_30_181558_add_table_tax_headings_to_invoice_layout',1),(149,'2018_10_31_122619_add_pay_terms_field_transactions_table',1),(150,'2018_10_31_161328_add_new_permissions_for_pos_screen',1),(151,'2018_10_31_174752_add_access_selected_contacts_only_to_users_table',1),(152,'2018_10_31_175627_add_user_contact_access',1),(153,'2018_10_31_180559_add_auto_send_sms_column_to_notification_templates_table',1),(154,'2018_11_02_171949_change_card_type_column_to_varchar_in_transaction_payments_table',1),(155,'2018_11_08_105621_add_role_permissions',1),(156,'2018_11_26_114135_add_is_suspend_column_to_transactions_table',1),(157,'2018_11_28_104410_modify_units_table_for_multi_unit',1),(158,'2018_11_28_170952_add_sub_unit_id_to_purchase_lines_and_sell_lines',1),(159,'2018_11_29_115918_add_primary_key_in_system_table',1),(160,'2018_12_03_185546_add_product_description_column_to_products_table',1),(161,'2018_12_06_114937_modify_system_table_and_users_table',1),(162,'2018_12_13_160007_add_custom_fields_display_options_to_invoice_layouts_table',1),(163,'2018_12_14_103307_modify_system_table',1),(164,'2018_12_18_133837_add_prev_balance_due_columns_to_invoice_layouts_table',1),(165,'2018_12_18_170656_add_invoice_token_column_to_transaction_table',1),(166,'2018_12_20_133639_add_date_time_format_column_to_invoice_layouts_table',1),(167,'2018_12_21_120659_add_recurring_invoice_fields_to_transactions_table',1),(168,'2018_12_24_154933_create_notifications_table',1),(169,'2019_01_08_112015_add_document_column_to_transaction_payments_table',1),(170,'2019_01_10_124645_add_account_permission',1),(171,'2019_01_16_125825_add_subscription_no_column_to_transactions_table',1),(172,'2019_01_28_111647_add_order_addresses_column_to_transactions_table',1),(173,'2019_02_13_173821_add_is_inactive_column_to_products_table',1),(174,'2019_02_19_103118_create_discounts_table',1),(175,'2019_02_21_120324_add_discount_id_column_to_transaction_sell_lines_table',1),(176,'2019_02_21_134324_add_permission_for_discount',1),(177,'2019_03_04_170832_add_service_staff_columns_to_transaction_sell_lines_table',1),(178,'2019_03_09_102425_add_sub_type_column_to_transactions_table',1),(179,'2019_03_09_124457_add_indexing_transaction_sell_lines_purchase_lines_table',1),(180,'2019_03_12_120336_create_activity_log_table',1),(181,'2019_03_15_132925_create_media_table',1),(182,'2019_05_08_130339_add_indexing_to_parent_id_in_transaction_payments_table',1),(183,'2019_05_10_132311_add_missing_column_indexing',1),(184,'2019_05_14_091812_add_show_image_column_to_invoice_layouts_table',1),(185,'2019_05_25_104922_add_view_purchase_price_permission',1),(186,'2019_06_17_103515_add_profile_informations_columns_to_users_table',1),(187,'2019_06_18_135524_add_permission_to_view_own_sales_only',1),(188,'2019_06_19_112058_add_database_changes_for_reward_points',1),(189,'2019_06_28_133732_change_type_column_to_string_in_transactions_table',1),(190,'2019_07_13_111420_add_is_created_from_api_column_to_transactions_table',1),(191,'2019_07_15_165136_add_fields_for_combo_product',1),(192,'2019_07_19_103446_add_mfg_quantity_used_column_to_purchase_lines_table',1),(193,'2019_07_22_152649_add_not_for_selling_in_product_table',1),(194,'2019_07_29_185351_add_show_reward_point_column_to_invoice_layouts_table',1),(195,'2019_08_08_162302_add_sub_units_related_fields',1),(196,'2019_08_26_133419_update_price_fields_decimal_point',1),(197,'2019_09_02_160054_remove_location_permissions_from_roles',1),(198,'2019_09_03_185259_add_permission_for_pos_screen',1),(199,'2019_09_04_163141_add_location_id_to_cash_registers_table',1),(200,'2019_09_04_184008_create_types_of_services_table',1),(201,'2019_09_06_131445_add_types_of_service_fields_to_transactions_table',1),(202,'2019_09_09_134810_add_default_selling_price_group_id_column_to_business_locations_table',1),(203,'2019_09_12_105616_create_product_locations_table',1),(204,'2019_09_17_122522_add_custom_labels_column_to_business_table',1),(205,'2019_09_18_164319_add_shipping_fields_to_transactions_table',1),(206,'2019_09_19_170927_close_all_active_registers',1),(207,'2019_09_23_161906_add_media_description_cloumn_to_media_table',1),(208,'2019_10_18_155633_create_account_types_table',1),(209,'2019_10_22_163335_add_common_settings_column_to_business_table',1),(210,'2019_10_29_132521_add_update_purchase_status_permission',1),(211,'2019_11_09_110522_add_indexing_to_lot_number',1),(212,'2019_11_19_170824_add_is_active_column_to_business_locations_table',1),(213,'2019_11_21_162913_change_quantity_field_types_to_decimal',1),(214,'2019_11_25_160340_modify_categories_table_for_polymerphic_relationship',1),(215,'2019_12_02_105025_create_warranties_table',1),(216,'2019_12_03_180342_add_common_settings_field_to_invoice_layouts_table',1),(217,'2019_12_05_183955_add_more_fields_to_users_table',1),(218,'2019_12_06_174904_add_change_return_label_column_to_invoice_layouts_table',1),(219,'2019_12_11_121307_add_draft_and_quotation_list_permissions',1),(220,'2019_12_12_180126_copy_expense_total_to_total_before_tax',1),(221,'2019_12_19_181412_make_alert_quantity_field_nullable_on_products_table',1),(222,'2019_12_25_173413_create_dashboard_configurations_table',1),(223,'2020_01_08_133506_create_document_and_notes_table',1),(224,'2020_01_09_113252_add_cc_bcc_column_to_notification_templates_table',1),(225,'2020_01_16_174818_add_round_off_amount_field_to_transactions_table',1),(226,'2020_01_28_162345_add_weighing_scale_settings_in_business_settings_table',1),(227,'2020_02_18_172447_add_import_fields_to_transactions_table',1),(228,'2020_03_13_135844_add_is_active_column_to_selling_price_groups_table',1),(229,'2020_03_16_115449_add_contact_status_field_to_contacts_table',1),(230,'2020_03_26_124736_add_allow_login_column_in_users_table',1),(231,'2020_04_13_154150_add_feature_products_column_to_business_loactions',1),(232,'2020_04_15_151802_add_user_type_to_users_table',1),(233,'2020_04_22_153905_add_subscription_repeat_on_column_to_transactions_table',1),(234,'2020_04_28_111436_add_shipping_address_to_contacts_table',1),(235,'2020_06_01_094654_add_max_sale_discount_column_to_users_table',1),(236,'2020_06_12_162245_modify_contacts_table',1),(237,'2020_06_22_103104_change_recur_interval_default_to_one',1),(238,'2020_07_09_174621_add_balance_field_to_contacts_table',1),(239,'2020_07_23_104933_change_status_column_to_varchar_in_transaction_table',1),(240,'2020_09_07_171059_change_completed_stock_transfer_status_to_final',1),(241,'2020_09_21_123224_modify_booking_status_column_in_bookings_table',1),(242,'2020_09_22_121639_create_discount_variations_table',1),(243,'2020_10_05_121550_modify_business_location_table_for_invoice_layout',1),(244,'2020_10_16_175726_set_status_as_received_for_opening_stock',1),(245,'2020_10_23_170823_add_for_group_tax_column_to_tax_rates_table',1),(246,'2020_11_04_130940_add_more_custom_fields_to_contacts_table',1),(247,'2020_11_10_152841_add_cash_register_permissions',1),(248,'2020_11_17_164041_modify_type_column_to_varchar_in_contacts_table',1),(249,'2020_12_18_181447_add_shipping_custom_fields_to_transactions_table',1),(250,'2020_12_22_164303_add_sub_status_column_to_transactions_table',1),(251,'2020_12_24_153050_add_custom_fields_to_transactions_table',1),(252,'2020_12_28_105403_add_whatsapp_text_column_to_notification_templates_table',1),(253,'2020_12_29_165925_add_model_document_type_to_media_table',1),(254,'2021_02_08_175632_add_contact_number_fields_to_users_table',1),(255,'2021_02_11_172217_add_indexing_for_multiple_columns',1),(256,'2021_02_23_122043_add_more_columns_to_customer_groups_table',1),(257,'2021_02_24_175551_add_print_invoice_permission_to_all_roles',1),(258,'2021_03_03_162021_add_purchase_order_columns_to_purchase_lines_and_transactions_table',1),(259,'2021_03_11_120229_add_sales_order_columns',1),(260,'2021_03_16_120705_add_business_id_to_activity_log_table',1),(261,'2021_03_16_153427_add_code_columns_to_business_table',1),(262,'2021_03_18_173308_add_account_details_column_to_accounts_table',1),(263,'2021_03_18_183119_add_prefer_payment_account_columns_to_transactions_table',1),(264,'2021_03_22_120810_add_more_types_of_service_custom_fields',1),(265,'2021_03_24_183132_add_shipping_export_custom_field_details_to_contacts_table',1),(266,'2021_03_25_170715_add_export_custom_fields_info_to_transactions_table',1),(267,'2021_04_15_063449_add_denominations_column_to_cash_registers_table',1),(268,'2021_05_22_083426_add_indexing_to_account_transactions_table',1),(269,'2021_07_08_065808_add_additional_expense_columns_to_transaction_table',1),(270,'2021_07_13_082918_add_qr_code_columns_to_invoice_layouts_table',1),(271,'2021_07_21_061615_add_fields_to_show_commission_agent_in_invoice_layout',1),(272,'2021_08_13_105549_add_crm_contact_id_to_users_table',1),(273,'2018_06_27_185405_create_packages_table',2),(274,'2018_06_28_182803_create_subscriptions_table',2),(275,'2018_07_17_182021_add_rows_to_system_table',2),(276,'2018_07_19_131721_add_options_to_packages_table',2),(277,'2018_08_17_155534_add_min_termination_alert_days',2),(278,'2018_08_28_105945_add_business_based_username_settings_to_system_table',2),(279,'2018_08_30_105906_add_superadmin_communicator_logs_table',2),(280,'2018_11_02_130636_add_custom_permissions_to_packages_table',2),(281,'2018_11_05_161848_add_more_fields_to_packages_table',2),(282,'2018_12_10_124621_modify_system_table_values_null_default',2),(283,'2019_05_10_135434_add_missing_database_column_indexes',2),(284,'2019_08_16_115300_create_superadmin_frontend_pages_table',2);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`) USING BTREE,
  KEY `model_has_permissions_model_type_model_id_index` (`model_type`,`model_id`) USING BTREE,
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
INSERT INTO `model_has_permissions` VALUES (83,'App\\User',3),(83,'App\\User',4),(83,'App\\User',5),(83,'App\\User',6),(83,'App\\User',7),(83,'App\\User',8),(86,'App\\User',9),(86,'App\\User',10),(86,'App\\User',11),(86,'App\\User',12),(86,'App\\User',13),(86,'App\\User',14);
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`) USING BTREE,
  KEY `model_has_roles_model_type_model_id_index` (`model_type`,`model_id`) USING BTREE,
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,'App\\User',1),(3,'App\\User',2),(4,'App\\User',3),(4,'App\\User',9);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `template_for` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_body` text COLLATE utf8mb4_unicode_ci,
  `sms_body` text COLLATE utf8mb4_unicode_ci,
  `whatsapp_text` text COLLATE utf8mb4_unicode_ci,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cc` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bcc` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT '0',
  `auto_send_sms` tinyint(1) NOT NULL DEFAULT '0',
  `auto_send_wa_notif` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES (1,1,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2021-08-31 05:43:53','2021-08-31 05:43:53'),(2,1,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2021-08-31 05:43:53','2021-08-31 05:43:53'),(3,1,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2021-08-31 05:43:53','2021-08-31 05:43:53'),(4,1,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2021-08-31 05:43:53','2021-08-31 05:43:53'),(5,1,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2021-08-31 05:43:53','2021-08-31 05:43:53'),(6,1,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2021-08-31 05:43:53','2021-08-31 05:43:53'),(7,1,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2021-08-31 05:43:53','2021-08-31 05:43:53'),(8,1,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2021-08-31 05:43:53','2021-08-31 05:43:53'),(9,1,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2021-08-31 05:43:53','2021-08-31 05:43:53'),(10,2,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2021-09-01 12:23:39','2021-09-01 12:23:39'),(11,2,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2021-09-01 12:23:39','2021-09-01 12:23:39'),(12,2,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2021-09-01 12:23:39','2021-09-01 12:23:39'),(13,2,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2021-09-01 12:23:39','2021-09-01 12:23:39'),(14,2,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2021-09-01 12:23:39','2021-09-01 12:23:39'),(15,2,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2021-09-01 12:23:39','2021-09-01 12:23:39'),(16,2,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2021-09-01 12:23:39','2021-09-01 12:23:39'),(17,2,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2021-09-01 12:23:39','2021-09-01 12:23:39'),(18,2,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2021-09-01 12:23:39','2021-09-01 12:23:39');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notifications` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `oauth_access_tokens_user_id_index` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `redirect` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `oauth_clients_user_id_index` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `oauth_personal_access_clients_client_id_index` (`client_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `access_token_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `packages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_count` int(11) NOT NULL COMMENT 'No. of Business Locations, 0 = infinite option.',
  `user_count` int(11) NOT NULL,
  `product_count` int(11) NOT NULL,
  `bookings` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Enable/Disable bookings',
  `kitchen` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Enable/Disable kitchen',
  `order_screen` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Enable/Disable order_screen',
  `tables` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Enable/Disable tables',
  `invoice_count` int(11) NOT NULL,
  `interval` enum('days','months','years') COLLATE utf8mb4_unicode_ci NOT NULL,
  `interval_count` int(11) NOT NULL,
  `trial_days` int(11) NOT NULL,
  `price` decimal(22,4) NOT NULL,
  `custom_permissions` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` int(11) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT '0',
  `is_one_time` tinyint(1) NOT NULL DEFAULT '0',
  `enable_custom_link` tinyint(1) NOT NULL DEFAULT '0',
  `custom_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_link_text` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `packages` WRITE;
/*!40000 ALTER TABLE `packages` DISABLE KEYS */;
INSERT INTO `packages` VALUES (1,'POS Version 2','POS Version 2 Location 7 Users',2,7,0,0,0,0,0,0,'years',5,15,632.5000,'',1,1,1,0,0,0,'','',NULL,'2021-08-31 02:21:44','2021-09-01 12:24:29'),(2,'POS Version 1','POS Version 1 Location 3 Users',1,3,0,0,0,0,0,0,'years',5,15,320.0000,'',1,0,1,0,0,0,'','',NULL,'2021-08-31 02:24:06','2021-08-31 02:24:06'),(3,'POS Version 3','POS Version 3 Location 12 Users',3,12,0,0,0,0,0,0,'years',5,15,865.0000,'',1,1,1,0,0,0,'','',NULL,'2021-08-31 02:25:42','2021-08-31 02:25:42'),(4,'POS Version 4','POS Version 4 Location 16 Users',4,18,0,0,0,0,0,0,'years',5,15,1090.0000,'',1,1,1,0,0,0,'','',NULL,'2021-08-31 02:27:19','2021-08-31 02:27:44'),(5,'POS Version 5','POS Version 5 Location 25 Users',5,25,0,0,0,0,0,0,'years',5,15,1280.0000,'',1,1,1,0,0,0,'','',NULL,'2021-08-31 02:29:06','2021-08-31 02:29:06'),(6,'POS Version 10','POS Version 10 Location 75 Users',10,75,0,0,0,0,0,0,'years',5,15,2200.0000,'',1,1,1,0,0,0,'','',NULL,'2021-08-31 02:30:58','2021-08-31 02:30:58');
/*!40000 ALTER TABLE `packages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'profit_loss_report.view','web','2021-08-31 05:39:52',NULL),(2,'direct_sell.access','web','2021-08-31 05:39:52',NULL),(3,'product.opening_stock','web','2021-08-31 05:40:05','2021-08-31 05:40:05'),(4,'crud_all_bookings','web','2021-08-31 05:40:10','2021-08-31 05:40:10'),(5,'crud_own_bookings','web','2021-08-31 05:40:10','2021-08-31 05:40:10'),(6,'access_default_selling_price','web','2021-08-31 05:40:18','2021-08-31 05:40:18'),(7,'purchase.payments','web','2021-08-31 05:40:23','2021-08-31 05:40:23'),(8,'sell.payments','web','2021-08-31 05:40:23','2021-08-31 05:40:23'),(9,'edit_product_price_from_sale_screen','web','2021-08-31 05:40:24','2021-08-31 05:40:24'),(10,'edit_product_discount_from_sale_screen','web','2021-08-31 05:40:24','2021-08-31 05:40:24'),(11,'roles.view','web','2021-08-31 05:40:26','2021-08-31 05:40:26'),(12,'roles.create','web','2021-08-31 05:40:26','2021-08-31 05:40:26'),(13,'roles.update','web','2021-08-31 05:40:26','2021-08-31 05:40:26'),(14,'roles.delete','web','2021-08-31 05:40:26','2021-08-31 05:40:26'),(15,'account.access','web','2021-08-31 05:40:30','2021-08-31 05:40:30'),(16,'discount.access','web','2021-08-31 05:40:31','2021-08-31 05:40:31'),(17,'view_purchase_price','web','2021-08-31 05:40:35','2021-08-31 05:40:35'),(18,'view_own_sell_only','web','2021-08-31 05:40:35','2021-08-31 05:40:35'),(19,'edit_product_discount_from_pos_screen','web','2021-08-31 05:40:40','2021-08-31 05:40:40'),(20,'edit_product_price_from_pos_screen','web','2021-08-31 05:40:40','2021-08-31 05:40:40'),(21,'access_shipping','web','2021-08-31 05:40:43','2021-08-31 05:40:43'),(22,'purchase.update_status','web','2021-08-31 05:40:44','2021-08-31 05:40:44'),(23,'list_drafts','web','2021-08-31 05:40:46','2021-08-31 05:40:46'),(24,'list_quotations','web','2021-08-31 05:40:46','2021-08-31 05:40:46'),(25,'view_cash_register','web','2021-08-31 05:40:58','2021-08-31 05:40:58'),(26,'close_cash_register','web','2021-08-31 05:40:58','2021-08-31 05:40:58'),(27,'print_invoice','web','2021-08-31 05:41:09','2021-08-31 05:41:09'),(28,'user.view','web','2021-08-31 05:41:17',NULL),(29,'user.create','web','2021-08-31 05:41:17',NULL),(30,'user.update','web','2021-08-31 05:41:17',NULL),(31,'user.delete','web','2021-08-31 05:41:17',NULL),(32,'supplier.view','web','2021-08-31 05:41:17',NULL),(33,'supplier.create','web','2021-08-31 05:41:17',NULL),(34,'supplier.update','web','2021-08-31 05:41:17',NULL),(35,'supplier.delete','web','2021-08-31 05:41:17',NULL),(36,'customer.view','web','2021-08-31 05:41:17',NULL),(37,'customer.create','web','2021-08-31 05:41:17',NULL),(38,'customer.update','web','2021-08-31 05:41:17',NULL),(39,'customer.delete','web','2021-08-31 05:41:17',NULL),(40,'product.view','web','2021-08-31 05:41:17',NULL),(41,'product.create','web','2021-08-31 05:41:17',NULL),(42,'product.update','web','2021-08-31 05:41:17',NULL),(43,'product.delete','web','2021-08-31 05:41:17',NULL),(44,'purchase.view','web','2021-08-31 05:41:17',NULL),(45,'purchase.create','web','2021-08-31 05:41:17',NULL),(46,'purchase.update','web','2021-08-31 05:41:17',NULL),(47,'purchase.delete','web','2021-08-31 05:41:17',NULL),(48,'sell.view','web','2021-08-31 05:41:17',NULL),(49,'sell.create','web','2021-08-31 05:41:17',NULL),(50,'sell.update','web','2021-08-31 05:41:17',NULL),(51,'sell.delete','web','2021-08-31 05:41:17',NULL),(52,'purchase_n_sell_report.view','web','2021-08-31 05:41:17',NULL),(53,'contacts_report.view','web','2021-08-31 05:41:17',NULL),(54,'stock_report.view','web','2021-08-31 05:41:17',NULL),(55,'tax_report.view','web','2021-08-31 05:41:17',NULL),(56,'trending_product_report.view','web','2021-08-31 05:41:17',NULL),(57,'register_report.view','web','2021-08-31 05:41:17',NULL),(58,'sales_representative.view','web','2021-08-31 05:41:17',NULL),(59,'expense_report.view','web','2021-08-31 05:41:17',NULL),(60,'business_settings.access','web','2021-08-31 05:41:17',NULL),(61,'barcode_settings.access','web','2021-08-31 05:41:17',NULL),(62,'invoice_settings.access','web','2021-08-31 05:41:17',NULL),(63,'brand.view','web','2021-08-31 05:41:17',NULL),(64,'brand.create','web','2021-08-31 05:41:17',NULL),(65,'brand.update','web','2021-08-31 05:41:17',NULL),(66,'brand.delete','web','2021-08-31 05:41:17',NULL),(67,'tax_rate.view','web','2021-08-31 05:41:17',NULL),(68,'tax_rate.create','web','2021-08-31 05:41:17',NULL),(69,'tax_rate.update','web','2021-08-31 05:41:17',NULL),(70,'tax_rate.delete','web','2021-08-31 05:41:17',NULL),(71,'unit.view','web','2021-08-31 05:41:17',NULL),(72,'unit.create','web','2021-08-31 05:41:17',NULL),(73,'unit.update','web','2021-08-31 05:41:17',NULL),(74,'unit.delete','web','2021-08-31 05:41:17',NULL),(75,'category.view','web','2021-08-31 05:41:17',NULL),(76,'category.create','web','2021-08-31 05:41:17',NULL),(77,'category.update','web','2021-08-31 05:41:17',NULL),(78,'category.delete','web','2021-08-31 05:41:17',NULL),(79,'expense.access','web','2021-08-31 05:41:17',NULL),(80,'access_all_locations','web','2021-08-31 05:41:17',NULL),(81,'dashboard.data','web','2021-08-31 05:41:17',NULL),(82,'location.1','web','2021-08-31 05:43:53','2021-08-31 05:43:53'),(83,'location.2','web','2021-09-01 12:23:39','2021-09-01 12:23:39'),(84,'selling_price_group.1','web','2021-09-01 16:35:56','2021-09-01 16:35:56'),(85,'access_own_sell_return','web','2021-09-01 21:30:17','2021-09-01 21:30:17'),(86,'location.3','web','2021-09-01 22:18:22','2021-09-01 22:18:22'),(87,'expense.add','web','2021-09-04 17:29:36','2021-09-04 17:29:36'),(88,'view_own_expense','web','2021-09-04 17:29:36','2021-09-04 17:29:36'),(89,'access_sell_return','web','2021-09-05 21:24:20','2021-09-05 21:24:20'),(90,'direct_sell.view','web','2021-09-05 21:24:20','2021-09-05 21:24:20'),(91,'selling_price_group.2','web','2021-09-07 11:25:37','2021-09-07 11:25:37');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection_type` enum('network','windows','linux') COLLATE utf8mb4_unicode_ci NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `port` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `printers_business_id_foreign` (`business_id`) USING BTREE,
  CONSTRAINT `printers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_locations` (
  `product_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  KEY `product_locations_product_id_index` (`product_id`) USING BTREE,
  KEY `product_locations_location_id_index` (`location_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_locations` WRITE;
/*!40000 ALTER TABLE `product_locations` DISABLE KEYS */;
INSERT INTO `product_locations` VALUES (1,2),(2,2),(3,2),(4,2),(5,2),(6,2),(7,2),(8,2),(9,2),(10,2),(11,2),(12,2),(13,2),(14,2),(15,2),(16,2),(17,2),(18,2),(19,2),(21,2),(22,2),(23,2),(24,2),(25,2),(26,2),(27,2),(28,2),(29,2),(30,2),(31,2),(32,2),(33,2),(34,2),(35,2),(36,2),(37,2),(38,2),(39,2),(40,2),(41,2),(42,2),(43,2),(44,2),(45,2),(46,2),(47,2),(48,2),(49,2),(50,2),(51,2),(52,2),(53,2),(54,2),(55,2),(56,2),(57,2),(58,2),(59,2),(60,2),(61,2),(62,2),(63,2),(64,2),(65,2),(66,2),(67,2),(68,2),(69,2),(70,2),(71,2),(72,2),(73,2),(74,2),(75,2),(76,2),(1,3),(2,3),(3,3),(4,3),(5,3),(6,3),(7,3),(8,3),(9,3),(10,3),(11,3),(12,3),(13,3),(14,3),(15,3),(16,3),(17,3),(18,3),(19,3),(20,3),(21,3),(23,3),(24,3),(25,3),(26,3),(27,3),(28,3),(29,3),(30,3),(31,3),(32,3),(33,3),(34,3),(35,3),(36,3),(37,3),(38,3),(39,3),(40,3),(41,3),(42,3),(43,3),(44,3),(45,3),(46,3),(47,3),(48,3),(49,3),(50,3),(51,3),(52,3),(53,3),(54,3),(55,3),(56,3),(57,3),(58,3),(59,3),(60,3),(61,3),(62,3),(63,3),(64,3),(65,3),(66,3),(67,3),(68,3),(69,3),(70,3),(71,3),(72,3),(73,3),(75,3),(76,3),(77,3),(78,3),(79,3),(80,3),(81,3),(82,3),(83,3),(84,3),(85,3),(86,3),(74,3),(87,3),(78,2),(20,2),(88,1),(89,1);
/*!40000 ALTER TABLE `product_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `row` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `product_racks_business_id_index` (`business_id`) USING BTREE,
  KEY `product_racks_location_id_index` (`location_id`) USING BTREE,
  KEY `product_racks_product_id_index` (`product_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_template_id` int(11) DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `product_variations_name_index` (`name`) USING BTREE,
  KEY `product_variations_product_id_index` (`product_id`) USING BTREE,
  CONSTRAINT `product_variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES (1,8,'Tracksuit Colors',1,0,'2021-09-01 18:53:57','2021-09-01 18:53:57'),(2,8,'Tracksuit Colors',2,0,'2021-09-01 19:34:16','2021-09-01 19:34:16'),(3,2,'JeansColors',3,0,'2021-09-01 19:38:06','2021-09-01 19:38:06'),(4,2,'JeansColors',4,0,'2021-09-01 19:39:19','2021-09-01 19:39:19'),(5,2,'JeansColors',5,0,'2021-09-01 19:40:36','2021-09-01 19:40:36'),(6,2,'JeansColors',6,0,'2021-09-01 19:40:57','2021-09-01 19:40:57'),(7,2,'JeansColors',7,0,'2021-09-01 19:42:01','2021-09-01 19:42:01'),(8,1,'Chino Colors',8,0,'2021-09-01 19:43:00','2021-09-01 19:43:00'),(9,2,'JeansColors',9,0,'2021-09-01 19:44:38','2021-09-01 19:44:38'),(10,2,'JeansColors',10,0,'2021-09-01 19:46:57','2021-09-01 19:46:57'),(11,2,'JeansColors',11,0,'2021-09-01 19:49:00','2021-09-01 19:49:00'),(12,1,'Chino Colors',12,0,'2021-09-01 19:49:25','2021-09-01 19:49:25'),(13,1,'Chino Colors',13,0,'2021-09-01 19:50:16','2021-09-01 19:50:16'),(14,1,'Chino Colors',14,0,'2021-09-01 19:51:00','2021-09-01 19:51:00'),(15,2,'JeansColors',15,0,'2021-09-01 19:51:28','2021-09-01 19:51:28'),(16,1,'Chino Colors',16,0,'2021-09-01 19:51:36','2021-09-01 19:51:36'),(17,1,'Chino Colors',17,0,'2021-09-01 19:52:24','2021-09-01 19:52:24'),(18,2,'JeansColors',18,0,'2021-09-01 19:52:45','2021-09-01 19:52:45'),(19,6,'Sweatpant Colors',19,0,'2021-09-01 19:53:20','2021-09-01 19:53:20'),(20,2,'JeansColors',20,0,'2021-09-01 19:53:37','2021-09-01 19:53:37'),(21,6,'Sweatpant Colors',21,0,'2021-09-01 19:54:15','2021-09-01 19:54:15'),(23,5,'Short Colors',23,0,'2021-09-01 19:55:01','2021-09-01 19:55:01'),(24,7,'Swimshort Colors',24,0,'2021-09-01 19:56:01','2021-09-01 19:56:01'),(25,7,'Swimshort Colors',25,0,'2021-09-01 19:57:13','2021-09-01 19:57:13'),(26,7,'Swimshort Colors',26,0,'2021-09-01 20:00:00','2021-09-01 20:00:00'),(27,8,'Tracksuit Colors',27,0,'2021-09-01 20:00:36','2021-09-01 20:00:36'),(28,7,'Swimshort Colors',28,0,'2021-09-01 20:01:52','2021-09-01 20:01:52'),(29,7,'Swimshort Colors',29,0,'2021-09-01 20:03:32','2021-09-01 20:03:32'),(30,4,'Shirt Colors',30,0,'2021-09-01 20:03:53','2021-09-01 20:03:53'),(31,7,'Swimshort Colors',31,0,'2021-09-01 20:04:13','2021-09-01 20:04:13'),(32,7,'Swimshort Colors',32,0,'2021-09-01 20:05:33','2021-09-01 20:05:33'),(33,7,'Swimshort Colors',33,0,'2021-09-01 20:06:19','2021-09-01 20:06:19'),(34,7,'Swimshort Colors',34,0,'2021-09-01 20:07:26','2021-09-01 20:07:26'),(35,7,'Swimshort Colors',35,0,'2021-09-01 20:08:15','2021-09-01 20:08:15'),(36,7,'Swimshort Colors',36,0,'2021-09-01 20:09:01','2021-09-01 20:09:01'),(37,7,'Swimshort Colors',37,0,'2021-09-01 20:09:42','2021-09-01 20:09:42'),(38,7,'Swimshort Colors',38,0,'2021-09-01 20:10:37','2021-09-01 20:10:37'),(39,7,'Swimshort Colors',39,0,'2021-09-01 20:11:25','2021-09-01 20:11:25'),(40,7,'Swimshort Colors',40,0,'2021-09-01 20:12:08','2021-09-01 20:12:08'),(41,7,'Swimshort Colors',41,0,'2021-09-01 20:12:50','2021-09-01 20:12:50'),(42,7,'Swimshort Colors',42,0,'2021-09-01 20:13:34','2021-09-01 20:13:34'),(43,7,'Swimshort Colors',43,0,'2021-09-01 20:14:19','2021-09-01 20:14:19'),(44,7,'Swimshort Colors',44,0,'2021-09-01 20:14:55','2021-09-01 20:14:55'),(45,4,'Shirt Colors',45,0,'2021-09-01 20:19:18','2021-09-01 20:19:18'),(46,4,'Shirt Colors',46,0,'2021-09-01 20:20:18','2021-09-01 20:20:18'),(47,4,'Shirt Colors',47,0,'2021-09-01 20:21:11','2021-09-01 20:21:11'),(48,4,'Shirt Colors',48,0,'2021-09-01 20:22:06','2021-09-01 20:22:06'),(49,4,'Shirt Colors',49,0,'2021-09-01 20:22:49','2021-09-01 20:22:49'),(50,4,'Shirt Colors',50,0,'2021-09-01 20:23:51','2021-09-01 20:23:51'),(51,4,'Shirt Colors',51,0,'2021-09-01 20:25:05','2021-09-01 20:25:05'),(52,4,'Shirt Colors',52,0,'2021-09-01 20:25:46','2021-09-01 20:25:46'),(53,9,'T-shirt Colors',53,0,'2021-09-01 20:26:36','2021-09-01 20:26:36'),(54,9,'T-shirt Colors',54,0,'2021-09-01 20:27:18','2021-09-01 20:27:18'),(55,9,'T-shirt Colors',55,0,'2021-09-01 20:28:11','2021-09-01 20:28:11'),(56,9,'T-shirt Colors',56,0,'2021-09-01 20:28:58','2021-09-01 20:28:58'),(57,9,'T-shirt Colors',57,0,'2021-09-01 20:29:45','2021-09-01 20:29:45'),(58,9,'T-shirt Colors',58,0,'2021-09-01 20:30:23','2021-09-01 20:30:23'),(59,9,'T-shirt Colors',59,0,'2021-09-01 20:31:27','2021-09-01 20:31:27'),(60,9,'T-shirt Colors',60,0,'2021-09-01 20:32:10','2021-09-01 20:32:10'),(61,9,'T-shirt Colors',61,0,'2021-09-01 20:32:52','2021-09-01 20:32:52'),(62,9,'T-shirt Colors',62,0,'2021-09-01 20:33:37','2021-09-01 20:33:37'),(63,9,'T-shirt Colors',63,0,'2021-09-01 20:34:17','2021-09-01 20:34:17'),(64,9,'T-shirt Colors',64,0,'2021-09-01 20:35:28','2021-09-01 20:35:28'),(65,9,'T-shirt Colors',65,0,'2021-09-01 20:36:16','2021-09-01 20:36:16'),(66,3,'Polo Colors',66,0,'2021-09-01 20:37:26','2021-09-01 20:37:26'),(67,3,'Polo Colors',67,0,'2021-09-01 20:38:46','2021-09-01 20:38:46'),(68,3,'Polo Colors',68,0,'2021-09-01 20:39:29','2021-09-01 20:39:29'),(69,3,'Polo Colors',69,0,'2021-09-01 20:40:07','2021-09-01 20:40:07'),(70,3,'Polo Colors',70,0,'2021-09-01 20:40:50','2021-09-01 20:40:50'),(71,3,'Polo Colors',71,0,'2021-09-01 20:41:27','2021-09-01 20:41:27'),(72,3,'Polo Colors',72,0,'2021-09-01 20:42:00','2021-09-01 20:42:00'),(73,3,'Polo Colors',73,0,'2021-09-01 20:42:35','2021-09-01 20:42:35'),(74,3,'Polo Colors',74,0,'2021-09-01 20:43:11','2021-09-01 20:43:11'),(75,3,'Polo Colors',75,0,'2021-09-01 20:43:51','2021-09-01 20:43:51'),(76,3,'Polo Colors',76,0,'2021-09-01 20:44:34','2021-09-01 20:44:34'),(77,2,'JeansColors',77,0,'2021-09-02 03:08:42','2021-09-02 03:08:42'),(78,1,'Chino Colors',78,0,'2021-09-02 03:10:57','2021-09-02 03:10:57'),(79,5,'Short Colors',79,0,'2021-09-02 03:21:55','2021-09-02 03:21:55'),(80,7,'Swimshort Colors',80,0,'2021-09-02 03:27:54','2021-09-02 03:27:54'),(81,7,'Swimshort Colors',81,0,'2021-09-02 03:30:42','2021-09-02 03:30:42'),(82,4,'Shirt Colors',82,0,'2021-09-02 03:52:32','2021-09-02 03:52:32'),(83,4,'Shirt Colors',83,0,'2021-09-02 03:54:34','2021-09-02 03:54:34'),(84,9,'T-shirt Colors',84,0,'2021-09-02 03:58:17','2021-09-02 03:58:17'),(85,9,'T-shirt Colors',85,0,'2021-09-02 04:06:49','2021-09-02 04:06:49'),(86,9,'T-shirt Colors',86,0,'2021-09-02 04:08:44','2021-09-02 04:08:44'),(87,3,'Polo Colors',87,0,'2021-09-02 04:27:24','2021-09-02 04:27:24'),(88,NULL,'DUMMY',88,1,'2021-09-20 22:36:59','2021-09-20 22:36:59'),(89,NULL,'DUMMY',89,1,'2021-09-21 13:49:15','2021-09-21 13:49:15');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier','combo') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_id` int(11) unsigned DEFAULT NULL,
  `sub_unit_ids` text COLLATE utf8mb4_unicode_ci,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') COLLATE utf8mb4_unicode_ci NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT '0',
  `alert_quantity` decimal(22,4) DEFAULT NULL,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') COLLATE utf8mb4_unicode_ci DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT '0',
  `weight` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `warranty_id` int(11) DEFAULT NULL,
  `is_inactive` tinyint(1) NOT NULL DEFAULT '0',
  `not_for_selling` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `products_brand_id_foreign` (`brand_id`) USING BTREE,
  KEY `products_category_id_foreign` (`category_id`) USING BTREE,
  KEY `products_sub_category_id_foreign` (`sub_category_id`) USING BTREE,
  KEY `products_tax_foreign` (`tax`) USING BTREE,
  KEY `products_name_index` (`name`) USING BTREE,
  KEY `products_business_id_index` (`business_id`) USING BTREE,
  KEY `products_unit_id_index` (`unit_id`) USING BTREE,
  KEY `products_created_by_index` (`created_by`) USING BTREE,
  KEY `products_warranty_id_index` (`warranty_id`) USING BTREE,
  KEY `products_type_index` (`type`) USING BTREE,
  KEY `products_tax_type_index` (`tax_type`) USING BTREE,
  KEY `products_barcode_type_index` (`barcode_type`) USING BTREE,
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_tax_foreign` FOREIGN KEY (`tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'022-3#basic (logo)tracksuit',2,'variable',2,NULL,NULL,2,NULL,NULL,'exclusive',1,1.0000,'0116010010','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 18:53:57','2021-09-01 19:31:33'),(2,'022-4#basic(logo)tracksuit',2,'variable',2,NULL,NULL,2,NULL,NULL,'exclusive',1,1.0000,'0116010012','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:34:16','2021-09-01 20:47:29'),(3,'021-38#basic five.p jeans',2,'variable',2,NULL,NULL,3,NULL,NULL,'exclusive',1,1.0000,'0101010111','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:38:06','2021-09-01 20:48:22'),(4,'021-24#basic five.p jeans',2,'variable',2,NULL,NULL,3,NULL,NULL,'exclusive',1,NULL,'0101010095','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:39:19','2021-09-01 20:50:04'),(5,'021-204/60/basic five.p jeans',2,'variable',2,NULL,NULL,3,NULL,NULL,'exclusive',1,0.0000,'0101010110','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:40:36','2021-09-02 18:01:52'),(6,'021-207#basic five.p jeans',2,'variable',2,NULL,NULL,3,NULL,NULL,'exclusive',1,1.0000,'0101010119','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:40:57','2021-09-01 22:05:57'),(7,'021-27#jogger jeans',2,'variable',2,NULL,NULL,3,NULL,NULL,'exclusive',1,0.0000,'0101030002','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:42:01','2021-09-01 20:53:48'),(8,'021-14#basic chino pant',2,'variable',2,NULL,NULL,1,NULL,NULL,'exclusive',1,0.0000,'0102010019','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:43:00','2021-09-01 20:57:01'),(9,'021-44#basic five.p jeans',2,'variable',2,NULL,NULL,3,NULL,NULL,'exclusive',1,1.0000,'0101010120','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:44:38','2021-09-10 16:57:31'),(10,'021-40#basic five.p jeans',2,'variable',2,NULL,NULL,3,NULL,NULL,'exclusive',1,1.0000,'0101010115','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:46:57','2021-09-10 16:57:58'),(11,'021-41#basic five.p jeans',2,'variable',2,NULL,NULL,3,NULL,NULL,'exclusive',1,1.0000,'0101010116','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:49:00','2021-09-10 16:58:36'),(12,'021-13#basic chino pant',2,'variable',2,NULL,NULL,1,NULL,NULL,'exclusive',1,0.0000,'0102010018','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:49:25','2021-09-01 20:57:48'),(13,'021-4#chino jogger',2,'variable',2,NULL,NULL,1,NULL,NULL,'exclusive',1,0.0000,'0102010016','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:50:16','2021-09-01 20:58:51'),(14,'021-18#basic chino jogger',2,'variable',2,NULL,NULL,1,NULL,NULL,'exclusive',1,0.0000,'0102040004','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:51:00','2021-09-01 20:59:43'),(15,'021-39#basic five.p jeans',2,'variable',2,NULL,NULL,3,NULL,NULL,'exclusive',1,1.0000,'0101010114','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:51:28','2021-09-10 16:59:08'),(16,'021-17#basic chino jogger',2,'variable',2,NULL,NULL,1,NULL,NULL,'exclusive',1,0.0000,'0102040003','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:51:36','2021-09-01 21:03:30'),(17,'021-19#basic chino jogger',2,'variable',2,NULL,NULL,1,NULL,NULL,'exclusive',1,0.0000,'0102040002','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:52:24','2021-09-01 21:04:54'),(18,'021-37#basic five.p jeans',2,'variable',2,NULL,NULL,3,NULL,NULL,'exclusive',1,1.0000,'0101010113','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:52:45','2021-09-10 16:59:37'),(19,'021-12#basic sweatpant',2,'variable',2,NULL,NULL,4,NULL,NULL,'exclusive',1,0.0000,'0102030021','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:53:20','2021-09-01 21:07:50'),(20,'021-43#basic slash jeans',2,'variable',2,NULL,NULL,3,NULL,NULL,'exclusive',1,1.0000,'0101010117','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:53:37','2021-09-10 16:24:47'),(21,'021-11#basic sweatpant',2,'variable',2,NULL,NULL,4,NULL,NULL,'exclusive',1,0.0000,'0102030020','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:54:15','2021-09-01 21:10:38'),(23,'021-1#basic cotton short',2,'variable',2,NULL,NULL,5,NULL,NULL,'exclusive',1,0.0000,'0103030007','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:55:01','2021-09-10 16:33:47'),(24,'021-1#print(monkey)swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,0.0000,'0103040035','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:56:01','2021-09-10 16:59:58'),(25,'021-1#p.(Army)swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,0.0000,'0103040038','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 19:57:13','2021-09-10 16:39:42'),(26,'021-1#p.(leafs)swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,0.0000,'0103040039','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:00:00','2021-09-10 17:00:28'),(27,'022-1#basic(pocket)tracksuit',2,'variable',2,NULL,NULL,2,NULL,NULL,'exclusive',1,1.0000,'0116010011','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:00:36','2021-09-10 17:15:03'),(28,'021-1#p.(big leaf)swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,0.0000,'0103040041','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:01:52','2021-09-10 17:05:23'),(29,'021-1#p.(crocodile)swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,0.0000,'0103040045','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:03:32','2021-09-10 17:15:27'),(30,'021-34#basic(logo)shirt',2,'variable',2,NULL,NULL,7,NULL,NULL,'exclusive',1,1.0000,'0104010031','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:03:53','2021-09-04 17:19:32'),(31,'021-1#print(fish)swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,0.0000,'0103040046','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:04:13','2021-09-10 17:15:49'),(32,'021-1#print(circle)swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,0.0000,'0103040047','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:05:33','2021-09-10 17:16:16'),(33,'021-1#print(can)swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,NULL,'0103040055','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:06:19','2021-09-10 17:16:55'),(34,'021-1#p.(writing)swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,0.0000,'0103040060','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:07:26','2021-09-10 17:17:10'),(35,'021-1#p.(banana l.)swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,0.0000,'0103040061','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:08:15','2021-09-10 17:17:31'),(36,'021-1#p.(flower)swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,0.0000,'0103040062','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:09:01','2021-09-10 17:17:49'),(37,'021-1#p.(big flower)swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,0.0000,'0103040065','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:09:42','2021-09-10 16:41:12'),(38,'021-2#basic swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,0.0000,'0103040067','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:10:37','2021-09-02 03:34:47'),(39,'021-1#print(x-o)swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,0.0000,'0103040036','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:11:25','2021-09-10 17:18:12'),(40,'021-1#print(stars)swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,NULL,'0103040050','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:12:08','2021-09-10 17:18:33'),(41,'021-1#printed swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,0.0000,'0103040034','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:12:50','2021-09-10 17:18:51'),(42,'021-1#p.(butterfly)swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,NULL,'0103040059','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:13:34','2021-09-10 17:19:18'),(43,'021-1#print(bird)swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,0.0000,'0103040057','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:14:19','2021-09-10 17:14:32'),(44,'021-1#p.(banana tree)swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,0.0000,'0103040058','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:14:55','2021-09-10 17:14:08'),(45,'021-32#basic(logo)shirt',2,'variable',2,NULL,NULL,7,NULL,NULL,'exclusive',1,0.0000,'0104010029','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:19:18','2021-09-02 03:44:33'),(46,'021-22#basic(logo)shirt',2,'variable',2,NULL,NULL,7,NULL,NULL,'exclusive',1,0.0000,'0104010025','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:20:18','2021-09-10 17:12:57'),(47,'021-31#basic shirt',2,'variable',2,NULL,NULL,7,NULL,NULL,'exclusive',1,0.0000,'0104010026','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:21:11','2021-09-10 17:12:17'),(48,'020-55#basic(logo)shirt',2,'variable',2,NULL,NULL,7,NULL,NULL,'exclusive',1,0.0000,'0104010014','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:22:06','2021-09-10 16:27:02'),(49,'021-30#basic shirt',2,'variable',2,NULL,NULL,7,NULL,NULL,'exclusive',1,0.0000,'0104010028','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:22:49','2021-09-10 17:11:47'),(50,'021-33#basic(logo)shirt',2,'variable',2,NULL,NULL,7,NULL,NULL,'exclusive',1,0.0000,'0104010030','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:23:51','2021-09-10 17:11:21'),(51,'021-18-5#checks shirt',2,'variable',2,NULL,NULL,7,NULL,NULL,'exclusive',1,0.0000,'0104020078','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:25:05','2021-09-10 17:10:43'),(52,'021-20-2#checks shirt',2,'variable',2,NULL,NULL,7,NULL,NULL,'exclusive',1,0.0000,'0104020081','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:25:46','2021-09-10 17:09:59'),(53,'021-2#basic[henly]t-shirt',2,'variable',2,NULL,NULL,8,NULL,NULL,'exclusive',1,0.0000,'0105010023','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:26:36','2021-09-10 16:41:54'),(54,'021-69#basic(OVERSIZE)t-shirt',2,'variable',2,NULL,NULL,8,NULL,NULL,'exclusive',1,NULL,'0105010031','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:27:18','2021-09-10 16:42:48'),(55,'021-77#basic(LINE)t-shirt',2,'variable',2,NULL,NULL,8,NULL,NULL,'exclusive',1,0.0000,'0105010032','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:28:11','2021-09-10 16:45:24'),(56,'021-75#print(smile)t-shirt',2,'variable',2,NULL,NULL,8,NULL,NULL,'exclusive',1,0.0000,'0105020100','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:28:58','2021-09-10 16:46:05'),(57,'021-67#print(face)t-shirt',2,'variable',2,NULL,NULL,8,NULL,NULL,'exclusive',1,0.0000,'0105020102','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:29:45','2021-09-10 16:46:57'),(58,'021-85#p.(disappeard)t-shirt',2,'variable',2,NULL,NULL,8,NULL,NULL,'exclusive',1,0.0000,'0105020105','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:30:23','2021-09-10 16:47:37'),(59,'021-74#print(predator)t-shirt',2,'variable',2,NULL,NULL,8,NULL,NULL,'exclusive',1,0.0000,'0105020106','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:31:27','2021-09-10 16:48:42'),(60,'021-76#p.(TIME)t-shirt',2,'variable',2,NULL,NULL,8,NULL,NULL,'exclusive',1,NULL,'0105020107','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:32:10','2021-09-10 16:49:28'),(61,'021-59#print(FUTURE)t-shirt',2,'variable',2,NULL,NULL,8,NULL,NULL,'exclusive',1,NULL,'0105020111','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:32:52','2021-09-10 16:49:59'),(62,'021-83#print(CROSS)t-shirt',2,'variable',2,NULL,NULL,8,NULL,NULL,'exclusive',1,NULL,'0105020112','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:33:37','2021-09-10 16:50:35'),(63,'021-72#print(Rhythm)t-shirt',2,'variable',2,NULL,NULL,8,NULL,NULL,'exclusive',1,0.0000,'0105020113','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:34:17','2021-09-10 16:51:49'),(64,'021-80#print(NY)t-shirt',2,'variable',2,NULL,NULL,8,NULL,NULL,'exclusive',1,0.0000,'0105020114','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:35:28','2021-09-10 16:52:36'),(65,'021-33#Print cuts t-shirt',2,'variable',2,NULL,NULL,8,NULL,NULL,'exclusive',1,NULL,'0105020115','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:36:16','2021-09-10 16:53:14'),(66,'021-18#basic polo',2,'variable',2,NULL,NULL,9,NULL,NULL,'exclusive',1,0.0000,'0106010047','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:37:26','2021-09-10 17:09:28'),(67,'021-24#Reglan(logo)polo',2,'variable',2,NULL,NULL,9,NULL,NULL,'exclusive',1,NULL,'0106010051','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:38:46','2021-09-05 01:07:18'),(68,'021-30#print(THE NEW)polo',2,'variable',2,NULL,NULL,9,NULL,NULL,'exclusive',1,0.0000,'0106010053','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:39:29','2021-09-10 17:08:55'),(69,'021-22#print(more)polo',2,'variable',2,NULL,NULL,9,NULL,NULL,'exclusive',1,NULL,'0106020046','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:40:07','2021-09-10 17:08:04'),(70,'021-31#print(89SUPER)polo',2,'variable',2,NULL,NULL,9,NULL,NULL,'exclusive',1,0.0000,'0106020047','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:40:50','2021-09-10 17:07:29'),(71,'021-27#print(FR1989WD)polo',2,'variable',2,NULL,NULL,9,NULL,NULL,'exclusive',1,0.0000,'0106020048','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:41:27','2021-09-10 17:07:01'),(72,'021-34#printed(POINT)polo',2,'variable',2,NULL,NULL,9,NULL,NULL,'exclusive',1,0.0000,'0106020049','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:42:00','2021-09-10 17:06:28'),(73,'021-32#printed(3.logo)polo',2,'variable',2,NULL,NULL,9,NULL,NULL,'exclusive',1,0.0000,'0106020050','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:42:35','2021-09-10 17:05:54'),(74,'021-35#printed(inter89)polo',2,'variable',2,NULL,NULL,9,NULL,NULL,'exclusive',1,0.0000,'0106020051','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:43:11','2021-09-10 17:04:45'),(75,'021-33#print(SAILMAKER)polo',2,'variable',2,NULL,NULL,9,NULL,NULL,'exclusive',1,0.0000,'0106020052','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:43:51','2021-09-01 22:18:45'),(76,'021-13#basic st.up polo',2,'variable',2,NULL,NULL,9,NULL,NULL,'exclusive',1,0.0000,'0106040012','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-01 20:44:34','2021-09-10 17:04:14'),(77,'021-31-1#basic five.p jeans',2,'variable',2,NULL,NULL,3,NULL,NULL,'exclusive',1,NULL,'0101010105','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-02 03:08:42','2021-09-02 03:09:02'),(78,'021-14#basic chino pant',2,'variable',2,NULL,NULL,1,NULL,NULL,'exclusive',1,0.0000,'0102010020','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-02 03:10:57','2021-09-10 16:32:04'),(79,'021-2#basic cotton(line)short',2,'variable',2,NULL,NULL,5,NULL,NULL,'exclusive',1,NULL,'0103030008','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-02 03:21:55','2021-09-02 03:22:24'),(80,'021-1#print(moon)swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,NULL,'0103040051','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-02 03:27:54','2021-09-02 03:28:13'),(81,'021-1#p.(m. leaf)swimshort',2,'variable',2,NULL,NULL,6,NULL,NULL,'exclusive',1,NULL,'0103040064','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-02 03:30:42','2021-09-10 17:13:45'),(82,'021-18-6#checks shirt',2,'variable',2,NULL,NULL,7,NULL,NULL,'exclusive',1,NULL,'0104020079','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-02 03:52:32','2021-09-10 17:03:44'),(83,'021-20-1#checks shirt',2,'variable',2,NULL,NULL,7,NULL,NULL,'exclusive',1,NULL,'0104020080','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-02 03:54:34','2021-09-10 17:02:27'),(84,'021-20#basic(pocket)t-shirt',2,'variable',2,NULL,NULL,8,NULL,NULL,'exclusive',1,NULL,'0105010024','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-02 03:58:17','2021-09-10 16:53:57'),(85,'021-71#p.(mind)t-shirt',2,'variable',2,NULL,NULL,8,NULL,NULL,'exclusive',1,NULL,'0105020108','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-02 04:06:49','2021-09-10 16:54:42'),(86,'021-84#p.(flage)po.t-shirt',2,'variable',2,NULL,NULL,8,NULL,NULL,'exclusive',1,NULL,'0105020109','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-02 04:08:44','2021-09-10 16:55:24'),(87,'021-30#print(THE NEW)polo',2,'variable',2,NULL,NULL,9,NULL,NULL,'exclusive',1,NULL,'0106020053','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2021-09-02 04:27:24','2021-09-10 17:01:47'),(88,'Test',1,'single',1,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'12344','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2021-09-20 22:36:59','2021-09-20 22:36:59'),(89,'Apple',1,'single',1,NULL,NULL,NULL,NULL,NULL,'exclusive',0,0.0000,'0089','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2021-09-21 13:49:15','2021-09-21 13:49:15');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `pp_without_discount` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Purchase price before inline discounts',
  `discount_percent` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'Inline discount percentage',
  `purchase_price` decimal(22,4) NOT NULL,
  `purchase_price_inc_tax` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `purchase_order_line_id` int(11) DEFAULT NULL,
  `quantity_sold` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Quanity sold from this purchase line',
  `quantity_adjusted` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Quanity adjusted in stock adjustment from this purchase line',
  `quantity_returned` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `po_quantity_purchased` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `mfg_quantity_used` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `mfg_date` date DEFAULT NULL,
  `exp_date` date DEFAULT NULL,
  `lot_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `purchase_lines_transaction_id_foreign` (`transaction_id`) USING BTREE,
  KEY `purchase_lines_product_id_foreign` (`product_id`) USING BTREE,
  KEY `purchase_lines_variation_id_foreign` (`variation_id`) USING BTREE,
  KEY `purchase_lines_tax_id_foreign` (`tax_id`) USING BTREE,
  KEY `purchase_lines_sub_unit_id_index` (`sub_unit_id`) USING BTREE,
  KEY `purchase_lines_lot_number_index` (`lot_number`) USING BTREE,
  CONSTRAINT `purchase_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=405 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purchase_lines` WRITE;
/*!40000 ALTER TABLE `purchase_lines` DISABLE KEYS */;
INSERT INTO `purchase_lines` VALUES (1,1,1,1,15.0000,525.0000,0.00,525.0000,525.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 18:56:08','2021-09-06 21:26:07'),(2,1,1,2,10.0000,525.0000,0.00,525.0000,525.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 18:56:08','2021-09-06 21:22:21'),(3,2,2,8,5.0000,650.0000,0.00,650.0000,650.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 20:47:39','2021-09-06 21:26:07'),(4,3,3,11,10.0000,375.0000,0.00,375.0000,375.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 20:48:39','2021-09-07 11:01:15'),(5,3,3,14,10.0000,375.0000,0.00,375.0000,375.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 20:48:39','2021-09-07 11:01:15'),(6,4,4,24,10.0000,375.0000,0.00,375.0000,375.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 20:50:28','2021-09-14 17:21:26'),(7,5,5,35,10.0000,375.0000,0.00,375.0000,375.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 20:51:57','2021-09-03 22:07:44'),(8,6,7,63,4.0000,495.0000,0.00,495.0000,495.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 20:54:15','2021-09-02 19:24:44'),(14,8,8,66,10.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 20:57:11','2021-09-07 18:54:24'),(15,9,12,109,10.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 20:58:10','2021-09-07 13:23:35'),(19,11,13,119,5.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 20:59:10','2021-09-05 15:24:23'),(20,11,13,120,5.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 20:59:10','2021-09-11 21:58:40'),(21,11,13,121,5.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 20:59:10','2021-09-05 15:24:23'),(25,14,14,129,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:02:56','2021-09-07 18:15:30'),(26,14,14,130,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:02:56','2021-09-02 22:54:37'),(27,14,14,132,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:02:56','2021-09-02 19:16:30'),(28,14,14,133,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:02:56','2021-09-10 21:16:33'),(29,14,14,134,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:02:56','2021-09-02 03:15:39'),(30,14,14,135,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:02:56','2021-09-02 20:12:40'),(34,17,16,150,6.0000,395.0000,0.00,395.0000,395.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:04:11','2021-09-03 21:45:39'),(35,17,16,153,6.0000,395.0000,0.00,395.0000,395.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:04:11','2021-09-03 19:27:30'),(36,17,16,154,6.0000,395.0000,0.00,395.0000,395.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:04:11','2021-09-02 03:16:33'),(37,17,16,155,6.0000,395.0000,0.00,395.0000,395.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:04:11','2021-09-02 03:16:33'),(38,17,16,157,6.0000,395.0000,0.00,395.0000,395.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:04:11','2021-09-02 03:16:33'),(39,17,16,158,6.0000,395.0000,0.00,395.0000,395.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:04:11','2021-09-02 17:12:54'),(41,18,20,191,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:05:14','2021-09-07 11:45:04'),(45,20,17,160,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:07:04','2021-09-09 17:34:10'),(46,20,17,161,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:07:04','2021-09-09 17:34:10'),(47,20,17,164,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:07:04','2021-09-09 17:34:10'),(48,20,17,165,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:07:04','2021-09-09 17:34:10'),(49,20,17,168,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:07:04','2021-09-09 17:34:10'),(50,20,17,169,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:07:04','2021-09-09 17:34:10'),(52,21,19,181,5.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,2.0000,1.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:08:12','2021-09-10 17:53:46'),(53,21,19,182,5.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:08:12','2021-09-10 20:04:16'),(54,21,19,184,6.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:08:12','2021-09-10 17:53:46'),(55,22,30,254,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:08:23','2021-09-07 10:23:03'),(56,23,76,847,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:10:21','2021-09-05 11:41:53'),(57,23,76,852,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:10:21','2021-09-07 13:23:35'),(58,24,21,197,5.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:11:09','2021-09-06 22:11:02'),(59,24,21,199,3.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:11:09','2021-09-09 16:35:04'),(60,24,21,200,6.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:11:09','2021-09-06 19:35:03'),(61,25,23,214,6.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:13:01','2021-09-10 20:04:16'),(62,25,23,215,6.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:13:01','2021-09-01 21:13:01'),(63,25,23,216,6.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:13:01','2021-09-01 21:13:01'),(64,25,23,217,6.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:13:01','2021-09-03 20:06:55'),(65,25,23,218,6.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:13:01','2021-09-10 20:04:16'),(66,25,23,219,6.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:13:01','2021-09-08 13:56:11'),(67,26,75,835,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:18:11','2021-09-03 23:21:16'),(68,26,75,838,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:18:11','2021-09-07 13:23:35'),(69,26,75,855,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,3.0000,1.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:18:11','2021-09-09 17:56:40'),(70,27,74,812,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:18:19','2021-09-02 04:25:16'),(71,27,74,816,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:18:19','2021-09-04 17:58:41'),(72,27,74,821,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:18:19','2021-09-11 21:58:40'),(73,27,74,822,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:18:19','2021-09-13 21:09:57'),(74,28,73,795,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:19:30','2021-09-07 13:23:35'),(75,28,73,802,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:19:30','2021-09-05 18:48:36'),(76,29,72,791,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:20:21','2021-09-10 22:15:08'),(77,29,72,792,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:20:21','2021-09-04 17:58:41'),(78,30,71,767,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:21:11','2021-09-02 04:21:56'),(79,30,71,775,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:21:11','2021-09-06 18:56:11'),(80,31,70,750,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:21:56','2021-09-03 22:53:01'),(81,32,69,737,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:23:41','2021-09-03 22:53:01'),(82,33,67,711,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:25:41','2021-09-07 13:23:35'),(83,33,67,712,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:25:41','2021-09-02 17:16:19'),(84,35,66,690,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:29:02','2021-09-09 21:33:29'),(85,35,66,691,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:29:02','2021-09-10 19:38:04'),(86,35,66,692,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:29:02','2021-09-09 17:38:50'),(87,35,66,693,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:29:02','2021-09-09 17:38:50'),(88,35,66,694,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:29:02','2021-09-09 17:38:50'),(89,35,66,695,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:29:02','2021-09-09 17:38:50'),(90,36,65,689,15.0000,149.0000,0.00,149.0000,149.0000,0.0000,NULL,NULL,14.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:30:38','2021-09-10 19:26:20'),(91,37,64,663,5.0000,225.0000,0.00,225.0000,225.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:31:22','2021-09-02 04:13:53'),(92,38,63,651,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:32:22','2021-09-08 13:56:11'),(93,38,63,653,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:32:22','2021-09-06 22:57:31'),(94,38,63,656,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:32:22','2021-09-14 21:29:08'),(95,40,62,629,5.0000,245.0000,0.00,245.0000,245.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:33:54','2021-09-09 17:37:57'),(96,40,62,630,5.0000,245.0000,0.00,245.0000,245.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:33:54','2021-09-09 17:37:57'),(97,40,62,639,5.0000,245.0000,0.00,245.0000,245.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:33:54','2021-09-09 17:37:57'),(98,41,61,616,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,3.0000,2.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:35:48','2021-09-14 21:29:08'),(99,41,61,621,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:35:48','2021-09-09 21:33:29'),(100,41,61,622,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:35:48','2021-09-10 14:19:36'),(101,41,61,623,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:35:48','2021-09-14 22:01:51'),(102,42,60,596,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:37:38','2021-09-13 18:43:31'),(103,42,60,597,2.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:37:38','2021-09-09 17:36:46'),(104,42,60,600,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:37:38','2021-09-09 17:36:46'),(105,43,59,580,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:38:47','2021-09-14 21:29:08'),(106,43,59,587,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:38:47','2021-09-07 10:58:34'),(107,44,58,569,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:39:38','2021-09-07 17:17:35'),(108,44,58,570,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:39:38','2021-09-07 18:15:30'),(109,46,57,547,5.0000,225.0000,0.00,225.0000,225.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:40:35','2021-09-08 19:34:20'),(110,47,56,536,5.0000,225.0000,0.00,225.0000,225.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:41:24','2021-09-06 17:52:49'),(111,48,55,519,5.0000,225.0000,0.00,225.0000,225.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:43:04','2021-09-10 21:22:41'),(112,48,55,526,5.0000,225.0000,0.00,225.0000,225.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:43:04','2021-09-09 16:22:56'),(113,49,54,500,4.0000,265.0000,0.00,265.0000,265.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:44:26','2021-09-02 16:35:41'),(114,49,54,501,2.0000,265.0000,0.00,265.0000,265.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:44:26','2021-09-02 04:00:31'),(115,49,54,502,4.0000,265.0000,0.00,265.0000,265.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:44:26','2021-09-02 04:00:31'),(116,50,53,482,5.0000,245.0000,0.00,245.0000,245.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:47:05','2021-09-09 21:33:29'),(117,50,53,483,5.0000,245.0000,0.00,245.0000,245.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:47:05','2021-09-09 17:36:23'),(118,50,53,491,5.0000,245.0000,0.00,245.0000,245.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:47:05','2021-09-10 19:38:04'),(119,51,51,461,7.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,7.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:49:20','2021-09-09 21:33:29'),(120,52,50,439,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:52:36','2021-09-04 18:48:17'),(121,52,50,440,10.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:52:36','2021-09-13 21:08:29'),(122,52,50,441,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:52:36','2021-09-05 11:59:40'),(123,53,49,410,6.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:55:12','2021-09-14 21:55:29'),(124,53,49,414,6.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:55:12','2021-09-09 17:34:58'),(125,53,49,415,7.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,7.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:55:12','2021-09-09 17:34:58'),(126,53,49,417,6.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,2.0000,1.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:55:12','2021-09-09 17:56:40'),(127,53,49,418,3.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:55:12','2021-09-09 17:34:58'),(128,53,49,419,4.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:55:12','2021-09-09 17:34:58'),(129,53,49,420,6.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:55:12','2021-09-09 17:34:58'),(130,54,48,396,5.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:56:00','2021-09-09 21:33:29'),(131,55,47,376,6.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:56:46','2021-09-02 23:07:52'),(132,55,47,377,6.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:56:46','2021-09-07 12:19:56'),(133,56,46,357,6.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:57:32','2021-09-04 22:48:28'),(134,57,44,333,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 21:59:15','2021-09-04 15:33:30'),(135,58,43,328,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 22:07:10','2021-09-06 22:57:31'),(136,59,42,323,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 22:07:56','2021-09-08 20:18:09'),(137,60,41,318,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 22:08:48','2021-09-05 23:02:18'),(138,61,40,313,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 22:09:26','2021-09-08 21:15:16'),(139,62,39,308,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 22:10:04','2021-09-14 17:01:34'),(140,63,37,298,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 22:12:38','2021-09-08 19:34:20'),(141,64,36,293,5.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 22:13:04','2021-09-10 22:15:08'),(142,65,35,288,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 22:13:44','2021-09-08 16:07:53'),(143,66,34,283,3.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 22:14:19','2021-09-08 13:47:35'),(144,67,33,278,8.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 22:15:13','2021-09-10 21:13:24'),(145,68,32,273,7.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 22:15:41','2021-09-06 19:16:30'),(146,69,31,268,3.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 22:19:09','2021-09-01 22:19:09'),(147,70,29,245,4.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 22:20:04','2021-09-04 22:02:59'),(148,71,28,240,5.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 22:20:40','2021-09-05 21:47:25'),(149,72,26,230,5.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 22:22:11','2021-09-08 20:18:09'),(150,73,25,225,4.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 22:22:44','2021-09-07 17:53:50'),(151,74,24,220,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-01 22:23:22','2021-09-08 13:51:16'),(152,77,1,1,15.0000,525.0000,0.00,525.0000,525.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:00:23','2021-09-03 16:00:14'),(153,77,1,2,10.0000,525.0000,0.00,525.0000,525.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:00:23','2021-09-02 03:00:23'),(154,78,2,8,5.0000,650.0000,0.00,650.0000,650.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:01:02','2021-09-02 03:01:02'),(157,80,3,11,9.0000,375.0000,0.00,375.0000,375.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:06:41','2021-09-07 19:31:15'),(158,81,77,857,10.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:09:19','2021-09-10 15:16:00'),(159,82,4,24,10.0000,375.0000,0.00,375.0000,375.0000,0.0000,NULL,NULL,7.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:10:08','2021-09-06 14:16:40'),(160,83,78,867,10.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,0.0000,10.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:12:47','2021-09-10 16:22:38'),(161,84,12,109,10.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:13:38','2021-09-03 20:36:21'),(162,85,13,119,5.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:14:21','2021-09-07 18:56:23'),(163,85,13,120,5.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:14:21','2021-09-02 03:14:21'),(164,85,13,121,5.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:14:21','2021-09-02 03:14:21'),(165,86,14,129,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:15:39','2021-09-13 19:25:31'),(166,86,14,130,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:15:39','2021-09-02 03:15:39'),(167,86,14,132,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:15:39','2021-09-02 03:15:39'),(168,86,14,133,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:15:39','2021-09-02 03:15:39'),(169,86,14,134,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:15:39','2021-09-02 03:15:39'),(170,86,14,135,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:15:39','2021-09-02 03:15:39'),(171,87,16,150,6.0000,395.0000,0.00,395.0000,395.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:16:33','2021-09-02 19:25:49'),(172,87,16,153,6.0000,395.0000,0.00,395.0000,395.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:16:33','2021-09-02 16:51:52'),(173,87,16,154,6.0000,395.0000,0.00,395.0000,395.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:16:33','2021-09-03 21:54:58'),(174,87,16,155,6.0000,395.0000,0.00,395.0000,395.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:16:33','2021-09-05 18:04:14'),(175,87,16,157,6.0000,395.0000,0.00,395.0000,395.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:16:33','2021-09-02 16:44:50'),(176,87,16,158,6.0000,395.0000,0.00,395.0000,395.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:16:33','2021-09-04 12:42:21'),(177,88,17,160,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:17:42','2021-09-11 20:45:46'),(178,88,17,161,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:17:42','2021-09-09 17:34:10'),(179,88,17,164,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:17:42','2021-09-09 17:34:10'),(180,88,17,165,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:17:42','2021-09-09 17:34:10'),(181,88,17,168,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:17:42','2021-09-09 17:34:10'),(182,88,17,169,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:17:42','2021-09-09 17:34:10'),(183,89,21,197,5.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:18:41','2021-09-02 03:20:02'),(184,89,21,198,6.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:18:41','2021-09-03 23:55:09'),(186,90,19,181,5.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:19:15','2021-09-09 17:33:41'),(187,90,19,182,6.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:19:15','2021-09-09 17:33:41'),(188,90,19,183,5.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:19:15','2021-09-09 17:33:41'),(189,89,21,201,6.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,0.0000,1.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:20:02','2021-09-08 17:38:03'),(190,91,79,877,7.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:23:24','2021-09-09 15:03:07'),(191,91,79,878,6.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:23:24','2021-09-02 03:23:24'),(192,91,79,879,6.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:23:24','2021-09-02 03:23:24'),(193,91,79,880,8.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:23:24','2021-09-02 22:12:31'),(194,91,79,881,5.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:23:24','2021-09-02 03:23:24'),(195,91,79,882,5.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:23:24','2021-09-02 03:23:24'),(196,91,79,883,6.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:23:24','2021-09-02 03:23:24'),(197,92,24,220,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:24:13','2021-09-10 19:42:34'),(198,93,26,230,5.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:24:41','2021-09-08 20:45:08'),(199,94,28,240,5.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:25:07','2021-09-05 22:40:19'),(200,95,29,245,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:25:31','2021-09-05 20:41:22'),(201,96,32,273,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:26:04','2021-09-02 03:26:04'),(202,97,80,884,5.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:28:21','2021-09-13 22:27:31'),(203,98,33,278,7.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:29:00','2021-09-11 20:31:12'),(204,99,35,288,5.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:29:18','2021-09-11 20:27:48'),(205,100,81,889,5.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:30:59','2021-09-05 20:42:46'),(206,101,37,298,5.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:31:28','2021-09-02 03:31:28'),(207,102,38,304,5.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:36:38','2021-09-05 23:02:18'),(208,102,38,307,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:36:38','2021-09-10 20:04:16'),(209,102,38,894,5.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:36:38','2021-09-07 11:49:53'),(210,102,38,895,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:36:38','2021-09-04 22:17:30'),(211,103,38,304,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:36:38','2021-09-08 19:43:14'),(212,103,38,305,5.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:36:38','2021-09-10 19:09:22'),(213,103,38,306,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:36:38','2021-09-13 22:27:31'),(214,103,38,307,7.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:36:38','2021-09-08 15:53:46'),(215,104,39,308,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:38:33','2021-09-09 17:34:31'),(216,105,40,313,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:40:14','2021-09-07 19:00:27'),(217,106,41,318,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:40:40','2021-09-08 22:24:10'),(218,107,42,323,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:41:11','2021-09-08 22:11:49'),(219,108,43,328,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:41:34','2021-09-08 15:56:50'),(220,109,44,333,6.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:41:53','2021-09-08 13:56:08'),(221,110,45,338,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:43:22','2021-09-07 19:19:08'),(222,111,45,338,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:44:52','2021-09-03 17:48:03'),(223,111,45,896,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:44:52','2021-09-04 12:19:48'),(224,112,46,357,6.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:45:28','2021-09-04 22:37:39'),(225,113,47,376,6.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:46:00','2021-09-04 19:40:58'),(226,113,47,377,6.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:46:00','2021-09-10 18:52:44'),(227,114,48,396,5.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:46:29','2021-09-09 17:35:37'),(228,115,49,415,7.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:47:39','2021-09-09 17:34:58'),(229,115,49,416,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:47:39','2021-09-09 17:34:58'),(230,115,49,417,6.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:47:39','2021-09-09 17:34:58'),(231,115,49,418,6.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:47:39','2021-09-09 17:34:58'),(232,115,49,419,6.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:47:39','2021-09-09 17:34:58'),(233,115,49,420,6.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:47:39','2021-09-09 23:15:06'),(234,116,50,439,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,1.0000,1.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:48:55','2021-09-08 17:38:03'),(235,116,50,440,10.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,8.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:48:55','2021-09-10 18:52:44'),(236,116,50,441,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:48:55','2021-09-14 15:15:10'),(237,117,30,264,3.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,2.0000,1.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:49:31','2021-09-08 20:45:08'),(238,118,82,912,3.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:53:21','2021-09-07 20:41:39'),(239,119,83,930,5.0000,365.0000,0.00,365.0000,365.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:56:16','2021-09-14 20:13:11'),(240,119,83,931,5.0000,365.0000,0.00,365.0000,365.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:56:16','2021-09-12 20:06:40'),(241,119,83,932,4.0000,365.0000,0.00,365.0000,365.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:56:16','2021-09-13 13:23:47'),(242,119,83,933,5.0000,365.0000,0.00,365.0000,365.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:56:16','2021-09-09 17:36:00'),(243,120,84,935,5.0000,225.0000,0.00,225.0000,225.0000,0.0000,NULL,NULL,0.0000,1.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:59:23','2021-09-09 17:54:32'),(244,120,84,936,5.0000,225.0000,0.00,225.0000,225.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 03:59:23','2021-09-02 03:59:23'),(245,121,54,500,4.0000,265.0000,0.00,265.0000,265.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:00:31','2021-09-02 04:00:31'),(246,121,54,501,5.0000,265.0000,0.00,265.0000,265.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:00:31','2021-09-02 04:00:31'),(247,121,54,502,4.0000,265.0000,0.00,265.0000,265.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:00:31','2021-09-02 04:00:31'),(248,122,55,519,5.0000,225.0000,0.00,225.0000,225.0000,0.0000,NULL,NULL,1.0000,1.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:01:04','2021-09-11 17:13:56'),(249,123,56,536,5.0000,225.0000,0.00,225.0000,225.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:02:13','2021-09-02 04:02:13'),(250,124,57,547,5.0000,225.0000,0.00,225.0000,225.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:03:24','2021-09-02 21:07:56'),(251,125,58,569,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:04:10','2021-09-07 13:47:49'),(252,125,58,570,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:04:10','2021-09-10 18:52:44'),(253,126,59,580,9.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,4.0000,4.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:05:05','2021-09-13 13:23:47'),(254,126,59,587,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:05:05','2021-09-07 10:58:34'),(255,127,85,953,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:07:19','2021-09-09 15:36:15'),(256,128,86,970,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,2.0000,1.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:10:09','2021-09-08 17:38:03'),(257,128,86,971,4.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:10:09','2021-09-03 21:28:18'),(258,128,86,977,4.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:10:09','2021-09-03 18:39:20'),(259,129,61,616,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:11:32','2021-09-14 15:27:41'),(260,129,61,621,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:11:32','2021-09-03 16:21:48'),(261,129,61,622,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:11:32','2021-09-10 22:14:17'),(262,129,61,623,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:11:32','2021-09-10 18:52:44'),(263,130,62,628,5.0000,245.0000,0.00,245.0000,245.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:12:27','2021-09-09 17:37:57'),(264,130,62,629,5.0000,245.0000,0.00,245.0000,245.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:12:27','2021-09-09 17:37:57'),(265,130,62,639,5.0000,245.0000,0.00,245.0000,245.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:12:27','2021-09-09 17:37:57'),(266,131,63,651,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:13:20','2021-09-04 12:42:22'),(267,131,63,653,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,2.0000,1.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:13:20','2021-09-14 15:27:41'),(268,131,63,656,5.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:13:20','2021-09-04 12:29:30'),(269,132,64,663,5.0000,225.0000,0.00,225.0000,225.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:13:53','2021-09-02 23:08:24'),(270,132,64,670,5.0000,225.0000,0.00,225.0000,225.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:13:53','2021-09-02 04:13:53'),(271,133,65,689,15.0000,149.0000,0.00,149.0000,149.0000,0.0000,NULL,NULL,8.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:14:39','2021-09-10 19:09:22'),(272,134,66,690,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:16:23','2021-09-09 17:38:50'),(273,134,66,691,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:16:23','2021-09-09 23:15:06'),(274,134,66,692,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:16:23','2021-09-09 17:38:50'),(275,134,66,693,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:16:23','2021-09-09 17:38:50'),(276,134,66,694,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:16:23','2021-09-09 17:38:50'),(277,134,66,695,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:16:23','2021-09-09 17:38:50'),(278,135,67,711,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:17:10','2021-09-07 15:12:11'),(279,135,67,712,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:17:10','2021-09-12 20:06:40'),(280,135,67,713,6.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:17:10','2021-09-05 20:25:23'),(281,136,68,723,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:20:12','2021-09-02 23:30:43'),(282,136,68,729,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:20:12','2021-09-06 19:12:58'),(283,136,68,983,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:20:12','2021-09-06 21:55:08'),(284,137,68,723,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:20:12','2021-09-09 16:44:58'),(285,137,68,729,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:20:12','2021-09-04 22:02:41'),(286,138,69,737,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:21:01','2021-09-02 04:21:01'),(287,139,70,750,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:21:19','2021-09-10 14:26:24'),(288,140,71,767,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:21:56','2021-09-04 22:02:41'),(289,140,71,775,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:21:56','2021-09-10 14:26:24'),(290,141,72,791,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:22:28','2021-09-03 20:23:18'),(291,141,72,792,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:22:28','2021-09-04 18:51:55'),(292,142,73,795,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:22:59','2021-09-02 20:20:03'),(293,142,73,802,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:22:59','2021-09-02 04:22:59'),(294,143,74,816,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:25:16','2021-09-09 21:59:51'),(295,143,74,821,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:25:16','2021-09-07 15:12:11'),(296,143,74,822,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:25:16','2021-09-06 21:23:21'),(297,144,75,838,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:26:21','2021-09-08 13:55:00'),(298,144,75,839,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:26:21','2021-09-12 19:45:22'),(299,145,87,995,5.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:27:57','2021-09-07 16:32:09'),(300,146,76,847,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:29:10','2021-09-09 15:03:07'),(302,147,6,50,1.0000,365.0000,0.00,365.0000,365.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:30:59','2021-09-07 11:38:37'),(318,117,30,254,2.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:37:51','2021-09-07 10:23:03'),(319,153,52,479,3.0000,365.0000,0.00,365.0000,365.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:40:33','2021-09-07 16:34:23'),(320,153,52,481,3.0000,365.0000,0.00,365.0000,365.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:40:33','2021-09-02 21:46:42'),(321,153,52,1001,3.0000,365.0000,0.00,365.0000,365.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 04:40:33','2021-09-03 20:32:21'),(322,189,5,35,10.0000,375.0000,0.00,375.0000,375.0000,0.0000,NULL,NULL,5.0000,1.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 17:02:08','2021-09-08 17:29:07'),(323,196,60,596,1.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-02 17:58:25','2021-09-09 17:36:46'),(328,503,19,181,1.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 17:51:57','2021-09-09 17:51:57'),(329,503,17,160,1.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 17:51:57','2021-09-09 17:51:57'),(330,503,39,308,1.0000,175.0000,0.00,175.0000,175.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 17:51:57','2021-09-09 17:51:57'),(331,503,49,410,1.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 17:51:57','2021-09-09 17:51:57'),(332,503,48,392,1.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 17:51:57','2021-09-10 17:32:40'),(333,503,83,916,2.0000,365.0000,0.00,365.0000,365.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 17:51:57','2021-09-09 17:51:57'),(334,503,53,482,5.0000,245.0000,0.00,245.0000,245.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 17:51:57','2021-09-09 17:51:57'),(335,503,60,594,4.0000,255.0000,0.00,255.0000,255.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 17:51:57','2021-09-11 22:19:48'),(336,503,8,66,10.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 17:51:57','2021-09-09 17:51:57'),(337,503,62,626,1.0000,245.0000,0.00,245.0000,245.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 17:51:57','2021-09-09 17:51:57'),(338,503,66,690,1.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 17:51:57','2021-09-09 17:51:57'),(339,506,62,626,1.0000,245.0000,0.00,245.0000,245.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 17:58:50','2021-09-09 17:58:50'),(340,506,66,690,1.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 17:58:50','2021-09-09 17:58:50'),(341,506,74,810,1.0000,355.0000,0.00,355.0000,355.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 17:58:50','2021-09-09 17:58:50'),(342,506,13,119,1.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 17:58:50','2021-09-09 17:58:50'),(343,506,21,197,1.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 17:58:50','2021-09-09 17:58:50'),(344,511,10,90,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:23:34','2021-09-10 16:18:14'),(345,511,18,171,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:23:34','2021-09-10 16:18:14'),(346,511,18,174,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:23:34','2021-09-10 16:18:14'),(347,511,20,191,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:23:34','2021-09-10 16:18:14'),(348,511,20,189,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:23:34','2021-09-10 16:18:14'),(349,511,20,192,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:23:34','2021-09-10 16:18:14'),(350,511,11,105,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:23:34','2021-09-10 16:18:14'),(351,511,27,238,5.0000,525.0000,0.00,525.0000,525.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:23:34','2021-09-10 16:18:14'),(352,511,27,239,5.0000,525.0000,0.00,525.0000,525.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:23:34','2021-09-10 16:18:14'),(353,511,30,254,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:23:34','2021-09-10 18:52:44'),(354,512,6,50,10.0000,365.0000,0.00,365.0000,365.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:33:30','2021-09-10 16:17:38'),(355,512,6,51,10.0000,365.0000,0.00,365.0000,365.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:33:30','2021-09-12 20:06:40'),(356,512,6,52,10.0000,365.0000,0.00,365.0000,365.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:33:30','2021-09-10 16:17:38'),(357,512,6,53,10.0000,365.0000,0.00,365.0000,365.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:33:30','2021-09-10 16:17:38'),(358,512,6,49,10.0000,365.0000,0.00,365.0000,365.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:33:30','2021-09-10 16:17:38'),(359,512,9,76,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:33:30','2021-09-10 17:32:40'),(360,512,9,86,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:33:30','2021-09-10 16:17:38'),(361,512,9,85,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:33:30','2021-09-14 20:13:11'),(362,512,10,88,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:33:30','2021-09-10 17:32:40'),(363,512,10,91,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,10.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:33:30','2021-09-11 20:50:03'),(364,512,20,196,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,10.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:33:30','2021-09-11 20:50:03'),(365,513,11,105,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:38:43','2021-09-10 16:17:18'),(366,513,9,80,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:38:43','2021-09-10 16:17:18'),(367,513,78,873,10.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:38:43','2021-09-10 16:17:18'),(368,513,78,869,10.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:38:43','2021-09-14 20:47:47'),(369,513,78,870,10.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:38:43','2021-09-14 20:47:47'),(370,513,78,867,10.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:38:43','2021-09-10 17:32:40'),(371,513,14,131,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:38:43','2021-09-11 20:45:46'),(372,513,30,254,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:38:43','2021-09-10 16:17:18'),(373,514,6,52,10.0000,365.0000,0.00,365.0000,365.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:49:28','2021-09-10 20:16:34'),(374,514,6,50,10.0000,365.0000,0.00,365.0000,365.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:49:28','2021-09-10 16:16:50'),(375,514,6,49,10.0000,365.0000,0.00,365.0000,365.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:49:28','2021-09-10 20:16:34'),(376,514,6,53,10.0000,365.0000,0.00,365.0000,365.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:49:28','2021-09-10 16:16:50'),(377,514,6,51,10.0000,365.0000,0.00,365.0000,365.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:49:28','2021-09-10 20:16:34'),(378,514,9,76,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:49:28','2021-09-10 16:16:50'),(379,514,9,86,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:49:28','2021-09-10 16:16:50'),(380,514,9,85,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:49:28','2021-09-10 16:16:50'),(381,514,10,91,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:49:28','2021-09-10 16:16:50'),(382,514,10,88,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:49:28','2021-09-10 16:16:50'),(383,514,11,108,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-09 23:49:28','2021-09-10 16:16:50'),(384,518,15,148,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-10 16:27:37','2021-09-10 16:27:37'),(385,518,18,174,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-10 16:27:37','2021-09-10 16:27:37'),(386,518,18,171,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-10 16:27:37','2021-09-10 16:27:37'),(387,518,20,189,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-10 16:27:37','2021-09-10 16:27:37'),(388,518,20,191,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-10 16:27:37','2021-09-10 16:27:37'),(389,518,20,192,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-10 16:27:37','2021-09-10 16:27:37'),(390,518,27,238,5.0000,525.0000,0.00,525.0000,525.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-10 16:27:37','2021-09-10 16:27:37'),(391,518,27,239,5.0000,525.0000,0.00,525.0000,525.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-10 16:27:37','2021-09-10 16:27:37'),(392,518,11,105,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-10 16:27:37','2021-09-10 16:27:37'),(393,518,30,254,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-10 16:27:37','2021-09-14 21:55:29'),(394,519,11,105,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-10 16:37:33','2021-09-10 16:37:33'),(395,519,9,80,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-10 16:37:33','2021-09-10 16:37:33'),(396,519,78,873,10.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-10 16:37:33','2021-09-10 16:37:33'),(397,519,78,869,10.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-10 16:37:33','2021-09-10 16:37:33'),(398,519,78,870,10.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-10 16:37:33','2021-09-10 16:37:33'),(399,519,78,867,10.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-10 16:37:33','2021-09-10 16:37:33'),(400,519,14,131,6.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-10 16:37:33','2021-09-10 16:37:33'),(401,519,30,254,5.0000,325.0000,0.00,325.0000,325.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-10 16:37:33','2021-09-10 16:37:33'),(402,545,11,98,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-11 20:51:49','2021-09-11 20:51:49'),(403,545,15,139,10.0000,425.0000,0.00,425.0000,425.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-11 20:51:49','2021-09-11 20:51:49'),(404,568,88,1002,100.0000,1000.0000,0.00,1000.0000,1000.0000,0.0000,NULL,NULL,20.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-09-20 22:37:17','2021-09-20 22:39:54');
/*!40000 ALTER TABLE `purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reference_counts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reference_counts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ref_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ref_count` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `reference_counts_business_id_index` (`business_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reference_counts` WRITE;
/*!40000 ALTER TABLE `reference_counts` DISABLE KEYS */;
INSERT INTO `reference_counts` VALUES (1,'contacts',2,1,'2021-08-31 05:43:53','2021-09-20 22:38:24'),(2,'business_location',1,1,'2021-08-31 05:43:53','2021-08-31 05:43:53'),(3,'contacts',3,2,'2021-09-01 12:23:39','2021-09-09 17:41:58'),(4,'business_location',2,2,'2021-09-01 12:23:39','2021-09-01 22:18:22'),(5,'sell_payment',394,2,'2021-09-01 21:28:23','2021-09-14 22:01:51'),(6,'sell_return',32,2,'2021-09-01 21:32:45','2021-09-13 21:08:29'),(7,'draft',3,2,'2021-09-01 21:39:59','2021-09-10 17:30:22'),(8,'stock_adjustment',5,2,'2021-09-08 17:29:07','2021-09-11 20:50:03'),(9,'purchase',9,2,'2021-09-09 17:51:56','2021-09-11 20:51:49'),(10,'sell_payment',2,1,'2021-09-20 22:39:03','2021-09-20 22:39:54');
/*!40000 ALTER TABLE `reference_counts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_product_modifier_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_product_modifier_sets` (
  `modifier_set_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL COMMENT 'Table use to store the modifier sets applicable for a product',
  KEY `res_product_modifier_sets_modifier_set_id_foreign` (`modifier_set_id`) USING BTREE,
  CONSTRAINT `res_product_modifier_sets_modifier_set_id_foreign` FOREIGN KEY (`modifier_set_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_product_modifier_sets` WRITE;
/*!40000 ALTER TABLE `res_product_modifier_sets` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_product_modifier_sets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_tables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_tables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `res_tables_business_id_foreign` (`business_id`) USING BTREE,
  CONSTRAINT `res_tables_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_tables` WRITE;
/*!40000 ALTER TABLE `res_tables` DISABLE KEYS */;
INSERT INTO `res_tables` VALUES (1,1,1,'1',NULL,1,NULL,'2021-09-21 13:44:43','2021-09-21 13:44:43'),(2,1,1,'2',NULL,1,NULL,'2021-09-21 13:44:50','2021-09-21 13:44:50');
/*!40000 ALTER TABLE `res_tables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`) USING BTREE,
  KEY `role_has_permissions_role_id_foreign` (`role_id`) USING BTREE,
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` VALUES (25,2),(26,2),(48,2),(49,2),(50,2),(51,2),(80,2),(18,4),(25,4),(26,4),(27,4),(48,4),(49,4),(58,4),(81,4),(84,4),(85,4),(87,4),(88,4);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_service_staff` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `roles_business_id_foreign` (`business_id`) USING BTREE,
  CONSTRAINT `roles_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Admin#1','web',1,1,0,'2021-08-31 05:43:53','2021-08-31 05:43:53'),(2,'Cashier#1','web',1,0,0,'2021-08-31 05:43:53','2021-08-31 05:43:53'),(3,'Admin#2','web',2,1,0,'2021-09-01 12:23:39','2021-09-01 12:23:39'),(4,'Cashier#2','web',2,0,0,'2021-09-01 12:23:39','2021-09-01 12:23:39'),(5,'Manger#2','web',2,0,0,'2021-09-05 21:24:19','2021-09-05 21:24:19');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sell_line_warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sell_line_warranties` (
  `sell_line_id` int(11) NOT NULL,
  `warranty_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sell_line_warranties` WRITE;
/*!40000 ALTER TABLE `sell_line_warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `sell_line_warranties` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `selling_price_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `selling_price_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `business_id` int(10) unsigned NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `selling_price_groups_business_id_foreign` (`business_id`) USING BTREE,
  CONSTRAINT `selling_price_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `selling_price_groups` WRITE;
/*!40000 ALTER TABLE `selling_price_groups` DISABLE KEYS */;
INSERT INTO `selling_price_groups` VALUES (1,'Offer','Offer Price Limited Time',2,1,NULL,'2021-09-01 16:35:56','2021-09-01 16:35:56'),(2,'Mena','Test',2,0,'2021-09-07 11:25:55','2021-09-07 11:25:37','2021-09-07 11:25:55');
/*!40000 ALTER TABLE `selling_price_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(11) NOT NULL,
  UNIQUE KEY `sessions_id_unique` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustment_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustment_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL,
  `unit_price` decimal(22,4) DEFAULT NULL COMMENT 'Last purchase unit price',
  `removed_purchase_line` int(11) DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `stock_adjustment_lines_product_id_foreign` (`product_id`) USING BTREE,
  KEY `stock_adjustment_lines_variation_id_foreign` (`variation_id`) USING BTREE,
  KEY `stock_adjustment_lines_transaction_id_index` (`transaction_id`) USING BTREE,
  KEY `stock_adjustment_lines_lot_no_line_id_index` (`lot_no_line_id`) USING BTREE,
  CONSTRAINT `stock_adjustment_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustment_lines` WRITE;
/*!40000 ALTER TABLE `stock_adjustment_lines` DISABLE KEYS */;
INSERT INTO `stock_adjustment_lines` VALUES (1,475,5,35,1.0000,375.0000,NULL,NULL,'2021-09-08 17:29:07','2021-09-08 17:29:07'),(2,476,78,867,10.0000,325.0000,NULL,NULL,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(3,476,21,201,1.0000,345.0000,NULL,NULL,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(4,476,50,439,1.0000,325.0000,NULL,NULL,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(5,476,30,264,1.0000,325.0000,NULL,NULL,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(6,476,55,519,1.0000,225.0000,NULL,NULL,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(7,476,59,580,4.0000,255.0000,NULL,NULL,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(8,476,86,970,1.0000,255.0000,NULL,NULL,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(9,476,63,653,1.0000,255.0000,NULL,NULL,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(10,504,84,935,1.0000,225.0000,NULL,NULL,'2021-09-09 17:54:32','2021-09-09 17:54:32'),(11,505,75,855,1.0000,355.0000,NULL,NULL,'2021-09-09 17:56:40','2021-09-09 17:56:40'),(12,505,19,181,1.0000,345.0000,NULL,NULL,'2021-09-09 17:56:40','2021-09-09 17:56:40'),(13,505,49,417,1.0000,355.0000,NULL,NULL,'2021-09-09 17:56:40','2021-09-09 17:56:40'),(14,505,61,616,2.0000,255.0000,NULL,NULL,'2021-09-09 17:56:40','2021-09-09 17:56:40'),(15,544,10,91,10.0000,425.0000,NULL,NULL,'2021-09-11 20:50:03','2021-09-11 20:50:03'),(16,544,20,196,10.0000,425.0000,NULL,NULL,'2021-09-11 20:50:03','2021-09-11 20:50:03');
/*!40000 ALTER TABLE `stock_adjustment_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustments_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustments_temp` (
  `id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustments_temp` WRITE;
/*!40000 ALTER TABLE `stock_adjustments_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustments_temp` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subscriptions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `package_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `trial_end_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `package_price` decimal(22,4) NOT NULL,
  `package_details` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_id` int(10) unsigned NOT NULL,
  `paid_via` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('approved','waiting','declined') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'waiting',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `subscriptions_business_id_foreign` (`business_id`) USING BTREE,
  KEY `subscriptions_package_id_index` (`package_id`) USING BTREE,
  KEY `subscriptions_created_id_index` (`created_id`) USING BTREE,
  CONSTRAINT `subscriptions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `subscriptions` WRITE;
/*!40000 ALTER TABLE `subscriptions` DISABLE KEYS */;
INSERT INTO `subscriptions` VALUES (1,2,1,'2021-09-01','2026-12-15','2026-09-01',632.5000,'{\"location_count\":2,\"user_count\":7,\"product_count\":0,\"invoice_count\":0,\"name\":\"POS Version 2\"}',1,'offline','154788','approved',NULL,'2021-09-01 12:23:39','2021-09-01 12:23:39'),(2,1,6,'2021-09-20','2026-10-05','2026-09-20',2200.0000,'{\"location_count\":10,\"user_count\":75,\"product_count\":0,\"invoice_count\":0,\"name\":\"POS Version 10\"}',1,'offline','100','approved',NULL,'2021-09-20 21:43:04','2021-09-20 21:43:30');
/*!40000 ALTER TABLE `subscriptions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `superadmin_communicator_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `superadmin_communicator_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_ids` text COLLATE utf8mb4_unicode_ci,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `superadmin_communicator_logs` WRITE;
/*!40000 ALTER TABLE `superadmin_communicator_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `superadmin_communicator_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `superadmin_frontend_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `superadmin_frontend_pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_shown` tinyint(1) NOT NULL,
  `menu_order` int(11) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `superadmin_frontend_pages` WRITE;
/*!40000 ALTER TABLE `superadmin_frontend_pages` DISABLE KEYS */;
/*!40000 ALTER TABLE `superadmin_frontend_pages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `system` WRITE;
/*!40000 ALTER TABLE `system` DISABLE KEYS */;
INSERT INTO `system` VALUES (1,'db_version','4.4'),(2,'default_business_active_status','1'),(3,'superadmin_version','2.8'),(4,'app_currency_id','2'),(5,'invoice_business_name','Sub Business ERP'),(6,'invoice_business_landmark','Landmark'),(7,'invoice_business_zip','Zip'),(8,'invoice_business_state','State'),(9,'invoice_business_city','City'),(10,'invoice_business_country','Country'),(11,'email','superadmin@example.com'),(12,'package_expiry_alert_days','5'),(13,'enable_business_based_username','0'),(14,'superadmin_register_tc',NULL),(15,'welcome_email_subject',NULL),(16,'welcome_email_body',NULL),(17,'additional_js',NULL),(18,'additional_css',NULL),(19,'offline_payment_details',NULL),(20,'superadmin_enable_register_tc','0'),(21,'allow_email_settings_to_businesses','0'),(22,'enable_new_business_registration_notification','0'),(23,'enable_new_subscription_notification','0'),(24,'enable_welcome_email','0'),(25,'enable_offline_payment','1');
/*!40000 ALTER TABLE `system` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tax_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tax_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(22,4) NOT NULL,
  `is_tax_group` tinyint(1) NOT NULL DEFAULT '0',
  `for_tax_group` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `tax_rates_business_id_foreign` (`business_id`) USING BTREE,
  KEY `tax_rates_created_by_foreign` (`created_by`) USING BTREE,
  CONSTRAINT `tax_rates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tax_rates_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tax_rates` WRITE;
/*!40000 ALTER TABLE `tax_rates` DISABLE KEYS */;
/*!40000 ALTER TABLE `tax_rates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) unsigned DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `is_return` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Used during sales to return the change',
  `amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `method` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_transaction_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_holder_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_month` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_year` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_security` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheque_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_account_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_on` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `is_advance` tinyint(1) NOT NULL DEFAULT '0',
  `payment_for` int(11) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `transaction_payments_transaction_id_foreign` (`transaction_id`) USING BTREE,
  KEY `transaction_payments_created_by_index` (`created_by`) USING BTREE,
  KEY `transaction_payments_parent_id_index` (`parent_id`) USING BTREE,
  CONSTRAINT `transaction_payments_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=419 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_payments` WRITE;
/*!40000 ALTER TABLE `transaction_payments` DISABLE KEYS */;
INSERT INTO `transaction_payments` VALUES (1,34,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:28:23',3,0,2,NULL,NULL,NULL,'SP2021/0001',NULL,'2021-09-01 21:28:23','2021-09-01 21:28:23'),(2,39,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:33:00',2,0,2,NULL,NULL,NULL,'SP2021/0002',NULL,'2021-09-01 21:33:42','2021-09-01 21:33:42'),(3,75,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:39:51',3,0,2,NULL,NULL,NULL,'SP2021/0003',NULL,'2021-09-01 22:39:51','2021-09-01 22:39:51'),(4,154,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 10:52:40',3,0,2,NULL,NULL,NULL,'SP2021/0004',NULL,'2021-09-02 10:52:41','2021-09-02 10:52:41'),(5,155,2,0,300.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 12:00:13',3,0,2,NULL,NULL,NULL,'SP2021/0005',NULL,'2021-09-02 12:00:13','2021-09-02 12:00:13'),(6,156,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 12:01:36',3,0,2,NULL,NULL,NULL,'SP2021/0006',NULL,'2021-09-02 12:01:36','2021-09-02 12:01:36'),(7,157,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 12:03:32',3,0,2,NULL,NULL,NULL,'SP2021/0007',NULL,'2021-09-02 12:03:32','2021-09-02 12:03:32'),(8,158,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 12:12:24',3,0,2,NULL,NULL,NULL,'SP2021/0008',NULL,'2021-09-02 12:12:24','2021-09-02 12:12:24'),(9,159,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 12:14:02',3,0,2,NULL,NULL,NULL,'SP2021/0009',NULL,'2021-09-02 12:14:02','2021-09-02 12:14:02'),(10,160,2,0,275.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 12:36:31',3,0,2,NULL,NULL,NULL,'SP2021/0010',NULL,'2021-09-02 12:36:31','2021-09-02 12:36:31'),(11,161,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 12:55:55',3,0,2,NULL,NULL,NULL,'SP2021/0011',NULL,'2021-09-02 12:55:55','2021-09-02 12:55:55'),(12,163,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 13:16:58',3,0,2,NULL,NULL,NULL,'SP2021/0012',NULL,'2021-09-02 13:16:58','2021-09-02 13:16:58'),(13,164,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 13:35:19',3,0,2,NULL,NULL,NULL,'SP2021/0013',NULL,'2021-09-02 13:35:19','2021-09-02 13:35:19'),(14,165,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 13:50:58',3,0,2,NULL,NULL,NULL,'SP2021/0014',NULL,'2021-09-02 13:50:58','2021-09-02 13:50:58'),(15,166,2,0,450.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 14:13:54',3,0,2,NULL,NULL,NULL,'SP2021/0015',NULL,'2021-09-02 14:13:54','2021-09-02 14:13:54'),(16,167,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 14:28:43',3,0,2,NULL,NULL,NULL,'SP2021/0016',NULL,'2021-09-02 14:28:43','2021-09-02 14:28:43'),(17,168,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 14:36:23',3,0,2,NULL,NULL,NULL,'SP2021/0017',NULL,'2021-09-02 14:36:23','2021-09-02 14:36:23'),(18,169,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 14:51:25',3,0,2,NULL,NULL,NULL,'SP2021/0018',NULL,'2021-09-02 14:51:25','2021-09-02 14:51:25'),(19,170,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 14:53:16',3,0,2,NULL,NULL,NULL,'SP2021/0019',NULL,'2021-09-02 14:53:16','2021-09-02 14:53:16'),(20,171,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 15:02:22',3,0,2,NULL,NULL,NULL,'SP2021/0020',NULL,'2021-09-02 15:02:22','2021-09-02 15:02:22'),(21,172,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 15:03:39',3,0,2,NULL,NULL,NULL,'SP2021/0021',NULL,'2021-09-02 15:03:39','2021-09-02 15:03:39'),(22,173,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 15:18:26',9,0,2,NULL,NULL,NULL,'SP2021/0022',NULL,'2021-09-02 15:18:26','2021-09-02 15:18:26'),(23,174,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 15:19:53',3,0,2,NULL,NULL,NULL,'SP2021/0023',NULL,'2021-09-02 15:19:53','2021-09-02 15:19:53'),(24,176,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 15:22:43',9,0,2,NULL,NULL,NULL,'SP2021/0024',NULL,'2021-09-02 15:22:43','2021-09-02 15:22:43'),(25,177,2,0,425.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 15:37:04',9,0,2,NULL,NULL,NULL,'SP2021/0025',NULL,'2021-09-02 15:37:04','2021-09-02 15:37:04'),(26,178,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 15:38:35',9,0,2,NULL,NULL,NULL,'SP2021/0026',NULL,'2021-09-02 15:38:35','2021-09-02 15:38:35'),(27,179,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 16:08:05',9,0,2,NULL,NULL,NULL,'SP2021/0027',NULL,'2021-09-02 16:08:05','2021-09-02 16:08:05'),(28,180,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 16:14:38',3,0,2,NULL,NULL,NULL,'SP2021/0028',NULL,'2021-09-02 16:14:38','2021-09-02 16:14:38'),(29,181,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 16:15:51',3,0,2,NULL,NULL,NULL,'SP2021/0029',NULL,'2021-09-02 16:15:51','2021-09-02 16:15:51'),(30,182,2,0,700.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 16:28:07',3,0,2,NULL,NULL,NULL,'SP2021/0030',NULL,'2021-09-02 16:28:07','2021-09-02 16:28:07'),(31,183,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 16:35:41',3,0,2,NULL,NULL,NULL,'SP2021/0031',NULL,'2021-09-02 16:35:41','2021-09-02 16:35:41'),(32,184,2,0,500.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 16:38:48',3,0,2,NULL,NULL,NULL,'SP2021/0032',NULL,'2021-09-02 16:38:48','2021-09-02 16:38:48'),(33,185,2,0,425.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 16:44:50',9,0,2,NULL,NULL,NULL,'SP2021/0033',NULL,'2021-09-02 16:44:50','2021-09-02 16:44:50'),(34,186,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 16:45:39',9,0,2,NULL,NULL,NULL,'SP2021/0034',NULL,'2021-09-02 16:45:39','2021-09-02 16:45:39'),(35,187,2,0,550.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 16:46:22',3,0,2,NULL,NULL,NULL,'SP2021/0035',NULL,'2021-09-02 16:46:22','2021-09-02 16:46:22'),(36,188,2,0,550.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 16:51:52',9,0,2,NULL,NULL,NULL,'SP2021/0036',NULL,'2021-09-02 16:51:52','2021-09-02 16:51:52'),(37,190,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 17:12:54',3,0,2,NULL,NULL,NULL,'SP2021/0037',NULL,'2021-09-02 17:12:54','2021-09-02 17:12:54'),(38,191,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 17:15:12',9,0,2,NULL,NULL,NULL,'SP2021/0038',NULL,'2021-09-02 17:15:12','2021-09-02 17:15:12'),(39,192,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 17:16:19',3,0,2,NULL,NULL,NULL,'SP2021/0039',NULL,'2021-09-02 17:16:19','2021-09-02 17:16:19'),(40,193,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 17:19:58',3,0,2,NULL,NULL,NULL,'SP2021/0040',NULL,'2021-09-02 17:19:58','2021-09-02 17:19:58'),(41,194,2,0,450.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 17:27:23',3,0,2,NULL,NULL,NULL,'SP2021/0041',NULL,'2021-09-02 17:27:23','2021-09-02 17:27:23'),(42,195,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 17:37:56',3,0,2,NULL,NULL,NULL,'SP2021/0042',NULL,'2021-09-02 17:37:56','2021-09-02 17:37:56'),(43,197,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:08:47',9,0,2,NULL,NULL,NULL,'SP2021/0043',NULL,'2021-09-02 18:08:47','2021-09-02 18:08:47'),(44,198,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:09:37',3,0,2,NULL,NULL,NULL,'SP2021/0044',NULL,'2021-09-02 18:09:37','2021-09-02 18:09:37'),(45,199,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:15:43',3,0,2,NULL,NULL,NULL,'SP2021/0045',NULL,'2021-09-02 18:15:43','2021-09-02 18:15:43'),(46,200,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:18:14',9,0,2,NULL,NULL,NULL,'SP2021/0046',NULL,'2021-09-02 18:18:14','2021-09-02 18:18:14'),(47,201,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:20:15',3,0,2,NULL,NULL,NULL,'SP2021/0047',NULL,'2021-09-02 18:20:15','2021-09-02 18:20:15'),(48,202,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:22:15',9,0,2,NULL,NULL,NULL,'SP2021/0048',NULL,'2021-09-02 18:22:15','2021-09-02 18:22:15'),(49,203,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:26:11',9,0,2,NULL,NULL,NULL,'SP2021/0049',NULL,'2021-09-02 18:26:11','2021-09-02 18:26:11'),(50,204,2,0,195.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:34:25',3,0,2,NULL,NULL,NULL,'SP2021/0050',NULL,'2021-09-02 18:34:25','2021-09-02 18:34:25'),(51,205,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:36:25',9,0,2,NULL,NULL,NULL,'SP2021/0051',NULL,'2021-09-02 18:36:25','2021-09-02 18:36:25'),(52,206,2,0,375.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:38:17',3,0,2,NULL,NULL,NULL,'SP2021/0052',NULL,'2021-09-02 18:38:17','2021-09-02 18:38:17'),(53,207,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:43:58',9,0,2,NULL,NULL,NULL,'SP2021/0053',NULL,'2021-09-02 18:43:58','2021-09-02 18:43:58'),(54,208,2,0,375.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:45:18',3,0,2,NULL,NULL,NULL,'SP2021/0054',NULL,'2021-09-02 18:45:18','2021-09-02 18:45:18'),(55,209,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:47:17',3,0,2,NULL,NULL,NULL,'SP2021/0055',NULL,'2021-09-02 18:47:17','2021-09-02 18:47:17'),(56,210,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:49:46',3,0,2,NULL,NULL,NULL,'SP2021/0056',NULL,'2021-09-02 18:49:46','2021-09-02 18:49:46'),(57,212,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:53:30',3,0,2,NULL,NULL,NULL,'SP2021/0057',NULL,'2021-09-02 18:53:30','2021-09-02 18:53:30'),(58,213,2,0,345.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:54:49',3,0,2,NULL,NULL,NULL,'SP2021/0058',NULL,'2021-09-02 18:54:49','2021-09-02 18:54:49'),(59,214,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:55:24',9,0,2,NULL,NULL,NULL,'SP2021/0059',NULL,'2021-09-02 18:55:24','2021-09-02 18:55:24'),(60,215,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:55:49',3,0,2,NULL,NULL,NULL,'SP2021/0060',NULL,'2021-09-02 18:55:49','2021-09-02 18:55:49'),(61,216,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:58:52',9,0,2,NULL,NULL,NULL,'SP2021/0061',NULL,'2021-09-02 18:58:52','2021-09-02 18:58:52'),(62,217,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 19:13:58',3,0,2,NULL,NULL,NULL,'SP2021/0062',NULL,'2021-09-02 19:13:58','2021-09-02 19:13:58'),(63,218,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 19:15:20',3,0,2,NULL,NULL,NULL,'SP2021/0063',NULL,'2021-09-02 19:15:20','2021-09-02 19:15:20'),(64,219,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 19:16:30',3,0,2,NULL,NULL,NULL,'SP2021/0064',NULL,'2021-09-02 19:16:30','2021-09-02 19:16:30'),(65,220,2,0,500.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 19:24:44',3,0,2,NULL,NULL,NULL,'SP2021/0065',NULL,'2021-09-02 19:24:44','2021-09-02 19:24:44'),(66,221,2,0,575.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 19:25:49',9,0,2,NULL,NULL,NULL,'SP2021/0066',NULL,'2021-09-02 19:25:49','2021-09-02 19:25:49'),(67,222,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 19:26:25',9,0,2,NULL,NULL,NULL,'SP2021/0067',NULL,'2021-09-02 19:26:25','2021-09-02 19:26:25'),(68,223,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 19:29:41',3,0,2,NULL,NULL,NULL,'SP2021/0068',NULL,'2021-09-02 19:29:41','2021-09-02 19:29:41'),(69,224,2,0,225.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 19:34:46',9,0,2,NULL,NULL,NULL,'SP2021/0069',NULL,'2021-09-02 19:34:46','2021-09-02 19:34:46'),(70,225,2,0,270.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 19:35:25',9,0,2,NULL,NULL,NULL,'SP2021/0070',NULL,'2021-09-02 19:35:25','2021-09-02 19:35:25'),(71,226,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 19:36:44',9,0,2,NULL,NULL,NULL,'SP2021/0071',NULL,'2021-09-02 19:36:44','2021-09-02 19:36:44'),(72,227,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 19:43:08',9,0,2,NULL,NULL,NULL,'SP2021/0072',NULL,'2021-09-02 19:43:08','2021-09-02 19:43:08'),(73,228,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 19:51:22',9,0,2,NULL,NULL,NULL,'SP2021/0073',NULL,'2021-09-02 19:51:22','2021-09-02 19:51:22'),(74,229,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 19:55:11',9,0,2,NULL,NULL,NULL,'SP2021/0074',NULL,'2021-09-02 19:55:11','2021-09-02 19:55:11'),(75,230,2,0,300.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 19:55:49',9,0,2,NULL,NULL,NULL,'SP2021/0075',NULL,'2021-09-02 19:55:49','2021-09-02 19:55:49'),(76,231,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 20:01:55',3,0,2,NULL,NULL,NULL,'SP2021/0076',NULL,'2021-09-02 20:01:55','2021-09-02 20:01:55'),(77,232,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 20:04:06',3,0,2,NULL,NULL,NULL,'SP2021/0077',NULL,'2021-09-02 20:04:06','2021-09-02 20:04:06'),(78,233,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 20:09:32',9,0,2,NULL,NULL,NULL,'SP2021/0078',NULL,'2021-09-02 20:09:32','2021-09-02 20:09:32'),(79,234,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 20:10:49',9,0,2,NULL,NULL,NULL,'SP2021/0079',NULL,'2021-09-02 20:10:49','2021-09-02 20:10:49'),(80,235,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 20:12:40',3,0,2,NULL,NULL,NULL,'SP2021/0080',NULL,'2021-09-02 20:12:40','2021-09-02 20:12:40'),(81,236,2,0,345.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 20:20:03',9,0,2,NULL,NULL,NULL,'SP2021/0081',NULL,'2021-09-02 20:20:03','2021-09-02 20:20:03'),(82,237,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 20:24:26',3,0,2,NULL,NULL,NULL,'SP2021/0082',NULL,'2021-09-02 20:24:26','2021-09-02 20:24:26'),(83,238,2,0,175.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 20:31:12',3,0,2,NULL,NULL,NULL,'SP2021/0083',NULL,'2021-09-02 20:31:12','2021-09-02 20:31:12'),(84,239,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 20:48:57',3,0,2,NULL,NULL,NULL,'SP2021/0084',NULL,'2021-09-02 20:48:57','2021-09-02 20:48:57'),(85,240,2,0,900.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 20:58:21',3,0,2,NULL,NULL,NULL,'SP2021/0085',NULL,'2021-09-02 20:58:21','2021-09-02 20:58:21'),(86,241,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 21:01:59',3,0,2,NULL,NULL,NULL,'SP2021/0086',NULL,'2021-09-02 21:01:59','2021-09-02 21:01:59'),(87,242,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 21:05:34',3,0,2,NULL,NULL,NULL,'SP2021/0087',NULL,'2021-09-02 21:05:34','2021-09-02 21:05:34'),(88,243,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 21:07:56',9,0,2,NULL,NULL,NULL,'SP2021/0088',NULL,'2021-09-02 21:07:56','2021-09-02 21:07:56'),(89,244,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 21:10:54',3,0,2,NULL,NULL,NULL,'SP2021/0089',NULL,'2021-09-02 21:10:54','2021-09-02 21:10:54'),(90,245,2,0,300.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 21:26:09',3,0,2,NULL,NULL,NULL,'SP2021/0090',NULL,'2021-09-02 21:26:09','2021-09-02 21:26:09'),(91,246,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 21:34:31',3,0,2,NULL,NULL,NULL,'SP2021/0091',NULL,'2021-09-02 21:34:31','2021-09-02 21:34:31'),(92,247,2,0,825.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 21:39:06',9,0,2,NULL,NULL,NULL,'SP2021/0092',NULL,'2021-09-02 21:39:06','2021-09-02 21:39:06'),(93,248,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 21:40:37',3,0,2,NULL,NULL,NULL,'SP2021/0093',NULL,'2021-09-02 21:40:37','2021-09-02 21:40:37'),(94,249,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 21:46:42',3,0,2,NULL,NULL,NULL,'SP2021/0094',NULL,'2021-09-02 21:46:42','2021-09-02 21:46:42'),(95,250,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 21:48:55',3,0,2,NULL,NULL,NULL,'SP2021/0095',NULL,'2021-09-02 21:48:55','2021-09-02 21:48:55'),(96,251,2,0,300.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 21:51:03',3,0,2,NULL,NULL,NULL,'SP2021/0096',NULL,'2021-09-02 21:51:03','2021-09-02 21:51:03'),(97,252,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 22:00:23',3,0,2,NULL,NULL,NULL,'SP2021/0097',NULL,'2021-09-02 22:00:23','2021-09-02 22:00:23'),(98,253,2,0,300.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 22:12:31',9,0,2,NULL,NULL,NULL,'SP2021/0098',NULL,'2021-09-02 22:12:31','2021-09-02 22:12:31'),(99,254,2,0,500.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 22:19:22',3,0,2,NULL,NULL,NULL,'SP2021/0099',NULL,'2021-09-02 22:19:22','2021-09-02 22:19:22'),(100,255,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 22:29:42',9,0,2,NULL,NULL,NULL,'SP2021/0100',NULL,'2021-09-02 22:29:42','2021-09-02 22:29:42'),(101,256,2,0,175.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 22:31:18',3,0,2,NULL,NULL,NULL,'SP2021/0101',NULL,'2021-09-02 22:31:18','2021-09-02 22:31:18'),(102,257,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 22:38:12',9,0,2,NULL,NULL,NULL,'SP2021/0102',NULL,'2021-09-02 22:38:12','2021-09-02 22:38:12'),(103,258,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 22:40:38',3,0,2,NULL,NULL,NULL,'SP2021/0103',NULL,'2021-09-02 22:40:38','2021-09-02 22:40:38'),(104,259,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 22:43:11',9,0,2,NULL,NULL,NULL,'SP2021/0104',NULL,'2021-09-02 22:43:11','2021-09-02 22:43:11'),(105,260,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 22:54:37',3,0,2,NULL,NULL,NULL,'SP2021/0105',NULL,'2021-09-02 22:54:37','2021-09-02 22:54:37'),(106,261,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 22:55:56',3,0,2,NULL,NULL,NULL,'SP2021/0106',NULL,'2021-09-02 22:55:56','2021-09-02 22:55:56'),(107,262,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 22:56:41',3,0,2,NULL,NULL,NULL,'SP2021/0107',NULL,'2021-09-02 22:56:41','2021-09-02 22:56:41'),(108,263,2,0,175.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 22:58:58',3,0,2,NULL,NULL,NULL,'SP2021/0108',NULL,'2021-09-02 22:58:58','2021-09-02 22:58:58'),(109,264,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 23:02:02',3,0,2,NULL,NULL,NULL,'SP2021/0109',NULL,'2021-09-02 23:02:02','2021-09-02 23:02:02'),(110,265,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 23:05:40',3,0,2,NULL,NULL,NULL,'SP2021/0110',NULL,'2021-09-02 23:05:40','2021-09-02 23:05:40'),(111,266,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 23:07:52',3,0,2,NULL,NULL,NULL,'SP2021/0111',NULL,'2021-09-02 23:07:52','2021-09-02 23:07:52'),(112,267,2,0,325.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 23:08:24',9,0,2,NULL,NULL,NULL,'SP2021/0112',NULL,'2021-09-02 23:08:24','2021-09-02 23:08:24'),(113,268,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 23:08:53',9,0,2,NULL,NULL,NULL,'SP2021/0113',NULL,'2021-09-02 23:08:53','2021-09-02 23:08:53'),(114,269,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 23:15:47',3,0,2,NULL,NULL,NULL,'SP2021/0114',NULL,'2021-09-02 23:15:47','2021-09-02 23:15:47'),(115,271,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 23:18:34',9,0,2,NULL,NULL,NULL,'SP2021/0115',NULL,'2021-09-02 23:18:34','2021-09-02 23:18:34'),(116,272,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 23:20:16',3,0,2,NULL,NULL,NULL,'SP2021/0116',NULL,'2021-09-02 23:20:16','2021-09-02 23:20:16'),(117,273,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 23:25:53',3,0,2,NULL,NULL,NULL,'SP2021/0117',NULL,'2021-09-02 23:25:53','2021-09-02 23:25:53'),(118,275,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 23:36:46',9,0,2,NULL,NULL,NULL,'SP2021/0118',NULL,'2021-09-02 23:36:46','2021-09-02 23:36:46'),(119,277,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 13:14:10',3,0,2,NULL,NULL,NULL,'SP2021/0119',NULL,'2021-09-03 13:14:10','2021-09-03 13:14:10'),(120,278,2,0,700.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 14:53:27',3,0,2,NULL,NULL,NULL,'SP2021/0120',NULL,'2021-09-03 14:53:27','2021-09-03 14:53:27'),(121,279,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 15:00:48',3,0,2,NULL,NULL,NULL,'SP2021/0121',NULL,'2021-09-03 15:00:48','2021-09-03 15:00:48'),(122,280,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 15:09:02',3,0,2,NULL,NULL,NULL,'SP2021/0122',NULL,'2021-09-03 15:09:02','2021-09-03 15:09:02'),(123,281,2,0,175.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 15:16:35',3,0,2,NULL,NULL,NULL,'SP2021/0123',NULL,'2021-09-03 15:16:35','2021-09-03 15:16:35'),(124,282,2,0,1150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 16:00:14',9,0,2,NULL,NULL,NULL,'SP2021/0124',NULL,'2021-09-03 16:00:14','2021-09-03 16:00:14'),(125,283,2,0,870.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 16:03:34',9,0,2,NULL,NULL,NULL,'SP2021/0125',NULL,'2021-09-03 16:03:34','2021-09-03 16:03:34'),(126,284,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 16:19:33',3,0,2,NULL,NULL,NULL,'SP2021/0126',NULL,'2021-09-03 16:19:33','2021-09-03 16:19:33'),(127,285,2,0,225.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 16:21:48',9,0,2,NULL,NULL,NULL,'SP2021/0127',NULL,'2021-09-03 16:21:48','2021-09-03 16:21:48'),(128,287,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 17:17:39',9,0,2,NULL,NULL,NULL,'SP2021/0128',NULL,'2021-09-03 17:17:39','2021-09-03 17:17:39'),(129,288,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 17:30:31',3,0,2,NULL,NULL,NULL,'SP2021/0129',NULL,'2021-09-03 17:30:31','2021-09-03 17:30:31'),(130,289,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 17:40:37',3,0,2,NULL,NULL,NULL,'SP2021/0130',NULL,'2021-09-03 17:40:37','2021-09-03 17:40:37'),(131,290,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 17:42:31',9,0,2,NULL,NULL,NULL,'SP2021/0131',NULL,'2021-09-03 17:42:31','2021-09-03 17:42:31'),(132,291,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 17:45:46',9,0,2,NULL,NULL,NULL,'SP2021/0132',NULL,'2021-09-03 17:45:46','2021-09-03 17:45:46'),(133,292,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 17:48:03',3,0,2,NULL,NULL,NULL,'SP2021/0133',NULL,'2021-09-03 17:48:03','2021-09-03 17:48:03'),(134,294,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 18:39:20',9,0,2,NULL,NULL,NULL,'SP2021/0134',NULL,'2021-09-03 18:39:20','2021-09-03 18:39:20'),(135,295,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 18:39:33',3,0,2,NULL,NULL,NULL,'SP2021/0135',NULL,'2021-09-03 18:39:33','2021-09-03 18:39:33'),(136,296,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 18:58:05',3,0,2,NULL,NULL,NULL,'SP2021/0136',NULL,'2021-09-03 18:58:05','2021-09-03 18:58:05'),(137,297,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 19:01:30',3,0,2,NULL,NULL,NULL,'SP2021/0137',NULL,'2021-09-03 19:01:30','2021-09-03 19:01:30'),(138,298,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 19:04:07',9,0,2,NULL,NULL,NULL,'SP2021/0138',NULL,'2021-09-03 19:04:07','2021-09-03 19:04:07'),(139,299,2,0,525.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 19:27:30',3,0,2,NULL,NULL,NULL,'SP2021/0139',NULL,'2021-09-03 19:27:30','2021-09-03 19:27:30'),(140,300,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 19:43:03',9,0,2,NULL,NULL,NULL,'SP2021/0140',NULL,'2021-09-03 19:43:03','2021-09-03 19:43:03'),(141,301,2,0,195.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 19:45:10',9,0,2,NULL,NULL,NULL,'SP2021/0141',NULL,'2021-09-03 19:45:10','2021-09-03 19:45:10'),(142,303,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 20:04:39',9,0,2,NULL,NULL,NULL,'SP2021/0142',NULL,'2021-09-03 20:04:39','2021-09-03 20:04:39'),(143,304,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 20:06:55',3,0,2,NULL,NULL,NULL,'SP2021/0143',NULL,'2021-09-03 20:06:55','2021-09-03 20:06:55'),(144,306,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 20:12:06',9,0,2,NULL,NULL,NULL,'SP2021/0144',NULL,'2021-09-03 20:12:06','2021-09-03 20:12:06'),(145,307,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 20:20:44',9,0,2,NULL,NULL,NULL,'SP2021/0145',NULL,'2021-09-03 20:20:44','2021-09-03 20:20:44'),(146,308,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 20:23:18',9,0,2,NULL,NULL,NULL,'SP2021/0146',NULL,'2021-09-03 20:23:18','2021-09-03 20:23:18'),(147,309,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 20:24:03',3,0,2,NULL,NULL,NULL,'SP2021/0147',NULL,'2021-09-03 20:24:03','2021-09-03 20:24:03'),(148,310,2,0,300.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 20:32:21',3,0,2,NULL,NULL,NULL,'SP2021/0148',NULL,'2021-09-03 20:32:21','2021-09-03 20:32:21'),(149,311,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 20:36:21',9,0,2,NULL,NULL,NULL,'SP2021/0149',NULL,'2021-09-03 20:36:21','2021-09-03 20:36:21'),(150,312,2,0,225.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 20:37:02',3,0,2,NULL,NULL,NULL,'SP2021/0150',NULL,'2021-09-03 20:37:02','2021-09-03 20:37:02'),(151,313,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 20:37:47',9,0,2,NULL,NULL,NULL,'SP2021/0151',NULL,'2021-09-03 20:37:47','2021-09-03 20:37:47'),(152,314,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 20:41:28',9,0,2,NULL,NULL,NULL,'SP2021/0152',NULL,'2021-09-03 20:41:28','2021-09-03 20:41:28'),(153,315,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 20:52:48',3,0,2,NULL,NULL,NULL,'SP2021/0153',NULL,'2021-09-03 20:52:48','2021-09-03 20:52:48'),(154,316,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 21:07:12',9,0,2,NULL,NULL,NULL,'SP2021/0154',NULL,'2021-09-03 21:07:12','2021-09-03 21:07:12'),(155,317,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 21:14:18',3,0,2,NULL,NULL,NULL,'SP2021/0155',NULL,'2021-09-03 21:14:18','2021-09-03 21:14:18'),(156,318,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 21:20:18',9,0,2,NULL,NULL,NULL,'SP2021/0156',NULL,'2021-09-03 21:20:18','2021-09-03 21:20:18'),(157,319,2,0,175.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 21:28:18',9,0,2,NULL,NULL,NULL,'SP2021/0157',NULL,'2021-09-03 21:28:18','2021-09-03 21:28:18'),(158,320,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 21:45:39',3,0,2,NULL,NULL,NULL,'SP2021/0158',NULL,'2021-09-03 21:45:39','2021-09-03 21:45:39'),(159,321,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 21:50:29',9,0,2,NULL,NULL,NULL,'SP2021/0159',NULL,'2021-09-03 21:50:29','2021-09-03 21:50:29'),(160,322,2,0,225.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 21:50:36',3,0,2,NULL,NULL,NULL,'SP2021/0160',NULL,'2021-09-03 21:50:36','2021-09-03 21:50:36'),(161,323,2,0,350.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 21:54:58',9,0,2,NULL,NULL,NULL,'SP2021/0161',NULL,'2021-09-03 21:54:58','2021-09-03 21:54:58'),(162,324,2,0,195.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 22:07:44',3,0,2,NULL,NULL,NULL,'SP2021/0162',NULL,'2021-09-03 22:07:44','2021-09-03 22:07:44'),(163,326,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 22:25:05',9,0,2,NULL,NULL,NULL,'SP2021/0163',NULL,'2021-09-03 22:25:05','2021-09-03 22:25:05'),(164,327,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 22:52:39',9,0,2,NULL,NULL,NULL,'SP2021/0164',NULL,'2021-09-03 22:52:39','2021-09-03 22:52:39'),(165,328,2,0,500.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 22:53:01',3,0,2,NULL,NULL,NULL,'SP2021/0165',NULL,'2021-09-03 22:53:01','2021-09-03 22:53:01'),(166,329,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 22:54:02',3,0,2,NULL,NULL,NULL,'SP2021/0166',NULL,'2021-09-03 22:54:02','2021-09-03 22:54:02'),(167,330,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 23:21:16',3,0,2,NULL,NULL,NULL,'SP2021/0167',NULL,'2021-09-03 23:21:16','2021-09-03 23:21:16'),(168,331,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 23:25:16',9,0,2,NULL,NULL,NULL,'SP2021/0168',NULL,'2021-09-03 23:25:16','2021-09-03 23:25:16'),(169,332,2,0,425.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 23:26:49',3,0,2,NULL,NULL,NULL,'SP2021/0169',NULL,'2021-09-03 23:26:49','2021-09-03 23:26:49'),(170,333,2,0,425.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 23:55:08',9,0,2,NULL,NULL,NULL,'SP2021/0170',NULL,'2021-09-03 23:55:08','2021-09-03 23:55:08'),(171,334,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 10:03:00',2,0,2,NULL,NULL,NULL,'SP2021/0171',NULL,'2021-09-04 10:03:48','2021-09-04 10:03:48'),(172,302,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 10:03:00',2,0,2,NULL,NULL,NULL,'SP2021/0172',NULL,'2021-09-04 10:04:01','2021-09-04 10:04:01'),(173,293,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 10:04:00',2,0,2,NULL,NULL,NULL,'SP2021/0173',NULL,'2021-09-04 10:04:18','2021-09-04 10:04:18'),(174,286,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 10:04:00',2,0,2,NULL,NULL,NULL,'SP2021/0174',NULL,'2021-09-04 10:04:43','2021-09-04 10:04:43'),(175,276,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 10:04:00',2,0,2,NULL,NULL,NULL,'SP2021/0175',NULL,'2021-09-04 10:04:59','2021-09-04 10:04:59'),(176,274,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 10:05:00',2,0,2,NULL,NULL,NULL,'SP2021/0176',NULL,'2021-09-04 10:05:13','2021-09-04 10:05:13'),(177,270,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 10:05:00',2,0,2,NULL,NULL,NULL,'SP2021/0177',NULL,'2021-09-04 10:05:30','2021-09-04 10:05:30'),(178,162,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 10:05:00',2,0,2,NULL,NULL,NULL,'SP2021/0178',NULL,'2021-09-04 10:05:41','2021-09-04 10:05:41'),(179,76,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 10:05:00',2,0,2,NULL,NULL,NULL,'SP2021/0179',NULL,'2021-09-04 10:05:54','2021-09-04 10:05:54'),(180,335,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 12:19:48',3,0,2,NULL,NULL,NULL,'SP2021/0180',NULL,'2021-09-04 12:19:48','2021-09-04 12:19:48'),(181,336,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 12:29:30',9,0,2,NULL,NULL,NULL,'SP2021/0181',NULL,'2021-09-04 12:29:30','2021-09-04 12:29:30'),(182,337,2,0,475.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 12:42:21',9,0,2,NULL,NULL,NULL,'SP2021/0182',NULL,'2021-09-04 12:42:21','2021-09-04 12:42:21'),(183,338,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 13:19:00',2,0,2,NULL,NULL,NULL,'SP2021/0183',NULL,'2021-09-04 13:20:28','2021-09-04 13:20:28'),(184,339,2,0,475.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 14:08:13',3,0,2,NULL,NULL,NULL,'SP2021/0184',NULL,'2021-09-04 14:08:13','2021-09-04 14:08:13'),(185,340,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 15:33:30',3,0,2,NULL,NULL,NULL,'SP2021/0185',NULL,'2021-09-04 15:33:30','2021-09-04 15:33:30'),(186,341,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 16:09:23',3,0,2,NULL,NULL,NULL,'SP2021/0186',NULL,'2021-09-04 16:09:23','2021-09-04 16:09:23'),(187,342,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 16:10:59',3,0,2,NULL,NULL,NULL,'SP2021/0187',NULL,'2021-09-04 16:10:59','2021-09-04 16:10:59'),(188,343,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 17:16:52',3,0,2,NULL,NULL,NULL,'SP2021/0188',NULL,'2021-09-04 17:16:52','2021-09-04 17:16:52'),(189,344,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 17:24:21',9,0,2,NULL,NULL,NULL,'SP2021/0189',NULL,'2021-09-04 17:24:21','2021-09-04 17:24:21'),(190,345,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 17:29:00',9,0,2,NULL,NULL,NULL,'SP2021/0190',NULL,'2021-09-04 17:29:50','2021-09-04 17:29:50'),(191,346,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 17:36:15',3,0,2,NULL,NULL,NULL,'SP2021/0191',NULL,'2021-09-04 17:36:15','2021-09-04 17:36:15'),(192,347,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 17:56:23',3,0,2,NULL,NULL,NULL,'SP2021/0192',NULL,'2021-09-04 17:56:23','2021-09-04 17:56:23'),(193,348,2,0,375.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 17:58:41',3,0,2,NULL,NULL,NULL,'SP2021/0193',NULL,'2021-09-04 17:58:41','2021-09-04 17:58:41'),(194,349,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 18:46:28',3,0,2,NULL,NULL,NULL,'SP2021/0194',NULL,'2021-09-04 18:46:28','2021-09-04 18:46:28'),(195,350,2,0,600.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 18:48:17',3,0,2,NULL,NULL,NULL,'SP2021/0195',NULL,'2021-09-04 18:48:17','2021-09-04 18:48:17'),(196,351,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 18:51:55',9,0,2,NULL,NULL,NULL,'SP2021/0196',NULL,'2021-09-04 18:51:55','2021-09-04 18:51:55'),(197,352,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 18:55:10',3,0,2,NULL,NULL,NULL,'SP2021/0197',NULL,'2021-09-04 18:55:10','2021-09-04 18:55:10'),(198,353,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 19:01:19',3,0,2,NULL,NULL,NULL,'SP2021/0198',NULL,'2021-09-04 19:01:19','2021-09-04 19:01:19'),(199,354,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 19:06:02',9,0,2,NULL,NULL,NULL,'SP2021/0199',NULL,'2021-09-04 19:06:02','2021-09-04 19:06:02'),(200,355,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 19:09:00',9,0,2,NULL,NULL,NULL,'SP2021/0200',NULL,'2021-09-04 19:09:21','2021-09-04 19:09:21'),(201,356,2,0,395.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 19:40:58',9,0,2,NULL,NULL,NULL,'SP2021/0201',NULL,'2021-09-04 19:40:58','2021-09-04 19:40:58'),(202,357,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 20:11:10',9,0,2,NULL,NULL,NULL,'SP2021/0202',NULL,'2021-09-04 20:11:10','2021-09-04 20:11:10'),(203,358,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 20:27:28',3,0,2,NULL,NULL,NULL,'SP2021/0203',NULL,'2021-09-04 20:27:28','2021-09-04 20:27:28'),(204,359,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 20:33:39',3,0,2,NULL,NULL,NULL,'SP2021/0204',NULL,'2021-09-04 20:33:39','2021-09-04 20:33:39'),(205,360,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 20:35:11',3,0,2,NULL,NULL,NULL,'SP2021/0205',NULL,'2021-09-04 20:35:11','2021-09-04 20:35:11'),(206,361,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 20:35:55',3,0,2,NULL,NULL,NULL,'SP2021/0206',NULL,'2021-09-04 20:35:55','2021-09-04 20:35:55'),(207,362,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 20:40:00',3,0,2,NULL,NULL,NULL,'SP2021/0207',NULL,'2021-09-04 20:40:00','2021-09-04 20:40:00'),(208,363,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 20:53:38',3,0,2,NULL,NULL,NULL,'SP2021/0208',NULL,'2021-09-04 20:53:38','2021-09-04 20:53:38'),(209,364,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 20:57:00',9,0,2,NULL,NULL,NULL,'SP2021/0209',NULL,'2021-09-04 20:57:00','2021-09-04 20:57:00'),(210,365,2,0,25.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 20:57:58',9,0,2,NULL,NULL,NULL,'SP2021/0210',NULL,'2021-09-04 20:57:58','2021-09-04 20:57:58'),(211,367,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 21:08:20',3,0,2,NULL,NULL,NULL,'SP2021/0211',NULL,'2021-09-04 21:08:20','2021-09-04 21:08:20'),(212,366,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 21:13:00',3,0,2,NULL,NULL,NULL,'SP2021/0212',NULL,'2021-09-04 21:13:31','2021-09-04 21:13:31'),(213,368,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 21:28:12',3,0,2,NULL,NULL,NULL,'SP2021/0213',NULL,'2021-09-04 21:28:12','2021-09-04 21:28:12'),(214,369,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 21:29:05',9,0,2,NULL,NULL,NULL,'SP2021/0214',NULL,'2021-09-04 21:29:05','2021-09-04 21:29:05'),(215,370,2,0,300.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 21:40:44',9,0,2,NULL,NULL,NULL,'SP2021/0215',NULL,'2021-09-04 21:40:44','2021-09-04 21:40:44'),(216,371,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 21:47:44',3,0,2,NULL,NULL,NULL,'SP2021/0216',NULL,'2021-09-04 21:47:44','2021-09-04 21:47:44'),(217,372,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 22:02:41',9,0,2,NULL,NULL,NULL,'SP2021/0217',NULL,'2021-09-04 22:02:41','2021-09-04 22:02:41'),(218,373,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 22:02:59',3,0,2,NULL,NULL,NULL,'SP2021/0218',NULL,'2021-09-04 22:02:59','2021-09-04 22:02:59'),(219,374,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 22:03:24',9,0,2,NULL,NULL,NULL,'SP2021/0219',NULL,'2021-09-04 22:03:24','2021-09-04 22:03:24'),(220,375,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 22:07:54',3,0,2,NULL,NULL,NULL,'SP2021/0220',NULL,'2021-09-04 22:07:54','2021-09-04 22:07:54'),(221,376,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 22:17:30',3,0,2,NULL,NULL,NULL,'SP2021/0221',NULL,'2021-09-04 22:17:30','2021-09-04 22:17:30'),(222,377,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 22:22:55',3,0,2,NULL,NULL,NULL,'SP2021/0222',NULL,'2021-09-04 22:22:55','2021-09-04 22:22:55'),(223,378,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 22:37:39',9,0,2,NULL,NULL,NULL,'SP2021/0223',NULL,'2021-09-04 22:37:39','2021-09-04 22:37:39'),(224,379,2,0,125.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 22:44:59',3,0,2,NULL,NULL,NULL,'SP2021/0224',NULL,'2021-09-04 22:44:59','2021-09-04 22:44:59'),(225,380,2,0,275.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 22:47:25',3,0,2,NULL,NULL,NULL,'SP2021/0225',NULL,'2021-09-04 22:47:25','2021-09-04 22:47:25'),(226,381,2,0,175.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 22:48:28',3,0,2,NULL,NULL,NULL,'SP2021/0226',NULL,'2021-09-04 22:48:28','2021-09-04 22:48:28'),(227,382,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 22:49:36',9,0,2,NULL,NULL,NULL,'SP2021/0227',NULL,'2021-09-04 22:49:36','2021-09-04 22:49:36'),(228,383,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 22:51:31',3,0,2,NULL,NULL,NULL,'SP2021/0228',NULL,'2021-09-04 22:51:31','2021-09-04 22:51:31'),(229,384,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 11:41:52',3,0,2,NULL,NULL,NULL,'SP2021/0229',NULL,'2021-09-05 11:41:52','2021-09-05 11:41:52'),(230,385,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 11:59:40',3,0,2,NULL,NULL,NULL,'SP2021/0230',NULL,'2021-09-05 11:59:40','2021-09-05 11:59:40'),(231,386,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 12:09:07',3,0,2,NULL,NULL,NULL,'SP2021/0231',NULL,'2021-09-05 12:09:07','2021-09-05 12:09:07'),(232,387,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 12:09:45',3,0,2,NULL,NULL,NULL,'SP2021/0232',NULL,'2021-09-05 12:09:45','2021-09-05 12:09:45'),(233,388,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 12:26:06',3,0,2,NULL,NULL,NULL,'SP2021/0233',NULL,'2021-09-05 12:26:06','2021-09-05 12:26:06'),(234,389,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 13:29:07',3,0,2,NULL,NULL,NULL,'SP2021/0234',NULL,'2021-09-05 13:29:07','2021-09-05 13:29:07'),(235,390,2,0,300.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 15:23:00',3,0,2,NULL,NULL,NULL,'SP2021/0235',NULL,'2021-09-05 15:23:18','2021-09-05 15:23:18'),(236,391,2,0,300.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 15:24:23',3,0,2,NULL,NULL,NULL,'SP2021/0236',NULL,'2021-09-05 15:24:23','2021-09-05 15:24:23'),(237,392,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 15:32:10',3,0,2,NULL,NULL,NULL,'SP2021/0237',NULL,'2021-09-05 15:32:10','2021-09-05 15:32:10'),(238,393,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 16:07:36',3,0,2,NULL,NULL,NULL,'SP2021/0238',NULL,'2021-09-05 16:07:36','2021-09-05 16:07:36'),(239,394,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 17:52:43',3,0,2,NULL,NULL,NULL,'SP2021/0239',NULL,'2021-09-05 17:52:43','2021-09-05 17:52:43'),(240,395,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 18:04:14',9,0,2,NULL,NULL,NULL,'SP2021/0240',NULL,'2021-09-05 18:04:14','2021-09-05 18:04:14'),(241,396,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 18:06:48',9,0,2,NULL,NULL,NULL,'SP2021/0241',NULL,'2021-09-05 18:06:48','2021-09-05 18:06:48'),(242,397,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 18:32:58',9,0,2,NULL,NULL,NULL,'SP2021/0242',NULL,'2021-09-05 18:32:58','2021-09-05 18:32:58'),(243,398,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 18:42:03',3,0,2,NULL,NULL,NULL,'SP2021/0243',NULL,'2021-09-05 18:42:03','2021-09-05 18:42:03'),(244,399,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 18:48:36',3,0,2,NULL,NULL,NULL,'SP2021/0244',NULL,'2021-09-05 18:48:36','2021-09-05 18:48:36'),(245,400,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 18:53:15',3,0,2,NULL,NULL,NULL,'SP2021/0245',NULL,'2021-09-05 18:53:15','2021-09-05 18:53:15'),(246,401,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 19:36:46',9,0,2,NULL,NULL,NULL,'SP2021/0246',NULL,'2021-09-05 19:36:46','2021-09-05 19:36:46'),(247,402,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 19:45:10',3,0,2,NULL,NULL,NULL,'SP2021/0247',NULL,'2021-09-05 19:45:10','2021-09-05 19:45:10'),(248,403,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 19:47:35',3,0,2,NULL,NULL,NULL,'SP2021/0248',NULL,'2021-09-05 19:47:35','2021-09-05 19:47:35'),(249,404,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 20:25:23',9,0,2,NULL,NULL,NULL,'SP2021/0249',NULL,'2021-09-05 20:25:23','2021-09-05 20:25:23'),(250,405,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 20:41:22',9,0,2,NULL,NULL,NULL,'SP2021/0250',NULL,'2021-09-05 20:41:22','2021-09-05 20:41:22'),(251,406,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 20:42:46',9,0,2,NULL,NULL,NULL,'SP2021/0251',NULL,'2021-09-05 20:42:46','2021-09-05 20:42:46'),(252,407,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 21:18:29',3,0,2,NULL,NULL,NULL,'SP2021/0252',NULL,'2021-09-05 21:18:29','2021-09-05 21:18:29'),(253,408,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 21:20:21',3,0,2,NULL,NULL,NULL,'SP2021/0253',NULL,'2021-09-05 21:20:21','2021-09-05 21:20:21'),(254,409,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 21:30:02',3,0,2,NULL,NULL,NULL,'SP2021/0254',NULL,'2021-09-05 21:30:02','2021-09-05 21:30:02'),(255,410,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 21:47:24',3,0,2,NULL,NULL,NULL,'SP2021/0255',NULL,'2021-09-05 21:47:24','2021-09-05 21:47:24'),(256,411,2,0,225.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 22:40:19',9,0,2,NULL,NULL,NULL,'SP2021/0256',NULL,'2021-09-05 22:40:19','2021-09-05 22:40:19'),(257,412,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 22:53:10',3,0,2,NULL,NULL,NULL,'SP2021/0257',NULL,'2021-09-05 22:53:10','2021-09-05 22:53:10'),(258,413,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 23:02:18',3,0,2,NULL,NULL,NULL,'SP2021/0258',NULL,'2021-09-05 23:02:18','2021-09-05 23:02:18'),(259,414,2,0,225.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 23:04:45',9,0,2,NULL,NULL,NULL,'SP2021/0259',NULL,'2021-09-05 23:04:45','2021-09-05 23:04:45'),(260,211,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:51:48',9,0,2,NULL,NULL,NULL,'SP2021/0056-edited',NULL,'2021-09-02 18:51:48','2021-09-02 18:49:46'),(261,415,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 13:17:55',3,0,2,NULL,NULL,NULL,'SP2021/0260',NULL,'2021-09-06 13:17:55','2021-09-06 13:17:55'),(262,416,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 14:06:12',3,0,2,NULL,NULL,NULL,'SP2021/0261',NULL,'2021-09-06 14:06:12','2021-09-06 14:06:12'),(263,417,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 14:16:40',9,0,2,NULL,NULL,NULL,'SP2021/0262',NULL,'2021-09-06 14:16:40','2021-09-06 14:16:40'),(264,418,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 16:10:43',9,0,2,NULL,NULL,NULL,'SP2021/0263',NULL,'2021-09-06 16:10:43','2021-09-06 16:10:43'),(265,420,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 17:52:49',3,0,2,NULL,NULL,NULL,'SP2021/0264',NULL,'2021-09-06 17:52:49','2021-09-06 17:52:49'),(266,419,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 17:54:00',3,0,2,NULL,NULL,NULL,'SP2021/0265',NULL,'2021-09-06 17:54:33','2021-09-06 17:54:33'),(267,421,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 18:38:05',3,0,2,NULL,NULL,NULL,'SP2021/0266',NULL,'2021-09-06 18:38:05','2021-09-06 18:38:05'),(268,422,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 18:56:11',3,0,2,NULL,NULL,NULL,'SP2021/0267',NULL,'2021-09-06 18:56:11','2021-09-06 18:56:11'),(269,423,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 19:12:58',3,0,2,NULL,NULL,NULL,'SP2021/0268',NULL,'2021-09-06 19:12:58','2021-09-06 19:12:58'),(270,424,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 19:16:30',3,0,2,NULL,NULL,NULL,'SP2021/0269',NULL,'2021-09-06 19:16:30','2021-09-06 19:16:30'),(271,425,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 19:35:03',3,0,2,NULL,NULL,NULL,'SP2021/0270',NULL,'2021-09-06 19:35:03','2021-09-06 19:35:03'),(272,426,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 20:00:00',3,0,2,NULL,NULL,NULL,'SP2021/0271',NULL,'2021-09-06 20:00:28','2021-09-06 20:00:28'),(273,427,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 20:08:02',3,0,2,NULL,NULL,NULL,'SP2021/0272',NULL,'2021-09-06 20:08:02','2021-09-06 20:08:02'),(274,428,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 20:09:40',3,0,2,NULL,NULL,NULL,'SP2021/0273',NULL,'2021-09-06 20:09:40','2021-09-06 20:09:40'),(275,429,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 20:38:46',9,0,2,NULL,NULL,NULL,'SP2021/0274',NULL,'2021-09-06 20:38:46','2021-09-06 20:38:46'),(276,430,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 20:51:19',9,0,2,NULL,NULL,NULL,'SP2021/0275',NULL,'2021-09-06 20:51:19','2021-09-06 20:51:19'),(277,431,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 21:22:21',3,0,2,NULL,NULL,NULL,'SP2021/0276',NULL,'2021-09-06 21:22:21','2021-09-06 21:22:21'),(278,432,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 21:22:37',9,0,2,NULL,NULL,NULL,'SP2021/0277',NULL,'2021-09-06 21:22:37','2021-09-06 21:22:37'),(279,433,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 21:23:21',9,0,2,NULL,NULL,NULL,'SP2021/0278',NULL,'2021-09-06 21:23:21','2021-09-06 21:23:21'),(280,434,2,0,575.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 21:26:07',3,0,2,NULL,NULL,NULL,'SP2021/0279',NULL,'2021-09-06 21:26:07','2021-09-06 21:26:07'),(281,435,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 21:41:10',3,0,2,NULL,NULL,NULL,'SP2021/0280',NULL,'2021-09-06 21:41:10','2021-09-06 21:41:10'),(282,436,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 21:55:08',3,0,2,NULL,NULL,NULL,'SP2021/0281',NULL,'2021-09-06 21:55:08','2021-09-06 21:55:08'),(283,437,2,0,275.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 22:11:02',3,0,2,NULL,NULL,NULL,'SP2021/0282',NULL,'2021-09-06 22:11:02','2021-09-06 22:11:02'),(284,438,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 22:36:37',3,0,2,NULL,NULL,NULL,'SP2021/0283',NULL,'2021-09-06 22:36:37','2021-09-06 22:36:37'),(285,439,2,0,350.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 22:57:31',3,0,2,NULL,NULL,NULL,'SP2021/0284',NULL,'2021-09-06 22:57:31','2021-09-06 22:57:31'),(286,440,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 11:19:35',3,0,2,NULL,NULL,NULL,'SP2021/0285',NULL,'2021-09-07 11:19:35','2021-09-07 11:19:35'),(287,442,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 11:49:53',3,0,2,NULL,NULL,NULL,'SP2021/0286',NULL,'2021-09-07 11:49:53','2021-09-07 11:49:53'),(288,441,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 11:51:00',3,0,2,NULL,NULL,NULL,'SP2021/0287',NULL,'2021-09-07 11:51:19','2021-09-07 11:51:19'),(289,443,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 12:19:56',3,0,2,NULL,NULL,NULL,'SP2021/0288',NULL,'2021-09-07 12:19:56','2021-09-07 12:19:56'),(290,444,2,0,650.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 13:23:35',3,0,2,NULL,NULL,NULL,'SP2021/0289',NULL,'2021-09-07 13:23:35','2021-09-07 13:23:35'),(291,445,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 13:47:49',9,0,2,NULL,NULL,NULL,'SP2021/0290',NULL,'2021-09-07 13:47:49','2021-09-07 13:47:49'),(292,446,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 15:07:51',9,0,2,NULL,NULL,NULL,'SP2021/0291',NULL,'2021-09-07 15:07:51','2021-09-07 15:07:51'),(293,447,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 15:10:12',9,0,2,NULL,NULL,NULL,'SP2021/0292',NULL,'2021-09-07 15:10:12','2021-09-07 15:10:12'),(294,448,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 15:13:00',9,0,2,NULL,NULL,NULL,'SP2021/0293',NULL,'2021-09-07 15:13:12','2021-09-07 15:13:12'),(295,449,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 16:32:09',9,0,2,NULL,NULL,NULL,'SP2021/0294',NULL,'2021-09-07 16:32:09','2021-09-07 16:32:09'),(296,450,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 16:34:23',3,0,2,NULL,NULL,NULL,'SP2021/0295',NULL,'2021-09-07 16:34:23','2021-09-07 16:34:23'),(297,451,2,0,225.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 17:17:35',3,0,2,NULL,NULL,NULL,'SP2021/0296',NULL,'2021-09-07 17:17:35','2021-09-07 17:17:35'),(298,452,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 17:53:50',3,0,2,NULL,NULL,NULL,'SP2021/0297',NULL,'2021-09-07 17:53:50','2021-09-07 17:53:50'),(299,453,2,0,225.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 18:15:30',3,0,2,NULL,NULL,NULL,'SP2021/0298',NULL,'2021-09-07 18:15:30','2021-09-07 18:15:30'),(300,454,2,0,350.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 18:54:24',3,0,2,NULL,NULL,NULL,'SP2021/0299',NULL,'2021-09-07 18:54:24','2021-09-07 18:54:24'),(301,455,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 18:56:23',9,0,2,NULL,NULL,NULL,'SP2021/0300',NULL,'2021-09-07 18:56:23','2021-09-07 18:56:23'),(302,456,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 19:00:27',9,0,2,NULL,NULL,NULL,'SP2021/0301',NULL,'2021-09-07 19:00:27','2021-09-07 19:00:27'),(303,457,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 19:19:08',9,0,2,NULL,NULL,NULL,'SP2021/0302',NULL,'2021-09-07 19:19:08','2021-09-07 19:19:08'),(304,458,2,0,650.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 19:31:15',9,0,2,NULL,NULL,NULL,'SP2021/0303',NULL,'2021-09-07 19:31:15','2021-09-07 19:31:15'),(305,459,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 20:04:54',9,0,2,NULL,NULL,NULL,'SP2021/0304',NULL,'2021-09-07 20:04:54','2021-09-07 20:04:54'),(306,460,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 20:41:39',9,0,2,NULL,NULL,NULL,'SP2021/0305',NULL,'2021-09-07 20:41:39','2021-09-07 20:41:39'),(307,461,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 20:59:08',3,0,2,NULL,NULL,NULL,'SP2021/0306',NULL,'2021-09-07 20:59:08','2021-09-07 20:59:08'),(308,462,2,0,25.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 21:42:36',3,0,2,NULL,NULL,NULL,'SP2021/0307',NULL,'2021-09-07 21:42:36','2021-09-07 21:42:36'),(309,463,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 22:29:14',3,0,2,NULL,NULL,NULL,'SP2021/0308',NULL,'2021-09-07 22:29:14','2021-09-07 22:29:14'),(310,464,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 13:18:05',9,0,2,NULL,NULL,NULL,'SP2021/0309',NULL,'2021-09-08 13:18:05','2021-09-08 13:18:05'),(311,466,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 13:51:16',3,0,2,NULL,NULL,NULL,'SP2021/0310',NULL,'2021-09-08 13:51:16','2021-09-08 13:51:16'),(312,467,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 13:55:00',9,0,2,NULL,NULL,NULL,'SP2021/0311',NULL,'2021-09-08 13:55:00','2021-09-08 13:55:00'),(313,468,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 13:56:08',9,0,2,NULL,NULL,NULL,'SP2021/0312',NULL,'2021-09-08 13:56:08','2021-09-08 13:56:08'),(314,469,2,0,225.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 13:56:11',3,0,2,NULL,NULL,NULL,'SP2021/0313',NULL,'2021-09-08 13:56:11','2021-09-08 13:56:11'),(319,470,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 15:53:46',9,0,2,NULL,NULL,NULL,'SP2021/0314',NULL,'2021-09-08 15:53:46','2021-09-08 15:53:46'),(321,472,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 16:07:52',3,0,2,NULL,NULL,NULL,'SP2021/0315',NULL,'2021-09-08 16:07:52','2021-09-08 16:07:52'),(322,473,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 16:55:51',9,0,2,NULL,NULL,NULL,'SP2021/0316',NULL,'2021-09-08 16:55:51','2021-09-08 16:55:51'),(337,474,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 18:24:00',9,0,2,NULL,NULL,NULL,'SP2021/0317',NULL,'2021-09-08 18:24:29','2021-09-08 18:24:29'),(338,471,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 18:24:00',9,0,2,NULL,NULL,NULL,'SP2021/0318',NULL,'2021-09-08 18:24:44','2021-09-08 18:24:44'),(339,478,2,0,350.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 19:25:32',9,0,2,NULL,NULL,NULL,'SP2021/0319',NULL,'2021-09-08 19:25:32','2021-09-08 19:25:32'),(340,479,2,0,125.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 19:34:20',3,0,2,NULL,NULL,NULL,'SP2021/0320',NULL,'2021-09-08 19:34:20','2021-09-08 19:34:20'),(341,465,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 19:40:00',3,0,2,NULL,NULL,NULL,'SP2021/0321',NULL,'2021-09-08 19:40:55','2021-09-08 19:40:55'),(342,480,2,0,300.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 19:41:57',9,0,2,NULL,NULL,NULL,'SP2021/0322',NULL,'2021-09-08 19:41:57','2021-09-08 19:41:57'),(343,481,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 19:43:14',9,0,2,NULL,NULL,NULL,'SP2021/0323',NULL,'2021-09-08 19:43:14','2021-09-08 19:43:14'),(344,482,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 20:09:16',3,0,2,NULL,NULL,NULL,'SP2021/0324',NULL,'2021-09-08 20:09:16','2021-09-08 20:09:16'),(345,483,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 20:18:09',3,0,2,NULL,NULL,NULL,'SP2021/0325',NULL,'2021-09-08 20:18:09','2021-09-08 20:18:09'),(346,484,2,0,350.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 20:45:08',9,0,2,NULL,NULL,NULL,'SP2021/0326',NULL,'2021-09-08 20:45:08','2021-09-08 20:45:08'),(347,485,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 20:48:15',3,0,2,NULL,NULL,NULL,'SP2021/0327',NULL,'2021-09-08 20:48:15','2021-09-08 20:48:15'),(348,486,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 20:49:08',9,0,2,NULL,NULL,NULL,'SP2021/0328',NULL,'2021-09-08 20:49:08','2021-09-08 20:49:08'),(349,487,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 21:15:16',3,0,2,NULL,NULL,NULL,'SP2021/0329',NULL,'2021-09-08 21:15:16','2021-09-08 21:15:16'),(350,488,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 22:11:49',9,0,2,NULL,NULL,NULL,'SP2021/0330',NULL,'2021-09-08 22:11:49','2021-09-08 22:11:49'),(351,489,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 22:24:10',9,0,2,NULL,NULL,NULL,'SP2021/0331',NULL,'2021-09-08 22:24:10','2021-09-08 22:24:10'),(352,490,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 13:46:47',3,0,2,NULL,NULL,NULL,'SP2021/0332',NULL,'2021-09-09 13:46:47','2021-09-09 13:46:47'),(353,491,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 14:20:25',3,0,2,NULL,NULL,NULL,'SP2021/0333',NULL,'2021-09-09 14:20:25','2021-09-09 14:20:25'),(354,492,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 14:37:28',3,0,2,NULL,NULL,NULL,'SP2021/0334',NULL,'2021-09-09 14:37:28','2021-09-09 14:37:28'),(355,493,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 14:52:11',3,0,2,NULL,NULL,NULL,'SP2021/0335',NULL,'2021-09-09 14:52:11','2021-09-09 14:52:11'),(356,494,2,0,350.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 15:05:00',9,0,2,NULL,NULL,NULL,'SP2021/0336',NULL,'2021-09-09 15:05:50','2021-09-09 15:05:50'),(357,496,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 15:36:15',9,0,2,NULL,NULL,NULL,'SP2021/0337',NULL,'2021-09-09 15:36:15','2021-09-09 15:36:15'),(358,497,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 16:22:56',3,0,2,NULL,NULL,NULL,'SP2021/0338',NULL,'2021-09-09 16:22:56','2021-09-09 16:22:56'),(359,498,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 16:35:00',3,0,2,NULL,NULL,NULL,'SP2021/0339',NULL,'2021-09-09 16:35:35','2021-09-09 16:35:35'),(360,499,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 16:37:00',3,0,2,NULL,NULL,NULL,'SP2021/0340',NULL,'2021-09-09 16:37:42','2021-09-09 16:37:42'),(361,495,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 16:42:00',9,0,2,NULL,NULL,NULL,'SP2021/0341',NULL,'2021-09-09 16:42:43','2021-09-09 16:42:43'),(362,500,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 16:44:58',9,0,2,NULL,NULL,NULL,'SP2021/0342',NULL,'2021-09-09 16:44:58','2021-09-09 16:44:58'),(363,501,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 16:45:18',9,0,2,NULL,NULL,NULL,'SP2021/0343',NULL,'2021-09-09 16:45:18','2021-09-09 16:45:18'),(364,502,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 17:44:14',3,0,2,NULL,NULL,NULL,'SP2021/0344',NULL,'2021-09-09 17:44:14','2021-09-09 17:44:14'),(365,507,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 19:43:45',9,0,2,NULL,NULL,NULL,'SP2021/0345',NULL,'2021-09-09 19:43:45','2021-09-09 19:43:45'),(366,508,2,0,450.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 21:33:29',3,0,2,NULL,NULL,NULL,'SP2021/0346',NULL,'2021-09-09 21:33:29','2021-09-09 21:33:29'),(367,509,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 21:59:51',9,0,2,NULL,NULL,NULL,'SP2021/0347',NULL,'2021-09-09 21:59:51','2021-09-09 21:59:51'),(368,510,2,0,275.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 23:15:06',9,0,2,NULL,NULL,NULL,'SP2021/0348',NULL,'2021-09-09 23:15:06','2021-09-09 23:15:06'),(369,515,2,0,675.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 14:19:35',3,0,2,NULL,NULL,NULL,'SP2021/0349',NULL,'2021-09-10 14:19:35','2021-09-10 14:19:35'),(370,516,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 14:26:24',9,0,2,NULL,NULL,NULL,'SP2021/0350',NULL,'2021-09-10 14:26:24','2021-09-10 14:26:24'),(371,517,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 15:16:00',9,0,2,NULL,NULL,NULL,'SP2021/0351',NULL,'2021-09-10 15:16:00','2021-09-10 15:16:00'),(372,520,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 17:06:27',9,0,2,NULL,NULL,NULL,'SP2021/0352',NULL,'2021-09-10 17:06:27','2021-09-10 17:06:27'),(373,522,2,0,1490.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 17:32:40',9,0,2,NULL,NULL,NULL,'SP2021/0353',NULL,'2021-09-10 17:32:40','2021-09-10 17:32:40'),(374,523,2,0,500.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 17:48:00',3,0,2,NULL,NULL,NULL,'SP2021/0354',NULL,'2021-09-10 17:48:00','2021-09-10 17:48:00'),(375,524,2,0,500.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 17:49:24',3,0,2,NULL,NULL,NULL,'SP2021/0355',NULL,'2021-09-10 17:49:24','2021-09-10 17:49:24'),(376,525,2,0,300.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 17:53:46',3,0,2,NULL,NULL,NULL,'SP2021/0356',NULL,'2021-09-10 17:53:46','2021-09-10 17:53:46'),(377,526,2,0,450.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 18:52:44',9,0,2,NULL,NULL,NULL,'SP2021/0357',NULL,'2021-09-10 18:52:44','2021-09-10 18:52:44'),(378,527,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 19:09:22',9,0,2,NULL,NULL,NULL,'SP2021/0358',NULL,'2021-09-10 19:09:22','2021-09-10 19:09:22'),(379,528,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 19:26:20',3,0,2,NULL,NULL,NULL,'SP2021/0359',NULL,'2021-09-10 19:26:20','2021-09-10 19:26:20'),(382,531,2,0,175.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 19:38:04',3,0,2,NULL,NULL,NULL,'SP2021/0360',NULL,'2021-09-10 19:38:04','2021-09-10 19:38:04'),(383,532,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 19:42:34',9,0,2,NULL,NULL,NULL,'SP2021/0361',NULL,'2021-09-10 19:42:34','2021-09-10 19:42:34'),(384,533,2,0,500.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 20:04:00',3,0,2,NULL,NULL,NULL,'SP2021/0362',NULL,'2021-09-10 20:04:48','2021-09-10 20:04:48'),(385,534,2,0,950.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 20:16:34',3,0,2,NULL,NULL,NULL,'SP2021/0363',NULL,'2021-09-10 20:16:34','2021-09-10 20:16:34'),(386,535,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 21:13:24',3,0,2,NULL,NULL,NULL,'SP2021/0364',NULL,'2021-09-10 21:13:24','2021-09-10 21:13:24'),(387,536,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 21:16:33',3,0,2,NULL,NULL,NULL,'SP2021/0365',NULL,'2021-09-10 21:16:33','2021-09-10 21:16:33'),(388,537,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 21:22:41',3,0,2,NULL,NULL,NULL,'SP2021/0366',NULL,'2021-09-10 21:22:41','2021-09-10 21:22:41'),(389,538,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 22:14:17',9,0,2,NULL,NULL,NULL,'SP2021/0367',NULL,'2021-09-10 22:14:17','2021-09-10 22:14:17'),(390,539,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 22:15:08',3,0,2,NULL,NULL,NULL,'SP2021/0368',NULL,'2021-09-10 22:15:08','2021-09-10 22:15:08'),(391,540,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 17:13:56',9,0,2,NULL,NULL,NULL,'SP2021/0369',NULL,'2021-09-11 17:13:56','2021-09-11 17:13:56'),(392,541,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 20:27:48',9,0,2,NULL,NULL,NULL,'SP2021/0370',NULL,'2021-09-11 20:27:48','2021-09-11 20:27:48'),(393,542,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 20:31:00',9,0,2,NULL,NULL,NULL,'SP2021/0371',NULL,'2021-09-11 20:31:48','2021-09-11 20:31:48'),(394,543,2,0,600.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 20:45:46',9,0,2,NULL,NULL,NULL,'SP2021/0372',NULL,'2021-09-11 20:45:46','2021-09-11 20:45:46'),(395,546,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 21:59:00',3,0,2,NULL,NULL,NULL,'SP2021/0373',NULL,'2021-09-11 21:59:48','2021-09-11 21:59:48'),(396,547,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 22:19:48',9,0,2,NULL,NULL,NULL,'SP2021/0374',NULL,'2021-09-11 22:19:48','2021-09-11 22:19:48'),(397,548,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 19:50:00',9,0,2,NULL,NULL,NULL,'SP2021/0375',NULL,'2021-09-12 19:51:41','2021-09-12 19:51:41'),(398,549,2,0,500.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 20:06:40',9,0,2,NULL,NULL,NULL,'SP2021/0376',NULL,'2021-09-12 20:06:40','2021-09-12 20:06:40'),(399,550,2,0,195.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 22:02:25',9,0,2,NULL,NULL,NULL,'SP2021/0377',NULL,'2021-09-12 22:02:25','2021-09-12 22:02:25'),(400,551,2,0,175.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 13:23:46',9,0,2,NULL,NULL,NULL,'SP2021/0378',NULL,'2021-09-13 13:23:46','2021-09-13 13:23:46'),(401,552,2,0,50.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 16:34:15',9,0,2,NULL,NULL,NULL,'SP2021/0379',NULL,'2021-09-13 16:34:15','2021-09-13 16:34:15'),(402,553,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 18:21:41',9,0,2,NULL,NULL,NULL,'SP2021/0380',NULL,'2021-09-13 18:21:41','2021-09-13 18:21:41'),(403,554,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 18:43:31',3,0,2,NULL,NULL,NULL,'SP2021/0381',NULL,'2021-09-13 18:43:31','2021-09-13 18:43:31'),(404,555,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 19:25:31',9,0,2,NULL,NULL,NULL,'SP2021/0382',NULL,'2021-09-13 19:25:31','2021-09-13 19:25:31'),(405,557,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 21:09:57',3,0,2,NULL,NULL,NULL,'SP2021/0383',NULL,'2021-09-13 21:09:57','2021-09-13 21:09:57'),(406,558,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 22:27:31',9,0,2,NULL,NULL,NULL,'SP2021/0384',NULL,'2021-09-13 22:27:31','2021-09-13 22:27:31'),(407,556,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 22:42:00',3,0,2,NULL,NULL,NULL,'SP2021/0385',NULL,'2021-09-13 22:42:16','2021-09-13 22:42:16'),(408,559,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 15:15:09',9,0,2,NULL,NULL,NULL,'SP2021/0386',NULL,'2021-09-14 15:15:09','2021-09-14 15:15:09'),(409,560,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 15:27:41',9,0,2,NULL,NULL,NULL,'SP2021/0387',NULL,'2021-09-14 15:27:41','2021-09-14 15:27:41'),(410,561,2,0,100.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 17:01:34',3,0,2,NULL,NULL,NULL,'SP2021/0388',NULL,'2021-09-14 17:01:34','2021-09-14 17:01:34'),(411,562,2,0,150.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 17:21:26',3,0,2,NULL,NULL,NULL,'SP2021/0389',NULL,'2021-09-14 17:21:26','2021-09-14 17:21:26'),(412,563,2,0,250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 20:13:11',9,0,2,NULL,NULL,NULL,'SP2021/0390',NULL,'2021-09-14 20:13:11','2021-09-14 20:13:11'),(413,564,2,0,390.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 20:47:47',9,0,2,NULL,NULL,NULL,'SP2021/0391',NULL,'2021-09-14 20:47:47','2021-09-14 20:47:47'),(414,565,2,0,225.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 21:29:08',3,0,2,NULL,NULL,NULL,'SP2021/0392',NULL,'2021-09-14 21:29:08','2021-09-14 21:29:08'),(415,566,2,0,200.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 21:55:29',3,0,2,NULL,NULL,NULL,'SP2021/0393',NULL,'2021-09-14 21:55:29','2021-09-14 21:55:29'),(416,567,2,0,75.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 22:01:51',3,0,2,NULL,NULL,NULL,'SP2021/0394',NULL,'2021-09-14 22:01:51','2021-09-14 22:01:51'),(417,569,1,0,11875.0000,'cheque',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,'123456',NULL,'2021-09-20 22:37:00',1,0,5,NULL,NULL,NULL,'SP2021/0001',23,'2021-09-20 22:39:03','2021-09-20 22:41:00'),(418,570,1,0,11250.0000,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 22:39:00',1,0,5,NULL,NULL,NULL,'SP2021/0002',23,'2021-09-20 22:39:54','2021-09-20 22:41:11');
/*!40000 ALTER TABLE `transaction_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_sell_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `quantity_returned` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `unit_price_before_discount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `unit_price` decimal(22,4) DEFAULT NULL COMMENT 'Sell price excluding tax',
  `line_discount_type` enum('fixed','percentage') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `line_discount_amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `unit_price_inc_tax` decimal(22,4) DEFAULT NULL COMMENT 'Sell price including tax',
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `discount_id` int(11) DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `sell_line_note` text COLLATE utf8mb4_unicode_ci,
  `so_line_id` int(11) DEFAULT NULL,
  `so_quantity_invoiced` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `res_service_staff_id` int(11) DEFAULT NULL,
  `res_line_order_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_sell_line_id` int(11) DEFAULT NULL,
  `children_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Type of children for the parent, like modifier or combo',
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `transaction_sell_lines_transaction_id_foreign` (`transaction_id`) USING BTREE,
  KEY `transaction_sell_lines_product_id_foreign` (`product_id`) USING BTREE,
  KEY `transaction_sell_lines_variation_id_foreign` (`variation_id`) USING BTREE,
  KEY `transaction_sell_lines_tax_id_foreign` (`tax_id`) USING BTREE,
  KEY `transaction_sell_lines_children_type_index` (`children_type`) USING BTREE,
  KEY `transaction_sell_lines_parent_sell_line_id_index` (`parent_sell_line_id`) USING BTREE,
  KEY `transaction_sell_lines_line_discount_type_index` (`line_discount_type`) USING BTREE,
  KEY `transaction_sell_lines_discount_id_index` (`discount_id`) USING BTREE,
  KEY `transaction_sell_lines_lot_no_line_id_index` (`lot_no_line_id`) USING BTREE,
  KEY `transaction_sell_lines_sub_unit_id_index` (`sub_unit_id`) USING BTREE,
  CONSTRAINT `transaction_sell_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=691 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines` VALUES (1,34,20,191,1.0000,1.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-01 21:28:23','2021-09-01 21:32:52'),(2,45,20,191,1.0000,1.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-01 21:39:59','2021-09-01 21:39:59'),(3,75,3,11,1.0000,1.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-01 22:39:51','2021-09-01 22:41:31'),(4,154,45,338,1.0000,1.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 10:52:40','2021-09-02 13:15:57'),(5,155,51,461,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 12:00:13','2021-09-02 12:00:13'),(6,155,45,338,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 12:00:13','2021-09-02 12:00:13'),(7,155,75,838,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 12:00:13','2021-09-02 12:00:13'),(8,156,25,225,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 12:01:36','2021-09-02 12:01:36'),(9,157,41,318,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 12:03:32','2021-09-02 12:03:32'),(10,158,71,775,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 12:12:24','2021-09-02 12:12:24'),(11,159,70,750,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 12:14:02','2021-09-02 12:14:02'),(12,159,49,415,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 12:14:02','2021-09-02 12:14:02'),(13,160,47,376,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 12:36:31','2021-09-02 12:36:31'),(14,160,61,623,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 12:36:31','2021-09-02 12:36:31'),(15,160,49,418,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 12:36:31','2021-09-02 12:36:31'),(16,161,47,376,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 12:55:55','2021-09-02 12:55:55'),(17,161,45,896,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 12:55:55','2021-09-02 12:55:55'),(18,163,30,254,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 13:16:58','2021-09-02 13:16:58'),(19,164,5,35,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 13:35:19','2021-09-02 13:35:19'),(20,164,74,816,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 13:35:19','2021-09-02 13:35:19'),(21,165,66,694,2.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 13:50:58','2021-09-02 13:50:58'),(22,166,50,440,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 14:13:54','2021-09-02 14:13:54'),(23,166,45,896,2.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 14:13:54','2021-09-02 14:13:54'),(24,166,3,11,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 14:13:54','2021-09-02 14:13:54'),(25,167,67,712,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 14:28:43','2021-09-02 14:28:43'),(26,168,23,214,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 14:36:23','2021-09-02 14:36:23'),(27,169,66,694,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 14:51:25','2021-09-02 14:51:25'),(28,169,67,711,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 14:51:25','2021-09-02 14:51:25'),(29,170,50,439,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 14:53:16','2021-09-02 14:53:16'),(30,171,23,214,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 15:02:22','2021-09-02 15:02:22'),(31,172,38,895,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 15:03:39','2021-09-02 15:03:39'),(32,172,44,333,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 15:03:39','2021-09-02 15:03:39'),(33,172,65,689,2.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 15:03:39','2021-09-02 15:03:39'),(34,173,35,288,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 15:18:26','2021-09-02 15:18:26'),(35,174,44,333,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 15:19:53','2021-09-02 15:19:53'),(36,174,28,240,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 15:19:53','2021-09-02 15:19:53'),(37,175,35,288,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 15:19:55','2021-09-02 15:19:55'),(38,176,45,338,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 15:22:43','2021-09-02 15:22:43'),(39,177,76,847,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 15:37:04','2021-09-02 15:37:04'),(40,177,86,970,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 15:37:04','2021-09-02 15:37:04'),(41,177,58,569,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 15:37:04','2021-09-02 15:37:04'),(42,177,61,623,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 15:37:04','2021-09-02 15:37:04'),(43,177,68,729,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 15:37:04','2021-09-02 15:37:04'),(44,178,38,307,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 15:38:35','2021-09-02 15:38:35'),(45,178,65,689,1.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 15:38:35','2021-09-02 15:38:35'),(46,179,50,440,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:08:05','2021-09-02 16:08:05'),(47,179,49,417,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:08:05','2021-09-02 16:08:05'),(48,180,47,376,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:14:38','2021-09-02 16:14:38'),(49,181,24,220,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:15:51','2021-09-02 16:15:51'),(50,182,21,200,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:28:07','2021-09-02 16:28:07'),(51,182,62,639,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:28:07','2021-09-02 16:28:07'),(52,182,59,587,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:28:07','2021-09-02 16:28:07'),(53,182,45,896,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:28:07','2021-09-02 16:28:07'),(54,182,13,121,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:28:07','2021-09-02 16:28:07'),(55,182,8,66,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:28:07','2021-09-02 16:28:07'),(56,183,54,500,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:35:41','2021-09-02 16:35:41'),(57,184,45,338,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:38:48','2021-09-02 16:38:48'),(58,184,30,254,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:38:48','2021-09-02 16:38:48'),(59,184,19,184,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:38:48','2021-09-02 16:38:48'),(60,184,12,109,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:38:48','2021-09-02 16:38:48'),(61,185,49,415,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:44:50','2021-09-02 16:44:50'),(62,185,83,930,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:44:50','2021-09-02 16:44:50'),(63,185,62,639,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:44:50','2021-09-02 16:44:50'),(64,185,16,157,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:44:50','2021-09-02 16:44:50'),(65,186,49,418,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:45:39','2021-09-02 16:45:39'),(66,186,81,889,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:45:39','2021-09-02 16:45:39'),(67,187,75,855,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:46:22','2021-09-02 16:46:22'),(68,187,3,14,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:46:22','2021-09-02 16:46:22'),(69,187,49,414,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:46:22','2021-09-02 16:46:22'),(70,187,50,440,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:46:22','2021-09-02 16:46:22'),(71,187,49,410,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:46:22','2021-09-02 16:46:22'),(72,188,1,1,1.0000,0.0000,250.0000,250.0000,'fixed',0.0000,250.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:51:52','2021-09-02 16:51:52'),(73,188,16,153,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:51:52','2021-09-02 16:51:52'),(74,188,61,621,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:51:52','2021-09-02 16:51:52'),(75,188,64,663,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 16:51:52','2021-09-02 16:51:52'),(76,190,16,158,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 17:12:54','2021-09-02 17:12:54'),(77,191,83,931,2.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 17:15:12','2021-09-02 17:15:12'),(78,192,67,712,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 17:16:19','2021-09-02 17:16:19'),(79,193,36,293,1.0000,1.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 17:19:58','2021-09-03 13:12:55'),(80,194,49,414,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 17:27:23','2021-09-02 17:27:23'),(81,194,49,415,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 17:27:23','2021-09-02 17:27:23'),(82,194,45,338,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 17:27:23','2021-09-02 17:27:23'),(83,194,12,109,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 17:27:23','2021-09-02 17:27:23'),(84,195,75,838,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 17:37:56','2021-09-02 17:37:56'),(85,197,68,723,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:08:47','2021-09-02 18:08:47'),(86,198,50,439,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:09:37','2021-09-02 18:09:37'),(87,198,30,254,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:09:37','2021-09-02 18:09:37'),(88,199,3,11,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:15:43','2021-09-02 18:15:43'),(89,199,52,1001,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:15:43','2021-09-02 18:15:43'),(90,200,38,304,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:18:14','2021-09-02 18:18:14'),(91,200,81,889,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:18:14','2021-09-02 18:18:14'),(92,200,44,333,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:18:14','2021-09-02 18:18:14'),(93,201,50,441,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:20:15','2021-09-02 18:20:15'),(94,201,52,481,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:20:15','2021-09-02 18:20:15'),(95,202,61,622,2.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:22:15','2021-09-02 18:22:15'),(96,203,58,570,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:26:11','2021-09-02 18:26:11'),(97,203,86,970,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:26:11','2021-09-02 18:26:11'),(98,204,5,35,1.0000,0.0000,195.0000,195.0000,'fixed',0.0000,195.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:34:25','2021-09-02 18:34:25'),(99,205,68,729,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:36:25','2021-09-02 18:36:25'),(100,205,61,616,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:36:25','2021-09-02 18:36:25'),(101,205,59,580,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:36:25','2021-09-02 18:36:25'),(102,206,30,254,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:38:17','2021-09-02 18:38:17'),(103,206,47,377,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:38:17','2021-09-02 18:38:17'),(104,206,47,376,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:38:17','2021-09-02 18:38:17'),(105,206,58,569,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:38:17','2021-09-02 18:38:17'),(106,207,4,24,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:43:58','2021-09-02 18:43:58'),(107,208,17,160,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:45:18','2021-09-02 18:45:18'),(108,208,7,63,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:45:18','2021-09-02 18:45:18'),(109,208,63,656,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:45:18','2021-09-02 18:45:18'),(110,209,66,693,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:47:17','2021-09-02 18:47:17'),(111,210,38,304,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:49:46','2021-09-02 18:49:46'),(112,210,32,273,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:49:46','2021-09-02 18:49:46'),(113,210,13,120,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:49:46','2021-09-02 18:49:46'),(114,211,67,713,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:51:48','2021-09-02 18:51:48'),(115,212,60,596,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:53:30','2021-09-02 18:53:30'),(116,213,46,357,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:54:49','2021-09-02 18:54:49'),(117,213,5,35,1.0000,0.0000,195.0000,195.0000,'fixed',0.0000,195.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:54:49','2021-09-02 18:54:49'),(118,213,40,313,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:54:49','2021-09-02 18:54:49'),(119,214,49,419,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:55:24','2021-09-02 18:55:24'),(120,215,61,623,2.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:55:49','2021-09-02 18:55:49'),(121,216,38,306,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 18:58:52','2021-09-02 18:58:52'),(122,217,47,376,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:13:58','2021-09-02 19:13:58'),(123,218,59,580,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:15:20','2021-09-02 19:15:20'),(124,218,55,519,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:15:20','2021-09-02 19:15:20'),(125,219,14,132,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:16:30','2021-09-02 19:16:30'),(126,220,76,852,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:24:44','2021-09-02 19:24:44'),(127,220,13,121,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:24:44','2021-09-02 19:24:44'),(128,220,70,750,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:24:44','2021-09-02 19:24:44'),(129,220,7,63,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:24:44','2021-09-02 19:24:44'),(130,221,16,150,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:25:49','2021-09-02 23:17:39'),(131,221,49,420,2.0000,1.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:25:49','2021-09-02 23:17:39'),(132,221,83,933,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:25:49','2021-09-02 23:17:39'),(133,221,81,889,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:25:49','2021-09-02 23:17:39'),(134,221,62,629,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:25:49','2021-09-02 23:17:39'),(135,222,45,338,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:26:25','2021-09-02 19:26:25'),(136,223,30,254,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:29:41','2021-09-02 19:29:41'),(137,223,50,439,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:29:41','2021-09-02 19:29:41'),(138,224,38,307,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:34:46','2021-09-02 19:34:46'),(139,224,45,338,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:34:46','2021-09-02 19:34:46'),(140,224,58,569,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:34:46','2021-09-02 19:34:46'),(141,225,5,35,1.0000,0.0000,195.0000,195.0000,'fixed',0.0000,195.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:35:25','2021-09-02 19:35:25'),(142,225,60,596,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:35:25','2021-09-02 19:35:25'),(143,226,4,24,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:36:44','2021-09-02 19:36:44'),(144,227,46,357,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:43:08','2021-09-02 19:43:08'),(145,228,47,376,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:51:22','2021-09-02 19:51:22'),(146,229,70,750,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:55:11','2021-09-02 19:55:11'),(147,230,83,930,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:55:49','2021-09-02 19:55:49'),(148,230,66,690,2.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 19:55:49','2021-09-02 19:55:49'),(149,231,74,816,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:01:55','2021-09-02 20:01:55'),(150,232,49,414,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:04:06','2021-09-02 20:04:06'),(151,233,48,396,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:09:32','2021-09-02 20:09:32'),(152,234,48,396,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:10:49','2021-09-02 20:10:49'),(153,235,14,135,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:12:40','2021-09-02 20:12:40'),(154,236,44,333,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:20:03','2021-09-02 20:20:03'),(155,236,73,795,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:20:03','2021-09-02 20:20:03'),(156,236,5,35,1.0000,0.0000,195.0000,195.0000,'fixed',0.0000,195.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:20:03','2021-09-02 20:20:03'),(157,237,66,694,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:24:26','2021-09-02 20:24:26'),(158,238,76,852,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:31:12','2021-09-02 20:31:12'),(159,238,63,656,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:31:12','2021-09-02 20:31:12'),(160,239,28,240,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:48:57','2021-09-02 20:48:57'),(161,240,68,729,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:58:21','2021-09-05 15:22:48'),(162,240,13,120,1.0000,1.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:58:21','2021-09-05 15:22:48'),(163,240,13,119,1.0000,1.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:58:21','2021-09-05 15:22:48'),(164,240,66,695,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:58:21','2021-09-05 15:22:48'),(165,240,66,690,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:58:21','2021-09-05 15:22:48'),(166,240,49,414,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:58:21','2021-09-05 15:22:48'),(167,240,51,461,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:58:21','2021-09-05 15:22:48'),(168,240,52,479,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 20:58:21','2021-09-05 15:22:48'),(169,241,63,653,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:01:59','2021-09-02 21:01:59'),(170,242,44,333,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:05:34','2021-09-02 21:05:34'),(171,242,37,298,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:05:34','2021-09-02 21:05:34'),(172,243,57,547,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:07:56','2021-09-02 21:07:56'),(173,243,38,304,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:07:56','2021-09-02 21:07:56'),(174,243,59,580,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:07:56','2021-09-02 21:07:56'),(175,244,38,895,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:10:54','2021-09-02 21:10:54'),(176,244,43,328,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:10:54','2021-09-02 21:10:54'),(177,245,59,580,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:26:09','2021-09-04 01:20:21'),(178,245,58,569,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:26:09','2021-09-04 01:20:21'),(179,245,14,133,1.0000,1.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:26:09','2021-09-04 01:20:21'),(180,246,60,596,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:34:31','2021-09-02 21:34:31'),(181,247,58,570,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:39:06','2021-09-02 21:39:06'),(182,247,48,396,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:39:06','2021-09-02 21:39:06'),(183,247,74,821,2.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:39:06','2021-09-02 21:39:06'),(184,247,12,109,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:39:06','2021-09-02 21:39:06'),(185,247,83,932,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:39:06','2021-09-02 21:39:06'),(186,247,75,838,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:39:06','2021-09-02 21:39:06'),(187,247,49,415,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:39:06','2021-09-02 21:39:06'),(188,248,76,847,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:40:37','2021-09-02 21:40:37'),(189,248,52,481,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:40:37','2021-09-02 21:40:37'),(190,249,52,481,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:46:42','2021-09-02 21:46:42'),(191,250,75,855,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:48:55','2021-09-02 21:48:55'),(192,251,59,587,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:51:03','2021-09-02 21:51:03'),(193,251,62,630,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:51:03','2021-09-02 21:51:03'),(194,251,61,621,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:51:03','2021-09-02 21:51:03'),(195,251,56,536,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 21:51:03','2021-09-02 21:51:03'),(196,252,1,2,1.0000,0.0000,250.0000,250.0000,'fixed',0.0000,250.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 22:00:22','2021-09-02 22:00:22'),(197,253,79,880,2.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 22:12:31','2021-09-02 22:12:31'),(198,254,76,847,2.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 22:19:22','2021-09-02 22:19:22'),(199,254,74,822,2.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 22:19:22','2021-09-02 22:19:22'),(200,254,76,852,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 22:19:22','2021-09-02 22:19:22'),(201,255,38,305,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 22:29:42','2021-09-02 22:29:42'),(202,256,63,653,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 22:31:18','2021-09-02 22:31:18'),(203,256,76,852,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 22:31:18','2021-09-02 22:31:18'),(204,257,61,623,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 22:38:12','2021-09-02 22:38:12'),(205,258,65,689,1.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 22:40:38','2021-09-02 22:40:38'),(206,258,40,313,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 22:40:38','2021-09-02 22:40:38'),(207,259,82,912,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 22:43:11','2021-09-02 22:43:11'),(208,260,14,130,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 22:54:37','2021-09-02 22:54:37'),(209,261,40,313,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 22:55:56','2021-09-02 22:55:56'),(210,261,42,323,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 22:55:56','2021-09-02 22:55:56'),(211,262,68,723,1.0000,1.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 22:56:41','2021-09-02 23:30:43'),(212,263,57,547,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 22:58:58','2021-09-02 22:58:58'),(213,263,71,775,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 22:58:58','2021-09-02 22:58:58'),(214,264,38,895,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 23:02:02','2021-09-02 23:02:02'),(215,264,65,689,2.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 23:02:02','2021-09-02 23:02:02'),(216,264,38,304,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 23:02:02','2021-09-02 23:02:02'),(217,265,37,298,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 23:05:40','2021-09-02 23:05:40'),(218,266,47,376,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 23:07:52','2021-09-02 23:07:52'),(219,266,45,338,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 23:07:52','2021-09-02 23:07:52'),(220,267,4,24,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 23:08:24','2021-09-02 23:08:24'),(221,267,47,377,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 23:08:24','2021-09-02 23:08:24'),(222,267,64,663,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 23:08:24','2021-09-02 23:08:24'),(223,268,47,376,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 23:08:53','2021-09-02 23:08:53'),(224,269,73,795,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 23:15:47','2021-09-02 23:15:47'),(225,271,47,377,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 23:18:34','2021-09-02 23:18:34'),(226,272,66,693,1.0000,1.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 23:20:16','2021-09-04 00:51:59'),(227,273,65,689,2.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 23:25:53','2021-09-02 23:25:53'),(228,273,38,894,2.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 23:25:53','2021-09-02 23:25:53'),(229,275,30,254,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 23:36:46','2021-09-02 23:36:46'),(230,275,47,376,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-02 23:36:46','2021-09-02 23:36:46'),(231,277,26,230,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 13:14:10','2021-09-03 13:14:10'),(232,278,1,2,1.0000,0.0000,250.0000,250.0000,'fixed',0.0000,250.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 14:53:27','2021-09-03 14:53:27'),(233,278,1,1,1.0000,0.0000,250.0000,250.0000,'fixed',0.0000,250.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 14:53:27','2021-09-03 14:53:27'),(234,278,42,323,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 14:53:27','2021-09-03 14:53:27'),(235,278,25,225,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 14:53:27','2021-09-03 14:53:27'),(236,278,26,230,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 14:53:27','2021-09-03 14:53:27'),(237,278,44,333,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 14:53:27','2021-09-03 14:53:27'),(238,279,37,298,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 15:00:48','2021-09-03 15:00:48'),(239,280,58,570,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 15:09:02','2021-09-03 15:09:02'),(240,281,61,622,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 15:16:35','2021-09-03 15:16:35'),(241,281,47,377,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 15:16:35','2021-09-03 15:16:35'),(242,282,47,377,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 16:00:14','2021-09-03 16:00:14'),(243,282,83,933,2.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 16:00:14','2021-09-03 16:00:14'),(244,282,1,1,1.0000,0.0000,250.0000,250.0000,'fixed',0.0000,250.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 16:00:14','2021-09-03 16:00:14'),(245,282,66,691,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 16:00:14','2021-09-03 16:00:14'),(246,282,66,692,2.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 16:00:14','2021-09-03 16:00:14'),(247,282,19,182,2.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 16:00:14','2021-09-03 16:00:14'),(248,283,62,639,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 16:03:34','2021-09-03 16:03:34'),(249,283,5,35,1.0000,0.0000,195.0000,195.0000,'fixed',0.0000,195.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 16:03:34','2021-09-03 16:03:34'),(250,283,76,847,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 16:03:34','2021-09-03 16:03:34'),(251,283,6,50,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 16:03:34','2021-09-03 16:03:34'),(252,283,48,396,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 16:03:34','2021-09-03 16:03:34'),(253,283,4,24,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 16:03:34','2021-09-03 16:03:34'),(254,283,70,750,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 16:03:34','2021-09-03 16:03:34'),(255,284,44,333,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 16:19:33','2021-09-03 16:19:33'),(256,285,61,621,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 16:21:48','2021-09-03 16:21:48'),(257,285,3,11,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 16:21:48','2021-09-03 16:21:48'),(258,287,70,750,1.0000,1.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 17:17:39','2021-09-03 18:35:04'),(259,288,38,304,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 17:30:31','2021-09-03 17:30:31'),(260,288,41,318,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 17:30:31','2021-09-03 17:30:31'),(261,289,8,66,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 17:40:37','2021-09-03 17:40:37'),(262,289,50,439,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 17:40:37','2021-09-03 17:40:37'),(263,290,68,723,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 17:42:31','2021-09-03 17:42:31'),(264,290,83,930,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 17:42:31','2021-09-03 17:42:31'),(265,291,46,357,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 17:45:46','2021-09-03 17:45:46'),(266,292,47,377,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 17:48:03','2021-09-03 17:48:03'),(267,292,45,338,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 17:48:03','2021-09-03 17:48:03'),(268,294,86,977,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 18:39:20','2021-09-03 18:39:20'),(269,295,49,420,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 18:39:33','2021-09-03 18:39:33'),(270,295,3,14,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 18:39:33','2021-09-03 18:39:33'),(271,296,75,835,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 18:58:05','2021-09-03 18:58:05'),(272,297,51,461,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 19:01:30','2021-09-03 19:01:30'),(273,298,49,415,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 19:04:07','2021-09-03 19:04:07'),(274,299,62,639,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 19:27:30','2021-09-03 19:27:30'),(275,299,58,570,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 19:27:30','2021-09-03 19:27:30'),(276,299,16,153,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 19:27:30','2021-09-03 19:27:30'),(277,299,61,616,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 19:27:30','2021-09-03 19:27:30'),(278,299,21,197,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 19:27:30','2021-09-03 19:27:30'),(279,300,47,376,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 19:43:03','2021-09-03 19:43:03'),(280,301,5,35,1.0000,0.0000,195.0000,195.0000,'fixed',0.0000,195.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 19:45:10','2021-09-03 19:45:10'),(281,303,4,24,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 20:04:39','2021-09-03 20:04:39'),(282,304,23,217,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 20:06:55','2021-09-03 20:06:55'),(283,305,30,264,1.0000,0.0000,0.0000,0.0000,'fixed',0.0000,0.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 20:10:57','2021-09-03 22:24:29'),(284,306,81,889,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 20:12:06','2021-09-03 20:12:06'),(285,307,47,377,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 20:20:44','2021-09-03 20:20:44'),(286,308,72,791,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 20:23:18','2021-09-03 20:23:18'),(287,308,70,750,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 20:23:18','2021-09-03 20:23:18'),(288,309,19,182,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 20:24:03','2021-09-03 20:24:03'),(289,310,52,1001,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 20:32:21','2021-09-03 20:32:21'),(290,310,46,357,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 20:32:21','2021-09-03 20:32:21'),(291,310,49,415,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 20:32:21','2021-09-03 20:32:21'),(292,311,12,109,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 20:36:21','2021-09-03 20:36:21'),(293,312,28,240,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 20:37:02','2021-09-03 20:37:02'),(294,312,75,835,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 20:37:02','2021-09-03 20:37:02'),(295,312,61,616,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 20:37:02','2021-09-03 20:37:02'),(296,313,83,931,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 20:37:47','2021-09-03 20:37:47'),(297,314,66,693,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 20:41:28','2021-09-03 20:41:28'),(298,315,3,11,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 20:52:48','2021-09-03 20:52:48'),(299,316,49,417,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 21:07:12','2021-09-03 21:07:12'),(300,317,38,307,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 21:14:18','2021-09-03 21:14:18'),(301,317,41,318,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 21:14:18','2021-09-03 21:14:18'),(302,318,50,440,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 21:20:18','2021-09-03 21:20:18'),(303,319,86,971,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 21:28:18','2021-09-03 21:28:18'),(304,319,76,847,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 21:28:18','2021-09-03 21:28:18'),(305,320,16,150,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 21:45:39','2021-09-03 21:45:39'),(306,321,4,24,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 21:50:29','2021-09-03 21:50:29'),(307,322,40,313,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 21:50:36','2021-09-03 21:50:36'),(308,322,76,847,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 21:50:36','2021-09-03 21:50:36'),(309,322,63,651,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 21:50:36','2021-09-03 21:50:36'),(310,323,16,154,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 21:54:58','2021-09-03 21:54:58'),(311,323,76,847,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 21:54:58','2021-09-03 21:54:58'),(312,323,66,694,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 21:54:58','2021-09-03 21:54:58'),(313,324,5,35,1.0000,0.0000,195.0000,195.0000,'fixed',0.0000,195.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 22:07:44','2021-09-03 22:07:44'),(314,326,30,254,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 22:25:05','2021-09-03 22:25:05'),(315,327,75,839,1.0000,1.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 22:52:39','2021-09-12 19:45:22'),(316,327,67,712,1.0000,1.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 22:52:39','2021-09-12 19:45:22'),(317,328,75,835,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 22:53:01','2021-09-03 22:53:01'),(318,328,73,802,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 22:53:01','2021-09-03 22:53:01'),(319,328,69,737,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 22:53:01','2021-09-03 22:53:01'),(320,328,66,691,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 22:53:01','2021-09-03 22:53:01'),(321,328,70,750,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 22:53:01','2021-09-03 22:53:01'),(322,329,49,410,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 22:54:02','2021-09-03 22:54:02'),(323,330,75,835,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 23:21:16','2021-09-03 23:21:16'),(324,331,50,440,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 23:25:16','2021-09-03 23:25:16'),(325,332,49,417,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 23:26:49','2021-09-03 23:26:49'),(326,332,66,692,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 23:26:49','2021-09-03 23:26:49'),(327,332,50,441,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 23:26:49','2021-09-03 23:26:49'),(328,332,61,622,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 23:26:49','2021-09-03 23:26:49'),(329,332,38,307,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 23:26:49','2021-09-03 23:26:49'),(330,333,61,616,1.0000,1.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 23:55:08','2021-09-04 09:55:53'),(331,333,75,838,2.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 23:55:08','2021-09-04 09:55:53'),(332,333,21,198,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-03 23:55:08','2021-09-04 09:55:53'),(333,335,45,896,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 12:19:48','2021-09-04 12:19:48'),(334,336,62,629,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 12:29:30','2021-09-04 12:29:30'),(335,336,63,656,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 12:29:30','2021-09-04 12:29:30'),(336,336,83,932,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 12:29:30','2021-09-04 12:29:30'),(337,337,67,711,1.0000,1.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 12:42:21','2021-09-04 12:48:50'),(338,337,16,158,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 12:42:21','2021-09-04 12:48:50'),(339,337,38,306,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 12:42:21','2021-09-04 12:48:50'),(340,337,66,695,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 12:42:21','2021-09-04 12:48:50'),(341,337,63,651,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 12:42:21','2021-09-04 12:48:50'),(342,339,68,983,2.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 14:08:13','2021-09-04 14:08:13'),(343,339,51,461,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 14:08:13','2021-09-04 14:08:13'),(344,339,55,526,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 14:08:13','2021-09-04 14:08:13'),(345,339,66,694,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 14:08:13','2021-09-04 14:08:13'),(346,340,40,313,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 15:33:30','2021-09-04 15:33:30'),(347,340,44,333,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 15:33:30','2021-09-04 15:33:30'),(348,341,67,711,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 16:09:23','2021-09-04 16:09:23'),(349,342,71,775,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 16:10:59','2021-09-04 16:10:59'),(350,342,8,66,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 16:10:59','2021-09-04 16:10:59'),(351,343,38,307,2.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 17:16:52','2021-09-04 17:16:52'),(352,344,58,569,1.0000,1.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 17:24:21','2021-09-04 17:25:04'),(353,346,26,230,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 17:36:15','2021-09-04 17:36:15'),(354,347,8,66,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 17:56:23','2021-09-04 17:56:23'),(355,348,49,415,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 17:58:41','2021-09-04 17:58:41'),(356,348,56,536,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 17:58:41','2021-09-04 17:58:41'),(357,348,74,816,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 17:58:41','2021-09-04 17:58:41'),(358,348,72,792,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 17:58:41','2021-09-04 17:58:41'),(359,349,66,695,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 18:46:28','2021-09-04 18:46:28'),(360,350,49,414,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 18:48:17','2021-09-04 18:48:17'),(361,350,51,461,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 18:48:17','2021-09-04 18:48:17'),(362,350,50,439,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 18:48:17','2021-09-04 18:48:17'),(363,350,3,11,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 18:48:17','2021-09-04 18:48:17'),(364,350,4,24,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 18:48:17','2021-09-04 18:48:17'),(365,351,72,792,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 18:51:55','2021-09-04 18:51:55'),(366,352,48,396,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 18:55:10','2021-09-04 18:55:10'),(367,353,23,214,1.0000,1.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 19:01:19','2021-09-04 21:05:56'),(368,353,34,283,1.0000,1.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 19:01:19','2021-09-04 21:05:56'),(369,354,58,569,1.0000,1.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 19:06:02','2021-09-04 19:06:55'),(370,356,50,440,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 19:40:58','2021-09-04 19:40:58'),(371,356,47,376,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 19:40:58','2021-09-04 19:40:58'),(372,356,5,35,1.0000,0.0000,195.0000,195.0000,'fixed',0.0000,195.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 19:40:58','2021-09-04 19:40:58'),(373,357,59,580,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 20:11:10','2021-09-04 20:11:10'),(374,358,65,689,2.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 20:27:28','2021-09-04 20:27:28'),(375,359,51,461,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 20:33:39','2021-09-04 20:33:39'),(376,360,13,120,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 20:35:11','2021-09-04 20:35:11'),(377,361,74,821,1.0000,1.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 20:35:55','2021-09-11 21:58:40'),(378,361,13,120,1.0000,1.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 20:35:55','2021-09-11 21:58:40'),(379,362,61,621,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 20:40:00','2021-09-04 20:40:00'),(380,363,49,418,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 20:53:38','2021-09-04 20:53:38'),(381,363,48,396,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 20:53:38','2021-09-04 20:53:38'),(382,364,33,278,1.0000,1.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 20:57:00','2021-09-11 20:31:12'),(383,364,26,230,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 20:57:00','2021-09-11 20:31:12'),(384,364,65,689,2.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 20:57:00','2021-09-11 20:31:12'),(385,365,65,689,1.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 20:57:58','2021-09-04 20:57:58'),(386,367,4,24,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 21:08:20','2021-09-04 21:08:20'),(387,368,38,895,2.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 21:28:12','2021-09-04 21:28:12'),(388,369,49,418,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 21:29:05','2021-09-04 21:29:05'),(389,370,46,357,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 21:40:44','2021-09-04 21:40:44'),(390,370,50,440,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 21:40:44','2021-09-04 21:40:44'),(391,370,45,338,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 21:40:44','2021-09-04 21:40:44'),(392,371,50,441,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 21:47:44','2021-09-09 16:35:04'),(393,371,21,199,1.0000,1.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 21:47:44','2021-09-09 16:35:04'),(394,372,71,767,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:02:41','2021-09-04 22:02:41'),(395,372,68,729,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:02:41','2021-09-04 22:02:41'),(396,373,29,245,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:02:59','2021-09-04 22:02:59'),(397,373,42,323,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:02:59','2021-09-04 22:02:59'),(398,374,66,691,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:03:24','2021-09-04 22:03:24'),(399,375,63,653,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:07:54','2021-09-04 22:07:54'),(400,376,42,323,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:17:30','2021-09-04 22:17:30'),(401,376,38,895,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:17:30','2021-09-04 22:17:30'),(402,377,75,838,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:22:55','2021-09-04 22:22:55'),(403,378,46,357,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:37:39','2021-09-04 22:37:39'),(404,378,3,11,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:37:39','2021-09-04 22:37:39'),(405,379,37,298,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:44:59','2021-09-04 22:44:59'),(406,379,61,622,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:44:59','2021-09-04 22:44:59'),(407,380,49,415,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:47:25','2021-09-04 22:47:25'),(408,380,50,441,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:47:25','2021-09-04 22:47:25'),(409,380,55,526,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:47:25','2021-09-04 22:47:25'),(410,381,58,569,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:48:28','2021-09-04 22:48:28'),(411,381,46,357,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:48:28','2021-09-04 22:48:28'),(412,382,49,419,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:49:36','2021-09-04 22:49:36'),(413,383,25,225,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-04 22:51:31','2021-09-04 22:51:31'),(414,384,76,847,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 11:41:52','2021-09-05 11:41:52'),(415,385,50,441,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 11:59:40','2021-09-05 11:59:40'),(416,386,61,621,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 12:09:07','2021-09-05 12:09:07'),(417,387,63,656,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 12:09:45','2021-09-05 12:09:45'),(418,388,3,14,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 12:26:06','2021-09-05 12:26:06'),(419,389,62,639,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 13:29:07','2021-09-05 13:29:07'),(420,391,13,121,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 15:24:23','2021-09-05 15:24:23'),(421,391,13,119,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 15:24:23','2021-09-05 15:24:23'),(422,392,47,377,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 15:32:10','2021-09-09 16:37:17'),(423,392,58,569,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 15:32:10','2021-09-09 16:37:17'),(424,392,61,616,1.0000,1.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 15:32:10','2021-09-09 16:37:17'),(425,393,63,651,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 16:07:36','2021-09-05 16:07:36'),(426,393,61,622,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 16:07:36','2021-09-05 16:07:36'),(427,394,49,420,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 17:52:43','2021-09-05 17:52:43'),(428,395,16,155,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 18:04:14','2021-09-05 18:04:14'),(429,395,49,420,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 18:04:14','2021-09-05 18:04:14'),(430,396,50,441,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 18:06:48','2021-09-05 18:06:48'),(431,397,50,439,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 18:32:58','2021-09-05 18:32:58'),(432,398,28,240,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 18:42:03','2021-09-05 18:42:03'),(433,398,43,328,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 18:42:03','2021-09-05 18:42:03'),(434,399,66,690,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 18:48:36','2021-09-05 18:48:36'),(435,399,73,802,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 18:48:36','2021-09-05 18:48:36'),(436,400,23,219,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 18:53:15','2021-09-06 17:52:16'),(437,400,43,328,1.0000,1.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 18:53:15','2021-09-06 17:52:16'),(438,401,44,333,2.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 19:36:46','2021-09-05 19:36:46'),(439,402,49,415,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 19:45:10','2021-09-05 19:45:10'),(440,403,33,278,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 19:47:35','2021-09-05 19:47:35'),(441,404,67,713,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 20:25:23','2021-09-05 20:25:23'),(442,405,75,839,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 20:41:22','2021-09-05 20:41:22'),(443,405,35,288,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 20:41:22','2021-09-05 20:41:22'),(444,405,29,245,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 20:41:22','2021-09-05 20:41:22'),(445,406,81,889,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 20:42:46','2021-09-05 20:42:46'),(446,407,23,219,1.0000,1.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 21:18:29','2021-09-06 19:59:45'),(447,408,41,318,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 21:20:21','2021-09-05 21:20:21'),(448,408,38,304,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 21:20:21','2021-09-05 21:20:21'),(449,409,49,419,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 21:30:02','2021-09-05 21:30:02'),(450,410,28,240,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 21:47:24','2021-09-05 21:47:24'),(451,411,65,689,1.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 22:40:19','2021-09-05 22:40:19'),(452,411,28,240,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 22:40:19','2021-09-05 22:40:19'),(453,411,17,160,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 22:40:19','2021-09-05 22:40:19'),(454,412,35,288,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 22:53:10','2021-09-05 22:53:10'),(455,413,38,304,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 23:02:18','2021-09-05 23:02:18'),(456,413,41,318,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 23:02:18','2021-09-05 23:02:18'),(457,413,65,689,2.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 23:02:18','2021-09-05 23:02:18'),(458,413,49,415,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 23:02:18','2021-09-05 23:02:18'),(459,414,42,323,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 23:04:45','2021-09-05 23:04:45'),(460,414,65,689,1.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 23:04:45','2021-09-05 23:04:45'),(461,414,17,161,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-05 23:04:45','2021-09-05 23:04:45'),(462,415,25,225,1.0000,1.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 13:17:55','2021-09-07 11:48:36'),(463,416,66,691,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 14:06:12','2021-09-06 14:06:12'),(464,416,66,693,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 14:06:12','2021-09-06 14:06:12'),(465,417,4,24,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 14:16:40','2021-09-06 14:16:40'),(466,418,75,839,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 16:10:43','2021-09-06 16:10:43'),(467,418,50,440,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 16:10:43','2021-09-06 16:10:43'),(468,420,56,536,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 17:52:49','2021-09-06 17:52:49'),(469,421,3,14,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 18:38:05','2021-09-06 18:38:05'),(470,422,71,775,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 18:56:11','2021-09-06 18:56:11'),(471,423,68,729,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 19:12:58','2021-09-06 19:12:58'),(472,423,48,396,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 19:12:58','2021-09-06 19:12:58'),(473,424,32,273,2.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 19:16:30','2021-09-06 19:16:30'),(474,424,38,894,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 19:16:30','2021-09-06 19:16:30'),(475,425,21,200,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 19:35:03','2021-09-06 19:35:03'),(476,427,62,629,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 20:08:02','2021-09-06 20:08:02'),(477,428,62,629,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 20:09:40','2021-09-06 20:09:40'),(478,429,48,396,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 20:38:46','2021-09-06 20:38:46'),(479,429,66,693,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 20:38:46','2021-09-06 20:38:46'),(480,429,43,328,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 20:38:46','2021-09-06 20:38:46'),(481,430,40,313,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 20:51:19','2021-09-06 20:51:19'),(482,431,1,2,1.0000,0.0000,250.0000,250.0000,'fixed',0.0000,250.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 21:22:21','2021-09-06 21:22:21'),(483,432,83,930,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 21:22:37','2021-09-06 21:22:37'),(484,433,74,822,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 21:23:21','2021-09-06 21:23:21'),(485,434,1,1,1.0000,0.0000,250.0000,250.0000,'fixed',0.0000,250.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 21:26:07','2021-09-06 21:26:07'),(486,434,2,8,1.0000,0.0000,325.0000,325.0000,'fixed',0.0000,325.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 21:26:07','2021-09-06 21:26:07'),(487,435,49,418,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 21:41:10','2021-09-06 21:41:10'),(488,435,47,377,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 21:41:10','2021-09-06 21:41:10'),(489,436,68,983,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 21:55:08','2021-09-06 21:55:08'),(490,436,60,600,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 21:55:08','2021-09-06 21:55:08'),(491,436,59,587,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 21:55:08','2021-09-06 21:55:08'),(492,437,36,293,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 22:11:02','2021-09-06 22:11:02'),(493,437,53,491,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 22:11:02','2021-09-06 22:11:02'),(494,437,21,197,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 22:11:02','2021-09-06 22:11:02'),(495,438,3,11,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 22:36:37','2021-09-06 22:36:37'),(496,438,34,283,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 22:36:37','2021-09-06 22:36:37'),(497,438,38,894,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 22:36:37','2021-09-06 22:36:37'),(498,439,65,689,1.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 22:57:31','2021-09-08 13:58:19'),(499,439,34,283,1.0000,1.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 22:57:31','2021-09-08 13:58:19'),(500,439,12,109,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 22:57:31','2021-09-08 13:58:19'),(501,439,43,328,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 22:57:31','2021-09-08 13:58:19'),(502,439,63,653,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-06 22:57:31','2021-09-08 13:58:19'),(503,440,66,693,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 11:19:35','2021-09-07 11:19:35'),(504,440,19,184,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 11:19:35','2021-09-07 11:19:35'),(505,442,38,894,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 11:49:53','2021-09-07 11:49:53'),(506,443,49,420,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 12:19:56','2021-09-07 12:19:56'),(507,443,47,377,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 12:19:56','2021-09-07 12:19:56'),(508,444,75,855,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 13:23:35','2021-09-07 13:23:35'),(509,444,67,711,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 13:23:35','2021-09-07 13:23:35'),(510,444,76,852,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 13:23:35','2021-09-07 13:23:35'),(511,444,75,838,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 13:23:35','2021-09-07 13:23:35'),(512,444,73,795,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 13:23:35','2021-09-07 13:23:35'),(513,444,12,109,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 13:23:35','2021-09-07 13:23:35'),(514,445,58,569,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 13:47:49','2021-09-07 13:47:49'),(515,445,63,653,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 13:47:49','2021-09-07 13:47:49'),(516,446,74,821,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 15:07:51','2021-09-07 15:07:51'),(517,446,67,711,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 15:07:51','2021-09-07 15:07:51'),(518,447,67,711,1.0000,1.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 15:10:12','2021-09-07 15:12:11'),(519,447,74,821,1.0000,1.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 15:10:12','2021-09-07 15:12:11'),(520,449,87,995,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 16:32:09','2021-09-08 15:56:50'),(521,449,43,328,1.0000,1.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 16:32:09','2021-09-08 15:56:50'),(522,450,52,479,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 16:34:23','2021-09-07 16:34:23'),(523,451,58,569,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 17:17:35','2021-09-07 17:17:35'),(524,451,8,66,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 17:17:35','2021-09-07 17:17:35'),(525,452,25,225,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 17:53:50','2021-09-07 17:53:50'),(526,453,14,129,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 18:15:30','2021-09-07 18:15:30'),(527,453,58,570,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 18:15:30','2021-09-07 18:15:30'),(528,454,66,693,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 18:54:24','2021-09-07 18:54:24'),(529,454,49,410,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 18:54:24','2021-09-07 18:54:24'),(530,454,8,66,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 18:54:24','2021-09-07 18:54:24'),(531,455,13,119,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 18:56:23','2021-09-07 18:56:23'),(532,456,40,313,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 19:00:27','2021-09-07 19:00:27'),(533,457,45,338,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 19:19:08','2021-09-07 19:19:08'),(534,457,83,931,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 19:19:08','2021-09-07 19:19:08'),(535,458,49,417,3.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 19:31:15','2021-09-07 19:31:15'),(536,458,47,377,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 19:31:15','2021-09-07 19:31:15'),(537,458,66,694,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 19:31:15','2021-09-07 19:31:15'),(538,458,3,11,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 19:31:15','2021-09-07 19:31:15'),(539,459,49,418,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 20:04:54','2021-09-07 20:04:54'),(540,459,83,932,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 20:04:54','2021-09-07 20:04:54'),(541,460,82,912,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 20:41:39','2021-09-07 20:41:39'),(542,461,66,690,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 20:59:08','2021-09-07 20:59:08'),(543,462,65,689,1.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 21:42:36','2021-09-07 21:42:36'),(544,463,35,288,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-07 22:29:14','2021-09-07 22:29:14'),(545,464,83,933,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 13:18:05','2021-09-08 13:18:05'),(546,466,24,220,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 13:51:16','2021-09-08 13:51:16'),(547,467,75,838,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 13:55:00','2021-09-08 13:55:00'),(548,468,44,333,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 13:56:08','2021-09-08 13:56:08'),(549,469,23,219,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 13:56:11','2021-09-08 13:56:11'),(550,469,63,651,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 13:56:11','2021-09-08 13:56:11'),(551,470,38,307,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 15:53:46','2021-09-08 15:53:46'),(552,472,35,288,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 16:07:52','2021-09-08 16:07:52'),(553,472,42,323,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 16:07:52','2021-09-08 16:07:52'),(554,473,86,970,1.0000,1.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 16:55:51','2021-09-08 17:21:33'),(555,478,76,847,1.0000,1.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 19:25:32','2021-09-09 15:03:07'),(556,478,79,877,1.0000,1.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 19:25:32','2021-09-09 15:03:07'),(557,478,66,690,1.0000,1.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 19:25:32','2021-09-09 15:03:07'),(558,479,37,298,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 19:34:20','2021-09-08 19:34:20'),(559,479,57,547,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 19:34:20','2021-09-08 19:34:20'),(560,480,49,415,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 19:41:57','2021-09-08 19:41:57'),(561,480,66,695,2.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 19:41:57','2021-09-08 19:41:57'),(562,481,38,304,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 19:43:14','2021-09-08 19:43:14'),(563,482,49,419,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 20:09:16','2021-09-08 20:09:16'),(564,483,50,440,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 20:18:09','2021-09-08 20:18:09'),(565,483,42,323,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 20:18:09','2021-09-08 20:18:09'),(566,483,26,230,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 20:18:09','2021-09-08 20:18:09'),(567,484,30,264,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 20:45:08','2021-09-08 20:45:08'),(568,484,26,230,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 20:45:08','2021-09-08 20:45:08'),(569,484,65,689,1.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 20:45:08','2021-09-08 20:45:08'),(570,484,61,616,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 20:45:08','2021-09-08 20:45:08'),(571,484,49,419,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 20:45:08','2021-09-08 20:45:08'),(572,485,48,396,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 20:48:15','2021-09-08 20:48:15'),(573,486,85,953,1.0000,1.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 20:49:08','2021-09-09 15:34:05'),(574,486,62,639,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 20:49:08','2021-09-09 15:34:05'),(575,487,40,313,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 21:15:16','2021-09-08 21:15:16'),(576,488,42,323,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 22:11:49','2021-09-08 22:11:49'),(577,489,41,318,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-08 22:24:10','2021-09-08 22:24:10'),(578,490,61,623,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 13:46:47','2021-09-09 13:46:47'),(579,490,61,621,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 13:46:47','2021-09-09 13:46:47'),(580,491,53,491,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 14:20:25','2021-09-09 14:20:25'),(581,492,62,630,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 14:37:28','2021-09-09 14:37:28'),(582,493,49,417,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 14:52:11','2021-09-09 14:52:11'),(583,496,85,953,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 15:36:15','2021-09-09 15:36:15'),(584,497,55,526,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 16:22:56','2021-09-09 16:22:56'),(585,500,68,723,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 16:44:58','2021-09-09 16:44:58'),(586,501,50,441,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 16:45:18','2021-09-09 16:45:18'),(587,502,53,482,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 17:44:14','2021-09-09 17:44:14'),(588,507,38,305,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 19:43:45','2021-09-09 19:43:45'),(589,508,61,621,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 21:33:29','2021-09-09 21:33:29'),(590,508,53,482,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 21:33:29','2021-09-09 21:33:29'),(591,508,51,461,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 21:33:29','2021-09-09 21:33:29'),(592,508,66,690,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 21:33:29','2021-09-09 21:33:29'),(593,508,48,396,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 21:33:29','2021-09-09 21:33:29'),(594,509,74,816,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 21:59:51','2021-09-09 21:59:51'),(595,510,66,691,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 23:15:06','2021-09-09 23:15:06'),(596,510,49,420,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 23:15:06','2021-09-09 23:15:06'),(597,510,61,623,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-09 23:15:06','2021-09-09 23:15:06'),(598,515,61,622,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 14:19:35','2021-09-10 14:19:35'),(599,515,19,182,2.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 14:19:35','2021-09-10 14:19:35'),(600,515,19,181,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 14:19:35','2021-09-10 14:19:35'),(601,515,19,184,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 14:19:35','2021-09-10 14:19:35'),(602,516,71,775,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 14:26:24','2021-09-10 14:26:24'),(603,516,70,750,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 14:26:24','2021-09-10 14:26:24'),(604,517,50,440,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 15:16:00','2021-09-10 15:16:00'),(605,517,77,857,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 15:16:00','2021-09-10 15:16:00'),(606,520,61,622,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:06:27','2021-09-10 17:06:27'),(607,521,48,392,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:30:22','2021-09-10 17:30:22'),(608,521,30,254,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:30:22','2021-09-10 17:30:22'),(609,521,78,867,2.0000,0.0000,195.0000,195.0000,'fixed',0.0000,195.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:30:22','2021-09-10 17:30:22'),(610,521,6,51,4.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:30:22','2021-09-10 17:30:22'),(611,521,10,88,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:30:22','2021-09-10 17:30:22'),(612,521,9,76,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:30:22','2021-09-10 17:30:22'),(613,522,6,51,4.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:32:40','2021-09-10 17:32:40'),(614,522,48,392,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:32:40','2021-09-10 17:32:40'),(615,522,30,254,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:32:40','2021-09-10 17:32:40'),(616,522,78,867,2.0000,0.0000,195.0000,195.0000,'fixed',0.0000,195.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:32:40','2021-09-10 17:32:40'),(617,522,10,88,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:32:40','2021-09-10 17:32:40'),(618,522,9,76,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:32:40','2021-09-10 17:32:40'),(619,523,23,218,1.0000,1.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:48:00','2021-09-10 20:04:16'),(620,523,23,214,1.0000,1.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:48:00','2021-09-10 20:04:16'),(621,523,38,307,1.0000,1.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:48:00','2021-09-10 20:04:16'),(622,523,19,182,1.0000,1.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:48:00','2021-09-10 20:04:16'),(623,524,23,218,2.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:49:24','2021-09-10 17:49:24'),(624,524,19,182,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:49:24','2021-09-10 17:49:24'),(625,524,38,307,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:49:24','2021-09-10 17:49:24'),(626,525,19,181,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:53:46','2021-09-10 17:53:46'),(627,525,19,184,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 17:53:46','2021-09-10 17:53:46'),(628,526,30,254,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 18:52:44','2021-09-10 18:52:44'),(629,526,47,377,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 18:52:44','2021-09-10 18:52:44'),(630,526,50,440,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 18:52:44','2021-09-10 18:52:44'),(631,526,61,623,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 18:52:44','2021-09-10 18:52:44'),(632,526,58,570,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 18:52:44','2021-09-10 18:52:44'),(633,527,38,305,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 19:09:22','2021-09-10 19:09:22'),(634,527,65,689,1.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 19:09:22','2021-09-10 19:09:22'),(635,528,65,689,1.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 19:26:20','2021-09-10 19:26:20'),(636,528,39,308,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 19:26:20','2021-09-10 19:26:20'),(641,531,53,491,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 19:38:04','2021-09-10 19:38:04'),(642,531,66,691,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 19:38:04','2021-09-10 19:38:04'),(643,532,24,220,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 19:42:34','2021-09-10 19:42:34'),(644,534,6,49,2.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 20:16:34','2021-09-10 20:16:34'),(645,534,6,51,2.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 20:16:34','2021-09-10 20:16:34'),(646,534,6,52,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 20:16:34','2021-09-10 20:16:34'),(647,534,30,254,2.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 20:16:34','2021-09-10 20:16:34'),(648,535,33,278,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 21:13:24','2021-09-10 21:13:24'),(649,536,14,133,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 21:16:33','2021-09-10 21:16:33'),(650,537,55,519,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 21:22:41','2021-09-10 21:22:41'),(651,538,61,622,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 22:14:17','2021-09-10 22:14:17'),(652,539,36,293,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 22:15:08','2021-09-13 21:08:29'),(653,539,50,440,1.0000,1.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 22:15:08','2021-09-13 21:08:29'),(654,539,72,791,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-10 22:15:08','2021-09-13 21:08:29'),(655,540,55,519,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-11 17:13:56','2021-09-11 17:13:56'),(656,541,35,288,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-11 20:27:48','2021-09-11 20:27:48'),(657,543,14,131,3.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-11 20:45:46','2021-09-11 20:45:46'),(658,543,17,160,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-11 20:45:46','2021-09-11 20:45:46'),(659,547,60,594,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-11 22:19:48','2021-09-11 22:19:48'),(660,549,6,51,2.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-12 20:06:40','2021-09-12 20:06:40'),(661,549,83,931,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-12 20:06:40','2021-09-12 20:06:40'),(662,549,67,712,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-12 20:06:40','2021-09-12 20:06:40'),(663,550,78,870,1.0000,0.0000,195.0000,195.0000,'fixed',0.0000,195.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-12 22:02:25','2021-09-12 22:02:25'),(664,551,59,580,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-13 13:23:46','2021-09-13 13:23:46'),(665,551,83,932,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-13 13:23:46','2021-09-13 13:23:46'),(666,552,38,306,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-13 16:34:15','2021-09-13 16:34:15'),(667,553,9,85,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-13 18:21:41','2021-09-13 18:21:41'),(668,554,60,596,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-13 18:43:31','2021-09-13 18:43:31'),(669,555,14,129,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-13 19:25:31','2021-09-13 19:25:31'),(670,557,74,822,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-13 21:09:57','2021-09-13 21:09:57'),(671,558,80,884,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-13 22:27:31','2021-09-13 22:27:31'),(672,558,38,306,1.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-13 22:27:31','2021-09-13 22:27:31'),(673,559,50,441,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-14 15:15:09','2021-09-14 15:15:09'),(674,560,63,653,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-14 15:27:41','2021-09-14 15:27:41'),(675,560,61,616,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-14 15:27:41','2021-09-14 15:27:41'),(676,561,39,308,2.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-14 17:01:34','2021-09-14 17:01:34'),(677,562,4,24,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-14 17:21:26','2021-09-14 17:21:26'),(678,563,9,85,1.0000,0.0000,150.0000,150.0000,'fixed',0.0000,150.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-14 20:13:11','2021-09-14 20:13:11'),(679,563,83,930,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-14 20:13:11','2021-09-14 20:13:11'),(680,564,78,869,1.0000,0.0000,195.0000,195.0000,'fixed',0.0000,195.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-14 20:47:47','2021-09-14 20:47:47'),(681,564,78,870,1.0000,0.0000,195.0000,195.0000,'fixed',0.0000,195.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-14 20:47:47','2021-09-14 20:47:47'),(682,565,59,580,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-14 21:29:08','2021-09-14 21:29:08'),(683,565,63,656,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-14 21:29:08','2021-09-14 21:29:08'),(684,565,61,616,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-14 21:29:08','2021-09-14 21:29:08'),(685,566,30,254,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-14 21:55:29','2021-09-14 21:55:29'),(686,566,49,410,1.0000,0.0000,100.0000,100.0000,'fixed',0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-14 21:55:29','2021-09-14 21:55:29'),(687,567,61,623,1.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-14 22:01:51','2021-09-14 22:01:51'),(688,569,88,1002,10.0000,0.0000,1250.0000,1250.0000,'fixed',0.0000,1250.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-20 22:39:03','2021-09-20 22:39:03'),(689,570,88,1002,10.0000,0.0000,1250.0000,1250.0000,'fixed',0.0000,1250.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-20 22:39:54','2021-09-20 22:39:54'),(690,571,89,1003,2.0000,0.0000,125.0000,125.0000,'fixed',0.0000,125.0000,0.0000,NULL,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2021-09-21 13:50:23','2021-09-21 13:50:23');
/*!40000 ALTER TABLE `transaction_sell_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines_purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_sell_lines_purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sell_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from transaction_sell_lines',
  `stock_adjustment_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from stock_adjustment_lines',
  `purchase_line_id` int(10) unsigned NOT NULL COMMENT 'id from purchase_lines',
  `quantity` decimal(22,4) NOT NULL,
  `qty_returned` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sell_line_id` (`sell_line_id`) USING BTREE,
  KEY `stock_adjustment_line_id` (`stock_adjustment_line_id`) USING BTREE,
  KEY `purchase_line_id` (`purchase_line_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=757 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines_purchase_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines_purchase_lines` VALUES (1,1,NULL,41,1.0000,1.0000,'2021-09-01 21:28:23','2021-09-01 21:32:46'),(2,3,NULL,4,1.0000,1.0000,'2021-09-01 22:39:51','2021-09-01 22:41:31'),(3,4,NULL,222,1.0000,1.0000,'2021-09-02 10:52:41','2021-09-02 13:15:57'),(4,5,NULL,119,1.0000,0.0000,'2021-09-02 12:00:13','2021-09-02 12:00:13'),(5,6,NULL,222,1.0000,0.0000,'2021-09-02 12:00:13','2021-09-02 12:00:13'),(6,7,NULL,68,1.0000,0.0000,'2021-09-02 12:00:13','2021-09-02 12:00:13'),(7,8,NULL,150,1.0000,0.0000,'2021-09-02 12:01:36','2021-09-02 12:01:36'),(8,9,NULL,137,1.0000,0.0000,'2021-09-02 12:03:32','2021-09-02 12:03:32'),(9,10,NULL,79,1.0000,0.0000,'2021-09-02 12:12:24','2021-09-02 12:12:24'),(10,11,NULL,80,1.0000,0.0000,'2021-09-02 12:14:02','2021-09-02 12:14:02'),(11,12,NULL,125,1.0000,0.0000,'2021-09-02 12:14:02','2021-09-02 12:14:02'),(12,13,NULL,131,1.0000,0.0000,'2021-09-02 12:36:31','2021-09-02 12:36:31'),(13,14,NULL,101,1.0000,0.0000,'2021-09-02 12:36:31','2021-09-02 12:36:31'),(14,15,NULL,127,1.0000,0.0000,'2021-09-02 12:36:31','2021-09-02 12:36:31'),(15,16,NULL,131,1.0000,0.0000,'2021-09-02 12:55:55','2021-09-02 12:55:55'),(16,17,NULL,223,1.0000,0.0000,'2021-09-02 12:55:55','2021-09-02 12:55:55'),(17,18,NULL,55,1.0000,0.0000,'2021-09-02 13:16:58','2021-09-02 13:16:58'),(18,19,NULL,7,1.0000,0.0000,'2021-09-02 13:35:19','2021-09-02 13:35:19'),(19,20,NULL,71,1.0000,0.0000,'2021-09-02 13:35:19','2021-09-02 13:35:19'),(20,21,NULL,88,2.0000,0.0000,'2021-09-02 13:50:58','2021-09-02 13:50:58'),(21,22,NULL,121,1.0000,0.0000,'2021-09-02 14:13:54','2021-09-02 14:13:54'),(22,23,NULL,223,2.0000,0.0000,'2021-09-02 14:13:54','2021-09-02 14:13:54'),(23,24,NULL,4,1.0000,0.0000,'2021-09-02 14:13:54','2021-09-02 14:13:54'),(24,25,NULL,83,1.0000,0.0000,'2021-09-02 14:28:43','2021-09-02 14:28:43'),(25,26,NULL,61,1.0000,0.0000,'2021-09-02 14:36:23','2021-09-02 14:36:23'),(26,27,NULL,88,1.0000,0.0000,'2021-09-02 14:51:25','2021-09-02 14:51:25'),(27,28,NULL,82,1.0000,0.0000,'2021-09-02 14:51:25','2021-09-02 14:51:25'),(28,29,NULL,120,1.0000,0.0000,'2021-09-02 14:53:16','2021-09-02 14:53:16'),(29,30,NULL,61,1.0000,0.0000,'2021-09-02 15:02:22','2021-09-02 15:02:22'),(30,31,NULL,210,1.0000,0.0000,'2021-09-02 15:03:39','2021-09-02 15:03:39'),(31,32,NULL,134,1.0000,0.0000,'2021-09-02 15:03:39','2021-09-02 15:03:39'),(32,33,NULL,90,2.0000,0.0000,'2021-09-02 15:03:39','2021-09-02 15:03:39'),(33,34,NULL,204,1.0000,0.0000,'2021-09-02 15:18:26','2021-09-02 15:18:26'),(34,35,NULL,134,1.0000,0.0000,'2021-09-02 15:19:53','2021-09-02 15:19:53'),(35,36,NULL,148,1.0000,0.0000,'2021-09-02 15:19:53','2021-09-02 15:19:53'),(36,38,NULL,221,1.0000,0.0000,'2021-09-02 15:22:43','2021-09-02 15:22:43'),(37,39,NULL,300,1.0000,0.0000,'2021-09-02 15:37:04','2021-09-02 15:37:04'),(38,40,NULL,256,1.0000,0.0000,'2021-09-02 15:37:04','2021-09-02 15:37:04'),(39,41,NULL,251,1.0000,0.0000,'2021-09-02 15:37:04','2021-09-02 15:37:04'),(40,42,NULL,262,1.0000,0.0000,'2021-09-02 15:37:04','2021-09-02 15:37:04'),(41,43,NULL,285,1.0000,0.0000,'2021-09-02 15:37:04','2021-09-02 15:37:04'),(42,44,NULL,214,1.0000,0.0000,'2021-09-02 15:38:35','2021-09-02 15:38:35'),(43,45,NULL,271,1.0000,0.0000,'2021-09-02 15:38:35','2021-09-02 15:38:35'),(44,46,NULL,235,1.0000,0.0000,'2021-09-02 16:08:05','2021-09-02 16:08:05'),(45,47,NULL,230,1.0000,0.0000,'2021-09-02 16:08:05','2021-09-02 16:08:05'),(46,48,NULL,131,1.0000,0.0000,'2021-09-02 16:14:38','2021-09-02 16:14:38'),(47,49,NULL,151,1.0000,0.0000,'2021-09-02 16:15:51','2021-09-02 16:15:51'),(48,50,NULL,60,1.0000,0.0000,'2021-09-02 16:28:07','2021-09-02 16:28:07'),(49,51,NULL,97,1.0000,0.0000,'2021-09-02 16:28:07','2021-09-02 16:28:07'),(50,52,NULL,106,1.0000,0.0000,'2021-09-02 16:28:07','2021-09-02 16:28:07'),(51,53,NULL,223,1.0000,0.0000,'2021-09-02 16:28:07','2021-09-02 16:28:07'),(52,54,NULL,21,1.0000,0.0000,'2021-09-02 16:28:07','2021-09-02 16:28:07'),(53,55,NULL,14,1.0000,0.0000,'2021-09-02 16:28:07','2021-09-02 16:28:07'),(54,56,NULL,113,1.0000,0.0000,'2021-09-02 16:35:41','2021-09-02 16:35:41'),(55,57,NULL,222,1.0000,0.0000,'2021-09-02 16:38:49','2021-09-02 16:38:49'),(56,58,NULL,55,1.0000,0.0000,'2021-09-02 16:38:49','2021-09-02 16:38:49'),(57,59,NULL,54,1.0000,0.0000,'2021-09-02 16:38:49','2021-09-02 16:38:49'),(58,60,NULL,15,1.0000,0.0000,'2021-09-02 16:38:49','2021-09-02 16:38:49'),(59,61,NULL,228,1.0000,0.0000,'2021-09-02 16:44:50','2021-09-02 16:44:50'),(60,62,NULL,239,1.0000,0.0000,'2021-09-02 16:44:50','2021-09-02 16:44:50'),(61,63,NULL,265,1.0000,0.0000,'2021-09-02 16:44:50','2021-09-02 16:44:50'),(62,64,NULL,175,1.0000,0.0000,'2021-09-02 16:44:50','2021-09-02 16:44:50'),(63,65,NULL,231,1.0000,0.0000,'2021-09-02 16:45:39','2021-09-02 16:45:39'),(64,66,NULL,205,1.0000,0.0000,'2021-09-02 16:45:39','2021-09-02 16:45:39'),(65,67,NULL,69,1.0000,0.0000,'2021-09-02 16:46:22','2021-09-02 16:46:22'),(66,68,NULL,5,1.0000,0.0000,'2021-09-02 16:46:22','2021-09-02 16:46:22'),(67,69,NULL,124,1.0000,0.0000,'2021-09-02 16:46:22','2021-09-02 16:46:22'),(68,70,NULL,121,1.0000,0.0000,'2021-09-02 16:46:22','2021-09-02 16:46:22'),(69,71,NULL,123,1.0000,0.0000,'2021-09-02 16:46:22','2021-09-02 16:46:22'),(70,72,NULL,152,1.0000,0.0000,'2021-09-02 16:51:52','2021-09-02 16:51:52'),(71,73,NULL,172,1.0000,0.0000,'2021-09-02 16:51:52','2021-09-02 16:51:52'),(72,74,NULL,260,1.0000,0.0000,'2021-09-02 16:51:52','2021-09-02 16:51:52'),(73,75,NULL,269,1.0000,0.0000,'2021-09-02 16:51:52','2021-09-02 16:51:52'),(74,76,NULL,39,1.0000,0.0000,'2021-09-02 17:12:54','2021-09-02 17:12:54'),(75,77,NULL,240,2.0000,0.0000,'2021-09-02 17:15:12','2021-09-02 17:15:12'),(76,78,NULL,83,1.0000,0.0000,'2021-09-02 17:16:19','2021-09-02 17:16:19'),(77,79,NULL,141,1.0000,1.0000,'2021-09-02 17:19:58','2021-09-03 13:12:55'),(78,80,NULL,124,1.0000,0.0000,'2021-09-02 17:27:23','2021-09-02 17:27:23'),(79,81,NULL,125,1.0000,0.0000,'2021-09-02 17:27:23','2021-09-02 17:27:23'),(80,82,NULL,222,1.0000,0.0000,'2021-09-02 17:27:23','2021-09-02 17:27:23'),(81,83,NULL,15,1.0000,0.0000,'2021-09-02 17:27:23','2021-09-02 17:27:23'),(82,84,NULL,68,1.0000,0.0000,'2021-09-02 17:37:56','2021-09-02 17:37:56'),(83,85,NULL,284,1.0000,0.0000,'2021-09-02 18:08:47','2021-09-02 18:08:47'),(84,86,NULL,120,1.0000,0.0000,'2021-09-02 18:09:37','2021-09-02 18:09:37'),(85,87,NULL,55,1.0000,0.0000,'2021-09-02 18:09:37','2021-09-02 18:09:37'),(86,88,NULL,4,1.0000,0.0000,'2021-09-02 18:15:43','2021-09-02 18:15:43'),(87,89,NULL,321,1.0000,0.0000,'2021-09-02 18:15:43','2021-09-02 18:15:43'),(88,90,NULL,211,1.0000,0.0000,'2021-09-02 18:18:14','2021-09-02 18:18:14'),(89,91,NULL,205,1.0000,0.0000,'2021-09-02 18:18:14','2021-09-02 18:18:14'),(90,92,NULL,220,1.0000,0.0000,'2021-09-02 18:18:14','2021-09-02 18:18:14'),(91,93,NULL,122,1.0000,0.0000,'2021-09-02 18:20:15','2021-09-02 18:20:15'),(92,94,NULL,320,1.0000,0.0000,'2021-09-02 18:20:15','2021-09-02 18:20:15'),(93,95,NULL,261,2.0000,0.0000,'2021-09-02 18:22:15','2021-09-02 18:22:15'),(94,96,NULL,252,1.0000,0.0000,'2021-09-02 18:26:11','2021-09-02 18:26:11'),(95,97,NULL,256,1.0000,0.0000,'2021-09-02 18:26:11','2021-09-02 18:26:11'),(96,98,NULL,7,1.0000,0.0000,'2021-09-02 18:34:25','2021-09-02 18:34:25'),(97,99,NULL,285,1.0000,0.0000,'2021-09-02 18:36:25','2021-09-02 18:36:25'),(98,100,NULL,259,1.0000,0.0000,'2021-09-02 18:36:25','2021-09-02 18:36:25'),(99,101,NULL,253,1.0000,0.0000,'2021-09-02 18:36:25','2021-09-02 18:36:25'),(100,102,NULL,55,1.0000,0.0000,'2021-09-02 18:38:17','2021-09-02 18:38:17'),(101,103,NULL,132,1.0000,0.0000,'2021-09-02 18:38:17','2021-09-02 18:38:17'),(102,104,NULL,131,1.0000,0.0000,'2021-09-02 18:38:17','2021-09-02 18:38:17'),(103,105,NULL,107,1.0000,0.0000,'2021-09-02 18:38:17','2021-09-02 18:38:17'),(104,106,NULL,159,1.0000,0.0000,'2021-09-02 18:43:58','2021-09-02 18:43:58'),(105,107,NULL,45,1.0000,0.0000,'2021-09-02 18:45:18','2021-09-02 18:45:18'),(106,108,NULL,8,1.0000,0.0000,'2021-09-02 18:45:18','2021-09-02 18:45:18'),(107,109,NULL,94,1.0000,0.0000,'2021-09-02 18:45:18','2021-09-02 18:45:18'),(108,110,NULL,87,1.0000,0.0000,'2021-09-02 18:47:17','2021-09-02 18:47:17'),(109,111,NULL,207,1.0000,0.0000,'2021-09-02 18:49:46','2021-09-02 18:49:46'),(110,112,NULL,145,1.0000,0.0000,'2021-09-02 18:49:46','2021-09-02 18:49:46'),(111,113,NULL,20,1.0000,0.0000,'2021-09-02 18:49:46','2021-09-02 18:49:46'),(112,114,NULL,280,1.0000,0.0000,'2021-09-02 18:51:48','2021-09-02 18:51:48'),(113,115,NULL,102,1.0000,0.0000,'2021-09-02 18:53:30','2021-09-02 18:53:30'),(114,116,NULL,133,1.0000,0.0000,'2021-09-02 18:54:49','2021-09-02 18:54:49'),(115,117,NULL,7,1.0000,0.0000,'2021-09-02 18:54:49','2021-09-02 18:54:49'),(116,118,NULL,138,1.0000,0.0000,'2021-09-02 18:54:49','2021-09-02 18:54:49'),(117,119,NULL,232,1.0000,0.0000,'2021-09-02 18:55:24','2021-09-02 18:55:24'),(118,120,NULL,101,2.0000,0.0000,'2021-09-02 18:55:49','2021-09-02 18:55:49'),(119,121,NULL,213,1.0000,0.0000,'2021-09-02 18:58:52','2021-09-02 18:58:52'),(120,122,NULL,131,1.0000,0.0000,'2021-09-02 19:13:58','2021-09-02 19:13:58'),(121,123,NULL,105,1.0000,0.0000,'2021-09-02 19:15:20','2021-09-02 19:15:20'),(122,124,NULL,111,1.0000,0.0000,'2021-09-02 19:15:20','2021-09-02 19:15:20'),(123,125,NULL,27,1.0000,0.0000,'2021-09-02 19:16:30','2021-09-02 19:16:30'),(124,126,NULL,57,1.0000,0.0000,'2021-09-02 19:24:44','2021-09-02 19:24:44'),(125,127,NULL,21,1.0000,0.0000,'2021-09-02 19:24:44','2021-09-02 19:24:44'),(126,128,NULL,80,1.0000,0.0000,'2021-09-02 19:24:44','2021-09-02 19:24:44'),(127,129,NULL,8,1.0000,0.0000,'2021-09-02 19:24:44','2021-09-02 19:24:44'),(128,130,NULL,171,1.0000,0.0000,'2021-09-02 19:25:49','2021-09-02 19:25:49'),(129,131,NULL,233,2.0000,1.0000,'2021-09-02 19:25:49','2021-09-02 23:17:39'),(130,132,NULL,242,1.0000,0.0000,'2021-09-02 19:25:49','2021-09-02 19:25:49'),(131,133,NULL,205,1.0000,0.0000,'2021-09-02 19:25:49','2021-09-02 19:25:49'),(132,134,NULL,264,1.0000,0.0000,'2021-09-02 19:25:50','2021-09-02 19:25:50'),(133,135,NULL,221,1.0000,0.0000,'2021-09-02 19:26:25','2021-09-02 19:26:25'),(134,136,NULL,55,1.0000,0.0000,'2021-09-02 19:29:41','2021-09-02 19:29:41'),(135,137,NULL,120,1.0000,0.0000,'2021-09-02 19:29:41','2021-09-02 19:29:41'),(136,138,NULL,214,1.0000,0.0000,'2021-09-02 19:34:46','2021-09-02 19:34:46'),(137,139,NULL,221,1.0000,0.0000,'2021-09-02 19:34:46','2021-09-02 19:34:46'),(138,140,NULL,251,1.0000,0.0000,'2021-09-02 19:34:46','2021-09-02 19:34:46'),(139,141,NULL,322,1.0000,0.0000,'2021-09-02 19:35:25','2021-09-02 19:35:25'),(140,142,NULL,323,1.0000,0.0000,'2021-09-02 19:35:25','2021-09-02 19:35:25'),(141,143,NULL,159,1.0000,0.0000,'2021-09-02 19:36:44','2021-09-02 19:36:44'),(142,144,NULL,224,1.0000,0.0000,'2021-09-02 19:43:08','2021-09-02 19:43:08'),(143,145,NULL,225,1.0000,0.0000,'2021-09-02 19:51:23','2021-09-02 19:51:23'),(144,146,NULL,287,1.0000,0.0000,'2021-09-02 19:55:11','2021-09-02 19:55:11'),(145,147,NULL,239,1.0000,0.0000,'2021-09-02 19:55:49','2021-09-02 19:55:49'),(146,148,NULL,272,2.0000,0.0000,'2021-09-02 19:55:49','2021-09-02 19:55:49'),(147,149,NULL,71,1.0000,0.0000,'2021-09-02 20:01:55','2021-09-02 20:01:55'),(148,150,NULL,124,1.0000,0.0000,'2021-09-02 20:04:06','2021-09-02 20:04:06'),(149,151,NULL,227,1.0000,0.0000,'2021-09-02 20:09:32','2021-09-02 20:09:32'),(150,152,NULL,227,1.0000,0.0000,'2021-09-02 20:10:49','2021-09-02 20:10:49'),(151,153,NULL,30,1.0000,0.0000,'2021-09-02 20:12:40','2021-09-02 20:12:40'),(152,154,NULL,220,1.0000,0.0000,'2021-09-02 20:20:03','2021-09-02 20:20:03'),(153,155,NULL,292,1.0000,0.0000,'2021-09-02 20:20:03','2021-09-02 20:20:03'),(154,156,NULL,322,1.0000,0.0000,'2021-09-02 20:20:03','2021-09-02 20:20:03'),(155,157,NULL,88,1.0000,0.0000,'2021-09-02 20:24:26','2021-09-02 20:24:26'),(156,158,NULL,57,1.0000,0.0000,'2021-09-02 20:31:12','2021-09-02 20:31:12'),(157,159,NULL,94,1.0000,0.0000,'2021-09-02 20:31:12','2021-09-02 20:31:12'),(158,160,NULL,148,1.0000,0.0000,'2021-09-02 20:48:57','2021-09-02 20:48:57'),(159,161,NULL,282,1.0000,0.0000,'2021-09-02 20:58:21','2021-09-02 20:58:21'),(160,162,NULL,20,1.0000,1.0000,'2021-09-02 20:58:21','2021-09-05 15:22:48'),(161,163,NULL,19,1.0000,1.0000,'2021-09-02 20:58:21','2021-09-05 15:22:48'),(162,164,NULL,89,1.0000,0.0000,'2021-09-02 20:58:21','2021-09-02 20:58:21'),(163,165,NULL,84,1.0000,0.0000,'2021-09-02 20:58:21','2021-09-02 20:58:21'),(164,166,NULL,124,1.0000,0.0000,'2021-09-02 20:58:21','2021-09-02 20:58:21'),(165,167,NULL,119,1.0000,0.0000,'2021-09-02 20:58:21','2021-09-02 20:58:21'),(166,168,NULL,319,1.0000,0.0000,'2021-09-02 20:58:21','2021-09-02 20:58:21'),(167,169,NULL,93,1.0000,0.0000,'2021-09-02 21:01:59','2021-09-02 21:01:59'),(168,170,NULL,134,1.0000,0.0000,'2021-09-02 21:05:34','2021-09-02 21:05:34'),(169,171,NULL,140,1.0000,0.0000,'2021-09-02 21:05:34','2021-09-02 21:05:34'),(170,172,NULL,250,1.0000,0.0000,'2021-09-02 21:07:56','2021-09-02 21:07:56'),(171,173,NULL,211,1.0000,0.0000,'2021-09-02 21:07:56','2021-09-02 21:07:56'),(172,174,NULL,253,1.0000,0.0000,'2021-09-02 21:07:56','2021-09-02 21:07:56'),(173,175,NULL,210,1.0000,0.0000,'2021-09-02 21:10:54','2021-09-02 21:10:54'),(174,176,NULL,135,1.0000,0.0000,'2021-09-02 21:10:54','2021-09-02 21:10:54'),(175,177,NULL,105,1.0000,0.0000,'2021-09-02 21:26:09','2021-09-02 21:26:09'),(176,178,NULL,107,1.0000,0.0000,'2021-09-02 21:26:09','2021-09-02 21:26:09'),(177,179,NULL,28,1.0000,1.0000,'2021-09-02 21:26:09','2021-09-04 00:51:27'),(178,180,NULL,102,1.0000,0.0000,'2021-09-02 21:34:31','2021-09-02 21:34:31'),(179,181,NULL,252,1.0000,0.0000,'2021-09-02 21:39:06','2021-09-02 21:39:06'),(180,182,NULL,227,1.0000,0.0000,'2021-09-02 21:39:06','2021-09-02 21:39:06'),(181,183,NULL,295,2.0000,0.0000,'2021-09-02 21:39:06','2021-09-02 21:39:06'),(182,184,NULL,161,1.0000,0.0000,'2021-09-02 21:39:06','2021-09-02 21:39:06'),(183,185,NULL,241,1.0000,0.0000,'2021-09-02 21:39:06','2021-09-02 21:39:06'),(184,186,NULL,297,1.0000,0.0000,'2021-09-02 21:39:06','2021-09-02 21:39:06'),(185,187,NULL,228,1.0000,0.0000,'2021-09-02 21:39:06','2021-09-02 21:39:06'),(186,188,NULL,56,1.0000,0.0000,'2021-09-02 21:40:37','2021-09-02 21:40:37'),(187,189,NULL,320,1.0000,0.0000,'2021-09-02 21:40:37','2021-09-02 21:40:37'),(188,190,NULL,320,1.0000,0.0000,'2021-09-02 21:46:42','2021-09-02 21:46:42'),(189,191,NULL,69,1.0000,0.0000,'2021-09-02 21:48:55','2021-09-02 21:48:55'),(190,192,NULL,106,1.0000,0.0000,'2021-09-02 21:51:03','2021-09-02 21:51:03'),(191,193,NULL,96,1.0000,0.0000,'2021-09-02 21:51:03','2021-09-02 21:51:03'),(192,194,NULL,99,1.0000,0.0000,'2021-09-02 21:51:03','2021-09-02 21:51:03'),(193,195,NULL,110,1.0000,0.0000,'2021-09-02 21:51:03','2021-09-02 21:51:03'),(194,196,NULL,2,1.0000,0.0000,'2021-09-02 22:00:23','2021-09-02 22:00:23'),(195,197,NULL,193,2.0000,0.0000,'2021-09-02 22:12:31','2021-09-02 22:12:31'),(196,198,NULL,56,2.0000,0.0000,'2021-09-02 22:19:22','2021-09-02 22:19:22'),(197,199,NULL,73,2.0000,0.0000,'2021-09-02 22:19:22','2021-09-02 22:19:22'),(198,200,NULL,57,1.0000,0.0000,'2021-09-02 22:19:22','2021-09-02 22:19:22'),(199,201,NULL,212,1.0000,0.0000,'2021-09-02 22:29:42','2021-09-02 22:29:42'),(200,202,NULL,93,1.0000,0.0000,'2021-09-02 22:31:18','2021-09-02 22:31:18'),(201,203,NULL,57,1.0000,0.0000,'2021-09-02 22:31:18','2021-09-02 22:31:18'),(202,204,NULL,262,1.0000,0.0000,'2021-09-02 22:38:12','2021-09-02 22:38:12'),(203,205,NULL,90,1.0000,0.0000,'2021-09-02 22:40:38','2021-09-02 22:40:38'),(204,206,NULL,138,1.0000,0.0000,'2021-09-02 22:40:38','2021-09-02 22:40:38'),(205,207,NULL,238,1.0000,0.0000,'2021-09-02 22:43:11','2021-09-02 22:43:11'),(206,208,NULL,26,1.0000,0.0000,'2021-09-02 22:54:37','2021-09-02 22:54:37'),(207,209,NULL,138,1.0000,0.0000,'2021-09-02 22:55:56','2021-09-02 22:55:56'),(208,210,NULL,136,1.0000,0.0000,'2021-09-02 22:55:56','2021-09-02 22:55:56'),(209,211,NULL,281,1.0000,1.0000,'2021-09-02 22:56:41','2021-09-02 23:30:43'),(210,212,NULL,109,1.0000,0.0000,'2021-09-02 22:58:58','2021-09-02 22:58:58'),(211,213,NULL,79,1.0000,0.0000,'2021-09-02 22:58:58','2021-09-02 22:58:58'),(212,214,NULL,210,1.0000,0.0000,'2021-09-02 23:02:03','2021-09-02 23:02:03'),(213,215,NULL,90,2.0000,0.0000,'2021-09-02 23:02:03','2021-09-02 23:02:03'),(214,216,NULL,207,1.0000,0.0000,'2021-09-02 23:02:03','2021-09-02 23:02:03'),(215,217,NULL,140,1.0000,0.0000,'2021-09-02 23:05:40','2021-09-02 23:05:40'),(216,218,NULL,131,1.0000,0.0000,'2021-09-02 23:07:52','2021-09-02 23:07:52'),(217,219,NULL,222,1.0000,0.0000,'2021-09-02 23:07:52','2021-09-02 23:07:52'),(218,220,NULL,159,1.0000,0.0000,'2021-09-02 23:08:24','2021-09-02 23:08:24'),(219,221,NULL,226,1.0000,0.0000,'2021-09-02 23:08:24','2021-09-02 23:08:24'),(220,222,NULL,269,1.0000,0.0000,'2021-09-02 23:08:24','2021-09-02 23:08:24'),(221,223,NULL,225,1.0000,0.0000,'2021-09-02 23:08:53','2021-09-02 23:08:53'),(222,224,NULL,74,1.0000,0.0000,'2021-09-02 23:15:47','2021-09-02 23:15:47'),(223,225,NULL,226,1.0000,0.0000,'2021-09-02 23:18:34','2021-09-02 23:18:34'),(224,226,NULL,87,1.0000,1.0000,'2021-09-02 23:20:16','2021-09-04 00:51:59'),(225,227,NULL,90,2.0000,0.0000,'2021-09-02 23:25:53','2021-09-02 23:25:53'),(226,228,NULL,209,2.0000,0.0000,'2021-09-02 23:25:53','2021-09-02 23:25:53'),(227,229,NULL,318,1.0000,0.0000,'2021-09-02 23:36:46','2021-09-02 23:36:46'),(228,230,NULL,225,1.0000,0.0000,'2021-09-02 23:36:46','2021-09-02 23:36:46'),(229,231,NULL,149,1.0000,0.0000,'2021-09-03 13:14:10','2021-09-03 13:14:10'),(230,232,NULL,2,1.0000,0.0000,'2021-09-03 14:53:27','2021-09-03 14:53:27'),(231,233,NULL,1,1.0000,0.0000,'2021-09-03 14:53:27','2021-09-03 14:53:27'),(232,234,NULL,136,1.0000,0.0000,'2021-09-03 14:53:27','2021-09-03 14:53:27'),(233,235,NULL,150,1.0000,0.0000,'2021-09-03 14:53:27','2021-09-03 14:53:27'),(234,236,NULL,149,1.0000,0.0000,'2021-09-03 14:53:27','2021-09-03 14:53:27'),(235,237,NULL,134,1.0000,0.0000,'2021-09-03 14:53:27','2021-09-03 14:53:27'),(236,238,NULL,140,1.0000,0.0000,'2021-09-03 15:00:48','2021-09-03 15:00:48'),(237,239,NULL,108,1.0000,0.0000,'2021-09-03 15:09:02','2021-09-03 15:09:02'),(238,240,NULL,100,1.0000,0.0000,'2021-09-03 15:16:35','2021-09-03 15:16:35'),(239,241,NULL,132,1.0000,0.0000,'2021-09-03 15:16:35','2021-09-03 15:16:35'),(240,242,NULL,226,1.0000,0.0000,'2021-09-03 16:00:14','2021-09-03 16:00:14'),(241,243,NULL,242,2.0000,0.0000,'2021-09-03 16:00:14','2021-09-03 16:00:14'),(242,244,NULL,152,1.0000,0.0000,'2021-09-03 16:00:14','2021-09-03 16:00:14'),(243,245,NULL,273,1.0000,0.0000,'2021-09-03 16:00:14','2021-09-03 16:00:14'),(244,246,NULL,274,2.0000,0.0000,'2021-09-03 16:00:14','2021-09-03 16:00:14'),(245,247,NULL,187,2.0000,0.0000,'2021-09-03 16:00:14','2021-09-03 16:00:14'),(246,248,NULL,265,1.0000,0.0000,'2021-09-03 16:03:34','2021-09-03 16:03:34'),(247,249,NULL,322,1.0000,0.0000,'2021-09-03 16:03:34','2021-09-03 16:03:34'),(248,250,NULL,300,1.0000,0.0000,'2021-09-03 16:03:34','2021-09-03 16:03:34'),(249,251,NULL,302,1.0000,0.0000,'2021-09-03 16:03:34','2021-09-03 16:03:34'),(250,252,NULL,227,1.0000,0.0000,'2021-09-03 16:03:34','2021-09-03 16:03:34'),(251,253,NULL,159,1.0000,0.0000,'2021-09-03 16:03:34','2021-09-03 16:03:34'),(252,254,NULL,287,1.0000,0.0000,'2021-09-03 16:03:34','2021-09-03 16:03:34'),(253,255,NULL,134,1.0000,0.0000,'2021-09-03 16:19:33','2021-09-03 16:19:33'),(254,256,NULL,260,1.0000,0.0000,'2021-09-03 16:21:48','2021-09-03 16:21:48'),(255,257,NULL,157,1.0000,0.0000,'2021-09-03 16:21:48','2021-09-03 16:21:48'),(256,258,NULL,287,1.0000,1.0000,'2021-09-03 17:17:39','2021-09-03 18:35:04'),(257,259,NULL,207,1.0000,0.0000,'2021-09-03 17:30:31','2021-09-03 17:30:31'),(258,260,NULL,137,1.0000,0.0000,'2021-09-03 17:30:31','2021-09-03 17:30:31'),(259,261,NULL,14,1.0000,0.0000,'2021-09-03 17:40:37','2021-09-03 17:40:37'),(260,262,NULL,120,1.0000,0.0000,'2021-09-03 17:40:37','2021-09-03 17:40:37'),(261,263,NULL,284,1.0000,0.0000,'2021-09-03 17:42:31','2021-09-03 17:42:31'),(262,264,NULL,239,1.0000,0.0000,'2021-09-03 17:42:31','2021-09-03 17:42:31'),(263,265,NULL,224,1.0000,0.0000,'2021-09-03 17:45:46','2021-09-03 17:45:46'),(264,266,NULL,132,1.0000,0.0000,'2021-09-03 17:48:03','2021-09-03 17:48:03'),(265,267,NULL,222,1.0000,0.0000,'2021-09-03 17:48:03','2021-09-03 17:48:03'),(266,268,NULL,258,1.0000,0.0000,'2021-09-03 18:39:20','2021-09-03 18:39:20'),(267,269,NULL,129,1.0000,0.0000,'2021-09-03 18:39:33','2021-09-03 18:39:33'),(268,270,NULL,5,1.0000,0.0000,'2021-09-03 18:39:33','2021-09-03 18:39:33'),(269,271,NULL,67,1.0000,0.0000,'2021-09-03 18:58:05','2021-09-03 18:58:05'),(270,272,NULL,119,1.0000,0.0000,'2021-09-03 19:01:30','2021-09-03 19:01:30'),(271,273,NULL,228,1.0000,0.0000,'2021-09-03 19:04:07','2021-09-03 19:04:07'),(272,274,NULL,97,1.0000,0.0000,'2021-09-03 19:27:30','2021-09-03 19:27:30'),(273,275,NULL,108,1.0000,0.0000,'2021-09-03 19:27:30','2021-09-03 19:27:30'),(274,276,NULL,35,1.0000,0.0000,'2021-09-03 19:27:30','2021-09-03 19:27:30'),(275,277,NULL,98,1.0000,0.0000,'2021-09-03 19:27:30','2021-09-03 19:27:30'),(276,278,NULL,58,1.0000,0.0000,'2021-09-03 19:27:30','2021-09-03 19:27:30'),(277,279,NULL,225,1.0000,0.0000,'2021-09-03 19:43:03','2021-09-03 19:43:03'),(278,280,NULL,322,1.0000,0.0000,'2021-09-03 19:45:10','2021-09-03 19:45:10'),(279,281,NULL,159,1.0000,0.0000,'2021-09-03 20:04:39','2021-09-03 20:04:39'),(280,282,NULL,64,1.0000,0.0000,'2021-09-03 20:06:55','2021-09-03 20:06:55'),(281,283,NULL,237,1.0000,0.0000,'2021-09-03 20:10:57','2021-09-03 20:10:57'),(282,284,NULL,205,1.0000,0.0000,'2021-09-03 20:12:06','2021-09-03 20:12:06'),(283,285,NULL,226,1.0000,0.0000,'2021-09-03 20:20:44','2021-09-03 20:20:44'),(284,286,NULL,290,1.0000,0.0000,'2021-09-03 20:23:18','2021-09-03 20:23:18'),(285,287,NULL,287,1.0000,0.0000,'2021-09-03 20:23:18','2021-09-03 20:23:18'),(286,288,NULL,53,1.0000,0.0000,'2021-09-03 20:24:03','2021-09-03 20:24:03'),(287,289,NULL,321,1.0000,0.0000,'2021-09-03 20:32:21','2021-09-03 20:32:21'),(288,290,NULL,133,1.0000,0.0000,'2021-09-03 20:32:21','2021-09-03 20:32:21'),(289,291,NULL,125,1.0000,0.0000,'2021-09-03 20:32:21','2021-09-03 20:32:21'),(290,292,NULL,161,1.0000,0.0000,'2021-09-03 20:36:21','2021-09-03 20:36:21'),(291,293,NULL,148,1.0000,0.0000,'2021-09-03 20:37:02','2021-09-03 20:37:02'),(292,294,NULL,67,1.0000,0.0000,'2021-09-03 20:37:02','2021-09-03 20:37:02'),(293,295,NULL,98,1.0000,0.0000,'2021-09-03 20:37:02','2021-09-03 20:37:02'),(294,296,NULL,240,1.0000,0.0000,'2021-09-03 20:37:47','2021-09-03 20:37:47'),(295,297,NULL,275,1.0000,0.0000,'2021-09-03 20:41:28','2021-09-03 20:41:28'),(296,298,NULL,4,1.0000,0.0000,'2021-09-03 20:52:48','2021-09-03 20:52:48'),(297,299,NULL,230,1.0000,0.0000,'2021-09-03 21:07:12','2021-09-03 21:07:12'),(298,300,NULL,208,1.0000,0.0000,'2021-09-03 21:14:18','2021-09-03 21:14:18'),(299,301,NULL,137,1.0000,0.0000,'2021-09-03 21:14:18','2021-09-03 21:14:18'),(300,302,NULL,235,1.0000,0.0000,'2021-09-03 21:20:18','2021-09-03 21:20:18'),(301,303,NULL,257,1.0000,0.0000,'2021-09-03 21:28:18','2021-09-03 21:28:18'),(302,304,NULL,300,1.0000,0.0000,'2021-09-03 21:28:18','2021-09-03 21:28:18'),(303,305,NULL,34,1.0000,0.0000,'2021-09-03 21:45:39','2021-09-03 21:45:39'),(304,306,NULL,159,1.0000,0.0000,'2021-09-03 21:50:29','2021-09-03 21:50:29'),(305,307,NULL,138,1.0000,0.0000,'2021-09-03 21:50:36','2021-09-03 21:50:36'),(306,308,NULL,56,1.0000,0.0000,'2021-09-03 21:50:36','2021-09-03 21:50:36'),(307,309,NULL,92,1.0000,0.0000,'2021-09-03 21:50:36','2021-09-03 21:50:36'),(308,310,NULL,173,1.0000,0.0000,'2021-09-03 21:54:58','2021-09-03 21:54:58'),(309,311,NULL,300,1.0000,0.0000,'2021-09-03 21:54:58','2021-09-03 21:54:58'),(310,312,NULL,276,1.0000,0.0000,'2021-09-03 21:54:58','2021-09-03 21:54:58'),(311,313,NULL,7,1.0000,0.0000,'2021-09-03 22:07:44','2021-09-03 22:07:44'),(312,314,NULL,318,1.0000,0.0000,'2021-09-03 22:25:05','2021-09-03 22:25:05'),(313,315,NULL,298,1.0000,1.0000,'2021-09-03 22:52:39','2021-09-12 19:45:22'),(314,316,NULL,279,1.0000,1.0000,'2021-09-03 22:52:39','2021-09-12 19:45:22'),(315,317,NULL,67,1.0000,0.0000,'2021-09-03 22:53:01','2021-09-03 22:53:01'),(316,318,NULL,75,1.0000,0.0000,'2021-09-03 22:53:01','2021-09-03 22:53:01'),(317,319,NULL,81,1.0000,0.0000,'2021-09-03 22:53:01','2021-09-03 22:53:01'),(318,320,NULL,85,1.0000,0.0000,'2021-09-03 22:53:01','2021-09-03 22:53:01'),(319,321,NULL,80,1.0000,0.0000,'2021-09-03 22:53:01','2021-09-03 22:53:01'),(320,322,NULL,123,1.0000,0.0000,'2021-09-03 22:54:02','2021-09-03 22:54:02'),(321,323,NULL,67,1.0000,0.0000,'2021-09-03 23:21:16','2021-09-03 23:21:16'),(322,324,NULL,235,1.0000,0.0000,'2021-09-03 23:25:16','2021-09-03 23:25:16'),(323,325,NULL,126,1.0000,0.0000,'2021-09-03 23:26:49','2021-09-03 23:26:49'),(324,326,NULL,86,1.0000,0.0000,'2021-09-03 23:26:49','2021-09-03 23:26:49'),(325,327,NULL,122,1.0000,0.0000,'2021-09-03 23:26:49','2021-09-03 23:26:49'),(326,328,NULL,100,1.0000,0.0000,'2021-09-03 23:26:49','2021-09-03 23:26:49'),(327,329,NULL,208,1.0000,0.0000,'2021-09-03 23:26:49','2021-09-03 23:26:49'),(328,330,NULL,259,1.0000,1.0000,'2021-09-03 23:55:09','2021-09-03 23:56:58'),(329,331,NULL,297,2.0000,0.0000,'2021-09-03 23:55:09','2021-09-03 23:55:09'),(330,332,NULL,184,1.0000,0.0000,'2021-09-03 23:55:09','2021-09-03 23:55:09'),(331,333,NULL,223,1.0000,0.0000,'2021-09-04 12:19:48','2021-09-04 12:19:48'),(332,334,NULL,264,1.0000,0.0000,'2021-09-04 12:29:30','2021-09-04 12:29:30'),(333,335,NULL,268,1.0000,0.0000,'2021-09-04 12:29:30','2021-09-04 12:29:30'),(334,336,NULL,241,1.0000,0.0000,'2021-09-04 12:29:30','2021-09-04 12:29:30'),(335,337,NULL,278,1.0000,1.0000,'2021-09-04 12:42:21','2021-09-04 12:48:50'),(336,338,NULL,176,1.0000,0.0000,'2021-09-04 12:42:21','2021-09-04 12:42:21'),(337,339,NULL,213,1.0000,0.0000,'2021-09-04 12:42:21','2021-09-04 12:42:21'),(338,340,NULL,277,1.0000,0.0000,'2021-09-04 12:42:22','2021-09-04 12:42:22'),(339,341,NULL,266,1.0000,0.0000,'2021-09-04 12:42:22','2021-09-04 12:42:22'),(340,342,NULL,283,2.0000,0.0000,'2021-09-04 14:08:14','2021-09-04 14:08:14'),(341,343,NULL,119,1.0000,0.0000,'2021-09-04 14:08:14','2021-09-04 14:08:14'),(342,344,NULL,112,1.0000,0.0000,'2021-09-04 14:08:14','2021-09-04 14:08:14'),(343,345,NULL,88,1.0000,0.0000,'2021-09-04 14:08:14','2021-09-04 14:08:14'),(344,346,NULL,138,1.0000,0.0000,'2021-09-04 15:33:30','2021-09-04 15:33:30'),(345,347,NULL,134,1.0000,0.0000,'2021-09-04 15:33:30','2021-09-04 15:33:30'),(346,348,NULL,82,1.0000,0.0000,'2021-09-04 16:09:23','2021-09-04 16:09:23'),(347,349,NULL,79,1.0000,0.0000,'2021-09-04 16:10:59','2021-09-04 16:10:59'),(348,350,NULL,14,1.0000,0.0000,'2021-09-04 16:10:59','2021-09-04 16:10:59'),(349,351,NULL,208,2.0000,0.0000,'2021-09-04 17:16:52','2021-09-04 17:16:52'),(350,352,NULL,251,1.0000,1.0000,'2021-09-04 17:24:21','2021-09-04 17:25:04'),(351,353,NULL,149,1.0000,0.0000,'2021-09-04 17:36:15','2021-09-04 17:36:15'),(352,354,NULL,14,1.0000,0.0000,'2021-09-04 17:56:23','2021-09-04 17:56:23'),(353,355,NULL,125,1.0000,0.0000,'2021-09-04 17:58:41','2021-09-04 17:58:41'),(354,356,NULL,110,1.0000,0.0000,'2021-09-04 17:58:41','2021-09-04 17:58:41'),(355,357,NULL,71,1.0000,0.0000,'2021-09-04 17:58:41','2021-09-04 17:58:41'),(356,358,NULL,77,1.0000,0.0000,'2021-09-04 17:58:41','2021-09-04 17:58:41'),(357,359,NULL,89,1.0000,0.0000,'2021-09-04 18:46:28','2021-09-04 18:46:28'),(358,360,NULL,124,1.0000,0.0000,'2021-09-04 18:48:17','2021-09-04 18:48:17'),(359,361,NULL,119,1.0000,0.0000,'2021-09-04 18:48:17','2021-09-04 18:48:17'),(360,362,NULL,120,1.0000,0.0000,'2021-09-04 18:48:17','2021-09-04 18:48:17'),(361,363,NULL,4,1.0000,0.0000,'2021-09-04 18:48:17','2021-09-04 18:48:17'),(362,364,NULL,6,1.0000,0.0000,'2021-09-04 18:48:18','2021-09-04 18:48:18'),(363,365,NULL,291,1.0000,0.0000,'2021-09-04 18:51:55','2021-09-04 18:51:55'),(364,366,NULL,130,1.0000,0.0000,'2021-09-04 18:55:10','2021-09-04 18:55:10'),(365,367,NULL,61,1.0000,1.0000,'2021-09-04 19:01:19','2021-09-04 21:05:56'),(366,368,NULL,143,1.0000,1.0000,'2021-09-04 19:01:19','2021-09-04 21:05:56'),(367,369,NULL,251,1.0000,1.0000,'2021-09-04 19:06:02','2021-09-04 19:06:55'),(368,370,NULL,235,1.0000,0.0000,'2021-09-04 19:40:58','2021-09-04 19:40:58'),(369,371,NULL,225,1.0000,0.0000,'2021-09-04 19:40:58','2021-09-04 19:40:58'),(370,372,NULL,322,1.0000,0.0000,'2021-09-04 19:40:58','2021-09-04 19:40:58'),(371,373,NULL,253,1.0000,0.0000,'2021-09-04 20:11:10','2021-09-04 20:11:10'),(372,374,NULL,90,2.0000,0.0000,'2021-09-04 20:27:28','2021-09-04 20:27:28'),(373,375,NULL,119,1.0000,0.0000,'2021-09-04 20:33:39','2021-09-04 20:33:39'),(374,376,NULL,20,1.0000,0.0000,'2021-09-04 20:35:12','2021-09-04 20:35:12'),(375,377,NULL,72,1.0000,1.0000,'2021-09-04 20:35:55','2021-09-11 21:58:40'),(376,378,NULL,20,1.0000,1.0000,'2021-09-04 20:35:55','2021-09-11 21:58:40'),(377,379,NULL,99,1.0000,0.0000,'2021-09-04 20:40:00','2021-09-04 20:40:00'),(378,380,NULL,127,1.0000,0.0000,'2021-09-04 20:53:38','2021-09-04 20:53:38'),(379,381,NULL,130,1.0000,0.0000,'2021-09-04 20:53:38','2021-09-04 20:53:38'),(380,382,NULL,203,1.0000,1.0000,'2021-09-04 20:57:00','2021-09-11 20:31:12'),(381,383,NULL,198,1.0000,0.0000,'2021-09-04 20:57:00','2021-09-04 20:57:00'),(382,384,NULL,271,2.0000,0.0000,'2021-09-04 20:57:00','2021-09-04 20:57:00'),(383,385,NULL,271,1.0000,0.0000,'2021-09-04 20:57:58','2021-09-04 20:57:58'),(384,386,NULL,6,1.0000,0.0000,'2021-09-04 21:08:20','2021-09-04 21:08:20'),(385,387,NULL,210,2.0000,0.0000,'2021-09-04 21:28:12','2021-09-04 21:28:12'),(386,388,NULL,231,1.0000,0.0000,'2021-09-04 21:29:05','2021-09-04 21:29:05'),(387,389,NULL,224,1.0000,0.0000,'2021-09-04 21:40:44','2021-09-04 21:40:44'),(388,390,NULL,235,1.0000,0.0000,'2021-09-04 21:40:44','2021-09-04 21:40:44'),(389,391,NULL,221,1.0000,0.0000,'2021-09-04 21:40:44','2021-09-04 21:40:44'),(390,392,NULL,122,1.0000,0.0000,'2021-09-04 21:47:44','2021-09-04 21:47:44'),(391,393,NULL,59,1.0000,1.0000,'2021-09-04 21:47:44','2021-09-09 16:35:04'),(392,394,NULL,288,1.0000,0.0000,'2021-09-04 22:02:41','2021-09-04 22:02:41'),(393,395,NULL,285,1.0000,0.0000,'2021-09-04 22:02:41','2021-09-04 22:02:41'),(394,396,NULL,147,1.0000,0.0000,'2021-09-04 22:02:59','2021-09-04 22:02:59'),(395,397,NULL,136,1.0000,0.0000,'2021-09-04 22:02:59','2021-09-04 22:02:59'),(396,398,NULL,273,1.0000,0.0000,'2021-09-04 22:03:24','2021-09-04 22:03:24'),(397,399,NULL,93,1.0000,0.0000,'2021-09-04 22:07:54','2021-09-04 22:07:54'),(398,400,NULL,136,1.0000,0.0000,'2021-09-04 22:17:30','2021-09-04 22:17:30'),(399,401,NULL,210,1.0000,0.0000,'2021-09-04 22:17:30','2021-09-04 22:17:30'),(400,402,NULL,68,1.0000,0.0000,'2021-09-04 22:22:55','2021-09-04 22:22:55'),(401,403,NULL,224,1.0000,0.0000,'2021-09-04 22:37:39','2021-09-04 22:37:39'),(402,404,NULL,157,1.0000,0.0000,'2021-09-04 22:37:39','2021-09-04 22:37:39'),(403,405,NULL,140,1.0000,0.0000,'2021-09-04 22:45:00','2021-09-04 22:45:00'),(404,406,NULL,100,1.0000,0.0000,'2021-09-04 22:45:00','2021-09-04 22:45:00'),(405,407,NULL,125,1.0000,0.0000,'2021-09-04 22:47:25','2021-09-04 22:47:25'),(406,408,NULL,122,1.0000,0.0000,'2021-09-04 22:47:25','2021-09-04 22:47:25'),(407,409,NULL,112,1.0000,0.0000,'2021-09-04 22:47:25','2021-09-04 22:47:25'),(408,410,NULL,107,1.0000,0.0000,'2021-09-04 22:48:28','2021-09-04 22:48:28'),(409,411,NULL,133,1.0000,0.0000,'2021-09-04 22:48:28','2021-09-04 22:48:28'),(410,412,NULL,232,1.0000,0.0000,'2021-09-04 22:49:36','2021-09-04 22:49:36'),(411,413,NULL,150,1.0000,0.0000,'2021-09-04 22:51:31','2021-09-04 22:51:31'),(412,414,NULL,56,1.0000,0.0000,'2021-09-05 11:41:53','2021-09-05 11:41:53'),(413,415,NULL,122,1.0000,0.0000,'2021-09-05 11:59:40','2021-09-05 11:59:40'),(414,416,NULL,99,1.0000,0.0000,'2021-09-05 12:09:07','2021-09-05 12:09:07'),(415,417,NULL,94,1.0000,0.0000,'2021-09-05 12:09:45','2021-09-05 12:09:45'),(416,418,NULL,5,1.0000,0.0000,'2021-09-05 12:26:06','2021-09-05 12:26:06'),(417,419,NULL,97,1.0000,0.0000,'2021-09-05 13:29:07','2021-09-05 13:29:07'),(418,420,NULL,21,1.0000,0.0000,'2021-09-05 15:24:23','2021-09-05 15:24:23'),(419,421,NULL,19,1.0000,0.0000,'2021-09-05 15:24:23','2021-09-05 15:24:23'),(420,422,NULL,132,1.0000,0.0000,'2021-09-05 15:32:10','2021-09-05 15:32:10'),(421,423,NULL,107,1.0000,0.0000,'2021-09-05 15:32:10','2021-09-05 15:32:10'),(422,424,NULL,98,1.0000,1.0000,'2021-09-05 15:32:10','2021-09-09 16:37:17'),(423,425,NULL,92,1.0000,0.0000,'2021-09-05 16:07:36','2021-09-05 16:07:36'),(424,426,NULL,100,1.0000,0.0000,'2021-09-05 16:07:36','2021-09-05 16:07:36'),(425,427,NULL,129,1.0000,0.0000,'2021-09-05 17:52:43','2021-09-05 17:52:43'),(426,428,NULL,174,1.0000,0.0000,'2021-09-05 18:04:14','2021-09-05 18:04:14'),(427,429,NULL,233,1.0000,0.0000,'2021-09-05 18:04:14','2021-09-05 18:04:14'),(428,430,NULL,236,1.0000,0.0000,'2021-09-05 18:06:48','2021-09-05 18:06:48'),(429,431,NULL,234,1.0000,0.0000,'2021-09-05 18:32:58','2021-09-05 18:32:58'),(430,432,NULL,148,1.0000,0.0000,'2021-09-05 18:42:04','2021-09-05 18:42:04'),(431,433,NULL,135,1.0000,0.0000,'2021-09-05 18:42:04','2021-09-05 18:42:04'),(432,434,NULL,84,1.0000,0.0000,'2021-09-05 18:48:36','2021-09-05 18:48:36'),(433,435,NULL,75,1.0000,0.0000,'2021-09-05 18:48:36','2021-09-05 18:48:36'),(434,436,NULL,66,1.0000,0.0000,'2021-09-05 18:53:15','2021-09-05 18:53:15'),(435,437,NULL,135,1.0000,1.0000,'2021-09-05 18:53:15','2021-09-06 17:52:16'),(436,438,NULL,220,2.0000,0.0000,'2021-09-05 19:36:46','2021-09-05 19:36:46'),(437,439,NULL,125,1.0000,0.0000,'2021-09-05 19:45:10','2021-09-05 19:45:10'),(438,440,NULL,144,1.0000,0.0000,'2021-09-05 19:47:35','2021-09-05 19:47:35'),(439,441,NULL,280,1.0000,0.0000,'2021-09-05 20:25:23','2021-09-05 20:25:23'),(440,442,NULL,298,1.0000,0.0000,'2021-09-05 20:41:22','2021-09-05 20:41:22'),(441,443,NULL,204,1.0000,0.0000,'2021-09-05 20:41:22','2021-09-05 20:41:22'),(442,444,NULL,200,1.0000,0.0000,'2021-09-05 20:41:22','2021-09-05 20:41:22'),(443,445,NULL,205,1.0000,0.0000,'2021-09-05 20:42:46','2021-09-05 20:42:46'),(444,446,NULL,66,1.0000,1.0000,'2021-09-05 21:18:29','2021-09-06 19:59:45'),(445,447,NULL,137,1.0000,0.0000,'2021-09-05 21:20:21','2021-09-05 21:20:21'),(446,448,NULL,207,1.0000,0.0000,'2021-09-05 21:20:21','2021-09-05 21:20:21'),(447,449,NULL,128,1.0000,0.0000,'2021-09-05 21:30:02','2021-09-05 21:30:02'),(448,450,NULL,148,1.0000,0.0000,'2021-09-05 21:47:25','2021-09-05 21:47:25'),(449,451,NULL,271,1.0000,0.0000,'2021-09-05 22:40:19','2021-09-05 22:40:19'),(450,452,NULL,199,1.0000,0.0000,'2021-09-05 22:40:19','2021-09-05 22:40:19'),(451,453,NULL,177,1.0000,0.0000,'2021-09-05 22:40:19','2021-09-05 22:40:19'),(452,454,NULL,142,1.0000,0.0000,'2021-09-05 22:53:10','2021-09-05 22:53:10'),(453,455,NULL,207,1.0000,0.0000,'2021-09-05 23:02:18','2021-09-05 23:02:18'),(454,456,NULL,137,1.0000,0.0000,'2021-09-05 23:02:18','2021-09-05 23:02:18'),(455,457,NULL,90,2.0000,0.0000,'2021-09-05 23:02:18','2021-09-05 23:02:18'),(456,458,NULL,125,1.0000,0.0000,'2021-09-05 23:02:18','2021-09-05 23:02:18'),(457,459,NULL,218,1.0000,0.0000,'2021-09-05 23:04:46','2021-09-05 23:04:46'),(458,460,NULL,271,1.0000,0.0000,'2021-09-05 23:04:46','2021-09-05 23:04:46'),(459,461,NULL,178,1.0000,0.0000,'2021-09-05 23:04:46','2021-09-05 23:04:46'),(460,462,NULL,150,1.0000,1.0000,'2021-09-06 13:17:55','2021-09-07 11:48:36'),(461,463,NULL,85,1.0000,0.0000,'2021-09-06 14:06:12','2021-09-06 14:06:12'),(462,464,NULL,87,1.0000,0.0000,'2021-09-06 14:06:12','2021-09-06 14:06:12'),(463,465,NULL,159,1.0000,0.0000,'2021-09-06 14:16:40','2021-09-06 14:16:40'),(464,466,NULL,298,1.0000,0.0000,'2021-09-06 16:10:43','2021-09-06 16:10:43'),(465,467,NULL,235,1.0000,0.0000,'2021-09-06 16:10:43','2021-09-06 16:10:43'),(466,468,NULL,110,1.0000,0.0000,'2021-09-06 17:52:49','2021-09-06 17:52:49'),(467,469,NULL,5,1.0000,0.0000,'2021-09-06 18:38:05','2021-09-06 18:38:05'),(468,470,NULL,79,1.0000,0.0000,'2021-09-06 18:56:11','2021-09-06 18:56:11'),(469,471,NULL,282,1.0000,0.0000,'2021-09-06 19:12:58','2021-09-06 19:12:58'),(470,472,NULL,130,1.0000,0.0000,'2021-09-06 19:12:58','2021-09-06 19:12:58'),(471,473,NULL,145,2.0000,0.0000,'2021-09-06 19:16:30','2021-09-06 19:16:30'),(472,474,NULL,209,1.0000,0.0000,'2021-09-06 19:16:30','2021-09-06 19:16:30'),(473,475,NULL,60,1.0000,0.0000,'2021-09-06 19:35:03','2021-09-06 19:35:03'),(474,476,NULL,95,1.0000,0.0000,'2021-09-06 20:08:02','2021-09-06 20:08:02'),(475,477,NULL,95,1.0000,0.0000,'2021-09-06 20:09:40','2021-09-06 20:09:40'),(476,478,NULL,227,1.0000,0.0000,'2021-09-06 20:38:46','2021-09-06 20:38:46'),(477,479,NULL,275,1.0000,0.0000,'2021-09-06 20:38:46','2021-09-06 20:38:46'),(478,480,NULL,219,1.0000,0.0000,'2021-09-06 20:38:46','2021-09-06 20:38:46'),(479,481,NULL,216,1.0000,0.0000,'2021-09-06 20:51:19','2021-09-06 20:51:19'),(480,482,NULL,2,1.0000,0.0000,'2021-09-06 21:22:21','2021-09-06 21:22:21'),(481,483,NULL,239,1.0000,0.0000,'2021-09-06 21:22:37','2021-09-06 21:22:37'),(482,484,NULL,296,1.0000,0.0000,'2021-09-06 21:23:21','2021-09-06 21:23:21'),(483,485,NULL,1,1.0000,0.0000,'2021-09-06 21:26:07','2021-09-06 21:26:07'),(484,486,NULL,3,1.0000,0.0000,'2021-09-06 21:26:07','2021-09-06 21:26:07'),(485,487,NULL,127,1.0000,0.0000,'2021-09-06 21:41:10','2021-09-06 21:41:10'),(486,488,NULL,132,1.0000,0.0000,'2021-09-06 21:41:10','2021-09-06 21:41:10'),(487,489,NULL,283,1.0000,0.0000,'2021-09-06 21:55:08','2021-09-06 21:55:08'),(488,490,NULL,104,1.0000,0.0000,'2021-09-06 21:55:08','2021-09-06 21:55:08'),(489,491,NULL,106,1.0000,0.0000,'2021-09-06 21:55:08','2021-09-06 21:55:08'),(490,492,NULL,141,1.0000,0.0000,'2021-09-06 22:11:02','2021-09-06 22:11:02'),(491,493,NULL,118,1.0000,0.0000,'2021-09-06 22:11:02','2021-09-06 22:11:02'),(492,494,NULL,58,1.0000,0.0000,'2021-09-06 22:11:02','2021-09-06 22:11:02'),(493,495,NULL,4,1.0000,0.0000,'2021-09-06 22:36:37','2021-09-06 22:36:37'),(494,496,NULL,143,1.0000,0.0000,'2021-09-06 22:36:37','2021-09-06 22:36:37'),(495,497,NULL,209,1.0000,0.0000,'2021-09-06 22:36:37','2021-09-06 22:36:37'),(496,498,NULL,90,1.0000,0.0000,'2021-09-06 22:57:31','2021-09-06 22:57:31'),(497,499,NULL,143,1.0000,1.0000,'2021-09-06 22:57:31','2021-09-08 13:47:35'),(498,500,NULL,15,1.0000,0.0000,'2021-09-06 22:57:31','2021-09-06 22:57:31'),(499,501,NULL,135,1.0000,0.0000,'2021-09-06 22:57:31','2021-09-06 22:57:31'),(500,502,NULL,93,1.0000,0.0000,'2021-09-06 22:57:31','2021-09-06 22:57:31'),(501,503,NULL,87,1.0000,0.0000,'2021-09-07 11:19:35','2021-09-07 11:19:35'),(502,504,NULL,54,1.0000,0.0000,'2021-09-07 11:19:36','2021-09-07 11:19:36'),(503,505,NULL,209,1.0000,0.0000,'2021-09-07 11:49:53','2021-09-07 11:49:53'),(504,506,NULL,129,1.0000,0.0000,'2021-09-07 12:19:56','2021-09-07 12:19:56'),(505,507,NULL,132,1.0000,0.0000,'2021-09-07 12:19:56','2021-09-07 12:19:56'),(506,508,NULL,69,1.0000,0.0000,'2021-09-07 13:23:35','2021-09-07 13:23:35'),(507,509,NULL,82,1.0000,0.0000,'2021-09-07 13:23:35','2021-09-07 13:23:35'),(508,510,NULL,57,1.0000,0.0000,'2021-09-07 13:23:35','2021-09-07 13:23:35'),(509,511,NULL,68,1.0000,0.0000,'2021-09-07 13:23:35','2021-09-07 13:23:35'),(510,512,NULL,74,1.0000,0.0000,'2021-09-07 13:23:35','2021-09-07 13:23:35'),(511,513,NULL,15,1.0000,0.0000,'2021-09-07 13:23:35','2021-09-07 13:23:35'),(512,514,NULL,251,1.0000,0.0000,'2021-09-07 13:47:49','2021-09-07 13:47:49'),(513,515,NULL,267,1.0000,0.0000,'2021-09-07 13:47:49','2021-09-07 13:47:49'),(514,516,NULL,295,1.0000,0.0000,'2021-09-07 15:07:51','2021-09-07 15:07:51'),(515,517,NULL,278,1.0000,0.0000,'2021-09-07 15:07:51','2021-09-07 15:07:51'),(516,518,NULL,278,1.0000,1.0000,'2021-09-07 15:10:13','2021-09-07 15:12:11'),(517,519,NULL,295,1.0000,1.0000,'2021-09-07 15:10:13','2021-09-07 15:12:11'),(518,520,NULL,299,1.0000,0.0000,'2021-09-07 16:32:09','2021-09-07 16:32:09'),(519,521,NULL,219,1.0000,1.0000,'2021-09-07 16:32:09','2021-09-08 15:56:50'),(520,522,NULL,319,1.0000,0.0000,'2021-09-07 16:34:23','2021-09-07 16:34:23'),(521,523,NULL,107,1.0000,0.0000,'2021-09-07 17:17:35','2021-09-07 17:17:35'),(522,524,NULL,14,1.0000,0.0000,'2021-09-07 17:17:35','2021-09-07 17:17:35'),(523,525,NULL,150,1.0000,0.0000,'2021-09-07 17:53:50','2021-09-07 17:53:50'),(524,526,NULL,25,1.0000,0.0000,'2021-09-07 18:15:30','2021-09-07 18:15:30'),(525,527,NULL,108,1.0000,0.0000,'2021-09-07 18:15:30','2021-09-07 18:15:30'),(526,528,NULL,87,1.0000,0.0000,'2021-09-07 18:54:24','2021-09-07 18:54:24'),(527,529,NULL,123,1.0000,0.0000,'2021-09-07 18:54:24','2021-09-07 18:54:24'),(528,530,NULL,14,1.0000,0.0000,'2021-09-07 18:54:24','2021-09-07 18:54:24'),(529,531,NULL,162,1.0000,0.0000,'2021-09-07 18:56:23','2021-09-07 18:56:23'),(530,532,NULL,216,1.0000,0.0000,'2021-09-07 19:00:27','2021-09-07 19:00:27'),(531,533,NULL,221,1.0000,0.0000,'2021-09-07 19:19:08','2021-09-07 19:19:08'),(532,534,NULL,240,1.0000,0.0000,'2021-09-07 19:19:08','2021-09-07 19:19:08'),(533,535,NULL,230,3.0000,0.0000,'2021-09-07 19:31:15','2021-09-07 19:31:15'),(534,536,NULL,226,1.0000,0.0000,'2021-09-07 19:31:15','2021-09-07 19:31:15'),(535,537,NULL,276,1.0000,0.0000,'2021-09-07 19:31:15','2021-09-07 19:31:15'),(536,538,NULL,157,1.0000,0.0000,'2021-09-07 19:31:15','2021-09-07 19:31:15'),(537,539,NULL,231,1.0000,0.0000,'2021-09-07 20:04:54','2021-09-07 20:04:54'),(538,540,NULL,241,1.0000,0.0000,'2021-09-07 20:04:54','2021-09-07 20:04:54'),(539,541,NULL,238,1.0000,0.0000,'2021-09-07 20:41:39','2021-09-07 20:41:39'),(540,542,NULL,84,1.0000,0.0000,'2021-09-07 20:59:08','2021-09-07 20:59:08'),(541,543,NULL,90,1.0000,0.0000,'2021-09-07 21:42:36','2021-09-07 21:42:36'),(542,544,NULL,142,1.0000,0.0000,'2021-09-07 22:29:14','2021-09-07 22:29:14'),(543,545,NULL,242,1.0000,0.0000,'2021-09-08 13:18:05','2021-09-08 13:18:05'),(544,546,NULL,151,1.0000,0.0000,'2021-09-08 13:51:16','2021-09-08 13:51:16'),(545,547,NULL,297,1.0000,0.0000,'2021-09-08 13:55:00','2021-09-08 13:55:00'),(546,548,NULL,220,1.0000,0.0000,'2021-09-08 13:56:08','2021-09-08 13:56:08'),(547,549,NULL,66,1.0000,0.0000,'2021-09-08 13:56:11','2021-09-08 13:56:11'),(548,550,NULL,92,1.0000,0.0000,'2021-09-08 13:56:11','2021-09-08 13:56:11'),(549,551,NULL,214,1.0000,0.0000,'2021-09-08 15:53:46','2021-09-08 15:53:46'),(550,552,NULL,142,1.0000,0.0000,'2021-09-08 16:07:53','2021-09-08 16:07:53'),(551,553,NULL,136,1.0000,0.0000,'2021-09-08 16:07:53','2021-09-08 16:07:53'),(552,554,NULL,256,1.0000,1.0000,'2021-09-08 16:55:51','2021-09-08 17:21:05'),(553,NULL,1,322,1.0000,0.0000,'2021-09-08 17:29:07','2021-09-08 17:29:07'),(554,NULL,2,160,10.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(556,NULL,3,189,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(558,NULL,3,189,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(559,NULL,4,234,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(561,NULL,3,189,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(562,NULL,4,234,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(563,NULL,5,237,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(565,NULL,3,189,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(566,NULL,4,234,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(567,NULL,5,237,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(568,NULL,6,248,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(570,NULL,3,189,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(571,NULL,4,234,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(572,NULL,5,237,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(573,NULL,6,248,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(574,NULL,7,253,4.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(576,NULL,3,189,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(577,NULL,4,234,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(578,NULL,5,237,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(579,NULL,6,248,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(580,NULL,7,253,4.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(581,NULL,8,256,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(583,NULL,3,189,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(584,NULL,4,234,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(585,NULL,5,237,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(586,NULL,6,248,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(587,NULL,7,253,4.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(588,NULL,8,256,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(589,NULL,9,267,1.0000,0.0000,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(590,555,NULL,300,1.0000,1.0000,'2021-09-08 19:25:32','2021-09-09 15:03:07'),(591,556,NULL,190,1.0000,1.0000,'2021-09-08 19:25:32','2021-09-09 15:03:07'),(592,557,NULL,272,1.0000,1.0000,'2021-09-08 19:25:32','2021-09-09 15:03:07'),(593,558,NULL,140,1.0000,0.0000,'2021-09-08 19:34:20','2021-09-08 19:34:20'),(594,559,NULL,109,1.0000,0.0000,'2021-09-08 19:34:20','2021-09-08 19:34:20'),(595,560,NULL,228,1.0000,0.0000,'2021-09-08 19:41:58','2021-09-08 19:41:58'),(596,561,NULL,277,2.0000,0.0000,'2021-09-08 19:41:58','2021-09-08 19:41:58'),(597,562,NULL,211,1.0000,0.0000,'2021-09-08 19:43:14','2021-09-08 19:43:14'),(598,563,NULL,128,1.0000,0.0000,'2021-09-08 20:09:16','2021-09-08 20:09:16'),(599,564,NULL,121,1.0000,0.0000,'2021-09-08 20:18:09','2021-09-08 20:18:09'),(600,565,NULL,136,1.0000,0.0000,'2021-09-08 20:18:09','2021-09-08 20:18:09'),(601,566,NULL,149,1.0000,0.0000,'2021-09-08 20:18:09','2021-09-08 20:18:09'),(602,567,NULL,237,1.0000,0.0000,'2021-09-08 20:45:08','2021-09-08 20:45:08'),(603,568,NULL,198,1.0000,0.0000,'2021-09-08 20:45:08','2021-09-08 20:45:08'),(604,569,NULL,271,1.0000,0.0000,'2021-09-08 20:45:08','2021-09-08 20:45:08'),(605,570,NULL,259,1.0000,0.0000,'2021-09-08 20:45:08','2021-09-08 20:45:08'),(606,571,NULL,232,1.0000,0.0000,'2021-09-08 20:45:08','2021-09-08 20:45:08'),(607,572,NULL,130,1.0000,0.0000,'2021-09-08 20:48:15','2021-09-08 20:48:15'),(608,573,NULL,255,1.0000,1.0000,'2021-09-08 20:49:08','2021-09-09 15:34:05'),(609,574,NULL,265,1.0000,0.0000,'2021-09-08 20:49:08','2021-09-08 20:49:08'),(610,575,NULL,138,1.0000,0.0000,'2021-09-08 21:15:16','2021-09-08 21:15:16'),(611,576,NULL,218,1.0000,0.0000,'2021-09-08 22:11:49','2021-09-08 22:11:49'),(612,577,NULL,217,1.0000,0.0000,'2021-09-08 22:24:10','2021-09-08 22:24:10'),(613,578,NULL,101,1.0000,0.0000,'2021-09-09 13:46:48','2021-09-09 13:46:48'),(614,579,NULL,99,1.0000,0.0000,'2021-09-09 13:46:48','2021-09-09 13:46:48'),(615,580,NULL,118,1.0000,0.0000,'2021-09-09 14:20:25','2021-09-09 14:20:25'),(616,581,NULL,96,1.0000,0.0000,'2021-09-09 14:37:28','2021-09-09 14:37:28'),(617,582,NULL,126,1.0000,0.0000,'2021-09-09 14:52:11','2021-09-09 14:52:11'),(618,583,NULL,255,1.0000,0.0000,'2021-09-09 15:36:15','2021-09-09 15:36:15'),(619,584,NULL,112,1.0000,0.0000,'2021-09-09 16:22:56','2021-09-09 16:22:56'),(620,585,NULL,284,1.0000,0.0000,'2021-09-09 16:44:58','2021-09-09 16:44:58'),(621,586,NULL,236,1.0000,0.0000,'2021-09-09 16:45:18','2021-09-09 16:45:18'),(622,587,NULL,116,1.0000,0.0000,'2021-09-09 17:44:14','2021-09-09 17:44:14'),(623,NULL,10,243,1.0000,0.0000,'2021-09-09 17:54:32','2021-09-09 17:54:32'),(624,NULL,11,69,1.0000,0.0000,'2021-09-09 17:56:40','2021-09-09 17:56:40'),(625,NULL,11,69,1.0000,0.0000,'2021-09-09 17:56:40','2021-09-09 17:56:40'),(626,NULL,12,52,1.0000,0.0000,'2021-09-09 17:56:40','2021-09-09 17:56:40'),(627,NULL,11,69,1.0000,0.0000,'2021-09-09 17:56:40','2021-09-09 17:56:40'),(628,NULL,12,52,1.0000,0.0000,'2021-09-09 17:56:40','2021-09-09 17:56:40'),(629,NULL,13,126,1.0000,0.0000,'2021-09-09 17:56:40','2021-09-09 17:56:40'),(630,NULL,11,69,1.0000,0.0000,'2021-09-09 17:56:40','2021-09-09 17:56:40'),(631,NULL,12,52,1.0000,0.0000,'2021-09-09 17:56:40','2021-09-09 17:56:40'),(632,NULL,13,126,1.0000,0.0000,'2021-09-09 17:56:40','2021-09-09 17:56:40'),(633,NULL,14,98,2.0000,0.0000,'2021-09-09 17:56:40','2021-09-09 17:56:40'),(634,588,NULL,212,1.0000,0.0000,'2021-09-09 19:43:45','2021-09-09 19:43:45'),(635,589,NULL,99,1.0000,0.0000,'2021-09-09 21:33:29','2021-09-09 21:33:29'),(636,590,NULL,116,1.0000,0.0000,'2021-09-09 21:33:29','2021-09-09 21:33:29'),(637,591,NULL,119,1.0000,0.0000,'2021-09-09 21:33:29','2021-09-09 21:33:29'),(638,592,NULL,84,1.0000,0.0000,'2021-09-09 21:33:29','2021-09-09 21:33:29'),(639,593,NULL,130,1.0000,0.0000,'2021-09-09 21:33:29','2021-09-09 21:33:29'),(640,594,NULL,294,1.0000,0.0000,'2021-09-09 21:59:51','2021-09-09 21:59:51'),(641,595,NULL,273,1.0000,0.0000,'2021-09-09 23:15:06','2021-09-09 23:15:06'),(642,596,NULL,233,1.0000,0.0000,'2021-09-09 23:15:06','2021-09-09 23:15:06'),(643,597,NULL,262,1.0000,0.0000,'2021-09-09 23:15:06','2021-09-09 23:15:06'),(644,598,NULL,100,1.0000,0.0000,'2021-09-10 14:19:36','2021-09-10 14:19:36'),(645,599,NULL,53,2.0000,0.0000,'2021-09-10 14:19:36','2021-09-10 14:19:36'),(646,600,NULL,52,1.0000,0.0000,'2021-09-10 14:19:36','2021-09-10 14:19:36'),(647,601,NULL,54,1.0000,0.0000,'2021-09-10 14:19:36','2021-09-10 14:19:36'),(648,602,NULL,289,1.0000,0.0000,'2021-09-10 14:26:24','2021-09-10 14:26:24'),(649,603,NULL,287,1.0000,0.0000,'2021-09-10 14:26:24','2021-09-10 14:26:24'),(650,604,NULL,235,1.0000,0.0000,'2021-09-10 15:16:00','2021-09-10 15:16:00'),(651,605,NULL,158,1.0000,0.0000,'2021-09-10 15:16:00','2021-09-10 15:16:00'),(652,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(653,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(654,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(655,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(656,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(657,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(658,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(659,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(660,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(661,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(662,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(663,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(664,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(665,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(666,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(667,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(668,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(669,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(670,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(671,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(672,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(673,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(674,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(675,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(676,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(677,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(678,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(679,NULL,2,160,10.0000,0.0000,'2021-09-10 16:22:38','2021-09-10 16:22:38'),(680,606,NULL,261,1.0000,0.0000,'2021-09-10 17:06:27','2021-09-10 17:06:27'),(681,613,NULL,355,4.0000,0.0000,'2021-09-10 17:32:40','2021-09-10 17:32:40'),(682,614,NULL,332,1.0000,0.0000,'2021-09-10 17:32:40','2021-09-10 17:32:40'),(683,615,NULL,353,1.0000,0.0000,'2021-09-10 17:32:40','2021-09-10 17:32:40'),(684,616,NULL,370,2.0000,0.0000,'2021-09-10 17:32:40','2021-09-10 17:32:40'),(685,617,NULL,362,1.0000,0.0000,'2021-09-10 17:32:40','2021-09-10 17:32:40'),(686,618,NULL,359,1.0000,0.0000,'2021-09-10 17:32:40','2021-09-10 17:32:40'),(687,619,NULL,65,1.0000,1.0000,'2021-09-10 17:48:00','2021-09-10 20:04:16'),(688,620,NULL,61,1.0000,1.0000,'2021-09-10 17:48:00','2021-09-10 20:04:16'),(689,621,NULL,208,1.0000,1.0000,'2021-09-10 17:48:00','2021-09-10 20:04:16'),(690,622,NULL,53,1.0000,1.0000,'2021-09-10 17:48:00','2021-09-10 20:04:16'),(691,623,NULL,65,2.0000,0.0000,'2021-09-10 17:49:24','2021-09-10 17:49:24'),(692,624,NULL,53,1.0000,0.0000,'2021-09-10 17:49:24','2021-09-10 17:49:24'),(693,625,NULL,208,1.0000,0.0000,'2021-09-10 17:49:24','2021-09-10 17:49:24'),(694,626,NULL,52,1.0000,0.0000,'2021-09-10 17:53:46','2021-09-10 17:53:46'),(695,627,NULL,54,1.0000,0.0000,'2021-09-10 17:53:46','2021-09-10 17:53:46'),(696,628,NULL,353,1.0000,0.0000,'2021-09-10 18:52:44','2021-09-10 18:52:44'),(697,629,NULL,226,1.0000,0.0000,'2021-09-10 18:52:44','2021-09-10 18:52:44'),(698,630,NULL,235,1.0000,0.0000,'2021-09-10 18:52:44','2021-09-10 18:52:44'),(699,631,NULL,262,1.0000,0.0000,'2021-09-10 18:52:44','2021-09-10 18:52:44'),(700,632,NULL,252,1.0000,0.0000,'2021-09-10 18:52:44','2021-09-10 18:52:44'),(701,633,NULL,212,1.0000,0.0000,'2021-09-10 19:09:22','2021-09-10 19:09:22'),(702,634,NULL,271,1.0000,0.0000,'2021-09-10 19:09:22','2021-09-10 19:09:22'),(703,635,NULL,90,1.0000,0.0000,'2021-09-10 19:26:20','2021-09-10 19:26:20'),(704,636,NULL,139,1.0000,0.0000,'2021-09-10 19:26:21','2021-09-10 19:26:21'),(705,641,NULL,118,1.0000,0.0000,'2021-09-10 19:38:04','2021-09-10 19:38:04'),(706,642,NULL,85,1.0000,0.0000,'2021-09-10 19:38:04','2021-09-10 19:38:04'),(707,643,NULL,197,1.0000,0.0000,'2021-09-10 19:42:34','2021-09-10 19:42:34'),(708,644,NULL,375,2.0000,0.0000,'2021-09-10 20:16:34','2021-09-10 20:16:34'),(709,645,NULL,377,2.0000,0.0000,'2021-09-10 20:16:34','2021-09-10 20:16:34'),(710,646,NULL,373,1.0000,0.0000,'2021-09-10 20:16:34','2021-09-10 20:16:34'),(711,647,NULL,393,2.0000,0.0000,'2021-09-10 20:16:34','2021-09-10 20:16:34'),(712,648,NULL,144,1.0000,0.0000,'2021-09-10 21:13:24','2021-09-10 21:13:24'),(713,649,NULL,28,1.0000,0.0000,'2021-09-10 21:16:33','2021-09-10 21:16:33'),(714,650,NULL,111,1.0000,0.0000,'2021-09-10 21:22:41','2021-09-10 21:22:41'),(715,651,NULL,261,1.0000,0.0000,'2021-09-10 22:14:17','2021-09-10 22:14:17'),(716,652,NULL,141,1.0000,0.0000,'2021-09-10 22:15:08','2021-09-10 22:15:08'),(717,653,NULL,121,1.0000,1.0000,'2021-09-10 22:15:08','2021-09-13 21:08:29'),(718,654,NULL,76,1.0000,0.0000,'2021-09-10 22:15:08','2021-09-10 22:15:08'),(719,655,NULL,248,1.0000,0.0000,'2021-09-11 17:13:56','2021-09-11 17:13:56'),(720,656,NULL,204,1.0000,0.0000,'2021-09-11 20:27:48','2021-09-11 20:27:48'),(721,657,NULL,371,3.0000,0.0000,'2021-09-11 20:45:46','2021-09-11 20:45:46'),(722,658,NULL,177,1.0000,0.0000,'2021-09-11 20:45:46','2021-09-11 20:45:46'),(723,NULL,15,363,10.0000,0.0000,'2021-09-11 20:50:03','2021-09-11 20:50:03'),(724,NULL,15,363,10.0000,0.0000,'2021-09-11 20:50:03','2021-09-11 20:50:03'),(725,NULL,16,364,10.0000,0.0000,'2021-09-11 20:50:03','2021-09-11 20:50:03'),(726,659,NULL,335,1.0000,0.0000,'2021-09-11 22:19:48','2021-09-11 22:19:48'),(727,660,NULL,355,2.0000,0.0000,'2021-09-12 20:06:40','2021-09-12 20:06:40'),(728,661,NULL,240,1.0000,0.0000,'2021-09-12 20:06:40','2021-09-12 20:06:40'),(729,662,NULL,279,1.0000,0.0000,'2021-09-12 20:06:40','2021-09-12 20:06:40'),(730,663,NULL,369,1.0000,0.0000,'2021-09-12 22:02:25','2021-09-12 22:02:25'),(731,664,NULL,253,1.0000,0.0000,'2021-09-13 13:23:47','2021-09-13 13:23:47'),(732,665,NULL,241,1.0000,0.0000,'2021-09-13 13:23:47','2021-09-13 13:23:47'),(733,666,NULL,213,1.0000,0.0000,'2021-09-13 16:34:15','2021-09-13 16:34:15'),(734,667,NULL,361,1.0000,0.0000,'2021-09-13 18:21:41','2021-09-13 18:21:41'),(735,668,NULL,102,1.0000,0.0000,'2021-09-13 18:43:31','2021-09-13 18:43:31'),(736,669,NULL,165,1.0000,0.0000,'2021-09-13 19:25:31','2021-09-13 19:25:31'),(737,670,NULL,73,1.0000,0.0000,'2021-09-13 21:09:57','2021-09-13 21:09:57'),(738,671,NULL,202,1.0000,0.0000,'2021-09-13 22:27:31','2021-09-13 22:27:31'),(739,672,NULL,213,1.0000,0.0000,'2021-09-13 22:27:31','2021-09-13 22:27:31'),(740,673,NULL,236,1.0000,0.0000,'2021-09-14 15:15:10','2021-09-14 15:15:10'),(741,674,NULL,267,1.0000,0.0000,'2021-09-14 15:27:41','2021-09-14 15:27:41'),(742,675,NULL,259,1.0000,0.0000,'2021-09-14 15:27:41','2021-09-14 15:27:41'),(743,676,NULL,139,2.0000,0.0000,'2021-09-14 17:01:34','2021-09-14 17:01:34'),(744,677,NULL,6,1.0000,0.0000,'2021-09-14 17:21:26','2021-09-14 17:21:26'),(745,678,NULL,361,1.0000,0.0000,'2021-09-14 20:13:11','2021-09-14 20:13:11'),(746,679,NULL,239,1.0000,0.0000,'2021-09-14 20:13:11','2021-09-14 20:13:11'),(747,680,NULL,368,1.0000,0.0000,'2021-09-14 20:47:47','2021-09-14 20:47:47'),(748,681,NULL,369,1.0000,0.0000,'2021-09-14 20:47:47','2021-09-14 20:47:47'),(749,682,NULL,105,1.0000,0.0000,'2021-09-14 21:29:08','2021-09-14 21:29:08'),(750,683,NULL,94,1.0000,0.0000,'2021-09-14 21:29:08','2021-09-14 21:29:08'),(751,684,NULL,98,1.0000,0.0000,'2021-09-14 21:29:08','2021-09-14 21:29:08'),(752,685,NULL,393,1.0000,0.0000,'2021-09-14 21:55:29','2021-09-14 21:55:29'),(753,686,NULL,123,1.0000,0.0000,'2021-09-14 21:55:29','2021-09-14 21:55:29'),(754,687,NULL,101,1.0000,0.0000,'2021-09-14 22:01:51','2021-09-14 22:01:51'),(755,688,NULL,404,10.0000,0.0000,'2021-09-20 22:39:03','2021-09-20 22:39:03'),(756,689,NULL,404,10.0000,0.0000,'2021-09-20 22:39:54','2021-09-20 22:39:54');
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `res_table_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_waiter_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_order_status` enum('received','cooked','served') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_quotation` tinyint(1) NOT NULL DEFAULT '0',
  `payment_status` enum('paid','due','partial') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjustment_type` enum('normal','abnormal') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` int(11) unsigned DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL COMMENT 'used to add customer group while selling',
  `invoice_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subscription_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subscription_repeat_on` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_date` datetime NOT NULL,
  `total_before_tax` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total before the purchase/invoice tax, this includeds the indivisual product tax',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `tax_amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `discount_type` enum('fixed','percentage') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(22,4) DEFAULT '0.0000',
  `rp_redeemed` int(11) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `rp_redeemed_amount` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'rp is the short form of reward points',
  `shipping_details` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_address` text COLLATE utf8mb4_unicode_ci,
  `shipping_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `delivered_to` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_charges` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `shipping_custom_field_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_custom_field_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_custom_field_3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_custom_field_4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_custom_field_5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_notes` text COLLATE utf8mb4_unicode_ci,
  `staff_note` text COLLATE utf8mb4_unicode_ci,
  `is_export` tinyint(1) NOT NULL DEFAULT '0',
  `export_custom_fields_info` longtext COLLATE utf8mb4_unicode_ci,
  `round_off_amount` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Difference of rounded total and actual total',
  `additional_expense_key_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_expense_value_1` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `additional_expense_key_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_expense_value_2` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `additional_expense_key_3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_expense_value_3` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `additional_expense_key_4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_expense_value_4` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `final_total` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `expense_category_id` int(10) unsigned DEFAULT NULL,
  `expense_for` int(10) unsigned DEFAULT NULL,
  `commission_agent` int(11) DEFAULT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_direct_sale` tinyint(1) NOT NULL DEFAULT '0',
  `is_suspend` tinyint(1) NOT NULL DEFAULT '0',
  `exchange_rate` decimal(20,3) NOT NULL DEFAULT '1.000',
  `total_amount_recovered` decimal(22,4) DEFAULT NULL COMMENT 'Used for stock adjustment.',
  `transfer_parent_id` int(11) DEFAULT NULL,
  `return_parent_id` int(11) DEFAULT NULL,
  `opening_stock_product_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `prefer_payment_method` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefer_payment_account` int(11) DEFAULT NULL,
  `sales_order_ids` text COLLATE utf8mb4_unicode_ci,
  `purchase_order_ids` text COLLATE utf8mb4_unicode_ci,
  `custom_field_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `import_batch` int(11) DEFAULT NULL,
  `import_time` datetime DEFAULT NULL,
  `types_of_service_id` int(11) DEFAULT NULL,
  `packing_charge` decimal(22,4) DEFAULT NULL,
  `packing_charge_type` enum('fixed','percent') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `service_custom_field_1` text COLLATE utf8mb4_unicode_ci,
  `service_custom_field_2` text COLLATE utf8mb4_unicode_ci,
  `service_custom_field_3` text COLLATE utf8mb4_unicode_ci,
  `service_custom_field_4` text COLLATE utf8mb4_unicode_ci,
  `service_custom_field_5` text COLLATE utf8mb4_unicode_ci,
  `service_custom_field_6` text COLLATE utf8mb4_unicode_ci,
  `is_created_from_api` tinyint(1) NOT NULL DEFAULT '0',
  `rp_earned` int(11) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `order_addresses` text COLLATE utf8mb4_unicode_ci,
  `is_recurring` tinyint(1) NOT NULL DEFAULT '0',
  `recur_interval` double(22,4) DEFAULT NULL,
  `recur_interval_type` enum('days','months','years') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recur_repetitions` int(11) DEFAULT NULL,
  `recur_stopped_on` datetime DEFAULT NULL,
  `recur_parent_id` int(11) DEFAULT NULL,
  `invoice_token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `transactions_tax_id_foreign` (`tax_id`) USING BTREE,
  KEY `transactions_business_id_index` (`business_id`) USING BTREE,
  KEY `transactions_type_index` (`type`) USING BTREE,
  KEY `transactions_contact_id_index` (`contact_id`) USING BTREE,
  KEY `transactions_transaction_date_index` (`transaction_date`) USING BTREE,
  KEY `transactions_created_by_index` (`created_by`) USING BTREE,
  KEY `transactions_location_id_index` (`location_id`) USING BTREE,
  KEY `transactions_expense_for_foreign` (`expense_for`) USING BTREE,
  KEY `transactions_expense_category_id_index` (`expense_category_id`) USING BTREE,
  KEY `transactions_sub_type_index` (`sub_type`) USING BTREE,
  KEY `transactions_return_parent_id_index` (`return_parent_id`) USING BTREE,
  KEY `type` (`type`) USING BTREE,
  KEY `transactions_status_index` (`status`) USING BTREE,
  KEY `transactions_sub_status_index` (`sub_status`) USING BTREE,
  KEY `transactions_res_table_id_index` (`res_table_id`) USING BTREE,
  KEY `transactions_res_waiter_id_index` (`res_waiter_id`) USING BTREE,
  KEY `transactions_res_order_status_index` (`res_order_status`) USING BTREE,
  KEY `transactions_payment_status_index` (`payment_status`) USING BTREE,
  KEY `transactions_discount_type_index` (`discount_type`) USING BTREE,
  KEY `transactions_commission_agent_index` (`commission_agent`) USING BTREE,
  KEY `transactions_transfer_parent_id_index` (`transfer_parent_id`) USING BTREE,
  KEY `transactions_types_of_service_id_index` (`types_of_service_id`) USING BTREE,
  KEY `transactions_packing_charge_type_index` (`packing_charge_type`) USING BTREE,
  KEY `transactions_recur_parent_id_index` (`recur_parent_id`) USING BTREE,
  KEY `transactions_selling_price_group_id_index` (`selling_price_group_id`) USING BTREE,
  CONSTRAINT `transactions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_category_id_foreign` FOREIGN KEY (`expense_category_id`) REFERENCES `expense_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_for_foreign` FOREIGN KEY (`expense_for`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `transactions_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=572 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
INSERT INTO `transactions` VALUES (1,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 18:56:08',13125.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,13125.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,1,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 18:56:08','2021-09-02 03:00:23'),(2,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 20:47:39',3250.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,2,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 20:47:39','2021-09-02 03:01:02'),(3,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 20:48:39',7500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,7500.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,3,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 20:48:39','2021-09-07 11:01:15'),(4,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 20:50:28',3750.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3750.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,4,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 20:50:28','2021-09-02 03:10:08'),(5,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 20:51:57',3750.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3750.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,5,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 20:51:57','2021-09-02 17:02:08'),(6,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 20:54:15',1980.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1980.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,7,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 20:54:15','2021-09-01 20:54:15'),(7,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 20:56:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,6,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 20:56:13','2021-09-07 11:38:37'),(8,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 20:57:11',3250.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,8,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 20:57:11','2021-09-01 20:57:11'),(9,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 20:58:09',3250.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,12,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 20:58:09','2021-09-02 03:13:38'),(10,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 20:59:08',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,9,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 20:59:08','2021-09-07 11:39:04'),(11,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 20:59:10',5175.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,5175.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,13,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 20:59:10','2021-09-02 03:14:21'),(12,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:01:10',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,10,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:01:10','2021-09-07 11:39:29'),(13,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:02:16',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,11,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:02:16','2021-09-07 11:39:55'),(14,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:02:56',15300.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,15300.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,14,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:02:56','2021-09-02 03:15:39'),(15,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:03:11',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,15,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:03:11','2021-09-07 11:40:27'),(16,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:04:05',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,18,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:04:05','2021-09-07 11:40:58'),(17,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:04:11',14220.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,14220.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,16,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:04:11','2021-09-02 03:16:33'),(18,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:05:14',4250.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,4250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,20,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:05:14','2021-09-07 11:45:04'),(19,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:06:24',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,27,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:06:24','2021-09-07 11:54:11'),(20,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:07:04',15300.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,15300.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,17,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:07:04','2021-09-09 17:34:10'),(21,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:08:12',5520.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,5520.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,19,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:08:12','2021-09-09 17:33:41'),(22,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:08:23',1625.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1625.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,30,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:08:23','2021-09-07 10:23:03'),(23,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:10:21',3250.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,76,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:10:21','2021-09-02 04:29:10'),(24,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:11:09',4830.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,4830.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,21,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:11:09','2021-09-02 03:20:02'),(25,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:13:01',10620.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,10620.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,23,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:13:01','2021-09-01 21:13:01'),(26,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:18:11',5325.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,5325.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,75,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:18:11','2021-09-02 04:26:21'),(27,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:18:19',7100.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,7100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,74,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:18:19','2021-09-02 04:25:16'),(28,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:19:30',3550.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3550.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,73,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:19:30','2021-09-02 04:22:59'),(29,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:20:21',3550.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3550.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,72,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:20:21','2021-09-02 04:22:28'),(30,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:21:11',3550.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3550.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,71,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:21:11','2021-09-02 04:21:56'),(31,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:21:55',1775.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1775.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,70,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:21:56','2021-09-02 04:21:19'),(32,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:23:41',1775.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1775.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,69,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:23:41','2021-09-02 04:21:01'),(33,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:25:41',3550.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3550.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,67,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:25:41','2021-09-02 04:17:10'),(34,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0001','',NULL,NULL,'2021-09-01 21:28:23',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-01 21:28:23','2021-09-01 21:28:23'),(35,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:29:02',9750.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,9750.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,66,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:29:02','2021-09-09 17:38:50'),(36,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:30:38',2235.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2235.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,65,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:30:38','2021-09-02 04:14:39'),(37,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:31:22',1125.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1125.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,64,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:31:22','2021-09-02 04:13:53'),(38,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:32:22',3825.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3825.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,63,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:32:22','2021-09-02 04:13:20'),(39,2,2,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0001',NULL,NULL,NULL,'2021-09-01 21:32:00',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,34,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:32:45','2021-09-01 21:33:42'),(40,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:33:54',3675.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3675.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,62,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:33:54','2021-09-09 17:37:57'),(41,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:35:48',5100.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,5100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,61,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:35:48','2021-09-02 04:11:32'),(42,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:37:38',3060.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3060.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,60,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:37:38','2021-09-09 17:36:46'),(43,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:38:47',2550.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2550.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,59,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:38:47','2021-09-07 10:58:34'),(44,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:39:38',2550.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2550.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,58,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:39:38','2021-09-02 04:04:10'),(45,2,2,NULL,NULL,NULL,'sell',NULL,'draft',NULL,0,NULL,NULL,2,NULL,'2021/0001','',NULL,NULL,'2021-09-01 21:39:59',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-01 21:39:59','2021-09-01 21:39:59'),(46,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:40:35',1125.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1125.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,57,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:40:35','2021-09-02 04:03:24'),(47,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:41:24',1125.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1125.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,56,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:41:24','2021-09-02 04:02:13'),(48,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:43:04',2250.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,55,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:43:04','2021-09-02 04:01:04'),(49,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:44:26',2650.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2650.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,54,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:44:26','2021-09-02 04:00:31'),(50,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:47:05',3675.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3675.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,53,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:47:05','2021-09-09 17:36:23'),(51,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:49:20',2275.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2275.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,51,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:49:20','2021-09-01 21:49:20'),(52,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:52:36',6500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,6500.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,50,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:52:36','2021-09-02 15:54:44'),(53,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:55:12',13490.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,13490.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,49,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:55:12','2021-09-09 17:34:58'),(54,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:56:00',1475.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1475.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,48,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:56:00','2021-09-09 17:35:37'),(55,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:56:46',4260.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,4260.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,47,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:56:46','2021-09-02 03:46:00'),(56,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:57:32',1950.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1950.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,46,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:57:32','2021-09-02 03:45:28'),(57,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 21:59:15',1050.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1050.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,44,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:59:15','2021-09-02 03:41:53'),(58,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 22:07:10',1050.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1050.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,43,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:07:10','2021-09-02 03:41:34'),(59,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 22:07:56',1050.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1050.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,42,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:07:56','2021-09-02 03:41:11'),(60,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 22:08:48',1050.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1050.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,41,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:08:48','2021-09-02 03:40:40'),(61,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 22:09:26',1050.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1050.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,40,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:09:26','2021-09-02 03:40:14'),(62,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 22:10:04',1050.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1050.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,39,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:10:04','2021-09-09 17:34:31'),(63,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 22:12:38',1050.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1050.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,37,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:12:38','2021-09-02 03:31:28'),(64,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 22:13:04',875.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,875.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,36,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:13:04','2021-09-01 22:13:04'),(65,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 22:13:44',1050.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1050.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,35,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:13:44','2021-09-02 03:29:18'),(66,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 22:14:19',525.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,525.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,34,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:14:19','2021-09-01 22:14:19'),(67,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 22:15:13',1400.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1400.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,33,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:15:13','2021-09-02 03:29:00'),(68,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 22:15:41',1225.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1225.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,32,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:15:41','2021-09-02 03:26:04'),(69,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 22:19:09',525.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,525.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,31,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:19:09','2021-09-01 22:19:09'),(70,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 22:20:04',700.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,700.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,29,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:20:04','2021-09-02 03:25:31'),(71,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 22:20:40',875.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,875.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,28,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:20:40','2021-09-02 03:25:07'),(72,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 22:22:11',875.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,875.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,26,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:22:11','2021-09-02 03:24:41'),(73,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 22:22:44',700.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,700.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,25,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:22:44','2021-09-01 22:22:44'),(74,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 22:23:22',1050.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1050.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,24,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:23:22','2021-09-02 03:24:13'),(75,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0002','',NULL,NULL,'2021-09-01 22:39:51',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-01 22:39:51','2021-09-01 22:39:51'),(76,2,2,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0002',NULL,NULL,NULL,'2021-09-01 22:41:00',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,75,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:41:31','2021-09-04 10:05:54'),(77,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:00:23',13125.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,13125.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,1,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:00:23','2021-09-02 03:00:23'),(78,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:01:02',3250.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,2,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:01:02','2021-09-02 03:01:02'),(80,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:06:41',3375.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3375.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,3,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:06:41','2021-09-07 11:01:15'),(81,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:09:19',3250.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,77,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:09:19','2021-09-02 03:09:19'),(82,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:10:08',3750.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3750.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,4,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:10:08','2021-09-02 03:10:08'),(83,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:12:47',3250.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,78,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:12:47','2021-09-10 16:22:38'),(84,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:13:38',3250.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,12,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:13:38','2021-09-02 03:13:38'),(85,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:14:21',5175.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,5175.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,13,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:14:21','2021-09-02 03:14:21'),(86,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:15:39',15300.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,15300.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,14,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:15:39','2021-09-02 03:15:39'),(87,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:16:33',14220.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,14220.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,16,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:16:33','2021-09-02 03:16:33'),(88,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:17:42',15300.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,15300.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,17,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:17:42','2021-09-09 17:34:10'),(89,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:18:41',5865.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,5865.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,21,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:18:41','2021-09-02 03:20:02'),(90,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:19:14',5520.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,5520.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,19,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:19:15','2021-09-09 17:33:41'),(91,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:23:24',12685.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,12685.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,79,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:23:24','2021-09-02 03:23:24'),(92,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:24:13',1050.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1050.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,24,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:24:13','2021-09-02 03:24:13'),(93,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:24:41',875.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,875.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,26,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:24:41','2021-09-02 03:24:41'),(94,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:25:07',875.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,875.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,28,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:25:07','2021-09-02 03:25:07'),(95,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:25:31',1050.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1050.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,29,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:25:31','2021-09-02 03:25:31'),(96,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:26:04',1050.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1050.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,32,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:26:04','2021-09-02 03:26:04'),(97,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:28:21',875.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,875.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,80,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:28:21','2021-09-02 03:28:21'),(98,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:29:00',1225.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1225.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,33,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:29:00','2021-09-02 03:29:00'),(99,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:29:18',875.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,875.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,35,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:29:18','2021-09-02 03:29:18'),(100,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:30:59',875.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,875.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,81,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:30:59','2021-09-02 03:30:59'),(101,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:31:28',875.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,875.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,37,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:31:28','2021-09-02 03:31:28'),(102,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:36:38',3850.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3850.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,38,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:36:38','2021-09-02 03:36:38'),(103,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:36:38',4200.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,4200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,38,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:36:38','2021-09-02 03:36:38'),(104,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:38:33',1050.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1050.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,39,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:38:33','2021-09-09 17:34:31'),(105,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:40:14',1050.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1050.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,40,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:40:14','2021-09-02 03:40:14'),(106,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:40:40',1050.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1050.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,41,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:40:40','2021-09-02 03:40:40'),(107,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:41:11',1050.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1050.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,42,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:41:11','2021-09-02 03:41:11'),(108,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:41:34',1050.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1050.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,43,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:41:34','2021-09-02 03:41:34'),(109,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:41:53',1050.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1050.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,44,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:41:53','2021-09-02 03:41:53'),(110,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:43:22',1625.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1625.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,45,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:43:22','2021-09-02 03:44:52'),(111,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:44:52',3250.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,45,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:44:52','2021-09-02 03:44:52'),(112,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:45:28',1950.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1950.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,46,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:45:28','2021-09-02 03:45:28'),(113,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:46:00',4260.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,4260.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,47,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:46:00','2021-09-02 03:46:00'),(114,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:46:29',1475.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1475.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,48,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:46:29','2021-09-09 17:35:37'),(115,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:47:39',12780.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,12780.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,49,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:47:39','2021-09-09 17:34:58'),(116,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:48:55',6500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,6500.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,50,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:48:55','2021-09-02 15:54:44'),(117,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:49:31',1625.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1625.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,30,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:49:31','2021-09-07 10:23:03'),(118,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:53:21',975.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,975.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,82,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:53:21','2021-09-02 03:53:21'),(119,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:56:16',6935.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,6935.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,83,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:56:16','2021-09-09 17:36:00'),(120,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 03:59:23',2250.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,84,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 03:59:23','2021-09-02 03:59:23'),(121,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:00:31',3445.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3445.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,54,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:00:31','2021-09-02 04:00:31'),(122,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:01:04',1125.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1125.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,55,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:01:04','2021-09-02 04:01:04'),(123,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:02:13',1125.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1125.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,56,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:02:13','2021-09-02 04:02:13'),(124,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:03:24',1125.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1125.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,57,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:03:24','2021-09-02 04:03:24'),(125,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:04:10',2550.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2550.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,58,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:04:10','2021-09-02 04:04:10'),(126,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:05:05',3570.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3570.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,59,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:05:05','2021-09-07 10:58:34'),(127,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:07:19',1275.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1275.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,85,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:07:19','2021-09-02 04:07:19'),(128,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:10:09',3315.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3315.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,86,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:10:09','2021-09-02 04:10:09'),(129,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:11:32',5100.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,5100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,61,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:11:32','2021-09-02 04:11:32'),(130,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:12:27',3675.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3675.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,62,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:12:27','2021-09-09 17:37:57'),(131,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:13:20',3825.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3825.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,63,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:13:20','2021-09-02 04:13:20'),(132,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:13:53',2250.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,64,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:13:53','2021-09-02 04:13:53'),(133,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:14:39',2235.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2235.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,65,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:14:39','2021-09-02 04:14:39'),(134,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:16:23',9750.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,9750.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,66,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:16:23','2021-09-09 17:38:50'),(135,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:17:09',5680.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,5680.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,67,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:17:10','2021-09-02 04:17:10'),(136,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:20:12',4875.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,4875.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,68,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:20:12','2021-09-02 04:20:12'),(137,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:20:12',3250.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,68,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:20:12','2021-09-02 04:20:12'),(138,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:21:01',1775.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1775.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,69,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:21:01','2021-09-02 04:21:01'),(139,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:21:19',1775.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1775.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,70,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:21:19','2021-09-02 04:21:19'),(140,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:21:56',3550.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3550.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,71,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:21:56','2021-09-02 04:21:56'),(141,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:22:28',3550.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3550.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,72,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:22:28','2021-09-02 04:22:28'),(142,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:22:59',3550.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3550.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,73,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:22:59','2021-09-02 04:22:59'),(143,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:25:16',5325.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,5325.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,74,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:25:16','2021-09-02 04:25:16'),(144,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:26:21',3550.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3550.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,75,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:26:21','2021-09-02 04:26:21'),(145,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:27:57',1775.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1775.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,87,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:27:57','2021-09-02 04:27:57'),(146,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:29:10',1625.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1625.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,76,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:29:10','2021-09-02 04:29:10'),(147,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:30:59',365.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,365.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,6,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:30:59','2021-09-07 11:38:37'),(153,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 04:40:33',3285.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3285.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,52,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 04:40:33','2021-09-02 04:40:33'),(154,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0003','',NULL,NULL,'2021-09-02 10:52:40',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 10:52:40','2021-09-02 10:52:41'),(155,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0004','',NULL,NULL,'2021-09-02 12:00:13',300.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,300.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 12:00:13','2021-09-02 12:00:13'),(156,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0005','',NULL,NULL,'2021-09-02 12:01:36',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 12:01:36','2021-09-02 12:01:36'),(157,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0006','',NULL,NULL,'2021-09-02 12:03:32',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 12:03:32','2021-09-02 12:03:32'),(158,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0007','',NULL,NULL,'2021-09-02 12:12:24',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 12:12:24','2021-09-02 12:12:24'),(159,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0008','',NULL,NULL,'2021-09-02 12:14:02',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 12:14:02','2021-09-02 12:14:02'),(160,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0009','',NULL,NULL,'2021-09-02 12:36:31',275.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,275.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 12:36:31','2021-09-02 12:36:31'),(161,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0010','',NULL,NULL,'2021-09-02 12:55:55',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 12:55:55','2021-09-02 12:55:55'),(162,2,2,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0003',NULL,NULL,NULL,'2021-09-02 13:15:00',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,154,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 13:15:57','2021-09-04 10:05:41'),(163,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0011','',NULL,NULL,'2021-09-02 13:16:58',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 13:16:58','2021-09-02 13:16:58'),(164,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0012','',NULL,NULL,'2021-09-02 13:35:19',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 13:35:19','2021-09-02 13:35:19'),(165,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0013','',NULL,NULL,'2021-09-02 13:50:58',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 13:50:58','2021-09-02 13:50:58'),(166,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0014','',NULL,NULL,'2021-09-02 14:13:53',450.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,450.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 14:13:53','2021-09-02 14:13:54'),(167,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0015','',NULL,NULL,'2021-09-02 14:28:43',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 14:28:43','2021-09-02 14:28:43'),(168,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0016','',NULL,NULL,'2021-09-02 14:36:23',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 14:36:23','2021-09-02 14:36:23'),(169,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0017','',NULL,NULL,'2021-09-02 14:51:25',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 14:51:25','2021-09-02 14:51:25'),(170,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0018','',NULL,NULL,'2021-09-02 14:53:16',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 14:53:16','2021-09-02 14:53:16'),(171,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0019','',NULL,NULL,'2021-09-02 15:02:22',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 15:02:22','2021-09-02 15:02:22'),(172,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0020','',NULL,NULL,'2021-09-02 15:03:39',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 15:03:39','2021-09-02 15:03:39'),(173,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0021','',NULL,NULL,'2021-09-02 15:18:26',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,'0453ec814f34785f3d3ff275451ee716',NULL,NULL,1,'2021-09-02 15:18:26','2021-09-02 15:20:16'),(174,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0022','',NULL,NULL,'2021-09-02 15:19:53',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 15:19:53','2021-09-02 15:19:53'),(175,2,3,NULL,NULL,NULL,'sell',NULL,'draft',NULL,0,NULL,NULL,2,NULL,'2021/0002','',NULL,NULL,'2021-09-02 15:19:55',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 15:19:55','2021-09-02 15:19:55'),(176,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0023','',NULL,NULL,'2021-09-02 15:22:43',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 15:22:43','2021-09-02 15:22:43'),(177,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0024','',NULL,NULL,'2021-09-02 15:37:04',425.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,425.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 15:37:04','2021-09-02 15:37:04'),(178,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0025','',NULL,NULL,'2021-09-02 15:38:35',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 15:38:35','2021-09-02 15:38:35'),(179,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0026','',NULL,NULL,'2021-09-02 16:08:05',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 16:08:05','2021-09-02 16:08:05'),(180,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0027','',NULL,NULL,'2021-09-02 16:14:38',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 16:14:38','2021-09-02 16:14:38'),(181,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0028','',NULL,NULL,'2021-09-02 16:15:51',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 16:15:51','2021-09-02 16:15:51'),(182,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0029','',NULL,NULL,'2021-09-02 16:28:07',700.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,700.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 16:28:07','2021-09-02 16:28:07'),(183,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0030','',NULL,NULL,'2021-09-02 16:35:41',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 16:35:41','2021-09-02 16:35:41'),(184,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0031','',NULL,NULL,'2021-09-02 16:38:48',500.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,500.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 16:38:48','2021-09-02 16:38:49'),(185,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0032','',NULL,NULL,'2021-09-02 16:44:50',425.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,425.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 16:44:50','2021-09-02 16:44:50'),(186,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0033','',NULL,NULL,'2021-09-02 16:45:39',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 16:45:39','2021-09-02 16:45:39'),(187,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0034','',NULL,NULL,'2021-09-02 16:46:22',550.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,550.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 16:46:22','2021-09-02 16:46:22'),(188,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0035','',NULL,NULL,'2021-09-02 16:51:52',550.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,550.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 16:51:52','2021-09-02 16:51:52'),(189,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 17:02:08',3750.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3750.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,5,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 17:02:08','2021-09-02 17:02:08'),(190,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0036','',NULL,NULL,'2021-09-02 17:12:53',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 17:12:53','2021-09-02 17:12:54'),(191,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0037','',NULL,NULL,'2021-09-02 17:15:12',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 17:15:12','2021-09-02 17:15:12'),(192,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0038','',NULL,NULL,'2021-09-02 17:16:19',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 17:16:19','2021-09-02 17:16:19'),(193,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0039','',NULL,NULL,'2021-09-02 17:19:58',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 17:19:58','2021-09-02 17:19:58'),(194,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0040','',NULL,NULL,'2021-09-02 17:27:23',450.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,450.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 17:27:23','2021-09-02 17:27:23'),(195,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0041','',NULL,NULL,'2021-09-02 17:37:56',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 17:37:56','2021-09-02 17:37:56'),(196,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 17:58:25',255.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,255.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,60,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 17:58:25','2021-09-09 17:36:46'),(197,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0042','',NULL,NULL,'2021-09-02 18:08:47',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:08:47','2021-09-02 18:08:47'),(198,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0043','',NULL,NULL,'2021-09-02 18:09:37',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:09:37','2021-09-02 18:09:37'),(199,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0044','',NULL,NULL,'2021-09-02 18:15:42',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:15:43','2021-09-02 18:15:43'),(200,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0045','',NULL,NULL,'2021-09-02 18:18:14',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:18:14','2021-09-02 18:18:14'),(201,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0046','',NULL,NULL,'2021-09-02 18:20:15',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:20:15','2021-09-02 18:20:15'),(202,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0047','',NULL,NULL,'2021-09-02 18:22:15',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,10,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:22:15','2021-09-02 18:22:15'),(203,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0048','',NULL,NULL,'2021-09-02 18:26:11',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:26:11','2021-09-02 18:26:11'),(204,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0049','',NULL,NULL,'2021-09-02 18:34:25',195.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,195.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:34:25','2021-09-02 18:34:25'),(205,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0050','',NULL,NULL,'2021-09-02 18:36:25',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:36:25','2021-09-02 18:36:25'),(206,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0051','',NULL,NULL,'2021-09-02 18:38:17',375.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,375.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:38:17','2021-09-02 18:38:17'),(207,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0052','',NULL,NULL,'2021-09-02 18:43:58',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,10,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:43:58','2021-09-02 18:43:58'),(208,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0053','',NULL,NULL,'2021-09-02 18:45:18',375.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,375.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:45:18','2021-09-02 18:45:18'),(209,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0054','',NULL,NULL,'2021-09-02 18:47:17',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:47:17','2021-09-02 18:47:17'),(210,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0055','',NULL,NULL,'2021-09-02 18:49:46',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:49:46','2021-09-02 18:49:46'),(211,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0056','',NULL,NULL,'2021-09-02 18:51:48',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:51:48','2021-09-02 18:51:48'),(212,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0057','',NULL,NULL,'2021-09-02 18:53:30',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:53:30','2021-09-02 18:53:30'),(213,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0058','',NULL,NULL,'2021-09-02 18:54:49',345.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,345.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:54:49','2021-09-02 18:54:49'),(214,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0059','',NULL,NULL,'2021-09-02 18:55:24',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:55:24','2021-09-02 18:55:24'),(215,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0060','',NULL,NULL,'2021-09-02 18:55:49',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:55:49','2021-09-02 18:55:49'),(216,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0061','',NULL,NULL,'2021-09-02 18:58:52',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 18:58:52','2021-09-02 18:58:52'),(217,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0062','',NULL,NULL,'2021-09-02 19:13:58',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 19:13:58','2021-09-02 19:13:58'),(218,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0063','',NULL,NULL,'2021-09-02 19:15:20',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 19:15:20','2021-09-02 19:15:20'),(219,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0064','',NULL,NULL,'2021-09-02 19:16:30',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 19:16:30','2021-09-02 19:16:30'),(220,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0065','',NULL,NULL,'2021-09-02 19:24:44',500.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,500.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 19:24:44','2021-09-02 19:24:44'),(221,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0066','',NULL,NULL,'2021-09-02 19:25:49',575.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,575.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 19:25:49','2021-09-02 19:25:49'),(222,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0067','',NULL,NULL,'2021-09-02 19:26:25',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 19:26:25','2021-09-02 19:26:25'),(223,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0068','',NULL,NULL,'2021-09-02 19:29:41',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 19:29:41','2021-09-02 19:29:41'),(224,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0069','',NULL,NULL,'2021-09-02 19:34:46',225.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,225.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 19:34:46','2021-09-02 19:34:46'),(225,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0070','',NULL,NULL,'2021-09-02 19:35:25',270.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,270.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 19:35:25','2021-09-02 19:35:25'),(226,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0071','',NULL,NULL,'2021-09-02 19:36:44',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 19:36:44','2021-09-02 19:36:44'),(227,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0072','',NULL,NULL,'2021-09-02 19:43:08',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 19:43:08','2021-09-02 19:43:08'),(228,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0073','',NULL,NULL,'2021-09-02 19:51:22',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 19:51:22','2021-09-02 19:51:22'),(229,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0074','',NULL,NULL,'2021-09-02 19:55:11',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 19:55:11','2021-09-02 19:55:11'),(230,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0075','',NULL,NULL,'2021-09-02 19:55:49',300.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,300.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 19:55:49','2021-09-02 19:55:49'),(231,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0076','',NULL,NULL,'2021-09-02 20:01:55',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 20:01:55','2021-09-02 20:01:55'),(232,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0077','',NULL,NULL,'2021-09-02 20:04:06',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 20:04:06','2021-09-02 20:04:06'),(233,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0078','',NULL,NULL,'2021-09-02 20:09:32',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 20:09:32','2021-09-02 20:09:32'),(234,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0079','',NULL,NULL,'2021-09-02 20:10:49',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 20:10:49','2021-09-02 20:10:49'),(235,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0080','',NULL,NULL,'2021-09-02 20:12:40',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 20:12:40','2021-09-02 20:12:40'),(236,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0081','',NULL,NULL,'2021-09-02 20:20:03',345.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,345.0000,NULL,NULL,10,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 20:20:03','2021-09-02 20:20:03'),(237,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0082','',NULL,NULL,'2021-09-02 20:24:26',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 20:24:26','2021-09-02 20:24:26'),(238,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0083','',NULL,NULL,'2021-09-02 20:31:12',175.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,175.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 20:31:12','2021-09-02 20:31:12'),(239,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0084','',NULL,NULL,'2021-09-02 20:48:57',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 20:48:57','2021-09-02 20:48:57'),(240,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0085','',NULL,NULL,'2021-09-02 20:58:21',900.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,900.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 20:58:21','2021-09-02 20:58:21'),(241,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0086','',NULL,NULL,'2021-09-02 21:01:59',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 21:01:59','2021-09-02 21:01:59'),(242,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0087','',NULL,NULL,'2021-09-02 21:05:34',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 21:05:34','2021-09-02 21:05:34'),(243,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0088','',NULL,NULL,'2021-09-02 21:07:56',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 21:07:56','2021-09-02 21:07:56'),(244,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0089','',NULL,NULL,'2021-09-02 21:10:54',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 21:10:54','2021-09-02 21:10:54'),(245,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0090','',NULL,NULL,'2021-09-02 21:26:09',300.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,300.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 21:26:09','2021-09-02 21:26:09'),(246,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0091','',NULL,NULL,'2021-09-02 21:34:31',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 21:34:31','2021-09-02 21:34:31'),(247,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0092','',NULL,NULL,'2021-09-02 21:39:06',825.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,825.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 21:39:06','2021-09-02 21:39:06'),(248,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0093','',NULL,NULL,'2021-09-02 21:40:37',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 21:40:37','2021-09-02 21:40:37'),(249,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0094','',NULL,NULL,'2021-09-02 21:46:41',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 21:46:42','2021-09-02 21:46:42'),(250,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0095','',NULL,NULL,'2021-09-02 21:48:55',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 21:48:55','2021-09-02 21:48:55'),(251,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0096','',NULL,NULL,'2021-09-02 21:51:03',300.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,300.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 21:51:03','2021-09-02 21:51:03'),(252,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0097','',NULL,NULL,'2021-09-02 22:00:22',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 22:00:22','2021-09-02 22:00:23'),(253,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0098','',NULL,NULL,'2021-09-02 22:12:31',300.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,300.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 22:12:31','2021-09-02 22:12:31'),(254,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0099','',NULL,NULL,'2021-09-02 22:19:22',500.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,500.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 22:19:22','2021-09-02 22:19:22'),(255,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0100','',NULL,NULL,'2021-09-02 22:29:42',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,10,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 22:29:42','2021-09-02 22:29:42'),(256,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0101','',NULL,NULL,'2021-09-02 22:31:18',175.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,175.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 22:31:18','2021-09-02 22:31:18'),(257,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0102','',NULL,NULL,'2021-09-02 22:38:12',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 22:38:12','2021-09-02 22:38:12'),(258,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0103','',NULL,NULL,'2021-09-02 22:40:38',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 22:40:38','2021-09-02 22:40:38'),(259,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0104','',NULL,NULL,'2021-09-02 22:43:11',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 22:43:11','2021-09-02 22:43:11'),(260,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0105','',NULL,NULL,'2021-09-02 22:54:37',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 22:54:37','2021-09-02 22:54:37'),(261,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0106','',NULL,NULL,'2021-09-02 22:55:56',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 22:55:56','2021-09-02 22:55:56'),(262,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0107','',NULL,NULL,'2021-09-02 22:56:41',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 22:56:41','2021-09-02 22:56:41'),(263,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0108','',NULL,NULL,'2021-09-02 22:58:58',175.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,175.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 22:58:58','2021-09-02 22:58:58'),(264,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0109','',NULL,NULL,'2021-09-02 23:02:02',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 23:02:02','2021-09-02 23:02:03'),(265,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0110','',NULL,NULL,'2021-09-02 23:05:40',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 23:05:40','2021-09-02 23:05:40'),(266,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0111','',NULL,NULL,'2021-09-02 23:07:52',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 23:07:52','2021-09-02 23:07:52'),(267,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0112','',NULL,NULL,'2021-09-02 23:08:24',325.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,325.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 23:08:24','2021-09-02 23:08:24'),(268,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0113','',NULL,NULL,'2021-09-02 23:08:53',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 23:08:53','2021-09-02 23:08:53'),(269,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0114','',NULL,NULL,'2021-09-02 23:15:47',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 23:15:47','2021-09-02 23:15:47'),(270,2,3,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0004',NULL,NULL,NULL,'2021-09-02 23:13:00',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,221,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 23:17:39','2021-09-04 10:05:30'),(271,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0115','',NULL,NULL,'2021-09-02 23:18:34',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 23:18:34','2021-09-02 23:18:34'),(272,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0116','',NULL,NULL,'2021-09-02 23:20:16',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 23:20:16','2021-09-02 23:20:16'),(273,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0117','',NULL,NULL,'2021-09-02 23:25:53',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 23:25:53','2021-09-02 23:25:53'),(274,2,2,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0005',NULL,NULL,NULL,'2021-09-02 23:30:00',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,262,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 23:30:43','2021-09-04 10:05:13'),(275,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0118','',NULL,NULL,'2021-09-02 23:36:46',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-02 23:36:46','2021-09-02 23:36:46'),(276,2,2,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0006',NULL,NULL,NULL,'2021-09-03 13:12:00',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,193,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 13:12:55','2021-09-04 10:04:59'),(277,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0119','',NULL,NULL,'2021-09-03 13:14:10',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 13:14:10','2021-09-03 13:14:10'),(278,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0120','',NULL,NULL,'2021-09-03 14:53:27',700.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,700.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 14:53:27','2021-09-03 14:53:27'),(279,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0121','',NULL,NULL,'2021-09-03 15:00:48',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 15:00:48','2021-09-03 15:00:48'),(280,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0122','',NULL,NULL,'2021-09-03 15:09:02',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 15:09:02','2021-09-03 15:09:02'),(281,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0123','',NULL,NULL,'2021-09-03 15:16:35',175.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,175.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 15:16:35','2021-09-03 15:16:35'),(282,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0124','',NULL,NULL,'2021-09-03 16:00:14',1150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1150.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 16:00:14','2021-09-03 16:00:14'),(283,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0125','',NULL,NULL,'2021-09-03 16:03:34',870.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,870.0000,NULL,NULL,10,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 16:03:34','2021-09-03 16:03:34'),(284,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0126','',NULL,NULL,'2021-09-03 16:19:33',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 16:19:33','2021-09-03 16:19:33'),(285,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0127','',NULL,NULL,'2021-09-03 16:21:48',225.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,225.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 16:21:48','2021-09-03 16:21:48'),(286,2,2,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0007',NULL,NULL,NULL,'2021-09-03 16:56:00',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,272,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 16:56:37','2021-09-04 10:04:43'),(287,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0128','',NULL,NULL,'2021-09-03 17:17:39',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 17:17:39','2021-09-03 17:17:39'),(288,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0129','',NULL,NULL,'2021-09-03 17:30:31',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 17:30:31','2021-09-03 17:30:31'),(289,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0130','',NULL,NULL,'2021-09-03 17:40:37',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 17:40:37','2021-09-03 17:40:37'),(290,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0131','',NULL,NULL,'2021-09-03 17:42:31',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 17:42:31','2021-09-03 17:42:31'),(291,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0132','',NULL,NULL,'2021-09-03 17:45:46',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 17:45:46','2021-09-03 17:45:46'),(292,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0133','',NULL,NULL,'2021-09-03 17:48:03',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 17:48:03','2021-09-03 17:48:03'),(293,2,3,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0008',NULL,NULL,NULL,'2021-09-03 18:34:00',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,287,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 18:35:04','2021-09-04 10:04:18'),(294,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0134','',NULL,NULL,'2021-09-03 18:39:20',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 18:39:20','2021-09-03 18:39:20'),(295,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0135','',NULL,NULL,'2021-09-03 18:39:33',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 18:39:33','2021-09-03 18:39:33'),(296,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0136','',NULL,NULL,'2021-09-03 18:58:05',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 18:58:05','2021-09-03 18:58:05'),(297,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0137','',NULL,NULL,'2021-09-03 19:01:30',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 19:01:30','2021-09-03 19:01:30'),(298,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0138','',NULL,NULL,'2021-09-03 19:04:07',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 19:04:07','2021-09-03 19:04:07'),(299,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0139','',NULL,NULL,'2021-09-03 19:27:30',525.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,525.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 19:27:30','2021-09-03 19:27:30'),(300,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0140','',NULL,NULL,'2021-09-03 19:43:03',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 19:43:03','2021-09-03 19:43:03'),(301,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0141','',NULL,NULL,'2021-09-03 19:45:10',195.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,195.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 19:45:10','2021-09-03 19:45:10'),(302,2,2,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0009',NULL,NULL,NULL,'2021-09-03 19:50:00',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,245,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 19:50:44','2021-09-04 10:04:01'),(303,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0142','',NULL,NULL,'2021-09-03 20:04:39',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 20:04:39','2021-09-03 20:04:39'),(304,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0143','',NULL,NULL,'2021-09-03 20:06:55',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 20:06:55','2021-09-03 20:06:55'),(305,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0144','',NULL,NULL,'2021-09-03 20:10:57',0.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 20:10:57','2021-09-03 20:10:57'),(306,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0145','',NULL,NULL,'2021-09-03 20:12:06',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 20:12:06','2021-09-03 20:12:06'),(307,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0146','',NULL,NULL,'2021-09-03 20:20:44',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 20:20:44','2021-09-03 20:20:44'),(308,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0147','',NULL,NULL,'2021-09-03 20:23:18',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 20:23:18','2021-09-03 20:23:18'),(309,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0148','',NULL,NULL,'2021-09-03 20:24:03',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 20:24:03','2021-09-03 20:24:03'),(310,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0149','',NULL,NULL,'2021-09-03 20:32:21',300.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,300.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 20:32:21','2021-09-03 20:32:21'),(311,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0150','',NULL,NULL,'2021-09-03 20:36:21',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 20:36:21','2021-09-03 20:36:21'),(312,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0151','',NULL,NULL,'2021-09-03 20:37:02',225.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,225.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 20:37:02','2021-09-03 20:37:02'),(313,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0152','',NULL,NULL,'2021-09-03 20:37:47',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,10,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 20:37:47','2021-09-03 20:37:47'),(314,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0153','',NULL,NULL,'2021-09-03 20:41:28',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 20:41:28','2021-09-03 20:41:28'),(315,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0154','',NULL,NULL,'2021-09-03 20:52:48',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 20:52:48','2021-09-03 20:52:48'),(316,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0155','',NULL,NULL,'2021-09-03 21:07:12',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 21:07:12','2021-09-03 21:07:12'),(317,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0156','',NULL,NULL,'2021-09-03 21:14:18',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 21:14:18','2021-09-03 21:14:18'),(318,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0157','',NULL,NULL,'2021-09-03 21:20:18',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 21:20:18','2021-09-03 21:20:18'),(319,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0158','',NULL,NULL,'2021-09-03 21:28:18',175.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,175.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 21:28:18','2021-09-03 21:28:18'),(320,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0159','',NULL,NULL,'2021-09-03 21:45:39',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 21:45:39','2021-09-03 21:45:39'),(321,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0160','',NULL,NULL,'2021-09-03 21:50:29',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 21:50:29','2021-09-03 21:50:29'),(322,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0161','',NULL,NULL,'2021-09-03 21:50:36',225.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,225.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 21:50:36','2021-09-03 21:50:36'),(323,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0162','',NULL,NULL,'2021-09-03 21:54:58',350.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,350.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 21:54:58','2021-09-03 21:54:58'),(324,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0163','',NULL,NULL,'2021-09-03 22:07:44',195.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,195.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 22:07:44','2021-09-03 22:07:44'),(325,2,3,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0010',NULL,NULL,NULL,'2021-09-03 22:24:00',0.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,305,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 22:24:29','2021-09-03 22:24:29'),(326,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0164','',NULL,NULL,'2021-09-03 22:25:05',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 22:25:05','2021-09-03 22:25:05'),(327,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0165','',NULL,NULL,'2021-09-03 22:52:39',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 22:52:39','2021-09-03 22:52:39'),(328,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0166','',NULL,NULL,'2021-09-03 22:53:01',500.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,500.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 22:53:01','2021-09-03 22:53:01'),(329,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0167','',NULL,NULL,'2021-09-03 22:54:02',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 22:54:02','2021-09-03 22:54:02'),(330,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0168','',NULL,NULL,'2021-09-03 23:21:16',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 23:21:16','2021-09-03 23:21:16'),(331,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0169','',NULL,NULL,'2021-09-03 23:25:16',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 23:25:16','2021-09-03 23:25:16'),(332,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0170','',NULL,NULL,'2021-09-03 23:26:49',425.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,425.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 23:26:49','2021-09-03 23:26:49'),(333,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0171','',NULL,NULL,'2021-09-03 23:55:08',425.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,425.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-03 23:55:08','2021-09-03 23:55:09'),(334,2,3,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0011',NULL,NULL,NULL,'2021-09-03 23:56:00',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,333,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 23:56:58','2021-09-04 10:03:48'),(335,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0172','',NULL,NULL,'2021-09-04 12:19:48',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 12:19:48','2021-09-04 12:19:48'),(336,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0173','',NULL,NULL,'2021-09-04 12:29:30',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,10,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 12:29:30','2021-09-04 12:29:30'),(337,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0174','',NULL,NULL,'2021-09-04 12:42:21',475.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,475.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 12:42:21','2021-09-04 12:42:21'),(338,2,3,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0012',NULL,NULL,NULL,'2021-09-04 12:47:00',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,337,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 12:48:50','2021-09-04 13:20:28'),(339,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0175','',NULL,NULL,'2021-09-04 14:08:13',475.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,475.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 14:08:13','2021-09-04 14:08:14'),(340,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0176','',NULL,NULL,'2021-09-04 15:33:29',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 15:33:30','2021-09-04 15:33:30'),(341,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0177','',NULL,NULL,'2021-09-04 16:09:23',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 16:09:23','2021-09-04 16:09:23'),(342,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0178','',NULL,NULL,'2021-09-04 16:10:59',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 16:10:59','2021-09-04 16:10:59'),(343,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0179','',NULL,NULL,'2021-09-04 17:16:52',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 17:16:52','2021-09-04 17:16:52'),(344,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0180','',NULL,NULL,'2021-09-04 17:24:21',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 17:24:21','2021-09-04 17:24:21'),(345,2,3,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0013',NULL,NULL,NULL,'2021-09-04 17:24:00',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,344,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 17:25:04','2021-09-04 17:29:50'),(346,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0181','',NULL,NULL,'2021-09-04 17:36:15',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 17:36:15','2021-09-04 17:36:15'),(347,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0182','',NULL,NULL,'2021-09-04 17:56:23',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 17:56:23','2021-09-04 17:56:23'),(348,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0183','',NULL,NULL,'2021-09-04 17:58:41',375.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,375.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 17:58:41','2021-09-04 17:58:41'),(349,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0184','',NULL,NULL,'2021-09-04 18:46:28',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 18:46:28','2021-09-04 18:46:28'),(350,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0185','',NULL,NULL,'2021-09-04 18:48:17',600.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,600.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 18:48:17','2021-09-04 18:48:17'),(351,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0186','',NULL,NULL,'2021-09-04 18:51:55',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 18:51:55','2021-09-04 18:51:55'),(352,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0187','',NULL,NULL,'2021-09-04 18:55:10',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 18:55:10','2021-09-04 18:55:10'),(353,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0188','',NULL,NULL,'2021-09-04 19:01:19',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 19:01:19','2021-09-04 19:01:19'),(354,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0189','',NULL,NULL,'2021-09-04 19:06:02',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 19:06:02','2021-09-04 19:06:02'),(355,2,3,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0014',NULL,NULL,NULL,'2021-09-04 19:06:00',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,354,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 19:06:55','2021-09-04 19:09:21'),(356,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0190','',NULL,NULL,'2021-09-04 19:40:58',395.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,395.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 19:40:58','2021-09-04 19:40:58'),(357,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0191','',NULL,NULL,'2021-09-04 20:11:09',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 20:11:09','2021-09-04 20:11:10'),(358,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0192','',NULL,NULL,'2021-09-04 20:27:28',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 20:27:28','2021-09-04 20:27:28'),(359,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0193','',NULL,NULL,'2021-09-04 20:33:39',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 20:33:39','2021-09-04 20:33:39'),(360,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0194','',NULL,NULL,'2021-09-04 20:35:11',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 20:35:11','2021-09-04 20:35:12'),(361,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0195','',NULL,NULL,'2021-09-04 20:35:55',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 20:35:55','2021-09-04 20:35:55'),(362,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0196','',NULL,NULL,'2021-09-04 20:40:00',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 20:40:00','2021-09-04 20:40:00'),(363,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0197','',NULL,NULL,'2021-09-04 20:53:38',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 20:53:38','2021-09-04 20:53:38'),(364,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0198','',NULL,NULL,'2021-09-04 20:57:00',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 20:57:00','2021-09-04 20:57:00'),(365,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0199','',NULL,NULL,'2021-09-04 20:57:58',25.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,25.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 20:57:58','2021-09-04 20:57:58'),(366,2,2,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0015',NULL,NULL,NULL,'2021-09-04 21:05:00',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,353,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 21:05:56','2021-09-04 21:13:31'),(367,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0200','',NULL,NULL,'2021-09-04 21:08:20',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 21:08:20','2021-09-04 21:08:20'),(368,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0201','',NULL,NULL,'2021-09-04 21:28:12',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 21:28:12','2021-09-04 21:28:12'),(369,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0202','',NULL,NULL,'2021-09-04 21:29:05',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 21:29:05','2021-09-04 21:29:05'),(370,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0203','',NULL,NULL,'2021-09-04 21:40:44',300.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,300.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 21:40:44','2021-09-04 21:40:44'),(371,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0204','',NULL,NULL,'2021-09-04 21:47:44',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 21:47:44','2021-09-04 21:47:44'),(372,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0205','',NULL,NULL,'2021-09-04 22:02:41',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 22:02:41','2021-09-04 22:02:41'),(373,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0206','',NULL,NULL,'2021-09-04 22:02:59',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 22:02:59','2021-09-04 22:02:59'),(374,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0207','',NULL,NULL,'2021-09-04 22:03:24',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 22:03:24','2021-09-04 22:03:24'),(375,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0208','',NULL,NULL,'2021-09-04 22:07:54',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 22:07:54','2021-09-04 22:07:54'),(376,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0209','',NULL,NULL,'2021-09-04 22:17:30',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 22:17:30','2021-09-04 22:17:30'),(377,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0210','',NULL,NULL,'2021-09-04 22:22:55',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 22:22:55','2021-09-04 22:22:55'),(378,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0211','',NULL,NULL,'2021-09-04 22:37:39',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 22:37:39','2021-09-04 22:37:39'),(379,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0212','',NULL,NULL,'2021-09-04 22:44:59',125.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,125.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 22:44:59','2021-09-04 22:45:00'),(380,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0213','',NULL,NULL,'2021-09-04 22:47:25',275.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,275.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 22:47:25','2021-09-04 22:47:25'),(381,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0214','',NULL,NULL,'2021-09-04 22:48:28',175.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,175.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 22:48:28','2021-09-04 22:48:28'),(382,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0215','',NULL,NULL,'2021-09-04 22:49:36',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 22:49:36','2021-09-04 22:49:36'),(383,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0216','',NULL,NULL,'2021-09-04 22:51:31',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-04 22:51:31','2021-09-04 22:51:31'),(384,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0217','',NULL,NULL,'2021-09-05 11:41:52',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 11:41:52','2021-09-05 11:41:53'),(385,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0218','',NULL,NULL,'2021-09-05 11:59:40',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,6,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 11:59:40','2021-09-05 11:59:40'),(386,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0219','',NULL,NULL,'2021-09-05 12:09:07',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 12:09:07','2021-09-05 12:09:07'),(387,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0220','',NULL,NULL,'2021-09-05 12:09:45',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,7,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 12:09:45','2021-09-05 12:09:45'),(388,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0221','',NULL,NULL,'2021-09-05 12:26:06',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,8,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 12:26:06','2021-09-05 12:26:06'),(389,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0222','',NULL,NULL,'2021-09-05 13:29:07',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,7,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 13:29:07','2021-09-05 13:29:07'),(390,2,2,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0016',NULL,NULL,NULL,'2021-09-05 15:21:00',300.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,300.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,240,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 15:22:48','2021-09-05 15:23:18'),(391,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0223','',NULL,NULL,'2021-09-05 15:24:23',300.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,300.0000,NULL,NULL,6,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 15:24:23','2021-09-05 15:24:23'),(392,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0224','',NULL,NULL,'2021-09-05 15:32:10',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,6,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 15:32:10','2021-09-05 15:32:10'),(393,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0225','',NULL,NULL,'2021-09-05 16:07:36',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,4,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 16:07:36','2021-09-05 16:07:36'),(394,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0226','',NULL,NULL,'2021-09-05 17:52:43',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 17:52:43','2021-09-05 17:52:43'),(395,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0227','',NULL,NULL,'2021-09-05 18:04:14',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 18:04:14','2021-09-05 18:04:14'),(396,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0228','',NULL,NULL,'2021-09-05 18:06:48',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 18:06:48','2021-09-05 18:06:48'),(397,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0229','',NULL,NULL,'2021-09-05 18:32:58',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 18:32:58','2021-09-05 18:32:58'),(398,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0230','',NULL,NULL,'2021-09-05 18:42:03',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,4,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 18:42:03','2021-09-05 18:42:04'),(399,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0231','',NULL,NULL,'2021-09-05 18:48:36',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 18:48:36','2021-09-05 18:48:36'),(400,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0232','',NULL,NULL,'2021-09-05 18:53:15',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 18:53:15','2021-09-05 18:53:15'),(401,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0233','',NULL,NULL,'2021-09-05 19:36:46',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 19:36:46','2021-09-05 19:36:46'),(402,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0234','',NULL,NULL,'2021-09-05 19:45:10',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 19:45:10','2021-09-05 19:45:10'),(403,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0235','',NULL,NULL,'2021-09-05 19:47:35',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 19:47:35','2021-09-05 19:47:35'),(404,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0236','',NULL,NULL,'2021-09-05 20:25:23',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 20:25:23','2021-09-05 20:25:23'),(405,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0237','',NULL,NULL,'2021-09-05 20:41:22',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 20:41:22','2021-09-05 20:41:22'),(406,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0238','',NULL,NULL,'2021-09-05 20:42:46',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 20:42:46','2021-09-05 20:42:46'),(407,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0239','',NULL,NULL,'2021-09-05 21:18:29',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 21:18:29','2021-09-05 21:18:29'),(408,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0240','',NULL,NULL,'2021-09-05 21:20:21',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 21:20:21','2021-09-05 21:20:21'),(409,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0241','',NULL,NULL,'2021-09-05 21:30:02',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 21:30:02','2021-09-05 21:30:02'),(410,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0242','',NULL,NULL,'2021-09-05 21:47:24',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 21:47:24','2021-09-05 21:47:25'),(411,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0243','',NULL,NULL,'2021-09-05 22:40:19',225.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,225.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 22:40:19','2021-09-05 22:40:19'),(412,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0244','',NULL,NULL,'2021-09-05 22:53:10',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,4,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 22:53:10','2021-09-05 22:53:10'),(413,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0245','',NULL,NULL,'2021-09-05 23:02:18',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 23:02:18','2021-09-05 23:02:18'),(414,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0246','',NULL,NULL,'2021-09-05 23:04:45',225.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,225.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-05 23:04:45','2021-09-05 23:04:46'),(415,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0247','',NULL,NULL,'2021-09-06 13:17:55',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,4,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 13:17:55','2021-09-06 13:17:55'),(416,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0248','',NULL,NULL,'2021-09-06 14:06:12',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 14:06:12','2021-09-06 14:06:12'),(417,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0249','',NULL,NULL,'2021-09-06 14:16:39',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 14:16:39','2021-09-06 14:16:40'),(418,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0250','',NULL,NULL,'2021-09-06 16:10:43',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 16:10:43','2021-09-06 16:10:43'),(419,2,2,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0017',NULL,NULL,NULL,'2021-09-06 17:52:00',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,400,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 17:52:16','2021-09-06 17:54:33'),(420,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0251','',NULL,NULL,'2021-09-06 17:52:49',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 17:52:49','2021-09-06 17:52:49'),(421,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0252','',NULL,NULL,'2021-09-06 18:38:05',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 18:38:05','2021-09-06 18:38:05'),(422,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0253','',NULL,NULL,'2021-09-06 18:56:11',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,4,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 18:56:11','2021-09-06 18:56:11'),(423,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0254','',NULL,NULL,'2021-09-06 19:12:58',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,4,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 19:12:58','2021-09-06 19:12:58'),(424,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0255','',NULL,NULL,'2021-09-06 19:16:30',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,6,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 19:16:30','2021-09-06 19:16:30'),(425,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0256','',NULL,NULL,'2021-09-06 19:35:03',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 19:35:03','2021-09-06 19:35:03'),(426,2,2,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0018',NULL,NULL,NULL,'2021-09-06 19:57:00',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,407,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 19:57:09','2021-09-06 20:00:28'),(427,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0257','',NULL,NULL,'2021-09-06 20:08:02',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 20:08:02','2021-09-06 20:08:02'),(428,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0258','',NULL,NULL,'2021-09-06 20:09:40',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,4,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 20:09:40','2021-09-06 20:09:40'),(429,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0259','',NULL,NULL,'2021-09-06 20:38:46',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 20:38:46','2021-09-06 20:38:46'),(430,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0260','',NULL,NULL,'2021-09-06 20:51:19',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 20:51:19','2021-09-06 20:51:19'),(431,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0261','',NULL,NULL,'2021-09-06 21:22:21',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 21:22:21','2021-09-06 21:22:21'),(432,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0262','',NULL,NULL,'2021-09-06 21:22:37',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 21:22:37','2021-09-06 21:22:37'),(433,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0263','',NULL,NULL,'2021-09-06 21:23:21',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 21:23:21','2021-09-06 21:23:21'),(434,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0264','',NULL,NULL,'2021-09-06 21:26:07',575.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,575.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 21:26:07','2021-09-06 21:26:07'),(435,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0265','',NULL,NULL,'2021-09-06 21:41:10',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,4,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 21:41:10','2021-09-06 21:41:10'),(436,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0266','',NULL,NULL,'2021-09-06 21:55:08',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 21:55:08','2021-09-06 21:55:08'),(437,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0267','',NULL,NULL,'2021-09-06 22:11:02',275.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,275.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 22:11:02','2021-09-06 22:11:02'),(438,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0268','',NULL,NULL,'2021-09-06 22:36:37',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,6,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 22:36:37','2021-09-06 22:36:37'),(439,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0269','',NULL,NULL,'2021-09-06 22:57:31',350.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,350.0000,NULL,NULL,4,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-06 22:57:31','2021-09-06 22:57:31'),(440,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0270','',NULL,NULL,'2021-09-07 11:19:35',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,8,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 11:19:35','2021-09-07 11:19:35'),(441,2,2,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0019',NULL,NULL,NULL,'2021-09-07 11:48:00',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,415,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 11:48:36','2021-09-07 11:51:19'),(442,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0271','',NULL,NULL,'2021-09-07 11:49:53',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 11:49:53','2021-09-07 11:49:53'),(443,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0272','',NULL,NULL,'2021-09-07 12:19:56',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,8,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 12:19:56','2021-09-07 12:19:56'),(444,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0273','',NULL,NULL,'2021-09-07 13:23:35',650.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,650.0000,NULL,NULL,4,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 13:23:35','2021-09-07 13:23:35'),(445,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0274','',NULL,NULL,'2021-09-07 13:47:49',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 13:47:49','2021-09-07 13:47:49'),(446,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0275','',NULL,NULL,'2021-09-07 15:07:51',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 15:07:51','2021-09-07 15:07:51'),(447,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0276','',NULL,NULL,'2021-09-07 15:10:12',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 15:10:12','2021-09-07 15:10:13'),(448,2,3,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0020',NULL,NULL,NULL,'2021-09-07 15:11:00',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,447,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 15:12:11','2021-09-07 15:13:12'),(449,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0277','',NULL,NULL,'2021-09-07 16:32:09',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 16:32:09','2021-09-07 16:32:09'),(450,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0278','',NULL,NULL,'2021-09-07 16:34:23',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,8,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 16:34:23','2021-09-07 16:34:23'),(451,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0279','',NULL,NULL,'2021-09-07 17:17:35',225.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,225.0000,NULL,NULL,8,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 17:17:35','2021-09-07 17:17:35'),(452,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0280','',NULL,NULL,'2021-09-07 17:53:50',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,7,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 17:53:50','2021-09-07 17:53:50'),(453,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0281','',NULL,NULL,'2021-09-07 18:15:30',225.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,225.0000,NULL,NULL,7,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 18:15:30','2021-09-07 18:15:30'),(454,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0282','',NULL,NULL,'2021-09-07 18:54:24',350.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,350.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 18:54:24','2021-09-07 18:54:24'),(455,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0283','',NULL,NULL,'2021-09-07 18:56:23',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 18:56:23','2021-09-07 18:56:23'),(456,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0284','',NULL,NULL,'2021-09-07 19:00:27',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 19:00:27','2021-09-07 19:00:27'),(457,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0285','',NULL,NULL,'2021-09-07 19:19:08',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 19:19:08','2021-09-07 19:19:08'),(458,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0286','',NULL,NULL,'2021-09-07 19:31:15',650.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,650.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 19:31:15','2021-09-07 19:31:15'),(459,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0287','',NULL,NULL,'2021-09-07 20:04:54',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 20:04:54','2021-09-07 20:04:54'),(460,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0288','',NULL,NULL,'2021-09-07 20:41:39',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 20:41:39','2021-09-07 20:41:39'),(461,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0289','',NULL,NULL,'2021-09-07 20:59:08',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,8,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 20:59:08','2021-09-07 20:59:08'),(462,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0290','',NULL,NULL,'2021-09-07 21:42:36',25.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,25.0000,NULL,NULL,4,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 21:42:36','2021-09-07 21:42:36'),(463,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0291','',NULL,NULL,'2021-09-07 22:29:13',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-07 22:29:14','2021-09-07 22:29:14'),(464,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0292','',NULL,NULL,'2021-09-08 13:18:05',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 13:18:05','2021-09-08 13:18:05'),(465,2,2,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0021',NULL,NULL,NULL,'2021-09-08 13:46:00',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,439,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 13:47:35','2021-09-08 19:40:55'),(466,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0293','',NULL,NULL,'2021-09-08 13:51:16',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 13:51:16','2021-09-08 13:51:16'),(467,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0294','',NULL,NULL,'2021-09-08 13:55:00',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 13:55:00','2021-09-08 13:55:00'),(468,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0295','',NULL,NULL,'2021-09-08 13:56:08',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,10,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 13:56:08','2021-09-08 13:56:08'),(469,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0296','',NULL,NULL,'2021-09-08 13:56:11',225.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,225.0000,NULL,NULL,6,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 13:56:11','2021-09-08 13:56:11'),(470,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0297','',NULL,NULL,'2021-09-08 15:53:46',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 15:53:46','2021-09-08 15:53:46'),(471,2,3,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0022',NULL,NULL,NULL,'2021-09-08 15:56:00',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,449,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 15:56:50','2021-09-08 18:24:44'),(472,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0298','',NULL,NULL,'2021-09-08 16:07:52',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,7,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 16:07:52','2021-09-08 16:07:53'),(473,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0299','',NULL,NULL,'2021-09-08 16:55:51',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 16:55:51','2021-09-08 16:55:51'),(474,2,3,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0023',NULL,NULL,NULL,'2021-09-08 17:20:00',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,473,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 17:21:05','2021-09-08 18:24:29'),(475,2,3,NULL,NULL,NULL,'stock_adjustment',NULL,'',NULL,0,NULL,'normal',NULL,NULL,NULL,'SA2021/0001',NULL,NULL,'2021-09-08 17:25:00',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,375.0000,NULL,NULL,NULL,NULL,0,0,1.000,0.0000,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 17:29:07','2021-09-08 17:29:07'),(476,2,3,NULL,NULL,NULL,'stock_adjustment',NULL,'',NULL,0,NULL,'normal',NULL,NULL,NULL,'SA2021/0002',NULL,NULL,'2021-09-08 17:32:00',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,'جرد',NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,6000.0000,NULL,NULL,NULL,NULL,0,0,1.000,0.0000,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 17:38:03','2021-09-08 17:38:03'),(477,2,3,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-01-01 17:56:09',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,53,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 17:56:09','2021-09-09 17:36:23'),(478,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0300','',NULL,NULL,'2021-09-08 19:25:32',350.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,350.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 19:25:32','2021-09-08 19:25:32'),(479,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0301','',NULL,NULL,'2021-09-08 19:34:20',125.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,125.0000,NULL,NULL,6,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 19:34:20','2021-09-08 19:34:20'),(480,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0302','',NULL,NULL,'2021-09-08 19:41:57',300.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,300.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 19:41:57','2021-09-08 19:41:57'),(481,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0303','',NULL,NULL,'2021-09-08 19:43:14',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 19:43:14','2021-09-08 19:43:14'),(482,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0304','',NULL,NULL,'2021-09-08 20:09:16',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,4,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 20:09:16','2021-09-08 20:09:16'),(483,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0305','',NULL,NULL,'2021-09-08 20:18:09',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,4,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 20:18:09','2021-09-08 20:18:09'),(484,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0306','',NULL,NULL,'2021-09-08 20:45:08',350.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,350.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 20:45:08','2021-09-08 20:45:08'),(485,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0307','',NULL,NULL,'2021-09-08 20:48:15',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 20:48:15','2021-09-08 20:48:15'),(486,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0308','',NULL,NULL,'2021-09-08 20:49:08',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 20:49:08','2021-09-08 20:49:08'),(487,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0309','',NULL,NULL,'2021-09-08 21:15:16',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,4,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 21:15:16','2021-09-08 21:15:16'),(488,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0310','',NULL,NULL,'2021-09-08 22:11:49',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 22:11:49','2021-09-08 22:11:49'),(489,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0311','',NULL,NULL,'2021-09-08 22:24:10',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,14,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-08 22:24:10','2021-09-08 22:24:10'),(490,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0312','',NULL,NULL,'2021-09-09 13:46:47',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-09 13:46:47','2021-09-09 13:46:48'),(491,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0313','',NULL,NULL,'2021-09-09 14:20:25',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,6,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-09 14:20:25','2021-09-09 14:20:25'),(492,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0314','',NULL,NULL,'2021-09-09 14:37:28',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,6,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-09 14:37:28','2021-09-09 14:37:28'),(493,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0315','',NULL,NULL,'2021-09-09 14:52:11',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,6,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-09 14:52:11','2021-09-09 14:52:11'),(494,2,3,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0024',NULL,NULL,NULL,'2021-09-09 15:02:00',350.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,350.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,478,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 15:03:07','2021-09-09 15:05:50'),(495,2,3,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0025',NULL,NULL,NULL,'2021-09-09 15:33:00',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,486,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 15:34:05','2021-09-09 16:42:43'),(496,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0316','',NULL,NULL,'2021-09-09 15:36:15',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-09 15:36:15','2021-09-09 15:36:15'),(497,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0317','',NULL,NULL,'2021-09-09 16:22:56',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-09 16:22:56','2021-09-09 16:22:56'),(498,2,2,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0026',NULL,NULL,NULL,'2021-09-09 16:34:00',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,371,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 16:35:04','2021-09-09 16:35:35'),(499,2,2,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0027',NULL,NULL,NULL,'2021-09-09 16:37:00',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,392,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 16:37:17','2021-09-09 16:37:42'),(500,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0318','',NULL,NULL,'2021-09-09 16:44:57',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,10,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-09 16:44:57','2021-09-09 16:44:58'),(501,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0319','',NULL,NULL,'2021-09-09 16:45:18',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-09 16:45:18','2021-09-09 16:45:18'),(502,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0320','',NULL,NULL,'2021-09-09 17:44:14',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-09 17:44:14','2021-09-09 17:44:14'),(503,2,3,NULL,NULL,NULL,'purchase',NULL,'received',NULL,0,'due',NULL,4,NULL,NULL,'PO2021/0001',NULL,NULL,'2021-09-09 17:47:00',8390.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,8390.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 17:51:56','2021-09-09 17:51:57'),(504,2,3,NULL,NULL,NULL,'stock_adjustment',NULL,'',NULL,0,NULL,'normal',NULL,NULL,NULL,'SA2021/0003',NULL,NULL,'2021-09-09 17:54:00',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,225.0000,NULL,NULL,NULL,NULL,0,0,1.000,0.0000,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 17:54:32','2021-09-09 17:54:32'),(505,2,2,NULL,NULL,NULL,'stock_adjustment',NULL,'',NULL,0,NULL,'normal',NULL,NULL,NULL,'SA2021/0004',NULL,NULL,'2021-09-09 17:55:00',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1565.0000,NULL,NULL,NULL,NULL,0,0,1.000,0.0000,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 17:56:39','2021-09-09 17:56:39'),(506,2,2,NULL,NULL,NULL,'purchase',NULL,'received',NULL,0,'due',NULL,4,NULL,NULL,'PO2021/0002',NULL,NULL,'2021-09-09 17:56:00',1615.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1615.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 17:58:50','2021-09-09 17:58:50'),(507,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0321','',NULL,NULL,'2021-09-09 19:43:45',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-09 19:43:45','2021-09-09 19:43:45'),(508,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0322','',NULL,NULL,'2021-09-09 21:33:29',450.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,450.0000,NULL,NULL,4,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-09 21:33:29','2021-09-09 21:33:29'),(509,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0323','',NULL,NULL,'2021-09-09 21:59:51',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-09 21:59:51','2021-09-09 21:59:51'),(510,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0324','',NULL,NULL,'2021-09-09 23:15:06',275.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,275.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-09 23:15:06','2021-09-09 23:15:06'),(511,2,3,NULL,NULL,NULL,'purchase',NULL,'received',NULL,0,'due',NULL,4,NULL,NULL,'PO2021/0003',NULL,NULL,'2021-09-09 23:16:00',36625.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,36625.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 23:23:34','2021-09-10 16:20:20'),(512,2,3,NULL,NULL,NULL,'purchase',NULL,'received',NULL,0,'due',NULL,4,NULL,NULL,'PO2021/0004',NULL,NULL,'2021-09-09 23:27:00',38650.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,38650.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 23:33:30','2021-09-10 16:20:26'),(513,2,3,NULL,NULL,NULL,'purchase',NULL,'received',NULL,0,'due',NULL,4,NULL,NULL,'PO2021/0005',NULL,NULL,'2021-09-09 23:33:00',23975.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,23975.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 23:38:43','2021-09-10 16:20:36'),(514,2,2,NULL,NULL,NULL,'purchase',NULL,'received',NULL,0,'due',NULL,4,NULL,NULL,'PO2021/0006',NULL,NULL,'2021-09-09 23:39:00',38650.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,38650.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 23:49:28','2021-09-10 16:27:48'),(515,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0325','',NULL,NULL,'2021-09-10 14:19:35',675.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,675.0000,NULL,NULL,6,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 14:19:35','2021-09-10 14:19:36'),(516,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0326','',NULL,NULL,'2021-09-10 14:26:24',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 14:26:24','2021-09-10 14:26:24'),(517,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0327','',NULL,NULL,'2021-09-10 15:16:00',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 15:16:00','2021-09-10 15:16:00'),(518,2,2,NULL,NULL,NULL,'purchase',NULL,'received',NULL,0,'due',NULL,4,NULL,NULL,'PO2021/0007',NULL,NULL,'2021-09-10 16:24:00',36625.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,36625.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 16:27:37','2021-09-10 16:27:37'),(519,2,2,NULL,NULL,NULL,'purchase',NULL,'received',NULL,0,'due',NULL,4,NULL,NULL,'PO2021/0008',NULL,NULL,'2021-09-10 16:35:00',23975.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,23975.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 16:37:33','2021-09-10 16:37:33'),(520,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0328','',NULL,NULL,'2021-09-10 17:06:27',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 17:06:27','2021-09-10 17:06:27'),(521,2,3,NULL,NULL,NULL,'sell',NULL,'draft','quotation',1,NULL,NULL,2,NULL,'2021/0003','',NULL,NULL,'2021-09-10 17:30:22',1490.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1490.0000,NULL,NULL,10,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 17:30:22','2021-09-10 17:30:22'),(522,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0329','',NULL,NULL,'2021-09-10 17:32:40',1490.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1490.0000,NULL,NULL,10,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 17:32:40','2021-09-10 17:32:40'),(523,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0330','',NULL,NULL,'2021-09-10 17:48:00',500.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,500.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 17:48:00','2021-09-10 17:48:00'),(524,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0331','',NULL,NULL,'2021-09-10 17:49:23',500.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,500.0000,NULL,NULL,6,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 17:49:23','2021-09-10 17:49:24'),(525,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0332','',NULL,NULL,'2021-09-10 17:53:46',300.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,300.0000,NULL,NULL,4,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 17:53:46','2021-09-10 17:53:46'),(526,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0333','',NULL,NULL,'2021-09-10 18:52:44',450.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,450.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 18:52:44','2021-09-10 18:52:44'),(527,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0334','',NULL,NULL,'2021-09-10 19:09:22',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 19:09:22','2021-09-10 19:09:22'),(528,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0335','',NULL,NULL,'2021-09-10 19:26:20',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 19:26:20','2021-09-10 19:26:20'),(531,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0336','',NULL,NULL,'2021-09-10 19:38:04',175.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,175.0000,NULL,NULL,4,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 19:38:04','2021-09-10 19:38:04'),(532,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0337','',NULL,NULL,'2021-09-10 19:42:34',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,11,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 19:42:34','2021-09-10 19:42:34'),(533,2,2,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'paid',NULL,2,NULL,'CN2021/0028',NULL,NULL,NULL,'2021-09-10 20:04:00',500.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,500.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,523,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 20:04:16','2021-09-10 20:04:48'),(534,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0338','',NULL,NULL,'2021-09-10 20:16:34',950.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,950.0000,NULL,NULL,4,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 20:16:34','2021-09-10 20:16:34'),(535,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0339','',NULL,NULL,'2021-09-10 21:13:24',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 21:13:24','2021-09-10 21:13:24'),(536,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0340','',NULL,NULL,'2021-09-10 21:16:33',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,4,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 21:16:33','2021-09-10 21:16:33'),(537,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0341','',NULL,NULL,'2021-09-10 21:22:41',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 21:22:41','2021-09-10 21:22:41'),(538,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0342','',NULL,NULL,'2021-09-10 22:14:17',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,12,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 22:14:17','2021-09-10 22:14:17'),(539,2,2,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0343','',NULL,NULL,'2021-09-10 22:15:08',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-10 22:15:08','2021-09-10 22:15:08'),(540,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0344','',NULL,NULL,'2021-09-11 17:13:56',75.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,75.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-11 17:13:56','2021-09-11 17:13:56'),(541,2,3,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'0345','',NULL,NULL,'2021-09-11 20:27:48',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,13,NULL,0,0,1.000,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,1,'2021-09-11 20:27