@extends('layouts.app')
@section('title', __('sentence.transport'))


@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> @lang('sentence.transport')
        </h1>
    </section>

    <!-- Main content -->
    <section class="content">
        @component('components.widget', ['class' => 'box-primary', 'title' => __( 'sentence.filter').' '.__('sentence.transport')])
            @slot('tool')
                <div class="box-tools"   style="float: left" >
                    <a class="btn btn-primary"  data-toggle="modal" href="#patient_modal" >
                        <i class="fa fa-plus"></i> @lang('messages.add')</a>

                </div>
            @endslot
                <div class="col-sm-4">
                    <div class="form-group">
                        {!! Form::label('expense_for', __('sentence.carPalet').':') !!}
                        <div class="input-group">
                            {!! Form::select('main_group_dd', $contact, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all'),'id'=>'main_group_dd']); !!}
                            <span class="input-group-btn">

						</span>
                        </div>
                    </div>
                </div>
        @endcomponent
            @component('components.widget', ['class' => 'box-primary', 'title' => __( 'sentence.transport')])


                <div class="table-responsive">
            <table class="table table-bordered table-striped" id="dataTableMis">
                <thead>
                <tr>

                    <th>@lang('sentence.carPalet')</th>
                    <th>@lang('sentence.transport_from')</th>
                    <th>@lang('sentence.transport_to')</th>
                    <th>@lang('sentence.days_count')</th>
                    <th>@lang('sentence.dayCost')</th>
                    <th>@lang('sentence.ShippingCost')</th>
                    <th style=" white-space: nowrap;">@lang('messages.action')</th>

                </tr>
                </thead>

                <tbody>
                @foreach($transports as $key =>$car)
                    <tr>

                        <td>{{$car['car_palate_type']}}</td>
                        <td> {{$car['move_from']}}</td>
                        <td>{{$car['move_to']}}</td>
                        <td>{{$car['days_count']}}</td>
                        <td>{{$car['day_cost']}}</td>
                        <td>{{$car['shipping_cost']}}</td>
                        <td>

                            <a class="edit_patient_button" data-toggle="modal" href="#"
                               data-goto="{{action('CarController@edit', [$car['id']])}}"
                               id="editCar-{{ $car['id'] }}" data-id="{{ $car['id'] }}" onclick="LoadEdit('{{$car['id']}}')" >
                                <i class="fa fa-edit"></i> @lang('messages.edit')</a>



                        </td>



                    </tr>
                @endforeach
                </tbody>


            </table>
                </div>


        @endcomponent

        <div class="modal fade contact_modal" tabindex="-1" role="dialog"
             aria-labelledby="gridSystemModalLabel">
        </div>
        <div class="modal fade pay_contact_due_modal" tabindex="-1" role="dialog"
             aria-labelledby="gridSystemModalLabel">
        </div>




        <!-- Add Patient Modal-->
        <div class="modal fade" id="patient_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none; ">
            <div class="modal-dialog" style="width: 800px!important;">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        <h4 class="modal-title">  {{ __('sentence.trasposrt_move') }}  </h4>
                    </div>
                    <div class="modal-body">
                        {!! Form::open(['url' => action('CarController@store'), 'method' => 'post', 'id' => 'add_transport','class'=>'clearfix', 'files' => true ]) !!}
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    {!! Form::label('car_palet', __('sentence.carType') . ':*') !!}
                                    {!! Form::select('car_palete_id', $contact, null, ['class' => 'form-control select2', 'style' => 'width:100%','id'=>'main_group_dd']); !!}
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    {!! Form::label('car_type', __('sentence.transport_from') . ':') !!}
                                    {!! Form::text('transport_from',  null, ['class' => 'form-control',
                                    'placeholder' => __('sentence.transport_from')]); !!}
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    {!! Form::label('car_type', __('sentence.transport_to') . ':') !!}
                                    {!! Form::text('transport_to',  null, ['class' => 'form-control',
                                    'placeholder' => __('sentence.transport_to')]); !!}
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    {!! Form::label('car_type', __('sentence.days_count') . ':') !!}
                                    {!! Form::text('days_count',  null, ['class' => 'form-control',
                                    'placeholder' => __('sentence.days_count')]); !!}
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    {!! Form::label('car_type', __('sentence.ShippingCost') . ':') !!}
                                    {!! Form::text('ShippingCost',  null, ['class' => 'form-control',
                                    'placeholder' => __('sentence.ShippingCost')]); !!}
                                </div>
                            </div>


                        </div>
                        <div class="clearfix"></div>
                        <div class="col-md-12"><hr/></div>
                        <div class="form-group col-md-12">
                            <button type="submit" name="submit" id="submit-transport" class="btn btn-info pull-right">  @lang('messages.submit')</button>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div>
        <!-- Add Schedule Modal-->






    </section>
    <!-- /.content -->
@stop
@section('javascript')

    <script type="text/javascript">

        $("#submit-transport").click(function () {
            $('#add_transport').submit(function (e) {
                e.preventDefault();
                var formData = new FormData($('#add_transport')[0]);
                var flag_material = false;
console.log(formData);
                $.ajax({
                    url: '/storeTransportDestination',
                    type: 'POST',
                    data: formData,
                    success: function (response) {
                        console.log(response);
                        location.reload();

                    },
                    error: function (request, status, error) {
                        console.log(error);
                    },
                    contentType: false,
                    processData: false

                });
            });
        });

        $(document).ready(function () {
            $('#dataTableMis').DataTable({


            });
        });
        function LoadEdit(patientID){

            $('#editCar-'+patientID).click(function(event) {
                event.preventDefault();
            });
            $('div.contact_modal').load($('#editCar-'+patientID).attr('data-goto'), function () {
                $(this).modal('show');

            });
        }
    </script>


@endsection
