@extends('layouts.app')
@section('title', __('sentence.kashf_hesab'))


@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> @lang('sentence.kashf_hesab')
        </h1>
    </section>
<style>
    .dataTables_wrapper {
        display: inline-table;

        /* below optional .*/
        --width: auto;
        --max-width: 45%;
    }


    th, td {
        white-space: nowrap;
    }

</style>
    <link href="//datatables.net/download/build/nightly/jquery.dataTables.css" rel="stylesheet" type="text/css" />

    <!-- Main content -->
    <section class="content">
        @component('components.widget', ['class' => 'box-primary', 'title' => __( 'sentence.kashf_hesab')])

            @slot('tool')
                <div class="box-tools" style="float: left">
                    <a class="btn btn-primary" data-toggle="modal"
                       href="{{ action('SupplierKashfController@create') }}">
                        <i class="fa fa-plus"></i> @lang('messages.add')</a>
                    <button type="button" class="btn btn-success add_new_supplier"
                            data-name="" id="add_supplier_customer"><i class="fa fa-plus-circle fa-lg"></i> @lang('sentence.add_contact')</button>
                    <button type="button" class="btn btn-border-success add_new_driver"
                            data-name="" id="add_driver"><i class="fa fa-plus fa-lg"></i> @lang('sentence.add_driver')</button>
                </div>
            @endslot


            <div id="exTab2">
                <ul class="nav nav-tabs">
                    <li class="active">
                        <a href="#1" data-toggle="tab">{{ __('sentence.supplier') }}</a>
                    </li>
                    <li><a href="#2" data-toggle="tab">{{ __('sentence.Customer') }}</a>
                    </li>
                    <li><a href="#3" data-toggle="tab">{{ __('sentence.driver') }}</a>
                    </li>

                </ul>
                <div class="tab-content ">
                    <div class="tab-pane active" id="1">
                        <div class="row">
                            <br />
                            <br />
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped" id="datatable-supplier" style="width:100%;">
                                        <thead>
                                        <tr>

                                            <th>@lang('sentence.supplier')</th>
                                            <th>@lang('sentence.onLandDate')</th>
                                            <th>@lang('sentence.factoryHoldDate')</th>
                                            <th>@lang('sentence.carPalet')</th>
                                            <th>@lang('sentence.amountWeight')</th>
                                            <th>@lang('sentence.westper')</th>
                                            <th>@lang('sentence.NetAmountWeight')</th>
                                            <th>@lang('sentence.kgprice')</th>
                                            <th>@lang('sentence.boxRent')</th>
                                            <th>@lang('sentence.ShippingCost')</th>
                                            <th>@lang('sentence.daysDiff')</th>
                                            <th>@lang('sentence.dayCost')</th>
                                            <th>@lang('sentence.netAmountOverAll')</th>
                                            <th>@lang('lang_v1.added_on')</th>
                                            <th  style="min-width: 65px;">@lang('messages.action')</th>

                                        </tr>
                                        </thead>


                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="2">
                        <div class="row">
                            <br />
                            <br />
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped" id="datatable-customer" style="width:100%;">
                                        <thead>
                                        <tr>
                                            <th style="min-width: 165px;">@lang('sentence.Customer')</th>
                                            <th>@lang('sentence.factoryHoldDate')</th>
                                            <th>@lang('sentence.carPalet')</th>
                                            <th>@lang('sentence.amountWeight')</th>
                                            <th>@lang('sentence.westper')</th>
                                            <th>@lang('sentence.NetAmountWeight')</th>
                                            <th>@lang('sentence.kgpriceClient')</th>
                                            <th>@lang('sentence.netAmountOverAllClient')</th>
                                            <th>@lang('lang_v1.added_on')</th>
                                            <th  style="min-width: 65px;">@lang('messages.action')</th>
                                        </tr>
                                        </thead>


                                    </table>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="tab-pane" id="3">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped" id="datatable-driver" style="width:100%;">
                                        <thead>
                                        <tr>

                                            <th style="min-width: 165px;">@lang('sentence.driver')</th>
                                            <th>@lang('sentence.carPalet')</th>
                                            <th>@lang('sentence.onLandDate')</th>
                                            <th>@lang('sentence.outLandDate')</th>
                                            <th>@lang('sentence.factoryHoldDate')</th>
                                            <th>@lang('sentence.daysTotalNumber')</th>
                                            <th>@lang('sentence.daysTotalNumberDefualt')</th>
                                            <th>@lang('sentence.daysDiff')</th>
                                            <th>@lang('sentence.dayCost')</th>
                                            <th>@lang('sentence.ShippingCost')</th>
                                            <th>@lang('sentence.netAmountMoneyDriver')</th>
                                            <th>@lang('sentence.boxCount')</th>
                                            <th>@lang('lang_v1.added_on')</th>
                                            <th style="min-width: 65px;">@lang('messages.action')</th>

                                        </tr>
                                        </thead>



                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>






        @endcomponent

        <div class="modal fade contact_modal" tabindex="-1" role="dialog"
             aria-labelledby="gridSystemModalLabel">
        </div>
        <div class="modal fade pay_contact_due_modal" tabindex="-1" role="dialog"
             aria-labelledby="gridSystemModalLabel">
        </div>


            <!-- Add Patient Modal-->
            <div class="modal fade" id="add_supplier_customer_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none; ">
                <div class="modal-dialog" style="width: 800px!important;">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4 class="modal-title">  {{ __('sentence.add_contact') }}  </h4>
                        </div>
                        <div class="modal-body">
                            {!! Form::open(['url' => action('CarController@store'), 'method' => 'post', 'id' => 'add_supplier_customer_form','class'=>'clearfix', 'files' => true ]) !!}
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        {!! Form::label('car_palet', __('sentence.contactType') . ':*') !!}
                                        <select name="contactType" class="form-control">
                                            <option value="1">عميل</option>
                                            <option value="2">مورد</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        {!! Form::label('car_type', __('sentence.first_name') . ':*') !!}
                                        {!! Form::text('first_name',  null, ['class' => 'form-control',
                                        'placeholder' => __('sentence.first_name'),'required'=>'required']); !!}
                                    </div>
                                </div>
                                <input type="hidden" name="middle_name" value=" "/>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        {!! Form::label('car_type', __('sentence.last_name') . ':*') !!}
                                        {!! Form::text('last_name',  null, ['class' => 'form-control',
                                        'placeholder' => __('sentence.last_name'),'required'=>'required']); !!}
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        {!! Form::label('car_description', __('sentence.phone_number') . ':*') !!}
                                        {!! Form::text('mobile',  null, ['class' => 'form-control',
                                        'placeholder' => __('sentence.phone_number'),'required'=>'required']); !!}
                                    </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-12"><hr/></div>
                            <div class="form-group col-md-12">
                                <button type="submit" name="submit" class="btn btn-info pull-right" id="submit-contact">  @lang('messages.submit')</button>
                            </div>
                            {!! Form::close() !!}
                        </div>
                    </div><!-- /.modal-content -->
                </div><!-- /.modal-dialog -->
            </div>
            <!-- Add Schedule Modal-->

            <!-- Add Patient Modal-->
            <div class="modal fade" id="add_driver_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none; ">
                <div class="modal-dialog" style="width: 800px!important;">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4 class="modal-title">  {{ __('sentence.add_driver') }}  </h4>
                        </div>
                        <div class="modal-body">
                            {!! Form::open(['url' => action('CarController@store'), 'method' => 'post', 'id' => 'add_driver_form','class'=>'clearfix', 'files' => true ]) !!}
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        {!! Form::label('car_type', __('sentence.first_name') . ':*') !!}
                                        {!! Form::text('first_name',  null, ['class' => 'form-control',
                                        'placeholder' => __('sentence.first_name'),'required'=>'required']); !!}
                                    </div>
                                </div>
                                <input type="hidden" name="middle_name" value=" "/>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        {!! Form::label('car_type', __('sentence.last_name') . ':*') !!}
                                        {!! Form::text('last_name',  null, ['class' => 'form-control',
                                        'placeholder' => __('sentence.last_name'),'required'=>'required']); !!}
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        {!! Form::label('car_description', __('sentence.phone_number') . ':*') !!}
                                        {!! Form::text('mobile',  null, ['class' => 'form-control',
                                        'placeholder' => __('sentence.phone_number'),'required'=>'required']); !!}
                                    </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-12"><hr/></div>
                            <div class="form-group col-md-12">
                                <button type="submit" name="submit" class="btn btn-info pull-right" id="submit-driver">  @lang('messages.submit')</button>
                            </div>
                            {!! Form::close() !!}
                        </div>
                    </div><!-- /.modal-content -->
                </div><!-- /.modal-dialog -->
            </div>
            <!-- Add Schedule Modal-->


    </section>
    <!-- /.content -->
@stop
@section('javascript')

    <script type="text/javascript">
        $("#add_supplier_customer").click(function() {
            //alert(this.id);
            $('#add_supplier_customer_modal').modal('show');

        });
        $("#add_driver").click(function() {
            //alert(this.id);
            $('#add_driver_modal').modal('show');

        });


        $("#submit-contact").click(function () {
            $('#add_supplier_customer_form').submit(function (e) {
                e.preventDefault();
                var formData = new FormData($('#add_supplier_customer_form')[0]);
                var flag_material = false;
                console.log(formData);
                $.ajax({
                    url: '/storeContactSmall',
                    type: 'POST',
                    data: formData,
                    success: function (response) {
                        console.log(response);
                        location.reload();

                    },
                    error: function (request, status, error) {
                        console.log(error);
                    },
                    contentType: false,
                    processData: false

                });
            });
        });
        $("#submit-driver").click(function () {
            $('#add_driver_form').submit(function (e) {
                e.preventDefault();
                var formData = new FormData($('#add_driver_form')[0]);
                var flag_material = false;
                console.log(formData);
                $.ajax({
                    url: '/storeDriverSmall',
                    type: 'POST',
                    data: formData,
                    success: function (response) {
                        console.log(response);
                        location.reload();

                    },
                    error: function (request, status, error) {
                        console.log(error);
                    },
                    contentType: false,
                    processData: false

                });
            });
        });
        $(document).ready(function () {
           $('#datatable-supplier').DataTable({processing: true,
                serverSide: true,
                aaSorting: [[1, 'DESC']],
                autoWidth:false,
                scrollY: "300px",
                scrollX: true,
                scrollCollapse: true,
                "ajax": {
                    "url": "/supplierKashf",
                    "data": function (d) {

                        //d.group_name = "";
                        d.type = 'supplier';
                        d = __datatable_ajax_callback(d);
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(errorThrown);
                    }
                },
               columnDefs: [ {"className": "dt-center", "targets": "_all"},
                   {
                       targets: 1,
                       width: 1
                   }],
                columns: [

                    {data: 'supplierName', name: 'supplierName'},
                    {data: 'on_land_date', name: 'on_land_date'},
                    {data: 'on_factory_date', name: 'on_factory_date'},
                    {data: 'car_palet', name: 'car_palet'},
                    {data: 'main_weight', name: 'main_weight'},
                    {data: 'loses_percent', name: 'loses_percent'},
                    {data: 'net_weight', name: 'net_weight'},
                    {data: 'supplier_price', name: 'supplier_price'},
                    {data: 'box_rent_cost', name: 'box_rent_cost'},
                    {data: 'shipping_cost', name: 'shipping_cost'},
                    {data: 'stay_days_no', name: 'stay_days_no'},
                    {data: 'stay_day_cost', name: 'stay_day_cost'},

                    {data: 'supplier_net_value', name: 'supplier_net_value'},
                    {data: 'created_at', name: 'created_at'},
                    {data: 'action', name: 'action'},
                ],


            });
           $('#datatable-customer').DataTable({processing: true,
                serverSide: true,
                aaSorting: [[1, 'DESC']],
                autoWidth:false,
                scrollY: "300px",
                scrollX: true,
                scrollCollapse: true,
                "ajax": {
                    "url": "/supplierKashf",
                    "data": function (d) {

                        //d.group_name = "";
                        d.type = 'customer';
                        d = __datatable_ajax_callback(d);
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(errorThrown);
                    }
                },
                columnDefs: [
                    {"className": "dt-center", "targets": "_all"},
                    {
                        targets: 1,
                        width: 1
                    },
                ],

                columns: [

                    {data: 'customerName', name: 'customerName'},
                    {data: 'on_factory_date', name: 'on_factory_date'},
                    {data: 'car_palet', name: 'car_palet'},
                    {data: 'main_weight', name: 'main_weight'},
                    {data: 'loses_percent', name: 'loses_percent'},
                    {data: 'net_weight', name: 'net_weight'},
                    {data: 'customer_price', name: 'customer_price'},
                    {data: 'customer_net_value', name: 'customer_net_value'},
                    {data: 'created_at', name: 'created_at'},
                    {data: 'action', name: 'action'},
                ],


            });
           $('#datatable-driver').DataTable({processing: true,
                serverSide: true,
                aaSorting: [[1, 'DESC']],
                autoWidth:false,
                scrollY: "300px",
                scrollX: true,
                scrollCollapse: true,
                "ajax": {
                    "url": "/supplierKashf",
                    "data": function (d) {

                        //d.group_name = "";
                        d.type = 'driver';
                        d = __datatable_ajax_callback(d);
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(errorThrown);
                    }
                },
                columnDefs: [
                    {"className": "dt-center", "targets": "_all"},
                    {
                        targets: 1,
                        width: 1
                    },
                ],

                columns: [

                    {data: 'driverName', name: 'driverName'},
                    {data: 'car_palet', name: 'car_palet'},
                    {data: 'on_land_date', name: 'on_land_date'},
                    {data: 'out_land_date', name: 'out_land_date'},
                    {data: 'on_factory_date', name: 'on_factory_date'},
                    {data: 'total_days_no', name: 'total_days_no'},
                    {data: 'days_default', name: 'days_default'},
                    {data: 'stay_days_no', name: 'stay_days_no'},
                    {data: 'stay_day_cost', name: 'stay_day_cost'},
                    {data: 'shipping_cost', name: 'shipping_cost'},
                    {data: 'driver_net_value', name: 'driver_net_value'},
                    {data: 'box_count', name: 'box_count'},
                    {data: 'created_at', name: 'created_at'},
                    {data: 'action', name: 'action'},
                ],


            });


        });

        function LoadEdit(patientID) {

            $('#editCar-' + patientID).click(function (event) {
                event.preventDefault();
            });
            $('div.contact_modal').load($('#editCar-' + patientID).attr('data-goto'), function () {
                $(this).modal('show');

            });
        }
    </script>


@endsection
