@extends('layouts.app')
@section('title', __('sentence.car_list'))


@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> @lang('sentence.car_list')
        </h1>
        <style>
            .sorting{
                text-align: right;
            }
        </style>
    </section>

    <!-- Main content -->
    <section class="content">
        @component('components.widget', ['class' => 'box-primary', 'title' => __( 'sentence.car_list')])

                @slot('tool')
                    <div class="box-tools"  style="float: left" >
                        <a class="btn btn-primary" data-toggle="modal" href="#patient_modal" >
                            <i class="fa fa-plus"></i> @lang('messages.add')</a>

                    </div>
                @endslot


            <table class="table table-bordered table-striped" id="dataTableMis">
                <thead>
                <tr>

                    <th>@lang('sentence.carPalet')</th>
                    <th>@lang('sentence.carType')</th>
                    <th>@lang('sentence.description')</th>
                    <th>@lang('sentence.boxCount')</th>
                    <th style=" white-space: nowrap;">@lang('messages.action')</th>

                </tr>
                </thead>

                <tbody>
                @foreach($cars as $key =>$car)
                    <tr>

                        <td>{{$car['car_palet']}}</td>
                        <td> {{$car['car_type']}}</td>
                        <td>{{$car['car_description']}}</td>
                        <td>{{$car['box_count']}}</td>
                        <td>
                         {{--   <a class="btn btn-primary" href="{{action('DoctorProductController@goToDoctorSchedule', [$drPros['id'] ])}}"><i class="fa fa-calendar"></i> Schedule Manage</a>
                            <a class="btn btn-warning" href="{{action('DoctorProductController@showServicePage', [$drPros['id'] ])}}"><i class="fa fa-edit"></i> Manage Services</a>
                            @if($is_admin)
                                <a class="btn btn-danger" href="{{action('ManageUserController@edit', [$drPros['id'] ])}}" target="_blank"><i class="fa fa-edit"></i> Manage Doctor Account</a>
                            @endif--}}
                            <a class="edit_patient_button" data-toggle="modal" href="#"
                               data-goto="{{action('CarController@edit', [$car['id']])}}"
                               id="editCar-{{ $car['id'] }}" data-id="{{ $car['id'] }}" onclick="LoadEdit('{{$car['id']}}')" >
                                <i class="fa fa-edit"></i> @lang('messages.edit')</a>



                        </td>



                    </tr>
                @endforeach
                </tbody>


            </table>


        @endcomponent

        <div class="modal fade contact_modal" tabindex="-1" role="dialog"
             aria-labelledby="gridSystemModalLabel">
        </div>
        <div class="modal fade pay_contact_due_modal" tabindex="-1" role="dialog"
             aria-labelledby="gridSystemModalLabel">
        </div>




        <!-- Add Patient Modal-->
        <div class="modal fade" id="patient_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none; ">
            <div class="modal-dialog" style="width: 800px!important;">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        <h4 class="modal-title">  {{ __('sentence.register_car') }}  </h4>
                    </div>
                    <div class="modal-body">
                        {!! Form::open(['url' => action('CarController@store'), 'method' => 'post', 'id' => 'add_car','class'=>'clearfix', 'files' => true ]) !!}
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    {!! Form::label('car_palet', __('sentence.carPalet') . ':*') !!}
                                    {!! Form::text('car_palet',  null, ['class' => 'form-control', 'required',
                                    'placeholder' => __('sentence.carPalet')]); !!}
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    {!! Form::label('car_type', __('sentence.carType') . ':') !!}
                                    {!! Form::text('car_type',  null, ['class' => 'form-control',
                                    'placeholder' => __('sentence.carType')]); !!}
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    {!! Form::label('box_count', __('sentence.boxCount') . ':') !!}
                                    {!! Form::text('box_count',  null, ['class' => 'form-control',
                                    'placeholder' => __('sentence.boxCount')]); !!}
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    {!! Form::label('day_cost', __('sentence.dayCost') . ':') !!}
                                    {!! Form::text('day_cost',  null, ['class' => 'form-control',
                                    'placeholder' => __('sentence.dayCost')]); !!}
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    {!! Form::label('day_cost', __('sentence.boxRentCost1') . ':') !!}
                                    {!! Form::text('box_cost',  null, ['class' => 'form-control',
                                    'placeholder' => __('sentence.boxRentCost1')]); !!}
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="form-group">
                                    {!! Form::label('car_description', __('sentence.description') . ':') !!}
                                    {!! Form::textarea('car_description',  null, ['class' => 'form-control',
                                    'placeholder' => __('sentence.description')]); !!}
                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <div class="col-md-12"><hr/></div>
                        <div class="form-group col-md-12">
                            <button type="submit" name="submit" class="btn btn-info pull-right">  @lang('messages.submit')</button>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div>
        <!-- Add Schedule Modal-->




    </section>
    <!-- /.content -->
@stop
@section('javascript')

    <script type="text/javascript">
        $(document).ready(function () {
            $('#dataTableMis').DataTable({

            });
        });

        function LoadEdit(patientID){

            $('#editCar-'+patientID).click(function(event) {
                event.preventDefault();
            });
            $('div.contact_modal').load($('#editCar-'+patientID).attr('data-goto'), function () {
                $(this).modal('show');

            });
        }
    </script>


@endsection
